/*
 * Decompiled with CFR 0.152.
 */
package com.pedro.encoder.input.video;

import android.annotation.SuppressLint;
import android.content.Context;
import android.graphics.Rect;
import android.graphics.SurfaceTexture;
import android.hardware.camera2.CameraAccessException;
import android.hardware.camera2.CameraCaptureSession;
import android.hardware.camera2.CameraCharacteristics;
import android.hardware.camera2.CameraDevice;
import android.hardware.camera2.CameraManager;
import android.hardware.camera2.CaptureRequest;
import android.hardware.camera2.CaptureResult;
import android.hardware.camera2.TotalCaptureResult;
import android.hardware.camera2.params.Face;
import android.hardware.camera2.params.MeteringRectangle;
import android.hardware.camera2.params.StreamConfigurationMap;
import android.media.Image;
import android.media.ImageReader;
import android.os.Build;
import android.os.Handler;
import android.os.HandlerThread;
import android.util.Log;
import android.util.Range;
import android.util.Size;
import android.view.MotionEvent;
import android.view.Surface;
import android.view.SurfaceView;
import android.view.TextureView;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import com.pedro.encoder.input.video.Camera2ResolutionCalculator;
import com.pedro.encoder.input.video.CameraCallbacks;
import com.pedro.encoder.input.video.CameraHelper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Semaphore;

@RequiresApi(api=21)
public class Camera2ApiManager
extends CameraDevice.StateCallback {
    private final String TAG = "Camera2ApiManager";
    private CameraDevice cameraDevice;
    private SurfaceView surfaceView;
    private TextureView textureView;
    private Surface surfaceEncoder;
    private CameraManager cameraManager;
    private Handler cameraHandler;
    private CameraCaptureSession cameraCaptureSession;
    private boolean prepared = false;
    private String cameraId = null;
    private CameraHelper.Facing facing = CameraHelper.Facing.BACK;
    private CaptureRequest.Builder builderInputSurface;
    private float fingerSpacing = 0.0f;
    private float zoomLevel = 0.0f;
    private boolean lanternEnable = false;
    private boolean videoStabilizationEnable = false;
    private boolean opticalVideoStabilizationEnable = false;
    private boolean autoFocusEnabled = true;
    private boolean running = false;
    private int fps = 30;
    private final Semaphore semaphore = new Semaphore(0);
    private CameraCallbacks cameraCallbacks;
    private int sensorOrientation = 0;
    private Rect faceSensorScale;
    private FaceDetectorCallback faceDetectorCallback;
    private boolean faceDetectionEnabled = false;
    private int faceDetectionMode;
    private ImageReader imageReader;
    private final CameraCaptureSession.CaptureCallback cb = new CameraCaptureSession.CaptureCallback(){

        public void onCaptureCompleted(@NonNull CameraCaptureSession session, @NonNull CaptureRequest request, @NonNull TotalCaptureResult result) {
            Face[] faces = (Face[])result.get(CaptureResult.STATISTICS_FACES);
            if (Camera2ApiManager.this.faceDetectorCallback != null) {
                Camera2ApiManager.this.faceDetectorCallback.onGetFaces(faces, Camera2ApiManager.this.faceSensorScale, Camera2ApiManager.this.sensorOrientation);
            }
        }
    };

    public Camera2ApiManager(Context context) {
        this.cameraManager = (CameraManager)context.getSystemService("camera");
    }

    public void prepareCamera(SurfaceView surfaceView, Surface surface, int fps) {
        this.surfaceView = surfaceView;
        this.surfaceEncoder = surface;
        this.fps = fps;
        this.prepared = true;
    }

    public void prepareCamera(TextureView textureView, Surface surface, int fps) {
        this.textureView = textureView;
        this.surfaceEncoder = surface;
        this.fps = fps;
        this.prepared = true;
    }

    public void prepareCamera(Surface surface, int fps) {
        this.surfaceEncoder = surface;
        this.fps = fps;
        this.prepared = true;
    }

    public void prepareCamera(SurfaceTexture surfaceTexture, int width, int height, int fps) {
        Size optimalResolution = Camera2ResolutionCalculator.INSTANCE.getOptimalResolution(new Size(width, height), this.getCameraResolutions(this.facing));
        Log.i((String)"Camera2ApiManager", (String)("optimal resolution set to: " + optimalResolution.getWidth() + "x" + optimalResolution.getHeight()));
        surfaceTexture.setDefaultBufferSize(optimalResolution.getWidth(), optimalResolution.getHeight());
        this.surfaceEncoder = new Surface(surfaceTexture);
        this.fps = fps;
        this.prepared = true;
    }

    public void prepareCamera(SurfaceTexture surfaceTexture, int width, int height, int fps, CameraHelper.Facing facing) {
        this.facing = facing;
        this.prepareCamera(surfaceTexture, width, height, fps);
    }

    public void prepareCamera(SurfaceTexture surfaceTexture, int width, int height, int fps, String cameraId) {
        this.facing = this.getFacingByCameraId(this.cameraManager, cameraId);
        this.prepareCamera(surfaceTexture, width, height, fps);
    }

    public boolean isPrepared() {
        return this.prepared;
    }

    private void startPreview(CameraDevice cameraDevice) {
        try {
            final ArrayList<Surface> listSurfaces = new ArrayList<Surface>();
            Surface preview = this.addPreviewSurface();
            if (preview != null) {
                listSurfaces.add(preview);
            }
            if (this.surfaceEncoder != preview && this.surfaceEncoder != null) {
                listSurfaces.add(this.surfaceEncoder);
            }
            if (this.imageReader != null) {
                listSurfaces.add(this.imageReader.getSurface());
            }
            cameraDevice.createCaptureSession(listSurfaces, new CameraCaptureSession.StateCallback(){

                public void onConfigured(@NonNull CameraCaptureSession cameraCaptureSession) {
                    Camera2ApiManager.this.cameraCaptureSession = cameraCaptureSession;
                    try {
                        CaptureRequest captureRequest = Camera2ApiManager.this.drawSurface(listSurfaces);
                        if (captureRequest != null) {
                            cameraCaptureSession.setRepeatingRequest(captureRequest, Camera2ApiManager.this.faceDetectionEnabled ? Camera2ApiManager.this.cb : null, Camera2ApiManager.this.cameraHandler);
                            Log.i((String)"Camera2ApiManager", (String)"Camera configured");
                        } else {
                            Log.e((String)"Camera2ApiManager", (String)"Error, captureRequest is null");
                        }
                    }
                    catch (CameraAccessException | NullPointerException e) {
                        Log.e((String)"Camera2ApiManager", (String)"Error", (Throwable)e);
                    }
                    catch (IllegalStateException e) {
                        Camera2ApiManager.this.reOpenCamera(Camera2ApiManager.this.cameraId != null ? Camera2ApiManager.this.cameraId : "0");
                    }
                }

                public void onConfigureFailed(@NonNull CameraCaptureSession cameraCaptureSession) {
                    cameraCaptureSession.close();
                    if (Camera2ApiManager.this.cameraCallbacks != null) {
                        Camera2ApiManager.this.cameraCallbacks.onCameraError("Configuration failed");
                    }
                    Log.e((String)"Camera2ApiManager", (String)"Configuration failed");
                }
            }, this.cameraHandler);
        }
        catch (CameraAccessException | IllegalArgumentException e) {
            if (this.cameraCallbacks != null) {
                this.cameraCallbacks.onCameraError("Create capture session failed: " + e.getMessage());
            }
            Log.e((String)"Camera2ApiManager", (String)"Error", (Throwable)e);
        }
        catch (IllegalStateException e) {
            this.reOpenCamera(this.cameraId != null ? this.cameraId : "0");
        }
    }

    private Surface addPreviewSurface() {
        Surface surface = null;
        if (this.surfaceView != null) {
            surface = this.surfaceView.getHolder().getSurface();
        } else if (this.textureView != null) {
            SurfaceTexture texture = this.textureView.getSurfaceTexture();
            surface = new Surface(texture);
        }
        return surface;
    }

    private CaptureRequest drawSurface(List<Surface> surfaces) {
        try {
            this.builderInputSurface = this.cameraDevice.createCaptureRequest(1);
            for (Surface surface : surfaces) {
                if (surface == null) continue;
                this.builderInputSurface.addTarget(surface);
            }
            this.setModeAuto(this.builderInputSurface);
            this.adaptFpsRange(this.fps, this.builderInputSurface);
            return this.builderInputSurface.build();
        }
        catch (CameraAccessException | IllegalStateException e) {
            Log.e((String)"Camera2ApiManager", (String)"Error", (Throwable)e);
            return null;
        }
    }

    private void setModeAuto(CaptureRequest.Builder builderInputSurface) {
        try {
            builderInputSurface.set(CaptureRequest.CONTROL_MODE, (Object)1);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void adaptFpsRange(int expectedFps, CaptureRequest.Builder builderInputSurface) {
        List<Range<Integer>> fpsRanges = this.getSupportedFps(null, CameraHelper.Facing.BACK);
        if (fpsRanges != null && fpsRanges.size() > 0) {
            Range<Integer> closestRange = fpsRanges.get(0);
            int measure = Math.abs((Integer)closestRange.getLower() - expectedFps) + Math.abs((Integer)closestRange.getUpper() - expectedFps);
            for (Range<Integer> range : fpsRanges) {
                if (CameraHelper.discardCamera2Fps(range, this.facing) || (Integer)range.getLower() > expectedFps || (Integer)range.getUpper() < expectedFps) continue;
                int curMeasure = Math.abs(((Integer)range.getLower() + (Integer)range.getUpper()) / 2 - expectedFps);
                if (curMeasure < measure) {
                    closestRange = range;
                    measure = curMeasure;
                    continue;
                }
                if (curMeasure != measure || Math.abs((Integer)range.getUpper() - expectedFps) >= Math.abs((Integer)closestRange.getUpper() - expectedFps)) continue;
                closestRange = range;
                measure = curMeasure;
            }
            Log.i((String)"Camera2ApiManager", (String)("fps: " + closestRange.getLower() + " - " + closestRange.getUpper()));
            builderInputSurface.set(CaptureRequest.CONTROL_AE_TARGET_FPS_RANGE, closestRange);
        }
    }

    public List<Range<Integer>> getSupportedFps(Size size, CameraHelper.Facing facing) {
        try {
            CameraCharacteristics characteristics = null;
            try {
                characteristics = this.getCharacteristicsForFacing(this.cameraManager, facing);
            }
            catch (CameraAccessException cameraAccessException) {
                // empty catch block
            }
            if (characteristics == null) {
                return null;
            }
            Range[] fpsSupported = (Range[])characteristics.get(CameraCharacteristics.CONTROL_AE_AVAILABLE_TARGET_FPS_RANGES);
            if (size != null) {
                StreamConfigurationMap streamConfigurationMap = (StreamConfigurationMap)characteristics.get(CameraCharacteristics.SCALER_STREAM_CONFIGURATION_MAP);
                ArrayList<Range<Integer>> list = new ArrayList<Range<Integer>>();
                long fd = streamConfigurationMap.getOutputMinFrameDuration(SurfaceTexture.class, size);
                int maxFPS = (int)(10.0f / Float.parseFloat("0." + fd));
                for (Range r : fpsSupported) {
                    if ((Integer)r.getUpper() > maxFPS) continue;
                    list.add((Range<Integer>)r);
                }
                return list;
            }
            return Arrays.asList(fpsSupported);
        }
        catch (IllegalStateException e) {
            Log.e((String)"Camera2ApiManager", (String)"Error", (Throwable)e);
            return null;
        }
    }

    public int getLevelSupported() {
        try {
            CameraCharacteristics characteristics = this.getCameraCharacteristics();
            if (characteristics == null) {
                return -1;
            }
            Integer level = (Integer)characteristics.get(CameraCharacteristics.INFO_SUPPORTED_HARDWARE_LEVEL);
            if (level == null) {
                return -1;
            }
            return level;
        }
        catch (IllegalStateException e) {
            Log.e((String)"Camera2ApiManager", (String)"Error", (Throwable)e);
            return -1;
        }
    }

    public void openCamera() {
        this.openCameraBack();
    }

    public void openCameraBack() {
        this.openCameraFacing(CameraHelper.Facing.BACK);
    }

    public void openCameraFront() {
        this.openCameraFacing(CameraHelper.Facing.FRONT);
    }

    public void openLastCamera() {
        if (this.cameraId == null) {
            this.openCameraBack();
        } else {
            this.openCameraId(this.cameraId);
        }
    }

    public void setCameraFacing(CameraHelper.Facing cameraFacing) {
        try {
            String cameraId = this.getCameraIdForFacing(this.cameraManager, cameraFacing);
            if (cameraId != null) {
                this.facing = cameraFacing;
                this.cameraId = cameraId;
            }
        }
        catch (CameraAccessException e) {
            Log.e((String)"Camera2ApiManager", (String)"Error", (Throwable)e);
        }
    }

    public void setCameraId(String cameraId) {
        this.cameraId = cameraId;
    }

    public CameraHelper.Facing getCameraFacing() {
        return this.facing;
    }

    public Size[] getCameraResolutionsBack() {
        return this.getCameraResolutions(CameraHelper.Facing.BACK);
    }

    public Size[] getCameraResolutionsFront() {
        return this.getCameraResolutions(CameraHelper.Facing.FRONT);
    }

    public Size[] getCameraResolutions(CameraHelper.Facing facing) {
        try {
            CameraCharacteristics characteristics = this.getCharacteristicsForFacing(this.cameraManager, facing);
            if (characteristics == null) {
                return new Size[0];
            }
            StreamConfigurationMap streamConfigurationMap = (StreamConfigurationMap)characteristics.get(CameraCharacteristics.SCALER_STREAM_CONFIGURATION_MAP);
            if (streamConfigurationMap == null) {
                return new Size[0];
            }
            Size[] outputSizes = streamConfigurationMap.getOutputSizes(SurfaceTexture.class);
            return outputSizes != null ? outputSizes : new Size[]{};
        }
        catch (CameraAccessException | NullPointerException e) {
            Log.e((String)"Camera2ApiManager", (String)"Error", (Throwable)e);
            return new Size[0];
        }
    }

    @Nullable
    public CameraCharacteristics getCameraCharacteristics() {
        try {
            return this.cameraId != null ? this.cameraManager.getCameraCharacteristics(this.cameraId) : null;
        }
        catch (CameraAccessException e) {
            Log.e((String)"Camera2ApiManager", (String)"Error", (Throwable)e);
            return null;
        }
    }

    public boolean enableVideoStabilization() {
        CameraCharacteristics characteristics = this.getCameraCharacteristics();
        if (characteristics == null) {
            return false;
        }
        int[] modes = (int[])characteristics.get(CameraCharacteristics.CONTROL_AVAILABLE_VIDEO_STABILIZATION_MODES);
        ArrayList<Integer> videoStabilizationList = new ArrayList<Integer>();
        for (int vsMode : modes) {
            videoStabilizationList.add(vsMode);
        }
        if (!videoStabilizationList.contains(1)) {
            Log.e((String)"Camera2ApiManager", (String)"video stabilization unsupported");
            return false;
        }
        if (this.builderInputSurface != null) {
            this.builderInputSurface.set(CaptureRequest.CONTROL_VIDEO_STABILIZATION_MODE, (Object)1);
            this.videoStabilizationEnable = true;
        }
        return this.videoStabilizationEnable;
    }

    public void disableVideoStabilization() {
        CameraCharacteristics characteristics = this.getCameraCharacteristics();
        if (characteristics == null) {
            return;
        }
        int[] modes = (int[])characteristics.get(CameraCharacteristics.CONTROL_AVAILABLE_VIDEO_STABILIZATION_MODES);
        ArrayList<Integer> videoStabilizationList = new ArrayList<Integer>();
        for (int vsMode : modes) {
            videoStabilizationList.add(vsMode);
        }
        if (!videoStabilizationList.contains(1)) {
            Log.e((String)"Camera2ApiManager", (String)"video stabilization unsupported");
            return;
        }
        if (this.builderInputSurface != null) {
            this.builderInputSurface.set(CaptureRequest.CONTROL_VIDEO_STABILIZATION_MODE, (Object)0);
            this.videoStabilizationEnable = false;
        }
    }

    public boolean isVideoStabilizationEnabled() {
        return this.videoStabilizationEnable;
    }

    public boolean enableOpticalVideoStabilization() {
        CameraCharacteristics characteristics = this.getCameraCharacteristics();
        if (characteristics == null) {
            return false;
        }
        int[] opticalStabilizationModes = (int[])characteristics.get(CameraCharacteristics.LENS_INFO_AVAILABLE_OPTICAL_STABILIZATION);
        ArrayList<Integer> opticalStabilizationList = new ArrayList<Integer>();
        for (int vsMode : opticalStabilizationModes) {
            opticalStabilizationList.add(vsMode);
        }
        if (!opticalStabilizationList.contains(1)) {
            Log.e((String)"Camera2ApiManager", (String)"OIS video stabilization unsupported");
            return false;
        }
        if (this.builderInputSurface != null) {
            this.builderInputSurface.set(CaptureRequest.LENS_OPTICAL_STABILIZATION_MODE, (Object)1);
            this.opticalVideoStabilizationEnable = true;
        }
        return this.opticalVideoStabilizationEnable;
    }

    public void disableOpticalVideoStabilization() {
        CameraCharacteristics characteristics = this.getCameraCharacteristics();
        if (characteristics == null) {
            return;
        }
        int[] modes = (int[])characteristics.get(CameraCharacteristics.LENS_INFO_AVAILABLE_OPTICAL_STABILIZATION);
        ArrayList<Integer> videoStabilizationList = new ArrayList<Integer>();
        for (int vsMode : modes) {
            videoStabilizationList.add(vsMode);
        }
        if (!videoStabilizationList.contains(1)) {
            Log.e((String)"Camera2ApiManager", (String)"OIS video stabilization unsupported");
            return;
        }
        if (this.builderInputSurface != null) {
            this.builderInputSurface.set(CaptureRequest.LENS_OPTICAL_STABILIZATION_MODE, (Object)0);
            this.opticalVideoStabilizationEnable = false;
        }
    }

    public boolean isOpticalStabilizationEnabled() {
        return this.opticalVideoStabilizationEnable;
    }

    public void setFocusDistance(float distance) {
        CameraCharacteristics characteristics = this.getCameraCharacteristics();
        if (characteristics == null) {
            return;
        }
        if (this.builderInputSurface != null) {
            try {
                if (distance < 0.0f) {
                    distance = 0.0f;
                }
                this.builderInputSurface.set(CaptureRequest.LENS_FOCUS_DISTANCE, (Object)Float.valueOf(distance));
                this.cameraCaptureSession.setRepeatingRequest(this.builderInputSurface.build(), this.faceDetectionEnabled ? this.cb : null, null);
            }
            catch (Exception e) {
                Log.e((String)"Camera2ApiManager", (String)"Error", (Throwable)e);
            }
        }
    }

    public void setExposure(int value) {
        CameraCharacteristics characteristics = this.getCameraCharacteristics();
        if (characteristics == null) {
            return;
        }
        Range supportedExposure = (Range)characteristics.get(CameraCharacteristics.CONTROL_AE_COMPENSATION_RANGE);
        if (supportedExposure != null && this.builderInputSurface != null) {
            if (value > (Integer)supportedExposure.getUpper()) {
                value = (Integer)supportedExposure.getUpper();
            }
            if (value < (Integer)supportedExposure.getLower()) {
                value = (Integer)supportedExposure.getLower();
            }
            try {
                this.builderInputSurface.set(CaptureRequest.CONTROL_AE_EXPOSURE_COMPENSATION, (Object)value);
                this.cameraCaptureSession.setRepeatingRequest(this.builderInputSurface.build(), this.faceDetectionEnabled ? this.cb : null, null);
            }
            catch (Exception e) {
                Log.e((String)"Camera2ApiManager", (String)"Error", (Throwable)e);
            }
        }
    }

    public int getExposure() {
        CameraCharacteristics characteristics = this.getCameraCharacteristics();
        if (characteristics == null) {
            return 0;
        }
        if (this.builderInputSurface != null) {
            try {
                return (Integer)this.builderInputSurface.get(CaptureRequest.CONTROL_AE_EXPOSURE_COMPENSATION);
            }
            catch (Exception e) {
                Log.e((String)"Camera2ApiManager", (String)"Error", (Throwable)e);
            }
        }
        return 0;
    }

    public int getMaxExposure() {
        CameraCharacteristics characteristics = this.getCameraCharacteristics();
        if (characteristics == null) {
            return 0;
        }
        Range supportedExposure = (Range)characteristics.get(CameraCharacteristics.CONTROL_AE_COMPENSATION_RANGE);
        if (supportedExposure != null) {
            return (Integer)supportedExposure.getUpper();
        }
        return 0;
    }

    public int getMinExposure() {
        CameraCharacteristics characteristics = this.getCameraCharacteristics();
        if (characteristics == null) {
            return 0;
        }
        Range supportedExposure = (Range)characteristics.get(CameraCharacteristics.CONTROL_AE_COMPENSATION_RANGE);
        if (supportedExposure != null) {
            return (Integer)supportedExposure.getLower();
        }
        return 0;
    }

    public void tapToFocus(MotionEvent event) {
        CameraCharacteristics characteristics = this.getCameraCharacteristics();
        if (characteristics == null) {
            return;
        }
        int pointerId = event.getPointerId(0);
        int pointerIndex = event.findPointerIndex(pointerId);
        float x = event.getX(pointerIndex);
        float y = event.getY(pointerIndex);
        Rect touchRect = new Rect((int)(x - 100.0f), (int)(y - 100.0f), (int)(x + 100.0f), (int)(y + 100.0f));
        MeteringRectangle focusArea = new MeteringRectangle(touchRect, 0);
        if (this.builderInputSurface != null) {
            try {
                this.builderInputSurface.set(CaptureRequest.CONTROL_AF_TRIGGER, (Object)2);
                this.builderInputSurface.set(CaptureRequest.CONTROL_AF_MODE, (Object)0);
                this.cameraCaptureSession.setRepeatingRequest(this.builderInputSurface.build(), this.faceDetectionEnabled ? this.cb : null, null);
                this.builderInputSurface.set(CaptureRequest.CONTROL_AF_REGIONS, (Object)new MeteringRectangle[]{focusArea});
                this.builderInputSurface.set(CaptureRequest.CONTROL_MODE, (Object)1);
                this.builderInputSurface.set(CaptureRequest.CONTROL_AF_MODE, (Object)1);
                this.builderInputSurface.set(CaptureRequest.CONTROL_AF_TRIGGER, (Object)1);
                this.cameraCaptureSession.setRepeatingRequest(this.builderInputSurface.build(), this.faceDetectionEnabled ? this.cb : null, null);
            }
            catch (Exception e) {
                Log.e((String)"Camera2ApiManager", (String)"Error", (Throwable)e);
            }
        }
    }

    public void openCameraFacing(CameraHelper.Facing selectedCameraFacing) {
        try {
            String cameraId = this.getCameraIdForFacing(this.cameraManager, selectedCameraFacing);
            if (cameraId != null) {
                this.openCameraId(cameraId);
            } else {
                Log.e((String)"Camera2ApiManager", (String)"Camera not supported");
            }
        }
        catch (CameraAccessException e) {
            Log.e((String)"Camera2ApiManager", (String)"Error", (Throwable)e);
        }
    }

    public boolean isLanternSupported() {
        CameraCharacteristics characteristics = this.getCameraCharacteristics();
        if (characteristics == null) {
            return false;
        }
        Boolean available = (Boolean)characteristics.get(CameraCharacteristics.FLASH_INFO_AVAILABLE);
        if (available == null) {
            return false;
        }
        return available;
    }

    public boolean isLanternEnabled() {
        return this.lanternEnable;
    }

    public void enableLantern() throws Exception {
        if (this.isLanternSupported()) {
            if (this.builderInputSurface != null) {
                try {
                    this.builderInputSurface.set(CaptureRequest.FLASH_MODE, (Object)2);
                    this.cameraCaptureSession.setRepeatingRequest(this.builderInputSurface.build(), this.faceDetectionEnabled ? this.cb : null, null);
                    this.lanternEnable = true;
                }
                catch (Exception e) {
                    Log.e((String)"Camera2ApiManager", (String)"Error", (Throwable)e);
                }
            }
        } else {
            Log.e((String)"Camera2ApiManager", (String)"Lantern unsupported");
            throw new Exception("Lantern unsupported");
        }
    }

    public void disableLantern() {
        CameraCharacteristics characteristics = this.getCameraCharacteristics();
        if (characteristics == null) {
            return;
        }
        Boolean available = (Boolean)characteristics.get(CameraCharacteristics.FLASH_INFO_AVAILABLE);
        if (available == null) {
            return;
        }
        if (available.booleanValue() && this.builderInputSurface != null) {
            try {
                this.builderInputSurface.set(CaptureRequest.FLASH_MODE, (Object)0);
                this.cameraCaptureSession.setRepeatingRequest(this.builderInputSurface.build(), this.faceDetectionEnabled ? this.cb : null, null);
                this.lanternEnable = false;
            }
            catch (Exception e) {
                Log.e((String)"Camera2ApiManager", (String)"Error", (Throwable)e);
            }
        }
    }

    public void enableAutoFocus() {
        CameraCharacteristics characteristics = this.getCameraCharacteristics();
        if (characteristics == null) {
            return;
        }
        int[] supportedFocusModes = (int[])characteristics.get(CameraCharacteristics.CONTROL_AF_AVAILABLE_MODES);
        if (supportedFocusModes != null) {
            ArrayList<Integer> focusModesList = new ArrayList<Integer>();
            for (int i : supportedFocusModes) {
                focusModesList.add(i);
            }
            if (this.builderInputSurface != null) {
                try {
                    if (!focusModesList.isEmpty()) {
                        this.builderInputSurface.set(CaptureRequest.CONTROL_AF_TRIGGER, (Object)2);
                        this.builderInputSurface.set(CaptureRequest.CONTROL_AF_MODE, (Object)0);
                        this.cameraCaptureSession.setRepeatingRequest(this.builderInputSurface.build(), this.faceDetectionEnabled ? this.cb : null, null);
                        if (focusModesList.contains(4)) {
                            this.builderInputSurface.set(CaptureRequest.CONTROL_AF_MODE, (Object)4);
                            this.cameraCaptureSession.setRepeatingRequest(this.builderInputSurface.build(), this.faceDetectionEnabled ? this.cb : null, null);
                            this.autoFocusEnabled = true;
                        } else if (focusModesList.contains(1)) {
                            this.builderInputSurface.set(CaptureRequest.CONTROL_AF_MODE, (Object)1);
                            this.cameraCaptureSession.setRepeatingRequest(this.builderInputSurface.build(), this.faceDetectionEnabled ? this.cb : null, null);
                            this.autoFocusEnabled = true;
                        } else {
                            this.builderInputSurface.set(CaptureRequest.CONTROL_AF_MODE, (Object)((Integer)focusModesList.get(0)));
                            this.cameraCaptureSession.setRepeatingRequest(this.builderInputSurface.build(), this.faceDetectionEnabled ? this.cb : null, null);
                            this.autoFocusEnabled = false;
                        }
                    }
                }
                catch (Exception e) {
                    Log.e((String)"Camera2ApiManager", (String)"Error", (Throwable)e);
                }
            }
        }
    }

    public void disableAutoFocus() {
        CameraCharacteristics characteristics = this.getCameraCharacteristics();
        if (characteristics == null) {
            return;
        }
        int[] supportedFocusModes = (int[])characteristics.get(CameraCharacteristics.CONTROL_AF_AVAILABLE_MODES);
        if (supportedFocusModes != null && this.builderInputSurface != null) {
            for (int mode : supportedFocusModes) {
                try {
                    if (mode == 0) {
                        this.builderInputSurface.set(CaptureRequest.CONTROL_AF_MODE, (Object)0);
                        this.cameraCaptureSession.setRepeatingRequest(this.builderInputSurface.build(), this.faceDetectionEnabled ? this.cb : null, null);
                        this.autoFocusEnabled = false;
                        return;
                    }
                }
                catch (Exception e) {
                    Log.e((String)"Camera2ApiManager", (String)"Error", (Throwable)e);
                }
            }
        }
    }

    public boolean isAutoFocusEnabled() {
        return this.autoFocusEnabled;
    }

    public boolean enableFaceDetection(FaceDetectorCallback faceDetectorCallback) {
        CameraCharacteristics characteristics = this.getCameraCharacteristics();
        if (characteristics == null) {
            Log.e((String)"Camera2ApiManager", (String)"face detection called with camera stopped");
            return false;
        }
        this.faceSensorScale = (Rect)characteristics.get(CameraCharacteristics.SENSOR_INFO_ACTIVE_ARRAY_SIZE);
        this.sensorOrientation = (Integer)characteristics.get(CameraCharacteristics.SENSOR_ORIENTATION);
        int[] fd = (int[])characteristics.get(CameraCharacteristics.STATISTICS_INFO_AVAILABLE_FACE_DETECT_MODES);
        if (fd == null || fd.length == 0) {
            Log.e((String)"Camera2ApiManager", (String)"face detection unsupported");
            return false;
        }
        Integer maxFD = (Integer)characteristics.get(CameraCharacteristics.STATISTICS_INFO_MAX_FACE_COUNT);
        if (maxFD == null || maxFD <= 0) {
            Log.e((String)"Camera2ApiManager", (String)"face detection unsupported");
            return false;
        }
        ArrayList<Integer> fdList = new ArrayList<Integer>();
        for (int FaceD : fd) {
            fdList.add(FaceD);
        }
        this.faceDetectorCallback = faceDetectorCallback;
        this.faceDetectionEnabled = true;
        this.faceDetectionMode = (Integer)Collections.max(fdList);
        this.setFaceDetect(this.builderInputSurface, this.faceDetectionMode);
        this.prepareFaceDetectionCallback();
        return true;
    }

    public void disableFaceDetection() {
        if (this.faceDetectionEnabled) {
            this.faceDetectorCallback = null;
            this.faceDetectionEnabled = false;
            this.faceDetectionMode = 0;
            this.prepareFaceDetectionCallback();
        }
    }

    public boolean isFaceDetectionEnabled() {
        return this.faceDetectorCallback != null;
    }

    private void setFaceDetect(CaptureRequest.Builder requestBuilder, int faceDetectMode) {
        if (this.faceDetectionEnabled) {
            requestBuilder.set(CaptureRequest.STATISTICS_FACE_DETECT_MODE, (Object)faceDetectMode);
        }
    }

    public void setCameraCallbacks(CameraCallbacks cameraCallbacks) {
        this.cameraCallbacks = cameraCallbacks;
    }

    private void prepareFaceDetectionCallback() {
        try {
            this.cameraCaptureSession.stopRepeating();
            this.cameraCaptureSession.setRepeatingRequest(this.builderInputSurface.build(), this.faceDetectionEnabled ? this.cb : null, null);
        }
        catch (CameraAccessException e) {
            Log.e((String)"Camera2ApiManager", (String)"Error", (Throwable)e);
        }
    }

    @SuppressLint(value={"MissingPermission"})
    public void openCameraId(String cameraId) {
        this.cameraId = cameraId;
        if (this.prepared) {
            HandlerThread cameraHandlerThread = new HandlerThread("Camera2ApiManager Id = " + cameraId);
            cameraHandlerThread.start();
            this.cameraHandler = new Handler(cameraHandlerThread.getLooper());
            try {
                this.cameraManager.openCamera(cameraId, (CameraDevice.StateCallback)this, this.cameraHandler);
                this.semaphore.acquireUninterruptibly();
                CameraCharacteristics cameraCharacteristics = this.cameraManager.getCameraCharacteristics(cameraId);
                this.running = true;
                Integer facing = (Integer)cameraCharacteristics.get(CameraCharacteristics.LENS_FACING);
                if (facing == null) {
                    return;
                }
                CameraHelper.Facing facing2 = this.facing = 0 == facing ? CameraHelper.Facing.FRONT : CameraHelper.Facing.BACK;
                if (this.cameraCallbacks != null) {
                    this.cameraCallbacks.onCameraChanged(this.facing);
                }
            }
            catch (CameraAccessException | SecurityException e) {
                if (this.cameraCallbacks != null) {
                    this.cameraCallbacks.onCameraError("Open camera " + cameraId + " failed");
                }
                Log.e((String)"Camera2ApiManager", (String)"Error", (Throwable)e);
            }
        } else {
            Log.e((String)"Camera2ApiManager", (String)"Camera2ApiManager need be prepared, Camera2ApiManager not enabled");
        }
    }

    public String[] getCamerasAvailable() {
        try {
            return this.cameraManager.getCameraIdList();
        }
        catch (CameraAccessException e) {
            return null;
        }
    }

    public boolean isRunning() {
        return this.running;
    }

    public void switchCamera() {
        try {
            String cameraId = this.cameraDevice == null || this.facing == CameraHelper.Facing.FRONT ? this.getCameraIdForFacing(this.cameraManager, CameraHelper.Facing.BACK) : this.getCameraIdForFacing(this.cameraManager, CameraHelper.Facing.FRONT);
            if (cameraId == null) {
                cameraId = "0";
            }
            this.reOpenCamera(cameraId);
        }
        catch (CameraAccessException e) {
            Log.e((String)"Camera2ApiManager", (String)"Error", (Throwable)e);
        }
    }

    public void reOpenCamera(String cameraId) {
        if (this.cameraDevice != null) {
            this.closeCamera(false);
            if (this.textureView != null) {
                this.prepareCamera(this.textureView, this.surfaceEncoder, this.fps);
            } else if (this.surfaceView != null) {
                this.prepareCamera(this.surfaceView, this.surfaceEncoder, this.fps);
            } else {
                this.prepareCamera(this.surfaceEncoder, this.fps);
            }
            this.openCameraId(cameraId);
        }
    }

    public Range<Float> getZoomRange() {
        CameraCharacteristics characteristics = this.getCameraCharacteristics();
        if (characteristics == null) {
            return new Range((Comparable)Float.valueOf(1.0f), (Comparable)Float.valueOf(1.0f));
        }
        Range zoomRanges = null;
        if (Build.VERSION.SDK_INT >= 30 && this.getLevelSupported() != 2) {
            zoomRanges = (Range)characteristics.get(CameraCharacteristics.CONTROL_ZOOM_RATIO_RANGE);
        }
        if (zoomRanges == null) {
            Float maxZoom = (Float)characteristics.get(CameraCharacteristics.SCALER_AVAILABLE_MAX_DIGITAL_ZOOM);
            if (maxZoom == null) {
                maxZoom = Float.valueOf(1.0f);
            }
            zoomRanges = new Range((Comparable)Float.valueOf(1.0f), (Comparable)maxZoom);
        }
        return zoomRanges;
    }

    public Float getZoom() {
        return Float.valueOf(this.zoomLevel);
    }

    public float[] getOpticalZooms() {
        CameraCharacteristics characteristics = this.getCameraCharacteristics();
        if (characteristics == null) {
            return null;
        }
        return (float[])characteristics.get(CameraCharacteristics.LENS_INFO_AVAILABLE_FOCAL_LENGTHS);
    }

    public void setOpticalZoom(float level) {
        CameraCharacteristics characteristics = this.getCameraCharacteristics();
        if (characteristics == null) {
            return;
        }
        if (this.builderInputSurface != null) {
            try {
                this.builderInputSurface.set(CaptureRequest.LENS_FOCAL_LENGTH, (Object)Float.valueOf(level));
                this.cameraCaptureSession.setRepeatingRequest(this.builderInputSurface.build(), this.faceDetectionEnabled ? this.cb : null, null);
            }
            catch (Exception e) {
                Log.e((String)"Camera2ApiManager", (String)"Error", (Throwable)e);
            }
        }
    }

    public void setZoom(float level) {
        try {
            Range<Float> zoomRange = this.getZoomRange();
            if (level <= ((Float)zoomRange.getLower()).floatValue()) {
                level = ((Float)zoomRange.getLower()).floatValue();
            } else if (level > ((Float)zoomRange.getUpper()).floatValue()) {
                level = ((Float)zoomRange.getUpper()).floatValue();
            }
            CameraCharacteristics characteristics = this.getCameraCharacteristics();
            if (characteristics == null) {
                return;
            }
            if (Build.VERSION.SDK_INT >= 30 && this.getLevelSupported() != 2) {
                this.builderInputSurface.set(CaptureRequest.CONTROL_ZOOM_RATIO, (Object)Float.valueOf(level));
            } else {
                Rect rect = (Rect)characteristics.get(CameraCharacteristics.SENSOR_INFO_ACTIVE_ARRAY_SIZE);
                if (rect == null) {
                    return;
                }
                float ratio = 1.0f / level;
                int croppedWidth = rect.width() - Math.round((float)rect.width() * ratio);
                int croppedHeight = rect.height() - Math.round((float)rect.height() * ratio);
                Rect zoom = new Rect(croppedWidth / 2, croppedHeight / 2, rect.width() - croppedWidth / 2, rect.height() - croppedHeight / 2);
                this.builderInputSurface.set(CaptureRequest.SCALER_CROP_REGION, (Object)zoom);
            }
            this.cameraCaptureSession.setRepeatingRequest(this.builderInputSurface.build(), this.faceDetectionEnabled ? this.cb : null, null);
            this.zoomLevel = level;
        }
        catch (CameraAccessException e) {
            Log.e((String)"Camera2ApiManager", (String)"Error", (Throwable)e);
        }
    }

    public void setZoom(MotionEvent event) {
        if (event.getPointerCount() > 1) {
            float currentFingerSpacing = CameraHelper.getFingerSpacing(event);
            float delta = 0.1f;
            if (this.fingerSpacing != 0.0f) {
                float newLevel = this.zoomLevel;
                if (currentFingerSpacing > this.fingerSpacing) {
                    newLevel += delta;
                } else if (currentFingerSpacing < this.fingerSpacing) {
                    newLevel -= delta;
                }
                this.setZoom(newLevel);
            }
            this.fingerSpacing = currentFingerSpacing;
        }
    }

    private void resetCameraValues() {
        this.lanternEnable = false;
        this.zoomLevel = 1.0f;
    }

    public void stopRepeatingEncoder() {
        if (this.cameraCaptureSession != null) {
            try {
                this.cameraCaptureSession.stopRepeating();
                this.surfaceEncoder = null;
                Surface preview = this.addPreviewSurface();
                if (preview != null) {
                    CaptureRequest captureRequest = this.drawSurface(Collections.singletonList(preview));
                    if (captureRequest != null) {
                        this.cameraCaptureSession.setRepeatingRequest(captureRequest, null, this.cameraHandler);
                    }
                } else {
                    Log.e((String)"Camera2ApiManager", (String)"preview surface is null");
                }
            }
            catch (CameraAccessException | IllegalStateException e) {
                Log.e((String)"Camera2ApiManager", (String)"Error", (Throwable)e);
            }
        }
    }

    public void closeCamera() {
        this.closeCamera(true);
    }

    public void closeCamera(boolean resetSurface) {
        this.resetCameraValues();
        if (this.cameraCaptureSession != null) {
            this.cameraCaptureSession.close();
            this.cameraCaptureSession = null;
        }
        if (this.cameraDevice != null) {
            this.cameraDevice.close();
            this.cameraDevice = null;
        }
        if (this.cameraHandler != null) {
            this.cameraHandler.getLooper().quitSafely();
            this.cameraHandler = null;
        }
        if (resetSurface) {
            this.surfaceEncoder = null;
            this.builderInputSurface = null;
        }
        this.prepared = false;
        this.running = false;
    }

    public void addImageListener(int width, int height, int format, int maxImages, ImageCallback listener) {
        boolean wasRunning = this.running;
        this.closeCamera(false);
        if (wasRunning) {
            this.closeCamera(false);
        }
        if (this.imageReader != null) {
            this.removeImageListener();
        }
        HandlerThread imageThread = new HandlerThread("Camera2ApiManager imageThread");
        imageThread.start();
        this.imageReader = ImageReader.newInstance((int)width, (int)height, (int)format, (int)maxImages);
        this.imageReader.setOnImageAvailableListener(reader -> {
            Image image = reader.acquireLatestImage();
            if (image != null) {
                listener.onImageAvailable(image);
                image.close();
            }
        }, new Handler(imageThread.getLooper()));
        if (wasRunning) {
            if (this.textureView != null) {
                this.prepareCamera(this.textureView, this.surfaceEncoder, this.fps);
            } else if (this.surfaceView != null) {
                this.prepareCamera(this.surfaceView, this.surfaceEncoder, this.fps);
            } else {
                this.prepareCamera(this.surfaceEncoder, this.fps);
            }
            this.openLastCamera();
        }
    }

    public void removeImageListener() {
        boolean wasRunning = this.running;
        if (wasRunning) {
            this.closeCamera(false);
        }
        if (this.imageReader != null) {
            this.imageReader.close();
            this.imageReader = null;
        }
        if (wasRunning) {
            if (this.textureView != null) {
                this.prepareCamera(this.textureView, this.surfaceEncoder, this.fps);
            } else if (this.surfaceView != null) {
                this.prepareCamera(this.surfaceView, this.surfaceEncoder, this.fps);
            } else {
                this.prepareCamera(this.surfaceEncoder, this.fps);
            }
            this.openLastCamera();
        }
    }

    public void onOpened(@NonNull CameraDevice cameraDevice) {
        this.cameraDevice = cameraDevice;
        this.startPreview(cameraDevice);
        this.semaphore.release();
        if (this.cameraCallbacks != null) {
            this.cameraCallbacks.onCameraOpened();
        }
        Log.i((String)"Camera2ApiManager", (String)"Camera opened");
    }

    public void onDisconnected(@NonNull CameraDevice cameraDevice) {
        cameraDevice.close();
        this.semaphore.release();
        if (this.cameraCallbacks != null) {
            this.cameraCallbacks.onCameraDisconnected();
        }
        Log.i((String)"Camera2ApiManager", (String)"Camera disconnected");
    }

    public void onError(@NonNull CameraDevice cameraDevice, int i) {
        cameraDevice.close();
        this.semaphore.release();
        if (this.cameraCallbacks != null) {
            this.cameraCallbacks.onCameraError("Open camera failed: " + i);
        }
        Log.e((String)"Camera2ApiManager", (String)("Open failed: " + i));
    }

    @Nullable
    private String getCameraIdForFacing(CameraManager cameraManager, CameraHelper.Facing facing) throws CameraAccessException {
        int selectedFacing = Camera2ApiManager.getFacing(facing);
        for (String cameraId : cameraManager.getCameraIdList()) {
            Integer cameraFacing = (Integer)cameraManager.getCameraCharacteristics(cameraId).get(CameraCharacteristics.LENS_FACING);
            if (cameraFacing == null || cameraFacing != selectedFacing) continue;
            return cameraId;
        }
        return null;
    }

    private CameraHelper.Facing getFacingByCameraId(CameraManager cameraManager, String cameraId) {
        try {
            for (String id : cameraManager.getCameraIdList()) {
                if (!id.equals(cameraId)) continue;
                Integer cameraFacing = (Integer)cameraManager.getCameraCharacteristics(cameraId).get(CameraCharacteristics.LENS_FACING);
                if (cameraFacing == 1) {
                    return CameraHelper.Facing.BACK;
                }
                return CameraHelper.Facing.FRONT;
            }
            return CameraHelper.Facing.BACK;
        }
        catch (CameraAccessException e) {
            return CameraHelper.Facing.BACK;
        }
    }

    @Nullable
    public String getCameraIdForFacing(CameraHelper.Facing facing) {
        try {
            return this.getCameraIdForFacing(this.cameraManager, facing);
        }
        catch (Exception e) {
            return null;
        }
    }

    @Nullable
    private CameraCharacteristics getCharacteristicsForFacing(CameraManager cameraManager, CameraHelper.Facing facing) throws CameraAccessException {
        String cameraId = this.getCameraIdForFacing(cameraManager, facing);
        return cameraId != null ? cameraManager.getCameraCharacteristics(cameraId) : null;
    }

    private static int getFacing(CameraHelper.Facing facing) {
        return facing == CameraHelper.Facing.BACK ? 1 : 0;
    }

    public static interface FaceDetectorCallback {
        public void onGetFaces(Face[] var1, Rect var2, int var3);
    }

    public static interface ImageCallback {
        public void onImageAvailable(Image var1);
    }
}

