/*
 * Decompiled with CFR 0.152.
 */
package com.pedro.encoder.input.video;

import android.content.Context;
import android.graphics.Rect;
import android.graphics.SurfaceTexture;
import android.hardware.Camera;
import android.media.CamcorderProfile;
import android.util.Log;
import android.view.MotionEvent;
import android.view.SurfaceView;
import android.view.TextureView;
import android.view.View;
import com.pedro.encoder.Frame;
import com.pedro.encoder.input.video.CameraCallbacks;
import com.pedro.encoder.input.video.CameraHelper;
import com.pedro.encoder.input.video.CameraOpenException;
import com.pedro.encoder.input.video.GetCameraData;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class Camera1ApiManager
implements Camera.PreviewCallback,
Camera.FaceDetectionListener {
    private String TAG = "Camera1ApiManager";
    private Camera camera = null;
    private SurfaceView surfaceView;
    private TextureView textureView;
    private SurfaceTexture surfaceTexture;
    private GetCameraData getCameraData;
    private boolean running = false;
    private boolean lanternEnable = false;
    private boolean autoFocusEnabled = false;
    private int cameraSelect;
    private CameraHelper.Facing facing = CameraHelper.Facing.BACK;
    private boolean isPortrait = false;
    private Context context;
    private int width = 640;
    private int height = 480;
    private int fps = 30;
    private int rotation = 0;
    private int imageFormat = 17;
    private byte[] yuvBuffer;
    private List<Camera.Size> previewSizeBack;
    private List<Camera.Size> previewSizeFront;
    private float distance;
    private CameraCallbacks cameraCallbacks;
    private final int focusAreaSize = 100;
    private final int sensorOrientation = 0;
    private final Rect faceSensorScale = new Rect(-1000, -1000, 1000, 1000);
    private FaceDetectorCallback faceDetectorCallback;
    private Camera.AutoFocusCallback autoFocusTakePictureCallback = new Camera.AutoFocusCallback(){

        public void onAutoFocus(boolean success, Camera camera) {
            if (success) {
                Log.i((String)Camera1ApiManager.this.TAG, (String)"tapToFocus success");
            } else {
                Log.e((String)Camera1ApiManager.this.TAG, (String)"tapToFocus failed");
            }
        }
    };

    public Camera1ApiManager(SurfaceView surfaceView, GetCameraData getCameraData) {
        this.surfaceView = surfaceView;
        this.getCameraData = getCameraData;
        this.context = surfaceView.getContext();
        this.init();
    }

    public Camera1ApiManager(TextureView textureView, GetCameraData getCameraData) {
        this.textureView = textureView;
        this.getCameraData = getCameraData;
        this.context = textureView.getContext();
        this.init();
    }

    public Camera1ApiManager(SurfaceTexture surfaceTexture, Context context) {
        this.surfaceTexture = surfaceTexture;
        this.context = context;
        this.init();
    }

    private void init() {
        this.cameraSelect = this.selectCameraBack();
        this.previewSizeBack = this.getPreviewSize();
        this.cameraSelect = this.selectCameraFront();
        this.previewSizeFront = this.getPreviewSize();
    }

    public void setRotation(int rotation) {
        this.rotation = rotation;
    }

    public void setSurfaceTexture(SurfaceTexture surfaceTexture) {
        this.surfaceTexture = surfaceTexture;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public void setCameraFacing(CameraHelper.Facing cameraFacing) {
        this.facing = cameraFacing;
    }

    public void start(CameraHelper.Facing cameraFacing, int width, int height, int fps) {
        boolean facing = cameraFacing != CameraHelper.Facing.BACK;
        this.width = width;
        this.height = height;
        this.fps = fps;
        this.cameraSelect = !facing ? this.selectCameraBack() : this.selectCameraFront();
        this.start();
    }

    public void start(int width, int height, int fps) {
        this.start(this.facing, width, height, fps);
    }

    private void start() {
        if (!this.checkCanOpen()) {
            throw new CameraOpenException("This camera resolution cant be opened");
        }
        this.yuvBuffer = new byte[this.width * this.height * 3 / 2];
        try {
            this.camera = Camera.open((int)this.cameraSelect);
            Camera.CameraInfo info = new Camera.CameraInfo();
            Camera.getCameraInfo((int)this.cameraSelect, (Camera.CameraInfo)info);
            this.facing = info.facing == 1 ? CameraHelper.Facing.FRONT : CameraHelper.Facing.BACK;
            this.isPortrait = this.context.getResources().getConfiguration().orientation == 1;
            Camera.Parameters parameters = this.camera.getParameters();
            parameters.setPreviewSize(this.width, this.height);
            parameters.setPreviewFormat(this.imageFormat);
            int[] range = this.adaptFpsRange(this.fps, parameters.getSupportedPreviewFpsRange());
            parameters.setPreviewFpsRange(range[0], range[1]);
            List supportedFocusModes = parameters.getSupportedFocusModes();
            if (supportedFocusModes != null && !supportedFocusModes.isEmpty()) {
                if (supportedFocusModes.contains("continuous-picture")) {
                    parameters.setFocusMode("continuous-picture");
                    this.autoFocusEnabled = true;
                } else if (supportedFocusModes.contains("auto")) {
                    parameters.setFocusMode("auto");
                    this.autoFocusEnabled = true;
                } else {
                    parameters.setFocusMode((String)supportedFocusModes.get(0));
                    this.autoFocusEnabled = false;
                }
            }
            this.camera.setParameters(parameters);
            this.camera.setDisplayOrientation(this.rotation);
            if (this.surfaceView != null) {
                this.camera.setPreviewDisplay(this.surfaceView.getHolder());
                this.camera.addCallbackBuffer(this.yuvBuffer);
                this.camera.setPreviewCallbackWithBuffer((Camera.PreviewCallback)this);
            } else if (this.textureView != null) {
                this.camera.setPreviewTexture(this.textureView.getSurfaceTexture());
                this.camera.addCallbackBuffer(this.yuvBuffer);
                this.camera.setPreviewCallbackWithBuffer((Camera.PreviewCallback)this);
            } else {
                this.camera.setPreviewTexture(this.surfaceTexture);
            }
            this.camera.startPreview();
            this.running = true;
            if (this.cameraCallbacks != null) {
                this.cameraCallbacks.onCameraChanged(this.facing);
            }
            Log.i((String)this.TAG, (String)(this.width + "X" + this.height));
        }
        catch (IOException e) {
            if (this.cameraCallbacks != null) {
                this.cameraCallbacks.onCameraError(e.getMessage());
            }
            Log.e((String)this.TAG, (String)"Error", (Throwable)e);
        }
    }

    public void setPreviewOrientation(int orientation) {
        this.rotation = orientation;
        if (this.camera != null && this.running) {
            this.camera.stopPreview();
            this.camera.setDisplayOrientation(orientation);
            this.camera.startPreview();
        }
    }

    public void setZoom(MotionEvent event) {
        try {
            if (this.camera != null && this.running && this.camera.getParameters() != null && this.camera.getParameters().isZoomSupported()) {
                Camera.Parameters params = this.camera.getParameters();
                int maxZoom = params.getMaxZoom();
                int zoom = params.getZoom();
                float newDist = CameraHelper.getFingerSpacing(event);
                if (newDist > this.distance) {
                    if (zoom < maxZoom) {
                        ++zoom;
                    }
                } else if (newDist < this.distance && zoom > 0) {
                    --zoom;
                }
                this.distance = newDist;
                params.setZoom(zoom);
                this.camera.setParameters(params);
            }
        }
        catch (Exception e) {
            Log.e((String)this.TAG, (String)"Error", (Throwable)e);
        }
    }

    public void setExposure(int value) {
        if (this.camera != null && this.camera.getParameters() != null) {
            Camera.Parameters params = this.camera.getParameters();
            if (value > params.getMaxExposureCompensation()) {
                value = params.getMaxExposureCompensation();
            } else if (value < params.getMinExposureCompensation()) {
                value = params.getMinExposureCompensation();
            }
            params.setExposureCompensation(value);
            this.camera.setParameters(params);
        }
    }

    public int getExposure() {
        if (this.camera != null && this.camera.getParameters() != null) {
            Camera.Parameters params = this.camera.getParameters();
            return params.getExposureCompensation();
        }
        return 0;
    }

    public int getMaxExposure() {
        if (this.camera != null && this.camera.getParameters() != null) {
            Camera.Parameters params = this.camera.getParameters();
            return params.getMaxExposureCompensation();
        }
        return 0;
    }

    public int getMinExposure() {
        if (this.camera != null && this.camera.getParameters() != null) {
            Camera.Parameters params = this.camera.getParameters();
            return params.getMinExposureCompensation();
        }
        return 0;
    }

    private int selectCameraBack() {
        return this.selectCamera(0);
    }

    private int selectCameraFront() {
        return this.selectCamera(1);
    }

    private int selectCamera(int facing) {
        int number = Camera.getNumberOfCameras();
        for (int i = 0; i < number; ++i) {
            Camera.CameraInfo info = new Camera.CameraInfo();
            Camera.getCameraInfo((int)i, (Camera.CameraInfo)info);
            if (info.facing != facing) continue;
            return i;
        }
        return 0;
    }

    public void stop() {
        if (this.camera != null) {
            this.camera.stopPreview();
            this.camera.setPreviewCallback(null);
            this.camera.setPreviewCallbackWithBuffer(null);
            this.camera.release();
            this.camera = null;
        }
        this.running = false;
    }

    public boolean isRunning() {
        return this.running;
    }

    private int[] adaptFpsRange(int expectedFps, List<int[]> fpsRanges) {
        int[] closestRange = fpsRanges.get(0);
        int measure = Math.abs(closestRange[0] - (expectedFps *= 1000)) + Math.abs(closestRange[1] - expectedFps);
        for (int[] range : fpsRanges) {
            int curMeasure;
            if (range[0] > expectedFps || range[1] < expectedFps || (curMeasure = Math.abs(range[0] - expectedFps) + Math.abs(range[1] - expectedFps)) >= measure) continue;
            closestRange = range;
            measure = curMeasure;
        }
        return closestRange;
    }

    public void onPreviewFrame(byte[] data, Camera camera) {
        this.getCameraData.inputYUVData(new Frame(data, this.rotation, this.facing == CameraHelper.Facing.FRONT && this.isPortrait, this.imageFormat));
        camera.addCallbackBuffer(this.yuvBuffer);
    }

    public List<Integer> getCameraPreviewImageFormatSupported() {
        List formats;
        if (this.camera != null) {
            formats = this.camera.getParameters().getSupportedPreviewFormats();
            for (Integer i : formats) {
                Log.i((String)this.TAG, (String)("camera format supported: " + i));
            }
        } else {
            this.camera = Camera.open((int)this.cameraSelect);
            formats = this.camera.getParameters().getSupportedPreviewFormats();
            this.camera.release();
            this.camera = null;
        }
        return formats;
    }

    private List<Camera.Size> getPreviewSize() {
        List previewSizes;
        Camera.Size maxSize;
        if (this.camera != null) {
            maxSize = this.getMaxEncoderSizeSupported();
            previewSizes = this.camera.getParameters().getSupportedPreviewSizes();
        } else {
            this.camera = Camera.open((int)this.cameraSelect);
            maxSize = this.getMaxEncoderSizeSupported();
            previewSizes = this.camera.getParameters().getSupportedPreviewSizes();
            this.camera.release();
            this.camera = null;
        }
        Iterator iterator = previewSizes.iterator();
        while (iterator.hasNext()) {
            Camera.Size size = (Camera.Size)iterator.next();
            if (size.width <= maxSize.width && size.height <= maxSize.height) continue;
            Log.i((String)this.TAG, (String)(size.width + "X" + size.height + ", not supported for encoder"));
            iterator.remove();
        }
        return previewSizes;
    }

    public List<Camera.Size> getPreviewSizeBack() {
        return this.previewSizeBack;
    }

    public List<Camera.Size> getPreviewSizeFront() {
        return this.previewSizeFront;
    }

    private Camera.Size getMaxEncoderSizeSupported() {
        if (CamcorderProfile.hasProfile((int)8)) {
            Camera camera = this.camera;
            camera.getClass();
            return new Camera.Size(camera, 3840, 2160);
        }
        if (CamcorderProfile.hasProfile((int)6)) {
            Camera camera = this.camera;
            camera.getClass();
            return new Camera.Size(camera, 1920, 1080);
        }
        if (CamcorderProfile.hasProfile((int)5)) {
            Camera camera = this.camera;
            camera.getClass();
            return new Camera.Size(camera, 1280, 720);
        }
        Camera camera = this.camera;
        camera.getClass();
        return new Camera.Size(camera, 640, 480);
    }

    public CameraHelper.Facing getCameraFacing() {
        return this.facing;
    }

    public void switchCamera() throws CameraOpenException {
        if (this.camera != null) {
            int oldCamera = this.cameraSelect;
            int number = Camera.getNumberOfCameras();
            for (int i = 0; i < number; ++i) {
                if (this.cameraSelect == i) continue;
                this.cameraSelect = i;
                if (!this.checkCanOpen()) {
                    this.cameraSelect = oldCamera;
                    throw new CameraOpenException("This camera resolution cant be opened");
                }
                this.stop();
                this.start();
                return;
            }
        }
    }

    private boolean checkCanOpen() {
        List<Camera.Size> previews = this.cameraSelect == this.selectCameraBack() ? this.previewSizeBack : this.previewSizeFront;
        for (Camera.Size size : previews) {
            if (size.width != this.width || size.height != this.height) continue;
            return true;
        }
        return false;
    }

    public boolean isLanternEnabled() {
        return this.lanternEnable;
    }

    public void enableLantern() throws Exception {
        Camera.Parameters parameters;
        List supportedFlashModes;
        if (this.camera != null && (supportedFlashModes = (parameters = this.camera.getParameters()).getSupportedFlashModes()) != null && !supportedFlashModes.isEmpty()) {
            if (supportedFlashModes.contains("torch")) {
                parameters.setFlashMode("torch");
                this.camera.setParameters(parameters);
                this.lanternEnable = true;
            } else {
                Log.e((String)this.TAG, (String)"Lantern unsupported");
                throw new Exception("Lantern unsupported");
            }
        }
    }

    public List<int[]> getSupportedFps() {
        List supportedFps;
        if (this.camera != null) {
            supportedFps = this.camera.getParameters().getSupportedPreviewFpsRange();
        } else {
            this.camera = Camera.open((int)this.cameraSelect);
            supportedFps = this.camera.getParameters().getSupportedPreviewFpsRange();
            this.camera.release();
            this.camera = null;
        }
        for (int[] range : supportedFps) {
            range[0] = range[0] / 1000;
            range[1] = range[1] / 1000;
        }
        return supportedFps;
    }

    public void disableLantern() {
        if (this.camera != null) {
            Camera.Parameters parameters = this.camera.getParameters();
            parameters.setFlashMode("off");
            this.camera.setParameters(parameters);
            this.lanternEnable = false;
        }
    }

    public void tapToFocus(View view, MotionEvent event) {
        if (this.camera != null && this.camera.getParameters() != null) {
            Camera.Parameters parameters = this.camera.getParameters();
            if (parameters.getMaxNumMeteringAreas() > 0) {
                Rect rect = this.calculateFocusArea(event.getX(), event.getY(), view.getWidth(), view.getHeight());
                parameters.setFocusMode("auto");
                ArrayList<Camera.Area> meteringAreas = new ArrayList<Camera.Area>();
                meteringAreas.add(new Camera.Area(rect, 800));
                parameters.setFocusAreas(meteringAreas);
                try {
                    this.camera.setParameters(parameters);
                }
                catch (Exception e) {
                    Log.i((String)this.TAG, (String)("tapToFocus error: " + e.getMessage()));
                }
            }
            this.camera.autoFocus(this.autoFocusTakePictureCallback);
        }
    }

    public void enableAutoFocus() {
        if (this.camera != null) {
            Camera.Parameters parameters = this.camera.getParameters();
            List supportedFocusModes = parameters.getSupportedFocusModes();
            if (supportedFocusModes != null && !supportedFocusModes.isEmpty()) {
                if (supportedFocusModes.contains("continuous-picture")) {
                    parameters.setFocusMode("continuous-picture");
                    this.autoFocusEnabled = true;
                } else if (supportedFocusModes.contains("auto")) {
                    parameters.setFocusMode("auto");
                    this.autoFocusEnabled = true;
                } else {
                    this.autoFocusEnabled = false;
                    parameters.setFocusMode((String)supportedFocusModes.get(0));
                }
            }
            this.camera.setParameters(parameters);
        }
    }

    public void disableAutoFocus() {
        if (this.camera != null) {
            Camera.Parameters parameters = this.camera.getParameters();
            List supportedFocusModes = parameters.getSupportedFocusModes();
            if (supportedFocusModes != null && !supportedFocusModes.isEmpty()) {
                if (supportedFocusModes.contains("infinity")) {
                    parameters.setFocusMode("infinity");
                } else {
                    parameters.setFocusMode((String)supportedFocusModes.get(0));
                }
            }
            this.autoFocusEnabled = false;
            this.camera.setParameters(parameters);
        }
    }

    public boolean isAutoFocusEnabled() {
        return this.autoFocusEnabled;
    }

    public void enableRecordingHint() {
        if (this.camera != null) {
            Camera.Parameters parameters = this.camera.getParameters();
            parameters.setRecordingHint(true);
            this.camera.setParameters(parameters);
        }
    }

    public void disableRecordingHint() {
        if (this.camera != null) {
            Camera.Parameters parameters = this.camera.getParameters();
            parameters.setRecordingHint(false);
            this.camera.setParameters(parameters);
        }
    }

    public boolean enableFaceDetection(FaceDetectorCallback faceDetectorCallback) {
        try {
            if (this.camera != null) {
                this.faceDetectorCallback = faceDetectorCallback;
                this.camera.setFaceDetectionListener((Camera.FaceDetectionListener)this);
                this.camera.startFaceDetection();
                return true;
            }
            Log.e((String)this.TAG, (String)"face detection called with camera stopped");
            return false;
        }
        catch (IllegalArgumentException e) {
            Log.e((String)this.TAG, (String)"face detection unsupported");
            return false;
        }
    }

    public void disableFaceDetection() {
        if (this.camera != null) {
            this.faceDetectorCallback = null;
            this.camera.stopFaceDetection();
            this.camera.setFaceDetectionListener(null);
        }
    }

    public void setCameraCallbacks(CameraCallbacks cameraCallbacks) {
        this.cameraCallbacks = cameraCallbacks;
    }

    public boolean isFaceDetectionEnabled() {
        return this.faceDetectorCallback != null;
    }

    public void onFaceDetection(Camera.Face[] faces, Camera camera) {
        if (this.faceDetectorCallback != null) {
            this.faceDetectorCallback.onGetFaces(faces, this.faceSensorScale, 0);
        }
    }

    private Rect calculateFocusArea(float x, float y, float previewWidth, float previewHeight) {
        int left = this.clamp((int)(x / previewWidth * 2000.0f - 1000.0f), 100);
        int top = this.clamp((int)(y / previewHeight * 2000.0f - 1000.0f), 100);
        return new Rect(left, top, left + 100, top + 100);
    }

    private int clamp(int touchCoordinateInCameraReper, int focusAreaSize) {
        int result = Math.abs(touchCoordinateInCameraReper) + focusAreaSize / 2 > 1000 ? (touchCoordinateInCameraReper > 0 ? 1000 - focusAreaSize / 2 : -1000 + focusAreaSize / 2) : touchCoordinateInCameraReper - focusAreaSize / 2;
        return result;
    }

    public static interface FaceDetectorCallback {
        public void onGetFaces(Camera.Face[] var1, Rect var2, int var3);
    }
}

