/*
 * Decompiled with CFR 0.152.
 */
package com.pedro.encoder.utils;

import android.media.MediaCodecInfo;
import android.media.MediaCodecList;
import android.os.Build;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class CodecUtil {
    private static final String TAG = "CodecUtil";
    public static final String H264_MIME = "video/avc";
    public static final String H265_MIME = "video/hevc";
    public static final String AAC_MIME = "audio/mp4a-latm";

    /*
     * Could not resolve type clashes
     */
    public static List<String> showAllCodecsInfo() {
        List<MediaCodecInfo> mediaCodecInfoList = CodecUtil.getAllCodecs(false);
        ArrayList<String> infos = new ArrayList<String>();
        for (MediaCodecInfo mediaCodecInfo : mediaCodecInfoList) {
            String info = "----------------\n";
            info = info + "Name: " + mediaCodecInfo.getName() + "\n";
            for (String type : mediaCodecInfo.getSupportedTypes()) {
                MediaCodecInfo.VideoCapabilities videoCapabilities;
                int n;
                MediaCodecInfo.CodecProfileLevel[] encoderCapabilities;
                info = info + "Type: " + type + "\n";
                MediaCodecInfo.CodecCapabilities codecCapabilities = mediaCodecInfo.getCapabilitiesForType(type);
                if (Build.VERSION.SDK_INT >= 23) {
                    info = info + "Max instances: " + codecCapabilities.getMaxSupportedInstances() + "\n";
                }
                if (mediaCodecInfo.isEncoder()) {
                    info = info + "----- Encoder info -----\n";
                    encoderCapabilities = null;
                    if (Build.VERSION.SDK_INT >= 21) {
                        encoderCapabilities = codecCapabilities.getEncoderCapabilities();
                        info = info + "Complexity range: " + encoderCapabilities.getComplexityRange().getLower() + " - " + encoderCapabilities.getComplexityRange().getUpper() + "\n";
                    }
                    if (Build.VERSION.SDK_INT >= 28) {
                        info = info + "Quality range: " + encoderCapabilities.getQualityRange().getLower() + " - " + encoderCapabilities.getQualityRange().getUpper() + "\n";
                    }
                    if (Build.VERSION.SDK_INT >= 21) {
                        info = info + "CBR supported: " + encoderCapabilities.isBitrateModeSupported(2) + "\n";
                        info = info + "VBR supported: " + encoderCapabilities.isBitrateModeSupported(1) + "\n";
                        info = info + "CQ supported: " + encoderCapabilities.isBitrateModeSupported(0) + "\n";
                    }
                    info = info + "----- -----\n";
                } else {
                    info = info + "----- Decoder info -----\n";
                    info = info + "----- -----\n";
                }
                if (codecCapabilities.colorFormats != null && codecCapabilities.colorFormats.length > 0) {
                    info = info + "----- Video info -----\n";
                    info = info + "Supported colors: \n";
                    for (MediaCodecInfo.EncoderCapabilities color : (MediaCodecInfo.CodecProfileLevel[])codecCapabilities.colorFormats) {
                        info = info + (int)color + "\n";
                    }
                    encoderCapabilities = codecCapabilities.profileLevels;
                    int n2 = encoderCapabilities.length;
                    for (n = 0; n < n2; ++n) {
                        MediaCodecInfo.CodecProfileLevel profile = encoderCapabilities[n];
                        info = info + "Profile: " + profile.profile + ", level: " + profile.level + "\n";
                    }
                    videoCapabilities = null;
                    if (Build.VERSION.SDK_INT >= 21) {
                        videoCapabilities = codecCapabilities.getVideoCapabilities();
                        info = info + "Bitrate range: " + videoCapabilities.getBitrateRange().getLower() + " - " + videoCapabilities.getBitrateRange().getUpper() + "\n";
                        info = info + "Frame rate range: " + videoCapabilities.getSupportedFrameRates().getLower() + " - " + videoCapabilities.getSupportedFrameRates().getUpper() + "\n";
                        info = info + "Width range: " + videoCapabilities.getSupportedWidths().getLower() + " - " + videoCapabilities.getSupportedWidths().getUpper() + "\n";
                        info = info + "Height range: " + videoCapabilities.getSupportedHeights().getLower() + " - " + videoCapabilities.getSupportedHeights().getUpper() + "\n";
                    }
                    info = info + "----- -----\n";
                } else {
                    info = info + "----- Audio info -----\n";
                    videoCapabilities = codecCapabilities.profileLevels;
                    int n3 = ((MediaCodecInfo.CodecProfileLevel[])videoCapabilities).length;
                    for (n = 0; n < n3; ++n) {
                        MediaCodecInfo.CodecProfileLevel profile = videoCapabilities[n];
                        info = info + "Profile: " + profile.profile + ", level: " + profile.level + "\n";
                    }
                    if (Build.VERSION.SDK_INT >= 21) {
                        MediaCodecInfo.AudioCapabilities audioCapabilities = codecCapabilities.getAudioCapabilities();
                        info = info + "Bitrate range: " + audioCapabilities.getBitrateRange().getLower() + " - " + audioCapabilities.getBitrateRange().getUpper() + "\n";
                        info = info + "Channels supported: " + audioCapabilities.getMaxInputChannelCount() + "\n";
                        try {
                            if (audioCapabilities.getSupportedSampleRates() != null && audioCapabilities.getSupportedSampleRates().length > 0) {
                                info = info + "Supported sample rate: \n";
                                int[] nArray = audioCapabilities.getSupportedSampleRates();
                                n = nArray.length;
                                for (int i = 0; i < n; ++i) {
                                    int sr = nArray[i];
                                    info = info + sr + "\n";
                                }
                            }
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    info = info + "----- -----\n";
                }
                if (Build.VERSION.SDK_INT < 23) continue;
                info = info + "Max instances: " + codecCapabilities.getMaxSupportedInstances() + "\n";
            }
            info = info + "----------------\n";
            infos.add(info);
        }
        return infos;
    }

    public static List<MediaCodecInfo> getAllCodecs(boolean filterBroken) {
        ArrayList<MediaCodecInfo> mediaCodecInfoList = new ArrayList<MediaCodecInfo>();
        if (Build.VERSION.SDK_INT >= 21) {
            MediaCodecList mediaCodecList = new MediaCodecList(1);
            MediaCodecInfo[] mediaCodecInfos = mediaCodecList.getCodecInfos();
            mediaCodecInfoList.addAll(Arrays.asList(mediaCodecInfos));
        } else {
            int count = MediaCodecList.getCodecCount();
            for (int i = 0; i < count; ++i) {
                MediaCodecInfo mci = MediaCodecList.getCodecInfoAt((int)i);
                mediaCodecInfoList.add(mci);
            }
        }
        return filterBroken ? CodecUtil.filterBrokenCodecs(mediaCodecInfoList) : mediaCodecInfoList;
    }

    public static List<MediaCodecInfo> getAllHardwareEncoders(String mime) {
        List<MediaCodecInfo> mediaCodecInfoList = CodecUtil.getAllEncoders(mime);
        ArrayList<MediaCodecInfo> mediaCodecInfoHardware = new ArrayList<MediaCodecInfo>();
        for (MediaCodecInfo mediaCodecInfo : mediaCodecInfoList) {
            if (!CodecUtil.isHardwareAccelerated(mediaCodecInfo)) continue;
            mediaCodecInfoHardware.add(mediaCodecInfo);
        }
        return mediaCodecInfoHardware;
    }

    public static List<MediaCodecInfo> getAllHardwareDecoders(String mime) {
        List<MediaCodecInfo> mediaCodecInfoList = CodecUtil.getAllDecoders(mime);
        ArrayList<MediaCodecInfo> mediaCodecInfoHardware = new ArrayList<MediaCodecInfo>();
        for (MediaCodecInfo mediaCodecInfo : mediaCodecInfoList) {
            if (!CodecUtil.isHardwareAccelerated(mediaCodecInfo)) continue;
            mediaCodecInfoHardware.add(mediaCodecInfo);
        }
        return mediaCodecInfoHardware;
    }

    public static List<MediaCodecInfo> getAllSoftwareEncoders(String mime) {
        List<MediaCodecInfo> mediaCodecInfoList = CodecUtil.getAllEncoders(mime);
        ArrayList<MediaCodecInfo> mediaCodecInfoSoftware = new ArrayList<MediaCodecInfo>();
        for (MediaCodecInfo mediaCodecInfo : mediaCodecInfoList) {
            if (!CodecUtil.isSoftwareOnly(mediaCodecInfo)) continue;
            mediaCodecInfoSoftware.add(mediaCodecInfo);
        }
        return mediaCodecInfoSoftware;
    }

    public static List<MediaCodecInfo> getAllSoftwareDecoders(String mime) {
        List<MediaCodecInfo> mediaCodecInfoList = CodecUtil.getAllDecoders(mime);
        ArrayList<MediaCodecInfo> mediaCodecInfoSoftware = new ArrayList<MediaCodecInfo>();
        for (MediaCodecInfo mediaCodecInfo : mediaCodecInfoList) {
            if (!CodecUtil.isSoftwareOnly(mediaCodecInfo)) continue;
            mediaCodecInfoSoftware.add(mediaCodecInfo);
        }
        return mediaCodecInfoSoftware;
    }

    public static List<MediaCodecInfo> getAllEncoders(String mime) {
        ArrayList<MediaCodecInfo> mediaCodecInfoList = new ArrayList<MediaCodecInfo>();
        List<MediaCodecInfo> mediaCodecInfos = CodecUtil.getAllCodecs(true);
        for (MediaCodecInfo mci : mediaCodecInfos) {
            String[] types;
            if (!mci.isEncoder()) continue;
            for (String type : types = mci.getSupportedTypes()) {
                if (!type.equalsIgnoreCase(mime)) continue;
                mediaCodecInfoList.add(mci);
            }
        }
        return mediaCodecInfoList;
    }

    public static List<MediaCodecInfo> getAllDecoders(String mime) {
        ArrayList<MediaCodecInfo> mediaCodecInfoList = new ArrayList<MediaCodecInfo>();
        List<MediaCodecInfo> mediaCodecInfos = CodecUtil.getAllCodecs(true);
        for (MediaCodecInfo mci : mediaCodecInfos) {
            String[] types;
            if (mci.isEncoder()) continue;
            for (String type : types = mci.getSupportedTypes()) {
                if (!type.equalsIgnoreCase(mime)) continue;
                mediaCodecInfoList.add(mci);
            }
        }
        return mediaCodecInfoList;
    }

    private static boolean isHardwareAccelerated(MediaCodecInfo codecInfo) {
        if (Build.VERSION.SDK_INT >= 29) {
            return codecInfo.isHardwareAccelerated();
        }
        return !CodecUtil.isSoftwareOnly(codecInfo);
    }

    private static boolean isSoftwareOnly(MediaCodecInfo mediaCodecInfo) {
        if (Build.VERSION.SDK_INT >= 29) {
            return mediaCodecInfo.isSoftwareOnly();
        }
        String name = mediaCodecInfo.getName().toLowerCase();
        if (name.startsWith("arc.")) {
            return false;
        }
        return name.startsWith("omx.google.") || name.startsWith("omx.ffmpeg.") || name.startsWith("omx.sec.") && name.contains(".sw.") || name.equals("omx.qcom.video.decoder.hevcswvdec") || name.startsWith("c2.android.") || name.startsWith("c2.google.") || !name.startsWith("omx.") && !name.startsWith("c2.");
    }

    private static List<MediaCodecInfo> filterBrokenCodecs(List<MediaCodecInfo> codecs) {
        ArrayList<MediaCodecInfo> listFilter = new ArrayList<MediaCodecInfo>();
        for (MediaCodecInfo mediaCodecInfo : codecs) {
            if (!CodecUtil.isValid(mediaCodecInfo.getName())) continue;
            listFilter.add(mediaCodecInfo);
        }
        return listFilter;
    }

    private static boolean isValid(String name) {
        return !name.equalsIgnoreCase("aacencoder");
    }

    public static enum Force {
        FIRST_COMPATIBLE_FOUND,
        SOFTWARE,
        HARDWARE;

    }
}

