/*
 * Decompiled with CFR 0.152.
 */
package com.pedro.encoder.input.gl.render.filters;

import android.content.Context;
import android.opengl.GLES20;
import androidx.annotation.RequiresApi;
import com.pedro.encoder.input.gl.render.BaseRenderOffScreen;
import com.pedro.encoder.input.gl.render.RenderHandler;
import com.pedro.encoder.utils.gl.GlUtil;

@RequiresApi(api=18)
public abstract class BaseFilterRender
extends BaseRenderOffScreen {
    private int width;
    private int height;
    private int previewWidth;
    private int previewHeight;
    protected int previousTexId;
    private RenderHandler renderHandler = new RenderHandler();

    @Override
    public void initGl(int width, int height, Context context, int previewWidth, int previewHeight) {
        this.width = width;
        this.height = height;
        this.previewWidth = previewWidth;
        this.previewHeight = previewHeight;
        GlUtil.checkGlError("initGl start");
        this.initGlFilter(context);
        GlUtil.checkGlError("initGl end");
    }

    public void initFBOLink() {
        this.initFBO(this.width, this.height, this.renderHandler.getFboId(), this.renderHandler.getRboId(), this.renderHandler.getTexId());
    }

    protected abstract void initGlFilter(Context var1);

    @Override
    public void draw() {
        GlUtil.checkGlError("drawFilter start");
        GLES20.glBindFramebuffer((int)36160, (int)this.renderHandler.getFboId()[0]);
        GLES20.glViewport((int)0, (int)0, (int)this.width, (int)this.height);
        this.drawFilter();
        GLES20.glDrawArrays((int)5, (int)0, (int)4);
        GLES20.glBindFramebuffer((int)36160, (int)0);
        GlUtil.checkGlError("drawFilter end");
    }

    protected abstract void drawFilter();

    public void setPreviousTexId(int texId) {
        this.previousTexId = texId;
    }

    @Override
    public int getTexId() {
        return this.renderHandler.getTexId()[0];
    }

    protected int getWidth() {
        return this.width;
    }

    protected int getHeight() {
        return this.height;
    }

    public int getPreviewWidth() {
        return this.previewWidth;
    }

    public int getPreviewHeight() {
        return this.previewHeight;
    }

    public int getPreviousTexId() {
        return this.previousTexId;
    }

    public RenderHandler getRenderHandler() {
        return this.renderHandler;
    }

    public void setRenderHandler(RenderHandler renderHandler) {
        this.renderHandler = renderHandler;
    }
}

