/*
 * Decompiled with CFR 0.152.
 */
package com.pedro.encoder.input.video;

import android.annotation.SuppressLint;
import android.content.Context;
import android.graphics.Rect;
import android.graphics.SurfaceTexture;
import android.hardware.camera2.CameraAccessException;
import android.hardware.camera2.CameraCaptureSession;
import android.hardware.camera2.CameraCharacteristics;
import android.hardware.camera2.CameraDevice;
import android.hardware.camera2.CameraManager;
import android.hardware.camera2.CaptureRequest;
import android.hardware.camera2.CaptureResult;
import android.hardware.camera2.TotalCaptureResult;
import android.hardware.camera2.params.Face;
import android.hardware.camera2.params.StreamConfigurationMap;
import android.os.Handler;
import android.os.HandlerThread;
import android.support.annotation.NonNull;
import android.support.annotation.RequiresApi;
import android.util.Log;
import android.util.Size;
import android.view.MotionEvent;
import android.view.Surface;
import android.view.SurfaceView;
import android.view.TextureView;
import com.pedro.encoder.input.video.CameraHelper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;

@RequiresApi(api=21)
public class Camera2ApiManager
extends CameraDevice.StateCallback {
    private final String TAG = "Camera2ApiManager";
    private CameraDevice cameraDevice;
    private SurfaceView surfaceView;
    private TextureView textureView;
    private Surface surfaceEncoder;
    private CameraManager cameraManager;
    private Handler cameraHandler;
    private CameraCaptureSession cameraCaptureSession;
    private boolean prepared = false;
    private int cameraId = -1;
    private Surface preview;
    private boolean isOpenGl = false;
    private boolean isFrontCamera = false;
    private CameraCharacteristics cameraCharacteristics;
    private CaptureRequest.Builder builderPreview;
    private CaptureRequest.Builder builderInputSurface;
    private float fingerSpacing = 0.0f;
    private int zoomLevel = 1;
    private FaceDetectorCallback faceDetectorCallback;
    private boolean faceDetectionEnabled = false;
    private int faceDetectionMode;
    private final CameraCaptureSession.CaptureCallback cb = new CameraCaptureSession.CaptureCallback(){

        public void onCaptureCompleted(@NonNull CameraCaptureSession session, @NonNull CaptureRequest request, @NonNull TotalCaptureResult result) {
            Face[] faces = (Face[])result.get(CaptureResult.STATISTICS_FACES);
            if (Camera2ApiManager.this.faceDetectorCallback != null) {
                Camera2ApiManager.this.faceDetectorCallback.onGetFaces(faces);
            }
        }
    };

    public Camera2ApiManager(Context context) {
        this.cameraManager = (CameraManager)context.getSystemService("camera");
    }

    public void prepareCamera(SurfaceView surfaceView, Surface surface) {
        this.surfaceView = surfaceView;
        this.surfaceEncoder = surface;
        this.prepared = true;
        this.isOpenGl = false;
    }

    public void prepareCamera(TextureView textureView, Surface surface) {
        this.textureView = textureView;
        this.surfaceEncoder = surface;
        this.prepared = true;
        this.isOpenGl = false;
    }

    public void prepareCamera(Surface surface) {
        this.surfaceEncoder = surface;
        this.prepared = true;
        this.isOpenGl = false;
    }

    public void prepareCamera(SurfaceTexture surfaceTexture, int width, int height) {
        surfaceTexture.setDefaultBufferSize(width, height);
        this.surfaceEncoder = new Surface(surfaceTexture);
        this.prepared = true;
        this.isOpenGl = true;
    }

    public boolean isPrepared() {
        return this.prepared;
    }

    private void startPreview(CameraDevice cameraDevice) {
        try {
            ArrayList<Surface> listSurfaces = new ArrayList<Surface>();
            this.preview = this.addPreviewSurface();
            if (this.preview != null) {
                listSurfaces.add(this.preview);
            }
            if (this.surfaceEncoder != null) {
                listSurfaces.add(this.surfaceEncoder);
            }
            cameraDevice.createCaptureSession(listSurfaces, new CameraCaptureSession.StateCallback(){

                public void onConfigured(@NonNull CameraCaptureSession cameraCaptureSession) {
                    Camera2ApiManager.this.cameraCaptureSession = cameraCaptureSession;
                    try {
                        if (Camera2ApiManager.this.surfaceView != null || Camera2ApiManager.this.textureView != null) {
                            cameraCaptureSession.setRepeatingBurst(Arrays.asList(Camera2ApiManager.this.drawSurface(Camera2ApiManager.this.preview), Camera2ApiManager.this.drawSurface(Camera2ApiManager.this.surfaceEncoder)), Camera2ApiManager.this.faceDetectionEnabled ? Camera2ApiManager.this.cb : null, Camera2ApiManager.this.cameraHandler);
                        } else {
                            cameraCaptureSession.setRepeatingBurst(Collections.singletonList(Camera2ApiManager.this.drawSurface(Camera2ApiManager.this.surfaceEncoder)), Camera2ApiManager.this.faceDetectionEnabled ? Camera2ApiManager.this.cb : null, Camera2ApiManager.this.cameraHandler);
                        }
                        Log.i((String)"Camera2ApiManager", (String)"Camera configured");
                    }
                    catch (CameraAccessException | NullPointerException e) {
                        Log.e((String)"Camera2ApiManager", (String)"Error", (Throwable)e);
                    }
                }

                public void onConfigureFailed(@NonNull CameraCaptureSession cameraCaptureSession) {
                    cameraCaptureSession.close();
                    Log.e((String)"Camera2ApiManager", (String)"Configuration failed");
                }
            }, null);
        }
        catch (CameraAccessException e) {
            Log.e((String)"Camera2ApiManager", (String)"Error", (Throwable)e);
        }
    }

    private Surface addPreviewSurface() {
        Surface surface = null;
        if (this.surfaceView != null) {
            surface = this.surfaceView.getHolder().getSurface();
        } else if (this.textureView != null) {
            SurfaceTexture texture = this.textureView.getSurfaceTexture();
            surface = new Surface(texture);
        }
        return surface;
    }

    private CaptureRequest drawSurface(Surface surface) {
        try {
            this.builderInputSurface = this.cameraDevice.createCaptureRequest(1);
            this.builderInputSurface.addTarget(surface);
            return this.builderInputSurface.build();
        }
        catch (CameraAccessException | IllegalStateException e) {
            Log.e((String)"Camera2ApiManager", (String)"Error", (Throwable)e);
            return null;
        }
    }

    public int getLevelSupported() {
        try {
            this.cameraCharacteristics = this.cameraManager.getCameraCharacteristics("0");
            return (Integer)this.cameraCharacteristics.get(CameraCharacteristics.INFO_SUPPORTED_HARDWARE_LEVEL);
        }
        catch (CameraAccessException | IllegalStateException e) {
            Log.e((String)"Camera2ApiManager", (String)"Error", (Throwable)e);
            return -1;
        }
    }

    public void openCamera() {
        this.openCameraBack();
    }

    public void openCameraBack() {
        this.openCameraFacing(CameraHelper.Facing.BACK);
    }

    public void openCameraFront() {
        this.openCameraFacing(CameraHelper.Facing.FRONT);
    }

    public void openLastCamera() {
        if (this.cameraId == -1) {
            this.openCameraBack();
        } else {
            this.openCameraId(this.cameraId);
        }
    }

    public Size[] getCameraResolutionsBack() {
        try {
            this.cameraCharacteristics = this.cameraManager.getCameraCharacteristics("0");
            if ((Integer)this.cameraCharacteristics.get(CameraCharacteristics.LENS_FACING) != 1) {
                this.cameraCharacteristics = this.cameraManager.getCameraCharacteristics("1");
            }
            StreamConfigurationMap streamConfigurationMap = (StreamConfigurationMap)this.cameraCharacteristics.get(CameraCharacteristics.SCALER_STREAM_CONFIGURATION_MAP);
            return streamConfigurationMap.getOutputSizes(SurfaceTexture.class);
        }
        catch (CameraAccessException e) {
            Log.e((String)"Camera2ApiManager", (String)"Error", (Throwable)e);
            return new Size[0];
        }
    }

    public Size[] getCameraResolutionsFront() {
        try {
            this.cameraCharacteristics = this.cameraManager.getCameraCharacteristics("0");
            if ((Integer)this.cameraCharacteristics.get(CameraCharacteristics.LENS_FACING) != 0) {
                this.cameraCharacteristics = this.cameraManager.getCameraCharacteristics("1");
            }
            StreamConfigurationMap streamConfigurationMap = (StreamConfigurationMap)this.cameraCharacteristics.get(CameraCharacteristics.SCALER_STREAM_CONFIGURATION_MAP);
            return streamConfigurationMap.getOutputSizes(SurfaceTexture.class);
        }
        catch (CameraAccessException e) {
            Log.e((String)"Camera2ApiManager", (String)"Error", (Throwable)e);
            return new Size[0];
        }
    }

    public void openCameraFacing(CameraHelper.Facing cameraFacing) {
        int facing = cameraFacing == CameraHelper.Facing.BACK ? 1 : 0;
        try {
            this.cameraCharacteristics = this.cameraManager.getCameraCharacteristics("0");
            if ((Integer)this.cameraCharacteristics.get(CameraCharacteristics.LENS_FACING) == facing) {
                this.openCameraId(0);
            } else {
                this.openCameraId(this.cameraManager.getCameraIdList().length - 1);
            }
        }
        catch (CameraAccessException e) {
            Log.e((String)"Camera2ApiManager", (String)"Error", (Throwable)e);
        }
    }

    public void enableFaceDetection(FaceDetectorCallback faceDetectorCallback) {
        int[] fd = (int[])this.cameraCharacteristics.get(CameraCharacteristics.STATISTICS_INFO_AVAILABLE_FACE_DETECT_MODES);
        int maxFD = (Integer)this.cameraCharacteristics.get(CameraCharacteristics.STATISTICS_INFO_MAX_FACE_COUNT);
        if (fd.length > 0) {
            ArrayList<Integer> fdList = new ArrayList<Integer>();
            for (int FaceD : fd) {
                fdList.add(FaceD);
            }
            if (maxFD > 0) {
                this.faceDetectorCallback = faceDetectorCallback;
                this.faceDetectionEnabled = true;
                this.faceDetectionMode = (Integer)Collections.max(fdList);
                if (this.builderPreview != null) {
                    this.setFaceDetect(this.builderPreview, this.faceDetectionMode);
                }
                this.setFaceDetect(this.builderInputSurface, this.faceDetectionMode);
                this.prepareFaceDetectionCallback();
            } else {
                Log.e((String)"Camera2ApiManager", (String)"No face detection");
            }
        } else {
            Log.e((String)"Camera2ApiManager", (String)"No face detection");
        }
    }

    public void disableFaceDetection() {
        if (this.faceDetectionEnabled) {
            this.faceDetectorCallback = null;
            this.faceDetectionEnabled = false;
            this.faceDetectionMode = 0;
            this.prepareFaceDetectionCallback();
        }
    }

    public boolean isFaceDetectionEnabled() {
        return this.faceDetectorCallback != null;
    }

    private void setFaceDetect(CaptureRequest.Builder requestBuilder, int faceDetectMode) {
        if (this.faceDetectionEnabled) {
            requestBuilder.set(CaptureRequest.STATISTICS_FACE_DETECT_MODE, (Object)faceDetectMode);
        }
    }

    private void prepareFaceDetectionCallback() {
        try {
            this.cameraCaptureSession.stopRepeating();
            if (this.builderPreview != null) {
                this.cameraCaptureSession.setRepeatingRequest(this.builderPreview.build(), this.faceDetectionEnabled ? this.cb : null, null);
            }
            this.cameraCaptureSession.setRepeatingRequest(this.builderInputSurface.build(), this.faceDetectionEnabled ? this.cb : null, null);
        }
        catch (CameraAccessException e) {
            Log.e((String)"Camera2ApiManager", (String)"Error", (Throwable)e);
        }
    }

    @SuppressLint(value={"MissingPermission"})
    public void openCameraId(Integer cameraId) {
        this.cameraId = cameraId;
        if (this.prepared) {
            HandlerThread cameraHandlerThread = new HandlerThread("Camera2ApiManager Id = " + cameraId);
            cameraHandlerThread.start();
            this.cameraHandler = new Handler(cameraHandlerThread.getLooper());
            try {
                this.cameraManager.openCamera(cameraId.toString(), (CameraDevice.StateCallback)this, this.cameraHandler);
                this.cameraCharacteristics = this.cameraManager.getCameraCharacteristics(Integer.toString(cameraId));
                this.isFrontCamera = 0 == (Integer)this.cameraCharacteristics.get(CameraCharacteristics.LENS_FACING);
            }
            catch (CameraAccessException | SecurityException e) {
                Log.e((String)"Camera2ApiManager", (String)"Error", (Throwable)e);
            }
        } else {
            Log.e((String)"Camera2ApiManager", (String)"Camera2ApiManager need be prepared, Camera2ApiManager not enabled");
        }
    }

    public void switchCamera() {
        if (this.cameraDevice != null) {
            int cameraId = Integer.parseInt(this.cameraDevice.getId()) == 1 ? 0 : 1;
            this.closeCamera(false);
            this.prepared = true;
            this.openCameraId(cameraId);
        }
    }

    public void setZoom(MotionEvent event) {
        try {
            float maxZoom = ((Float)this.cameraCharacteristics.get(CameraCharacteristics.SCALER_AVAILABLE_MAX_DIGITAL_ZOOM)).floatValue() * 10.0f;
            Rect m = (Rect)this.cameraCharacteristics.get(CameraCharacteristics.SENSOR_INFO_ACTIVE_ARRAY_SIZE);
            if (event.getPointerCount() > 1) {
                float currentFingerSpacing = CameraHelper.getFingerSpacing(event);
                if (this.fingerSpacing != 0.0f) {
                    if (currentFingerSpacing > this.fingerSpacing && maxZoom > (float)this.zoomLevel) {
                        ++this.zoomLevel;
                    } else if (currentFingerSpacing < this.fingerSpacing && this.zoomLevel > 1) {
                        --this.zoomLevel;
                    }
                    int minW = (int)((float)m.width() / maxZoom);
                    int minH = (int)((float)m.height() / maxZoom);
                    int difW = m.width() - minW;
                    int difH = m.height() - minH;
                    int cropW = difW / 100 * this.zoomLevel;
                    int cropH = difH / 100 * this.zoomLevel;
                    cropW -= cropW & 3;
                    cropH -= cropH & 3;
                    Rect zoom = new Rect(cropW, cropH, m.width() - cropW, m.height() - cropH);
                    if (this.builderPreview != null) {
                        this.builderPreview.set(CaptureRequest.SCALER_CROP_REGION, (Object)zoom);
                    }
                    this.builderInputSurface.set(CaptureRequest.SCALER_CROP_REGION, (Object)zoom);
                }
                this.fingerSpacing = currentFingerSpacing;
            }
            if (this.builderPreview != null) {
                this.cameraCaptureSession.setRepeatingRequest(this.builderPreview.build(), this.faceDetectionEnabled ? this.cb : null, null);
            }
            this.cameraCaptureSession.setRepeatingRequest(this.builderInputSurface.build(), this.faceDetectionEnabled ? this.cb : null, null);
        }
        catch (CameraAccessException e) {
            Log.e((String)"Camera2ApiManager", (String)"Error", (Throwable)e);
        }
    }

    public boolean isFrontCamera() {
        return this.isFrontCamera;
    }

    public void closeCamera(boolean reOpen) {
        if (reOpen) {
            try {
                this.cameraCaptureSession.stopRepeating();
                if (this.surfaceView != null || this.textureView != null) {
                    this.cameraCaptureSession.setRepeatingBurst(Collections.singletonList(this.drawSurface(this.preview)), null, this.cameraHandler);
                } else if (this.surfaceEncoder != null && this.isOpenGl) {
                    this.cameraCaptureSession.setRepeatingBurst(Collections.singletonList(this.drawSurface(this.surfaceEncoder)), null, this.cameraHandler);
                }
            }
            catch (Exception e) {
                Log.e((String)"Camera2ApiManager", (String)"Error", (Throwable)e);
            }
        } else {
            if (this.cameraCaptureSession != null) {
                this.cameraCaptureSession.close();
                this.cameraCaptureSession = null;
            }
            if (this.cameraDevice != null) {
                this.cameraDevice.close();
                this.cameraDevice = null;
            }
            if (this.cameraHandler != null) {
                this.cameraHandler.getLooper().quitSafely();
                this.cameraHandler = null;
            }
            this.prepared = false;
            this.builderPreview = null;
            this.builderInputSurface = null;
        }
    }

    public void onOpened(@NonNull CameraDevice cameraDevice) {
        this.cameraDevice = cameraDevice;
        this.startPreview(cameraDevice);
        Log.i((String)"Camera2ApiManager", (String)"Camera opened");
    }

    public void onDisconnected(@NonNull CameraDevice cameraDevice) {
        cameraDevice.close();
        Log.i((String)"Camera2ApiManager", (String)"Camera disconnected");
    }

    public void onError(@NonNull CameraDevice cameraDevice, int i) {
        cameraDevice.close();
        Log.e((String)"Camera2ApiManager", (String)"Open failed");
    }

    public static interface FaceDetectorCallback {
        public void onGetFaces(Face[] var1);
    }
}

