/*
 * Decompiled with CFR 0.152.
 */
package com.pedro.encoder.video;

import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.media.MediaCodec;
import android.media.MediaCodecInfo;
import android.media.MediaFormat;
import android.os.Build;
import android.os.Bundle;
import android.support.annotation.RequiresApi;
import android.util.Log;
import android.util.Pair;
import android.view.Surface;
import com.pedro.encoder.input.video.FpsLimiter;
import com.pedro.encoder.input.video.Frame;
import com.pedro.encoder.input.video.GetCameraData;
import com.pedro.encoder.utils.CodecUtil;
import com.pedro.encoder.utils.YUVUtil;
import com.pedro.encoder.video.FormatVideoEncoder;
import com.pedro.encoder.video.GetH264Data;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;

public class VideoEncoder
implements GetCameraData {
    private String TAG = "VideoEncoder";
    private MediaCodec videoEncoder;
    private Thread thread;
    private GetH264Data getH264Data;
    private MediaCodec.BufferInfo videoInfo = new MediaCodec.BufferInfo();
    private long mPresentTimeUs;
    private boolean running = false;
    private boolean spsPpsSetted = false;
    private boolean hardwareRotation = false;
    private Surface inputSurface;
    private BlockingQueue<Frame> queue = new LinkedBlockingQueue<Frame>(80);
    private final Object sync = new Object();
    private CodecUtil.Force force = CodecUtil.Force.FIRST_COMPATIBLE_FOUND;
    private int width = 640;
    private int height = 480;
    private int fps = 30;
    private int bitRate = 1228800;
    private int rotation = 90;
    private int iFrameInterval = 2;
    private FormatVideoEncoder formatVideoEncoder = FormatVideoEncoder.YUV420Dynamical;
    private boolean sendBlackImage = false;
    private byte[] blackImage;
    private FpsLimiter fpsLimiter = new FpsLimiter();

    public VideoEncoder(GetH264Data getH264Data) {
        this.getH264Data = getH264Data;
    }

    public boolean prepareVideoEncoder(int width, int height, int fps, int bitRate, int rotation, boolean hardwareRotation, int iFrameInterval, FormatVideoEncoder formatVideoEncoder) {
        this.width = width;
        this.height = height;
        this.fps = fps;
        this.bitRate = bitRate;
        this.rotation = rotation;
        this.hardwareRotation = hardwareRotation;
        this.formatVideoEncoder = formatVideoEncoder;
        MediaCodecInfo encoder = this.chooseVideoEncoder("video/avc");
        try {
            MediaFormat videoFormat;
            String resolution;
            if (encoder != null) {
                this.videoEncoder = MediaCodec.createByCodecName((String)encoder.getName());
                if (this.formatVideoEncoder == FormatVideoEncoder.YUV420Dynamical) {
                    this.formatVideoEncoder = this.chooseColorDynamically(encoder);
                    if (this.formatVideoEncoder == null) {
                        Log.e((String)this.TAG, (String)"YUV420 dynamical choose failed");
                        return false;
                    }
                }
            } else {
                Log.e((String)this.TAG, (String)"Valid encoder not found");
                return false;
            }
            if (!(hardwareRotation || rotation != 90 && rotation != 270)) {
                resolution = height + "x" + width;
                videoFormat = MediaFormat.createVideoFormat((String)"video/avc", (int)height, (int)width);
            } else {
                resolution = width + "x" + height;
                videoFormat = MediaFormat.createVideoFormat((String)"video/avc", (int)width, (int)height);
            }
            Log.i((String)this.TAG, (String)("Prepare video info: " + this.formatVideoEncoder.name() + ", " + resolution));
            videoFormat.setInteger("color-format", this.formatVideoEncoder.getFormatCodec());
            videoFormat.setInteger("max-input-size", 0);
            videoFormat.setInteger("bitrate", bitRate);
            videoFormat.setInteger("frame-rate", fps);
            videoFormat.setInteger("i-frame-interval", iFrameInterval);
            if (hardwareRotation) {
                videoFormat.setInteger("rotation-degrees", rotation);
            }
            this.videoEncoder.configure(videoFormat, null, null, 1);
            this.running = false;
            if (formatVideoEncoder == FormatVideoEncoder.SURFACE && Build.VERSION.SDK_INT >= 18) {
                this.inputSurface = this.videoEncoder.createInputSurface();
            }
            this.prepareBlackImage();
            return true;
        }
        catch (IOException | IllegalStateException e) {
            Log.e((String)this.TAG, (String)"create videoEncoder failed.", (Throwable)e);
            return false;
        }
    }

    private FormatVideoEncoder chooseColorDynamically(MediaCodecInfo mediaCodecInfo) {
        for (int color : mediaCodecInfo.getCapabilitiesForType((String)"video/avc").colorFormats) {
            if (color == FormatVideoEncoder.YUV420PLANAR.getFormatCodec()) {
                return FormatVideoEncoder.YUV420PLANAR;
            }
            if (color == FormatVideoEncoder.YUV420SEMIPLANAR.getFormatCodec()) {
                return FormatVideoEncoder.YUV420SEMIPLANAR;
            }
            if (color != FormatVideoEncoder.YUV420PACKEDPLANAR.getFormatCodec()) continue;
            return FormatVideoEncoder.YUV420PACKEDPLANAR;
        }
        return null;
    }

    public boolean prepareVideoEncoder() {
        return this.prepareVideoEncoder(this.width, this.height, this.fps, this.bitRate, this.rotation, false, this.iFrameInterval, this.formatVideoEncoder);
    }

    @RequiresApi(api=19)
    public void setVideoBitrateOnFly(int bitrate) {
        if (this.isRunning()) {
            this.bitRate = bitrate;
            Bundle bundle = new Bundle();
            bundle.putInt("video-bitrate", bitrate);
            try {
                this.videoEncoder.setParameters(bundle);
            }
            catch (IllegalStateException e) {
                Log.e((String)this.TAG, (String)"encoder need be running", (Throwable)e);
            }
        }
    }

    @RequiresApi(api=19)
    public void forceSyncFrame() {
        if (this.isRunning()) {
            Bundle bundle = new Bundle();
            bundle.putInt("request-sync", 0);
            try {
                this.videoEncoder.setParameters(bundle);
            }
            catch (IllegalStateException e) {
                Log.e((String)this.TAG, (String)"encoder need be running", (Throwable)e);
            }
        }
    }

    public void setForce(CodecUtil.Force force) {
        this.force = force;
    }

    public Surface getInputSurface() {
        return this.inputSurface;
    }

    public void setInputSurface(Surface inputSurface) {
        this.inputSurface = inputSurface;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public boolean isHardwareRotation() {
        return this.hardwareRotation;
    }

    public boolean isRunning() {
        return this.running;
    }

    public int getRotation() {
        return this.rotation;
    }

    public void setFps(int fps) {
        this.fps = fps;
    }

    public int getFps() {
        return this.fps;
    }

    public void start() {
        this.start(true);
    }

    public int getBitRate() {
        return this.bitRate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start(boolean resetTs) {
        Object object = this.sync;
        synchronized (object) {
            if (this.videoEncoder != null) {
                this.spsPpsSetted = false;
                if (resetTs) {
                    this.mPresentTimeUs = System.nanoTime() / 1000L;
                }
                this.videoEncoder.start();
                if (this.formatVideoEncoder == FormatVideoEncoder.SURFACE && Build.VERSION.SDK_INT >= 18) {
                    if (Build.VERSION.SDK_INT >= 21) {
                        this.getDataFromSurfaceAPI21();
                    } else {
                        this.getDataFromSurface();
                    }
                } else {
                    if (this.rotation != 0 && this.rotation != 90 && this.rotation != 180 && this.rotation != 270) {
                        throw new RuntimeException("rotation value unsupported, select value 0, 90, 180 or 270");
                    }
                    this.thread = new Thread(new Runnable(){

                        @Override
                        public void run() {
                            YUVUtil.preAllocateBuffers(VideoEncoder.this.width * VideoEncoder.this.height * 3 / 2);
                            while (!Thread.interrupted()) {
                                try {
                                    Frame frame = (Frame)VideoEncoder.this.queue.take();
                                    if (VideoEncoder.this.fpsLimiter.limitFPS(VideoEncoder.this.fps)) continue;
                                    byte[] buffer = frame.getBuffer();
                                    if (frame.getFormat() == 842094169) {
                                        buffer = YUVUtil.YV12toNV21(buffer, VideoEncoder.this.width, VideoEncoder.this.height);
                                    }
                                    if (!VideoEncoder.this.hardwareRotation) {
                                        int orientation;
                                        int n = orientation = frame.isFlip() ? frame.getOrientation() + 180 : frame.getOrientation();
                                        if (orientation >= 360) {
                                            orientation -= 360;
                                        }
                                        buffer = YUVUtil.rotateNV21(buffer, VideoEncoder.this.width, VideoEncoder.this.height, orientation);
                                    }
                                    byte[] byArray = buffer = VideoEncoder.this.sendBlackImage ? VideoEncoder.this.blackImage : YUVUtil.NV21toYUV420byColor(buffer, VideoEncoder.this.width, VideoEncoder.this.height, VideoEncoder.this.formatVideoEncoder);
                                    if (Build.VERSION.SDK_INT >= 21) {
                                        VideoEncoder.this.getDataFromEncoderAPI21(buffer);
                                        continue;
                                    }
                                    VideoEncoder.this.getDataFromEncoder(buffer);
                                }
                                catch (InterruptedException e) {
                                    if (VideoEncoder.this.thread == null) continue;
                                    VideoEncoder.this.thread.interrupt();
                                }
                            }
                        }
                    });
                    this.thread.start();
                }
                this.running = true;
            } else {
                Log.e((String)this.TAG, (String)"VideoEncoder need be prepared, VideoEncoder not enabled");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        Object object = this.sync;
        synchronized (object) {
            this.running = false;
            if (this.thread != null) {
                this.thread.interrupt();
                try {
                    this.thread.join(1000L);
                }
                catch (InterruptedException e) {
                    this.thread.interrupt();
                }
                this.thread = null;
            }
            if (this.videoEncoder != null) {
                this.videoEncoder.stop();
                this.videoEncoder.release();
                this.videoEncoder = null;
            }
            this.queue.clear();
            this.fpsLimiter.reset();
            this.spsPpsSetted = false;
            this.inputSurface = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset() {
        Object object = this.sync;
        synchronized (object) {
            this.stop();
            this.prepareVideoEncoder(this.width, this.height, this.fps, this.bitRate, this.rotation, this.hardwareRotation, this.iFrameInterval, this.formatVideoEncoder);
            this.start(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void inputYUVData(Frame frame) {
        Object object = this.sync;
        synchronized (object) {
            if (this.running) {
                try {
                    this.queue.add(frame);
                }
                catch (IllegalStateException e) {
                    Log.i((String)this.TAG, (String)"frame discarded");
                }
            }
        }
    }

    @RequiresApi(api=21)
    private void getDataFromSurfaceAPI21() {
        this.thread = new Thread(new Runnable(){

            @Override
            public void run() {
                block0: while (!Thread.interrupted()) {
                    while (true) {
                        Pair buffers;
                        if (VideoEncoder.this.fpsLimiter.limitFPS(VideoEncoder.this.fps)) {
                            continue;
                        }
                        int outBufferIndex = VideoEncoder.this.videoEncoder.dequeueOutputBuffer(VideoEncoder.this.videoInfo, 0L);
                        if (outBufferIndex == -2) {
                            MediaFormat mediaFormat = VideoEncoder.this.videoEncoder.getOutputFormat();
                            VideoEncoder.this.getH264Data.onVideoFormat(mediaFormat);
                            VideoEncoder.this.getH264Data.onSPSandPPS(mediaFormat.getByteBuffer("csd-0"), mediaFormat.getByteBuffer("csd-1"));
                            VideoEncoder.this.spsPpsSetted = true;
                            continue;
                        }
                        if (outBufferIndex < 0) continue block0;
                        ByteBuffer bb = VideoEncoder.this.videoEncoder.getOutputBuffer(outBufferIndex);
                        if ((((VideoEncoder)VideoEncoder.this).videoInfo.flags & 2) != 0 && !VideoEncoder.this.spsPpsSetted && (buffers = VideoEncoder.this.decodeSpsPpsFromBuffer(bb.duplicate(), ((VideoEncoder)VideoEncoder.this).videoInfo.size)) != null) {
                            VideoEncoder.this.getH264Data.onSPSandPPS((ByteBuffer)buffers.first, (ByteBuffer)buffers.second);
                            VideoEncoder.this.spsPpsSetted = true;
                        }
                        ((VideoEncoder)VideoEncoder.this).videoInfo.presentationTimeUs = System.nanoTime() / 1000L - VideoEncoder.this.mPresentTimeUs;
                        VideoEncoder.this.getH264Data.getH264Data(bb, VideoEncoder.this.videoInfo);
                        VideoEncoder.this.videoEncoder.releaseOutputBuffer(outBufferIndex, false);
                    }
                }
            }
        });
        this.thread.start();
    }

    private void getDataFromSurface() {
        this.thread = new Thread(new Runnable(){

            @Override
            public void run() {
                block0: while (!Thread.interrupted()) {
                    ByteBuffer[] outputBuffers = VideoEncoder.this.videoEncoder.getOutputBuffers();
                    while (true) {
                        Pair buffers;
                        if (VideoEncoder.this.fpsLimiter.limitFPS(VideoEncoder.this.fps)) {
                            continue;
                        }
                        int outBufferIndex = VideoEncoder.this.videoEncoder.dequeueOutputBuffer(VideoEncoder.this.videoInfo, 10000L);
                        if (outBufferIndex == -2) {
                            MediaFormat mediaFormat = VideoEncoder.this.videoEncoder.getOutputFormat();
                            VideoEncoder.this.getH264Data.onVideoFormat(mediaFormat);
                            VideoEncoder.this.getH264Data.onSPSandPPS(mediaFormat.getByteBuffer("csd-0"), mediaFormat.getByteBuffer("csd-1"));
                            VideoEncoder.this.spsPpsSetted = true;
                            continue;
                        }
                        if (outBufferIndex < 0) continue block0;
                        ByteBuffer bb = outputBuffers[outBufferIndex];
                        if ((((VideoEncoder)VideoEncoder.this).videoInfo.flags & 2) != 0 && !VideoEncoder.this.spsPpsSetted && (buffers = VideoEncoder.this.decodeSpsPpsFromBuffer(bb.duplicate(), ((VideoEncoder)VideoEncoder.this).videoInfo.size)) != null) {
                            VideoEncoder.this.getH264Data.onSPSandPPS((ByteBuffer)buffers.first, (ByteBuffer)buffers.second);
                            VideoEncoder.this.spsPpsSetted = true;
                        }
                        ((VideoEncoder)VideoEncoder.this).videoInfo.presentationTimeUs = System.nanoTime() / 1000L - VideoEncoder.this.mPresentTimeUs;
                        VideoEncoder.this.getH264Data.getH264Data(bb, VideoEncoder.this.videoInfo);
                        VideoEncoder.this.videoEncoder.releaseOutputBuffer(outBufferIndex, false);
                    }
                }
            }
        });
        this.thread.start();
    }

    @RequiresApi(api=21)
    private void getDataFromEncoderAPI21(byte[] buffer) {
        int inBufferIndex = this.videoEncoder.dequeueInputBuffer(-1L);
        if (inBufferIndex >= 0) {
            ByteBuffer bb = this.videoEncoder.getInputBuffer(inBufferIndex);
            bb.put(buffer, 0, buffer.length);
            long pts = System.nanoTime() / 1000L - this.mPresentTimeUs;
            this.videoEncoder.queueInputBuffer(inBufferIndex, 0, buffer.length, pts, 0);
        }
        while (true) {
            Pair<ByteBuffer, ByteBuffer> buffers;
            int outBufferIndex;
            if ((outBufferIndex = this.videoEncoder.dequeueOutputBuffer(this.videoInfo, 0L)) == -2) {
                MediaFormat mediaFormat = this.videoEncoder.getOutputFormat();
                this.getH264Data.onVideoFormat(mediaFormat);
                this.getH264Data.onSPSandPPS(mediaFormat.getByteBuffer("csd-0"), mediaFormat.getByteBuffer("csd-1"));
                this.spsPpsSetted = true;
                continue;
            }
            if (outBufferIndex < 0) break;
            ByteBuffer bb = this.videoEncoder.getOutputBuffer(outBufferIndex);
            if ((this.videoInfo.flags & 2) != 0 && !this.spsPpsSetted && (buffers = this.decodeSpsPpsFromBuffer(bb.duplicate(), this.videoInfo.size)) != null) {
                this.getH264Data.onSPSandPPS((ByteBuffer)buffers.first, (ByteBuffer)buffers.second);
                this.spsPpsSetted = true;
            }
            this.videoInfo.presentationTimeUs = System.nanoTime() / 1000L - this.mPresentTimeUs;
            this.getH264Data.getH264Data(bb, this.videoInfo);
            this.videoEncoder.releaseOutputBuffer(outBufferIndex, false);
        }
    }

    private void getDataFromEncoder(byte[] buffer) {
        ByteBuffer[] inputBuffers = this.videoEncoder.getInputBuffers();
        ByteBuffer[] outputBuffers = this.videoEncoder.getOutputBuffers();
        int inBufferIndex = this.videoEncoder.dequeueInputBuffer(-1L);
        if (inBufferIndex >= 0) {
            ByteBuffer bb = inputBuffers[inBufferIndex];
            bb.clear();
            bb.put(buffer, 0, buffer.length);
            long pts = System.nanoTime() / 1000L - this.mPresentTimeUs;
            this.videoEncoder.queueInputBuffer(inBufferIndex, 0, buffer.length, pts, 0);
        }
        while (true) {
            Pair<ByteBuffer, ByteBuffer> buffers;
            int outBufferIndex;
            if ((outBufferIndex = this.videoEncoder.dequeueOutputBuffer(this.videoInfo, 0L)) == -2) {
                MediaFormat mediaFormat = this.videoEncoder.getOutputFormat();
                this.getH264Data.onVideoFormat(mediaFormat);
                this.getH264Data.onSPSandPPS(mediaFormat.getByteBuffer("csd-0"), mediaFormat.getByteBuffer("csd-1"));
                this.spsPpsSetted = true;
                continue;
            }
            if (outBufferIndex < 0) break;
            ByteBuffer bb = outputBuffers[outBufferIndex];
            if ((this.videoInfo.flags & 2) != 0 && !this.spsPpsSetted && (buffers = this.decodeSpsPpsFromBuffer(bb.duplicate(), this.videoInfo.size)) != null) {
                this.getH264Data.onSPSandPPS((ByteBuffer)buffers.first, (ByteBuffer)buffers.second);
                this.spsPpsSetted = true;
            }
            this.videoInfo.presentationTimeUs = System.nanoTime() / 1000L - this.mPresentTimeUs;
            this.getH264Data.getH264Data(bb, this.videoInfo);
            this.videoEncoder.releaseOutputBuffer(outBufferIndex, false);
        }
    }

    private MediaCodecInfo chooseVideoEncoder(String mime) {
        List<MediaCodecInfo> mediaCodecInfoList = this.force == CodecUtil.Force.HARDWARE ? CodecUtil.getAllHardwareEncoders(mime) : (this.force == CodecUtil.Force.SOFTWARE ? CodecUtil.getAllSoftwareEncoders(mime) : CodecUtil.getAllEncoders(mime));
        for (MediaCodecInfo mci : mediaCodecInfoList) {
            Log.i((String)this.TAG, (String)String.format("VideoEncoder %s", mci.getName()));
            MediaCodecInfo.CodecCapabilities codecCapabilities = mci.getCapabilitiesForType(mime);
            for (int color : codecCapabilities.colorFormats) {
                Log.i((String)this.TAG, (String)("Color supported: " + color));
                if (color != FormatVideoEncoder.YUV420PLANAR.getFormatCodec() && color != FormatVideoEncoder.YUV420SEMIPLANAR.getFormatCodec() && color != FormatVideoEncoder.YUV420PACKEDPLANAR.getFormatCodec()) continue;
                return mci;
            }
        }
        return null;
    }

    private void prepareBlackImage() {
        Bitmap b = Bitmap.createBitmap((int)this.width, (int)this.height, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas canvas = new Canvas(b);
        canvas.drawColor(-16777216);
        int x = b.getWidth();
        int y = b.getHeight();
        int[] data = new int[x * y];
        b.getPixels(data, 0, x, 0, 0, x, y);
        this.blackImage = YUVUtil.ARGBtoYUV420SemiPlanar(data, this.width, this.height);
    }

    public void startSendBlackImage() {
        this.sendBlackImage = true;
        if (Build.VERSION.SDK_INT >= 19 && this.isRunning()) {
            Bundle bundle = new Bundle();
            bundle.putInt("video-bitrate", 102400);
            try {
                this.videoEncoder.setParameters(bundle);
            }
            catch (IllegalStateException e) {
                Log.e((String)this.TAG, (String)"encoder need be running");
                e.printStackTrace();
            }
        }
    }

    public void stopSendBlackImage() {
        this.sendBlackImage = false;
        if (Build.VERSION.SDK_INT >= 19) {
            this.setVideoBitrateOnFly(this.bitRate);
        }
    }

    private Pair<ByteBuffer, ByteBuffer> decodeSpsPpsFromBuffer(ByteBuffer outputBuffer, int length) {
        byte[] mSPS = null;
        byte[] mPPS = null;
        byte[] csd = new byte[length];
        outputBuffer.get(csd, 0, length);
        int spsIndex = -1;
        int ppsIndex = -1;
        for (int i = 0; i < length - 4; ++i) {
            if (csd[i] != 0 || csd[i + 1] != 0 || csd[i + 2] != 0 || csd[i + 3] != 1) continue;
            if (spsIndex == -1) {
                spsIndex = i;
                continue;
            }
            ppsIndex = i;
            break;
        }
        if (spsIndex != -1 && ppsIndex != -1) {
            mSPS = new byte[ppsIndex];
            System.arraycopy(csd, spsIndex, mSPS, 0, ppsIndex);
            mPPS = new byte[length - ppsIndex];
            System.arraycopy(csd, ppsIndex, mPPS, 0, length - ppsIndex);
        }
        if (mSPS != null && mPPS != null) {
            return new Pair((Object)ByteBuffer.wrap(mSPS), (Object)ByteBuffer.wrap(mPPS));
        }
        return null;
    }
}

