/*
 * Decompiled with CFR 0.152.
 */
package com.pedro.encoder.utils;

import android.graphics.Bitmap;
import android.os.Environment;
import com.pedro.encoder.input.video.Frame;
import com.pedro.encoder.video.FormatVideoEncoder;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;

public class YUVUtil {
    private static byte[] preAllocatedBufferRotate;
    private static byte[] preAllocatedBufferColor;

    public static void preAllocateBuffers(int length) {
        preAllocatedBufferRotate = new byte[length];
        preAllocatedBufferColor = new byte[length];
    }

    public static Bitmap frameToBitmap(Frame frame, int width, int height, int orientation) {
        int w = orientation == 90 || orientation == 270 ? height : width;
        int h = orientation == 90 || orientation == 270 ? width : height;
        int[] argb = YUVUtil.NV21toARGB(YUVUtil.rotateNV21(frame.getBuffer(), width, height, orientation), w, h);
        return Bitmap.createBitmap((int[])argb, (int)w, (int)h, (Bitmap.Config)Bitmap.Config.ARGB_8888);
    }

    public static int[] NV21toARGB(byte[] yuv, int width, int height) {
        int[] argb = new int[width * height];
        int frameSize = width * height;
        boolean ii = false;
        boolean ij = false;
        boolean di = true;
        boolean dj = true;
        int a = 0;
        int i = 0;
        int ci = 0;
        while (i < height) {
            int j = 0;
            int cj = 0;
            while (j < width) {
                int y = 0xFF & yuv[ci * width + cj];
                int v = 0xFF & yuv[frameSize + (ci >> 1) * width + (cj & 0xFFFFFFFE) + 0];
                int u = 0xFF & yuv[frameSize + (ci >> 1) * width + (cj & 0xFFFFFFFE) + 1];
                y = y < 16 ? 16 : y;
                int r = (int)(1.164f * (float)(y - 16) + 1.596f * (float)(v - 128));
                int g = (int)(1.164f * (float)(y - 16) - 0.813f * (float)(v - 128) - 0.391f * (float)(u - 128));
                int b = (int)(1.164f * (float)(y - 16) + 2.018f * (float)(u - 128));
                int n = r < 0 ? 0 : (r = r > 255 ? 255 : r);
                int n2 = g < 0 ? 0 : (g = g > 255 ? 255 : g);
                b = b < 0 ? 0 : (b > 255 ? 255 : b);
                argb[a++] = 0xFF000000 | r << 16 | g << 8 | b;
                ++j;
                ++cj;
            }
            ++i;
            ++ci;
        }
        return argb;
    }

    public static int getYuvBuffer(int width, int height) {
        int stride = (int)Math.ceil((double)width / 16.0) * 16;
        int y_size = stride * height;
        int c_stride = (int)Math.ceil((double)width / 32.0) * 16;
        int c_size = c_stride * height / 2;
        return y_size + c_size * 2;
    }

    public static byte[] ARGBtoYUV420SemiPlanar(int[] input, int width, int height) {
        int frameSize = width * height;
        byte[] yuv420sp = new byte[width * height * 3 / 2];
        int yIndex = 0;
        int uvIndex = frameSize;
        int index = 0;
        for (int j = 0; j < height; ++j) {
            for (int i = 0; i < width; ++i) {
                int a = (input[index] & 0xFF000000) >> 24;
                int R2 = (input[index] & 0xFF0000) >> 16;
                int G = (input[index] & 0xFF00) >> 8;
                int B = (input[index] & 0xFF) >> 0;
                int Y = (66 * R2 + 129 * G + 25 * B + 128 >> 8) + 16;
                int U = (-38 * R2 - 74 * G + 112 * B + 128 >> 8) + 128;
                int V = (112 * R2 - 94 * G - 18 * B + 128 >> 8) + 128;
                yuv420sp[yIndex++] = (byte)(Y < 0 ? 0 : (Y > 255 ? 255 : Y));
                if (j % 2 == 0 && index % 2 == 0) {
                    yuv420sp[uvIndex++] = (byte)(V < 0 ? 0 : (V > 255 ? 255 : V));
                    yuv420sp[uvIndex++] = (byte)(U < 0 ? 0 : (U > 255 ? 255 : U));
                }
                ++index;
            }
        }
        return yuv420sp;
    }

    public static byte[] YV12toYUV420byColor(byte[] input, int width, int height, FormatVideoEncoder formatVideoEncoder) {
        switch (formatVideoEncoder) {
            case YUV420PLANAR: {
                return YUVUtil.YV12toI420(input, width, height);
            }
            case YUV420PACKEDSEMIPLANAR: {
                return YUVUtil.YV12toNV12(input, width, height);
            }
            case YUV420SEMIPLANAR: {
                return YUVUtil.YV12toNV12(input, width, height);
            }
            case YUV420PACKEDPLANAR: {
                return YUVUtil.NV21toI420(YUVUtil.YV12toNV21(input, width, height), width, height);
            }
        }
        return null;
    }

    public static byte[] YV12toNV12(byte[] input, int width, int height) {
        int frameSize = width * height;
        int qFrameSize = frameSize / 4;
        System.arraycopy(input, 0, preAllocatedBufferColor, 0, frameSize);
        for (int i = 0; i < qFrameSize; ++i) {
            YUVUtil.preAllocatedBufferColor[frameSize + i * 2] = input[frameSize + i + qFrameSize];
            YUVUtil.preAllocatedBufferColor[frameSize + i * 2 + 1] = input[frameSize + i];
        }
        return preAllocatedBufferColor;
    }

    public static byte[] YV12toI420(byte[] input, int width, int height) {
        int frameSize = width * height;
        int qFrameSize = frameSize / 4;
        System.arraycopy(input, 0, preAllocatedBufferColor, 0, frameSize);
        System.arraycopy(input, frameSize + qFrameSize, preAllocatedBufferColor, frameSize, qFrameSize);
        System.arraycopy(input, frameSize, preAllocatedBufferColor, frameSize + qFrameSize, qFrameSize);
        return preAllocatedBufferColor;
    }

    public static byte[] YV12toNV21(byte[] input, int width, int height) {
        int frameSize = width * height;
        int qFrameSize = frameSize / 4;
        System.arraycopy(input, 0, preAllocatedBufferColor, 0, frameSize);
        for (int i = 0; i < qFrameSize; ++i) {
            YUVUtil.preAllocatedBufferColor[frameSize + i * 2 + 1] = input[frameSize + i + qFrameSize];
            YUVUtil.preAllocatedBufferColor[frameSize + i * 2] = input[frameSize + i];
        }
        return preAllocatedBufferColor;
    }

    public static byte[] NV21toYUV420byColor(byte[] input, int width, int height, FormatVideoEncoder formatVideoEncoder) {
        switch (formatVideoEncoder) {
            case YUV420PLANAR: {
                return YUVUtil.NV21toI420(input, width, height);
            }
            case YUV420PACKEDPLANAR: {
                return YUVUtil.NV21toI420(input, width, height);
            }
            case YUV420SEMIPLANAR: {
                return YUVUtil.NV21toNV12(input, width, height);
            }
            case YUV420PACKEDSEMIPLANAR: {
                return input;
            }
        }
        return null;
    }

    public static byte[] NV21toNV12(byte[] input, int width, int height) {
        int frameSize = width * height;
        int qFrameSize = frameSize / 4;
        System.arraycopy(input, 0, preAllocatedBufferColor, 0, frameSize);
        for (int i = 0; i < qFrameSize; ++i) {
            YUVUtil.preAllocatedBufferColor[frameSize + i * 2] = input[frameSize + i * 2 + 1];
            YUVUtil.preAllocatedBufferColor[frameSize + i * 2 + 1] = input[frameSize + i * 2];
        }
        return preAllocatedBufferColor;
    }

    public static byte[] NV21toI420(byte[] input, int width, int height) {
        int frameSize = width * height;
        int qFrameSize = frameSize / 4;
        System.arraycopy(input, 0, preAllocatedBufferColor, 0, frameSize);
        for (int i = 0; i < qFrameSize; ++i) {
            YUVUtil.preAllocatedBufferColor[frameSize + i] = input[frameSize + i * 2 + 1];
            YUVUtil.preAllocatedBufferColor[frameSize + i + qFrameSize] = input[frameSize + i * 2];
        }
        return preAllocatedBufferColor;
    }

    public static byte[] NV21toYV12(byte[] input, int width, int height) {
        int frameSize = width * height;
        int qFrameSize = frameSize / 4;
        System.arraycopy(input, 0, preAllocatedBufferColor, 0, frameSize);
        for (int i = 0; i < qFrameSize; ++i) {
            YUVUtil.preAllocatedBufferColor[frameSize + i + qFrameSize] = input[frameSize + i * 2 + 1];
            YUVUtil.preAllocatedBufferColor[frameSize + i] = input[frameSize + i * 2];
        }
        return preAllocatedBufferColor;
    }

    public static byte[] rotateNV21(byte[] data, int width, int height, int rotation) {
        switch (rotation) {
            case 0: {
                return data;
            }
            case 90: {
                return YUVUtil.rotateNV21Degree90(data, width, height);
            }
            case 180: {
                return YUVUtil.rotateNV21Degree180(data, width, height);
            }
            case 270: {
                return YUVUtil.rotateNV21Degree270(data, width, height);
            }
        }
        return null;
    }

    private static byte[] rotateNV21Degree90(byte[] data, int imageWidth, int imageHeight) {
        int i = 0;
        for (int x = 0; x < imageWidth; ++x) {
            for (int y = imageHeight - 1; y >= 0; --y) {
                YUVUtil.preAllocatedBufferRotate[i++] = data[y * imageWidth + x];
            }
        }
        int size = imageWidth * imageHeight;
        i = size * 3 / 2 - 1;
        for (int x = imageWidth - 1; x > 0; x -= 2) {
            for (int y = 0; y < imageHeight / 2; ++y) {
                YUVUtil.preAllocatedBufferRotate[i--] = data[size + y * imageWidth + x];
                YUVUtil.preAllocatedBufferRotate[i--] = data[size + y * imageWidth + (x - 1)];
            }
        }
        return preAllocatedBufferRotate;
    }

    private static byte[] rotateNV21Degree180(byte[] data, int imageWidth, int imageHeight) {
        int i;
        int count = 0;
        for (i = imageWidth * imageHeight - 1; i >= 0; --i) {
            YUVUtil.preAllocatedBufferRotate[count] = data[i];
            ++count;
        }
        for (i = imageWidth * imageHeight * 3 / 2 - 1; i >= imageWidth * imageHeight; i -= 2) {
            YUVUtil.preAllocatedBufferRotate[count++] = data[i - 1];
            YUVUtil.preAllocatedBufferRotate[count++] = data[i];
        }
        return preAllocatedBufferRotate;
    }

    private static byte[] rotateNV21Degree270(byte[] data, int imageWidth, int imageHeight) {
        int i = 0;
        for (int x = imageWidth - 1; x >= 0; --x) {
            for (int y = 0; y < imageHeight; ++y) {
                YUVUtil.preAllocatedBufferRotate[i++] = data[y * imageWidth + x];
            }
        }
        i = imageWidth * imageHeight;
        int uvHeight = imageHeight / 2;
        for (int x = imageWidth - 1; x >= 0; x -= 2) {
            for (int y = imageHeight; y < uvHeight + imageHeight; ++y) {
                YUVUtil.preAllocatedBufferRotate[i++] = data[y * imageWidth + x - 1];
                YUVUtil.preAllocatedBufferRotate[i++] = data[y * imageWidth + x];
            }
        }
        return preAllocatedBufferRotate;
    }

    public void dumpYUVData(byte[] buffer, int len, String name) {
        File f = new File(Environment.getExternalStorageDirectory().getPath() + "/tmp/", name);
        if (f.exists()) {
            f.delete();
        }
        try {
            FileOutputStream out = new FileOutputStream(f);
            out.write(buffer);
            out.flush();
            out.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static byte[] CropYuv(int src_format, byte[] src_yuv, int src_width, int src_height, int dst_width, int dst_height) {
        byte[] dst_yuv;
        if (src_yuv == null) {
            return null;
        }
        if (src_width == dst_width && src_height == dst_height) {
            dst_yuv = src_yuv;
        } else {
            dst_yuv = new byte[(int)((double)(dst_width * dst_height) * 1.5)];
            switch (src_format) {
                case 19: 
                case 20: {
                    int src_yoffset = 0;
                    int dst_yoffset = 0;
                    for (int i = 0; i < dst_height; ++i) {
                        System.arraycopy(src_yuv, src_yoffset, dst_yuv, dst_yoffset, dst_width);
                        src_yoffset += src_width;
                        dst_yoffset += dst_width;
                    }
                    int src_uoffset = 0;
                    int dst_uoffset = 0;
                    src_yoffset = src_width * src_height;
                    dst_yoffset = dst_width * dst_height;
                    for (int i = 0; i < dst_height / 2; ++i) {
                        System.arraycopy(src_yuv, src_yoffset + src_uoffset, dst_yuv, dst_yoffset + dst_uoffset, dst_width / 2);
                        src_uoffset += src_width / 2;
                        dst_uoffset += dst_width / 2;
                    }
                    int src_voffset = 0;
                    int dst_voffset = 0;
                    src_uoffset = src_width * src_height + src_width * src_height / 4;
                    dst_uoffset = dst_width * dst_height + dst_width * dst_height / 4;
                    for (int i = 0; i < dst_height / 2; ++i) {
                        System.arraycopy(src_yuv, src_uoffset + src_voffset, dst_yuv, dst_uoffset + dst_voffset, dst_width / 2);
                        src_voffset += src_width / 2;
                        dst_voffset += dst_width / 2;
                    }
                    break;
                }
                case 21: 
                case 39: 
                case 2130706688: 
                case 2141391872: {
                    int src_yoffset = 0;
                    int dst_yoffset = 0;
                    for (int i = 0; i < dst_height; ++i) {
                        System.arraycopy(src_yuv, src_yoffset, dst_yuv, dst_yoffset, dst_width);
                        src_yoffset += src_width;
                        dst_yoffset += dst_width;
                    }
                    int src_uoffset = 0;
                    int dst_uoffset = 0;
                    src_yoffset = src_width * src_height;
                    dst_yoffset = dst_width * dst_height;
                    for (int i = 0; i < dst_height / 2; ++i) {
                        System.arraycopy(src_yuv, src_yoffset + src_uoffset, dst_yuv, dst_yoffset + dst_uoffset, dst_width);
                        src_uoffset += src_width;
                        dst_uoffset += dst_width;
                    }
                    break;
                }
                default: {
                    dst_yuv = null;
                }
            }
        }
        return dst_yuv;
    }

    public static byte[] rotatePixelsNV21(byte[] input, int width, int height, int rotation) {
        byte[] output = new byte[input.length];
        boolean swap = rotation == 90 || rotation == 270;
        boolean yflip = rotation == 90 || rotation == 180;
        boolean xflip = rotation == 270 || rotation == 180;
        for (int x = 0; x < width; ++x) {
            for (int y = 0; y < height; ++y) {
                int xo = x;
                int yo = y;
                int w = width;
                int h = height;
                int xi = xo;
                int yi = yo;
                if (swap) {
                    xi = w * yo / h;
                    yi = h * xo / w;
                }
                if (yflip) {
                    yi = h - yi - 1;
                }
                if (xflip) {
                    xi = w - xi - 1;
                }
                output[w * yo + xo] = input[w * yi + xi];
                int fs = w * h;
                int qs = fs >> 2;
                h >>= 1;
                int ui = fs + ((w >>= 1) * (yi >>= 1) + (xi >>= 1)) * 2;
                int uo = fs + (w * (yo >>= 1) + (xo >>= 1)) * 2;
                int vi = ui + 1;
                int vo = uo + 1;
                output[uo] = input[ui];
                output[vo] = input[vi];
            }
        }
        return output;
    }

    public static byte[] mirrorNV21(byte[] input, int width, int height) {
        byte[] output = new byte[input.length];
        for (int x = 0; x < width; ++x) {
            for (int y = 0; y < height; ++y) {
                int xo = x;
                int yo = y;
                int w = width;
                int h = height;
                int xi = xo;
                int yi = yo;
                yi = h - yi - 1;
                output[w * yo + xo] = input[w * yi + xi];
                int fs = w * h;
                int qs = fs >> 2;
                h >>= 1;
                int ui = fs + ((w >>= 1) * (yi >>= 1) + (xi >>= 1)) * 2;
                int uo = fs + (w * (yo >>= 1) + (xo >>= 1)) * 2;
                int vi = ui + 1;
                int vo = uo + 1;
                output[uo] = input[ui];
                output[vo] = input[vi];
            }
        }
        return output;
    }

    public static byte[] bitmapToNV21(int inputWidth, int inputHeight, Bitmap bitmap) {
        int[] argb = new int[inputWidth * inputHeight];
        bitmap.getPixels(argb, 0, inputWidth, 0, 0, inputWidth, inputHeight);
        byte[] yuv = YUVUtil.ARGBtoYUV420SemiPlanar(argb, inputWidth, inputHeight);
        bitmap.recycle();
        return yuv;
    }
}

