/*
 * Decompiled with CFR 0.152.
 */
package com.pedro.encoder.input.video;

import android.content.Context;
import android.graphics.SurfaceTexture;
import android.hardware.Camera;
import android.media.CamcorderProfile;
import android.util.Log;
import android.view.SurfaceView;
import android.view.TextureView;
import com.pedro.encoder.input.video.Camera1Facing;
import com.pedro.encoder.input.video.CameraOpenException;
import com.pedro.encoder.input.video.EffectManager;
import com.pedro.encoder.input.video.Frame;
import com.pedro.encoder.input.video.GetCameraData;
import com.pedro.encoder.utils.YUVUtil;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;

public class Camera1ApiManager
implements Camera.PreviewCallback,
Camera.FaceDetectionListener {
    private String TAG = "Camera1ApiManager";
    private Camera camera = null;
    private SurfaceView surfaceView;
    private TextureView textureView;
    private SurfaceTexture surfaceTexture;
    private GetCameraData getCameraData;
    private boolean running = false;
    private volatile boolean prepared = false;
    private boolean lanternEnable = false;
    private int cameraSelect;
    private boolean isFrontCamera = false;
    private int width = 640;
    private int height = 480;
    private int fps = 30;
    private int orientation = 0;
    private int imageFormat = 17;
    private byte[] yuvBuffer;
    private List<Camera.Size> previewSizeBack;
    private List<Camera.Size> previewSizeFront;

    public Camera1ApiManager(SurfaceView surfaceView, GetCameraData getCameraData) {
        this.surfaceView = surfaceView;
        this.getCameraData = getCameraData;
        this.init(surfaceView.getContext());
    }

    public Camera1ApiManager(TextureView textureView, GetCameraData getCameraData) {
        this.textureView = textureView;
        this.getCameraData = getCameraData;
        this.init(textureView.getContext());
    }

    public Camera1ApiManager(SurfaceTexture surfaceTexture, Context context) {
        this.surfaceTexture = surfaceTexture;
        this.init(context);
    }

    private void init(Context context) {
        if (context.getResources().getConfiguration().orientation == 1) {
            this.orientation = 90;
        }
        this.cameraSelect = this.selectCameraFront();
        this.previewSizeFront = this.getPreviewSize();
        this.cameraSelect = this.selectCameraBack();
        this.previewSizeBack = this.getPreviewSize();
    }

    public void setSurfaceTexture(SurfaceTexture surfaceTexture) {
        this.surfaceTexture = surfaceTexture;
    }

    public void prepareCamera(int width, int height, int fps, int imageFormat) {
        this.width = width;
        this.height = height;
        this.fps = fps;
        this.imageFormat = imageFormat;
        this.prepared = true;
    }

    public void prepareCamera() {
        this.prepareCamera(640, 480, this.fps, this.imageFormat);
    }

    public void start(@Camera1Facing int cameraFacing, int width, int height) {
        this.width = width;
        this.height = height;
        this.cameraSelect = cameraFacing == 0 ? this.selectCameraBack() : this.selectCameraFront();
        this.start();
    }

    public void start(@Camera1Facing int cameraFacing) {
        this.start(cameraFacing, this.width, this.height);
    }

    public void start() {
        if (!this.checkCanOpen()) {
            throw new CameraOpenException("This camera resolution cant be opened");
        }
        this.yuvBuffer = new byte[this.width * this.height * 3 / 2];
        YUVUtil.preAllocateRotateBuffers(this.yuvBuffer.length);
        YUVUtil.preAllocateNv21Buffers(this.yuvBuffer.length);
        if (this.imageFormat == 842094169) {
            YUVUtil.preAllocateYv12Buffers(this.yuvBuffer.length);
        }
        if (this.camera == null && this.prepared) {
            try {
                this.camera = Camera.open((int)this.cameraSelect);
                Camera.CameraInfo info = new Camera.CameraInfo();
                Camera.getCameraInfo((int)this.cameraSelect, (Camera.CameraInfo)info);
                this.isFrontCamera = info.facing == 1;
                Camera.Parameters parameters = this.camera.getParameters();
                parameters.setPreviewSize(this.width, this.height);
                parameters.setPreviewFormat(this.imageFormat);
                int[] range = this.adaptFpsRange(this.fps, parameters.getSupportedPreviewFpsRange());
                parameters.setPreviewFpsRange(range[0], range[1]);
                List supportedFocusModes = parameters.getSupportedFocusModes();
                if (supportedFocusModes != null && !supportedFocusModes.isEmpty()) {
                    if (supportedFocusModes.contains("continuous-picture")) {
                        parameters.setFocusMode("continuous-picture");
                    } else if (supportedFocusModes.contains("auto")) {
                        parameters.setFocusMode("auto");
                    } else {
                        parameters.setFocusMode((String)supportedFocusModes.get(0));
                    }
                }
                this.camera.setParameters(parameters);
                this.camera.setDisplayOrientation(this.orientation);
                if (this.surfaceView != null) {
                    this.camera.setPreviewDisplay(this.surfaceView.getHolder());
                    this.camera.addCallbackBuffer(this.yuvBuffer);
                    this.camera.setPreviewCallbackWithBuffer((Camera.PreviewCallback)this);
                } else if (this.textureView != null) {
                    this.camera.setPreviewTexture(this.textureView.getSurfaceTexture());
                    this.camera.addCallbackBuffer(this.yuvBuffer);
                    this.camera.setPreviewCallbackWithBuffer((Camera.PreviewCallback)this);
                } else {
                    this.camera.setPreviewTexture(this.surfaceTexture);
                }
                this.camera.startPreview();
                this.running = true;
                Log.i((String)this.TAG, (String)(this.width + "X" + this.height));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else {
            Log.e((String)this.TAG, (String)"Camera1ApiManager need be prepared, Camera1ApiManager not enabled");
        }
    }

    public void setPreviewOrientation(int orientation) {
        this.orientation = orientation;
        if (this.camera != null && this.running) {
            this.camera.stopPreview();
            this.camera.setDisplayOrientation(orientation);
            this.camera.startPreview();
        }
    }

    private int selectCameraBack() {
        int number = Camera.getNumberOfCameras();
        int i = 0;
        while (i < number) {
            Camera.CameraInfo info = new Camera.CameraInfo();
            Camera.getCameraInfo((int)i, (Camera.CameraInfo)info);
            if (info.facing == 0) {
                return i;
            }
            this.cameraSelect = i++;
        }
        return this.cameraSelect;
    }

    private int selectCameraFront() {
        int number = Camera.getNumberOfCameras();
        int i = 0;
        while (i < number) {
            Camera.CameraInfo info = new Camera.CameraInfo();
            Camera.getCameraInfo((int)i, (Camera.CameraInfo)info);
            if (info.facing == 1) {
                return i;
            }
            this.cameraSelect = i++;
        }
        return this.cameraSelect;
    }

    public void stop() {
        if (this.camera != null) {
            this.camera.stopPreview();
            this.camera.setPreviewCallback(null);
            this.camera.setPreviewCallbackWithBuffer(null);
            this.camera.release();
            this.camera = null;
        }
        this.running = false;
        this.prepared = false;
    }

    public boolean isRunning() {
        return this.running;
    }

    public boolean isPrepared() {
        return this.prepared;
    }

    private int[] adaptFpsRange(int expectedFps, List<int[]> fpsRanges) {
        int[] closestRange = fpsRanges.get(0);
        int measure = Math.abs(closestRange[0] - (expectedFps *= 1000)) + Math.abs(closestRange[1] - expectedFps);
        for (int[] range : fpsRanges) {
            int curMeasure;
            if (range[0] > expectedFps || range[1] < expectedFps || (curMeasure = Math.abs(range[0] - expectedFps) + Math.abs(range[1] - expectedFps)) >= measure) continue;
            closestRange = range;
            measure = curMeasure;
        }
        return closestRange;
    }

    public void onPreviewFrame(byte[] data, Camera camera) {
        this.getCameraData.inputYUVData(new Frame(data, this.isFrontCamera && (this.orientation == 90 || this.orientation == 270), this.imageFormat));
        camera.addCallbackBuffer(this.yuvBuffer);
    }

    public List<Integer> getCameraPreviewImageFormatSupported() {
        List formats;
        if (this.camera != null) {
            formats = this.camera.getParameters().getSupportedPreviewFormats();
            for (Integer i : formats) {
                Log.i((String)this.TAG, (String)("camera format supported: " + i));
            }
        } else {
            this.camera = Camera.open((int)this.cameraSelect);
            formats = this.camera.getParameters().getSupportedPreviewFormats();
            this.camera.release();
            this.camera = null;
        }
        return formats;
    }

    private List<Camera.Size> getPreviewSize() {
        List previewSizes;
        Camera.Size maxSize;
        if (this.camera != null) {
            maxSize = this.getMaxEncoderSizeSupported();
            previewSizes = this.camera.getParameters().getSupportedPreviewSizes();
        } else {
            this.camera = Camera.open((int)this.cameraSelect);
            maxSize = this.getMaxEncoderSizeSupported();
            previewSizes = this.camera.getParameters().getSupportedPreviewSizes();
            this.camera.release();
            this.camera = null;
        }
        Iterator iterator = previewSizes.iterator();
        while (iterator.hasNext()) {
            Camera.Size size = (Camera.Size)iterator.next();
            if (size.width <= maxSize.width && size.height <= maxSize.height) continue;
            Log.i((String)this.TAG, (String)(size.width + "X" + size.height + ", not supported for encoder"));
            iterator.remove();
        }
        return previewSizes;
    }

    public List<Camera.Size> getPreviewSizeBack() {
        return this.previewSizeBack;
    }

    public List<Camera.Size> getPreviewSizeFront() {
        return this.previewSizeFront;
    }

    private Camera.Size getMaxEncoderSizeSupported() {
        if (CamcorderProfile.hasProfile((int)8)) {
            Camera camera = this.camera;
            camera.getClass();
            return new Camera.Size(camera, 3840, 2160);
        }
        if (CamcorderProfile.hasProfile((int)6)) {
            Camera camera = this.camera;
            camera.getClass();
            return new Camera.Size(camera, 1920, 1080);
        }
        if (CamcorderProfile.hasProfile((int)5)) {
            Camera camera = this.camera;
            camera.getClass();
            return new Camera.Size(camera, 1280, 720);
        }
        Camera camera = this.camera;
        camera.getClass();
        return new Camera.Size(camera, 640, 480);
    }

    public void setEffect(EffectManager effect) {
        if (this.camera != null) {
            Camera.Parameters parameters = this.camera.getParameters();
            parameters.setColorEffect(effect.getEffect());
            try {
                this.camera.setParameters(parameters);
            }
            catch (RuntimeException e) {
                Log.e((String)this.TAG, (String)"Unsupported effect: ", (Throwable)e);
            }
        }
    }

    public void switchCamera() throws CameraOpenException {
        if (this.camera != null) {
            int oldCamera = this.cameraSelect;
            int number = Camera.getNumberOfCameras();
            for (int i = 0; i < number; ++i) {
                if (this.cameraSelect == i) continue;
                this.cameraSelect = i;
                if (!this.checkCanOpen()) {
                    this.cameraSelect = oldCamera;
                    throw new CameraOpenException("This camera resolution cant be opened");
                }
                this.stop();
                this.prepared = true;
                this.start();
                return;
            }
        }
    }

    private boolean checkCanOpen() {
        List<Camera.Size> previews = this.cameraSelect == this.selectCameraBack() ? this.previewSizeBack : this.previewSizeFront;
        for (Camera.Size size : previews) {
            if (size.width != this.width || size.height != this.height) continue;
            return true;
        }
        return false;
    }

    public boolean isLanternEnable() {
        return this.lanternEnable;
    }

    public void enableLantern() {
        Camera.Parameters parameters;
        List supportedFlashModes;
        if (this.camera != null && (supportedFlashModes = (parameters = this.camera.getParameters()).getSupportedFlashModes()) != null && !supportedFlashModes.isEmpty()) {
            if (supportedFlashModes.contains("torch")) {
                parameters.setFlashMode("torch");
                this.camera.setParameters(parameters);
                this.lanternEnable = true;
            } else {
                Log.e((String)this.TAG, (String)"Lantern unsupported");
            }
        }
    }

    public void disableLantern() {
        if (this.camera != null) {
            Camera.Parameters parameters = this.camera.getParameters();
            parameters.setFlashMode("off");
            this.camera.setParameters(parameters);
            this.lanternEnable = false;
        }
    }

    public void enableFaceDetection() {
        if (this.camera != null) {
            this.camera.setFaceDetectionListener((Camera.FaceDetectionListener)this);
        }
    }

    public void onFaceDetection(Camera.Face[] faces, Camera camera) {
    }
}

