/*
 * Decompiled with CFR 0.152.
 */
package com.pedro.encoder.video;

import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.media.MediaCodec;
import android.media.MediaCodecInfo;
import android.media.MediaCodecList;
import android.media.MediaFormat;
import android.os.Build;
import android.os.Bundle;
import android.support.annotation.RequiresApi;
import android.util.Log;
import android.util.Pair;
import android.view.Surface;
import com.pedro.encoder.input.video.GetCameraData;
import com.pedro.encoder.utils.YUVUtil;
import com.pedro.encoder.video.FormatVideoEncoder;
import com.pedro.encoder.video.GetH264Data;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;

public class VideoEncoder
implements GetCameraData {
    private String TAG = "VideoEncoder";
    private MediaCodec videoEncoder;
    private Thread thread;
    private Thread threadRotate;
    private Thread threadColor;
    private GetH264Data getH264Data;
    private MediaCodec.BufferInfo videoInfo = new MediaCodec.BufferInfo();
    private long mPresentTimeUs;
    private boolean running = false;
    private boolean spsPpsSetted = false;
    private boolean hardwareRotation = false;
    private Surface inputSurface;
    private BlockingQueue<byte[]> queueEncode = new LinkedBlockingQueue<byte[]>(30);
    private BlockingQueue<byte[]> queueRotate = new LinkedBlockingQueue<byte[]>(30);
    private BlockingQueue<byte[]> queueColor = new LinkedBlockingQueue<byte[]>(30);
    private int imageFormat = 17;
    private final Object sync = new Object();
    private String mime = "video/avc";
    private int width = 640;
    private int height = 480;
    private int fps = 30;
    private int bitRate = 1228800;
    private int rotation = 90;
    private FormatVideoEncoder formatVideoEncoder = FormatVideoEncoder.YUV420Dynamical;
    private boolean sendBlackImage = false;
    private byte[] blackImage;

    public VideoEncoder(GetH264Data getH264Data) {
        this.getH264Data = getH264Data;
    }

    public boolean prepareVideoEncoder(int width, int height, int fps, int bitRate, int rotation, boolean hardwareRotation, FormatVideoEncoder formatVideoEncoder) {
        this.width = width;
        this.height = height;
        this.fps = fps;
        this.bitRate = bitRate;
        this.rotation = rotation;
        this.hardwareRotation = hardwareRotation;
        this.formatVideoEncoder = formatVideoEncoder;
        MediaCodecInfo encoder = Build.VERSION.SDK_INT >= 21 ? this.chooseVideoEncoderAPI21(this.mime) : this.chooseVideoEncoder(this.mime);
        try {
            if (encoder != null) {
                this.videoEncoder = MediaCodec.createByCodecName((String)encoder.getName());
                if (this.formatVideoEncoder == FormatVideoEncoder.YUV420Dynamical) {
                    this.formatVideoEncoder = this.chooseColorDynamically(encoder);
                    if (this.formatVideoEncoder == null) {
                        Log.e((String)this.TAG, (String)"YUV420 dynamical choose failed");
                        return false;
                    }
                }
            } else {
                Log.e((String)this.TAG, (String)"valid encoder not found");
                return false;
            }
            MediaFormat videoFormat = !hardwareRotation && (rotation == 90 || rotation == 270) ? MediaFormat.createVideoFormat((String)this.mime, (int)height, (int)width) : MediaFormat.createVideoFormat((String)this.mime, (int)width, (int)height);
            videoFormat.setInteger("color-format", this.formatVideoEncoder.getFormatCodec());
            videoFormat.setInteger("max-input-size", 0);
            videoFormat.setInteger("bitrate", bitRate);
            videoFormat.setInteger("frame-rate", fps);
            videoFormat.setInteger("i-frame-interval", 2);
            if (hardwareRotation) {
                videoFormat.setInteger("rotation-degrees", rotation);
            }
            this.videoEncoder.configure(videoFormat, null, null, 1);
            this.running = false;
            if (formatVideoEncoder == FormatVideoEncoder.SURFACE && Build.VERSION.SDK_INT >= 18) {
                this.inputSurface = this.videoEncoder.createInputSurface();
            }
            this.prepareBlackImage();
            return true;
        }
        catch (IOException e) {
            Log.e((String)this.TAG, (String)"create videoEncoder failed.");
            e.printStackTrace();
            return false;
        }
        catch (IllegalStateException e) {
            e.printStackTrace();
            return false;
        }
    }

    private FormatVideoEncoder chooseColorDynamically(MediaCodecInfo mediaCodecInfo) {
        for (int color : mediaCodecInfo.getCapabilitiesForType((String)this.mime).colorFormats) {
            if (color == FormatVideoEncoder.YUV420PLANAR.getFormatCodec()) {
                return FormatVideoEncoder.YUV420PLANAR;
            }
            if (color == FormatVideoEncoder.YUV420SEMIPLANAR.getFormatCodec()) {
                return FormatVideoEncoder.YUV420SEMIPLANAR;
            }
            if (color != FormatVideoEncoder.YUV420PACKEDPLANAR.getFormatCodec()) continue;
            return FormatVideoEncoder.YUV420PACKEDPLANAR;
        }
        return null;
    }

    public boolean prepareVideoEncoder() {
        return this.prepareVideoEncoder(this.width, this.height, this.fps, this.bitRate, this.rotation, false, this.formatVideoEncoder);
    }

    @RequiresApi(api=19)
    public void setVideoBitrateOnFly(int bitrate) {
        if (this.isRunning()) {
            this.bitRate = bitrate;
            Bundle bundle = new Bundle();
            bundle.putInt("video-bitrate", bitrate);
            try {
                this.videoEncoder.setParameters(bundle);
            }
            catch (IllegalStateException e) {
                Log.e((String)this.TAG, (String)"encoder need be running");
                e.printStackTrace();
            }
        }
    }

    public Surface getInputSurface() {
        return this.inputSurface;
    }

    public void setInputSurface(Surface inputSurface) {
        this.inputSurface = inputSurface;
    }

    public void setImageFormat(int imageFormat) {
        this.imageFormat = imageFormat;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public boolean isRunning() {
        return this.running;
    }

    public int getRotation() {
        return this.rotation;
    }

    public int getFps() {
        return this.fps;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        Object object = this.sync;
        synchronized (object) {
            if (this.videoEncoder != null) {
                this.spsPpsSetted = false;
                this.mPresentTimeUs = System.nanoTime() / 1000L;
                this.videoEncoder.start();
                if (this.formatVideoEncoder == FormatVideoEncoder.SURFACE && Build.VERSION.SDK_INT >= 18) {
                    if (Build.VERSION.SDK_INT >= 21) {
                        this.getDataFromSurfaceAPI21();
                    } else {
                        this.getDataFromSurface();
                    }
                } else {
                    if (this.imageFormat != 17 && this.imageFormat != 842094169) {
                        this.stop();
                        Log.e((String)this.TAG, (String)"Unsupported imageFormat");
                        return;
                    }
                    if (this.rotation != 0 && this.rotation != 90 && this.rotation != 180 && this.rotation != 270) {
                        throw new RuntimeException("rotation value unsupported, select value 0, 90, 180 or 270");
                    }
                    this.thread = new Thread(new Runnable(){

                        @Override
                        public void run() {
                            while (!Thread.interrupted()) {
                                try {
                                    byte[] buffer = (byte[])VideoEncoder.this.queueEncode.take();
                                    if (Build.VERSION.SDK_INT >= 21) {
                                        VideoEncoder.this.getDataFromEncoderAPI21(buffer);
                                        continue;
                                    }
                                    VideoEncoder.this.getDataFromEncoder(buffer);
                                }
                                catch (InterruptedException e) {
                                    if (VideoEncoder.this.thread == null) continue;
                                    VideoEncoder.this.thread.interrupt();
                                }
                            }
                        }
                    });
                    this.threadRotate = new Thread(new Runnable(){

                        @Override
                        public void run() {
                            while (!Thread.interrupted()) {
                                try {
                                    byte[] buffer = (byte[])VideoEncoder.this.queueRotate.take();
                                    if (VideoEncoder.this.imageFormat == 842094169) {
                                        buffer = YUVUtil.YV12toYUV420PackedSemiPlanar(buffer, VideoEncoder.this.width, VideoEncoder.this.height);
                                    }
                                    if (VideoEncoder.this.hardwareRotation) continue;
                                    buffer = YUVUtil.rotateNV21(buffer, VideoEncoder.this.width, VideoEncoder.this.height, VideoEncoder.this.rotation);
                                    try {
                                        VideoEncoder.this.queueColor.add(buffer);
                                    }
                                    catch (IllegalStateException e) {
                                        Log.i((String)VideoEncoder.this.TAG, (String)"frame discarded");
                                    }
                                }
                                catch (InterruptedException e) {
                                    if (VideoEncoder.this.threadRotate == null) continue;
                                    VideoEncoder.this.threadRotate.interrupt();
                                }
                            }
                        }
                    });
                    this.threadColor = new Thread(new Runnable(){

                        @Override
                        public void run() {
                            while (!Thread.interrupted()) {
                                try {
                                    byte[] buffer = (byte[])VideoEncoder.this.queueColor.take();
                                    buffer = VideoEncoder.this.sendBlackImage ? VideoEncoder.this.blackImage : YUVUtil.NV21toYUV420byColor(buffer, VideoEncoder.this.width, VideoEncoder.this.height, VideoEncoder.this.formatVideoEncoder);
                                    try {
                                        VideoEncoder.this.queueEncode.add(buffer);
                                    }
                                    catch (IllegalStateException e) {
                                        Log.i((String)VideoEncoder.this.TAG, (String)"frame discarded");
                                    }
                                }
                                catch (InterruptedException e) {
                                    if (VideoEncoder.this.threadColor == null) continue;
                                    VideoEncoder.this.threadColor.interrupt();
                                }
                            }
                        }
                    });
                    this.thread.start();
                    this.threadRotate.start();
                    this.threadColor.start();
                }
                this.running = true;
            } else {
                Log.e((String)this.TAG, (String)"VideoEncoder need be prepared, VideoEncoder not enabled");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        Object object = this.sync;
        synchronized (object) {
            this.running = false;
            if (this.thread != null) {
                this.thread.interrupt();
                try {
                    this.thread.join();
                }
                catch (InterruptedException e) {
                    this.thread.interrupt();
                }
                this.thread = null;
            }
            if (this.threadRotate != null) {
                this.threadRotate.interrupt();
                try {
                    this.threadRotate.join();
                }
                catch (InterruptedException e) {
                    this.threadRotate.interrupt();
                }
                this.threadRotate = null;
            }
            if (this.threadColor != null) {
                this.threadColor.interrupt();
                try {
                    this.threadColor.join();
                }
                catch (InterruptedException e) {
                    this.threadColor.interrupt();
                }
                this.threadColor = null;
            }
            if (this.videoEncoder != null) {
                this.videoEncoder.stop();
                this.videoEncoder.release();
                this.videoEncoder = null;
            }
            this.queueEncode.clear();
            this.queueRotate.clear();
            this.queueColor.clear();
            this.spsPpsSetted = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void inputYUVData(byte[] buffer) {
        Object object = this.sync;
        synchronized (object) {
            if (this.running) {
                try {
                    this.queueRotate.add(buffer);
                }
                catch (IllegalStateException e) {
                    Log.i((String)this.TAG, (String)"frame discarded");
                }
            }
        }
    }

    @RequiresApi(api=21)
    private void getDataFromSurfaceAPI21() {
        this.thread = new Thread(new Runnable(){

            @Override
            public void run() {
                block0: while (!Thread.interrupted()) {
                    while (true) {
                        Pair buffers;
                        int outBufferIndex;
                        if ((outBufferIndex = VideoEncoder.this.videoEncoder.dequeueOutputBuffer(VideoEncoder.this.videoInfo, 0L)) == -2) {
                            MediaFormat mediaFormat = VideoEncoder.this.videoEncoder.getOutputFormat();
                            VideoEncoder.this.getH264Data.onVideoFormat(mediaFormat);
                            VideoEncoder.this.getH264Data.onSPSandPPS(mediaFormat.getByteBuffer("csd-0"), mediaFormat.getByteBuffer("csd-1"));
                            VideoEncoder.this.spsPpsSetted = true;
                            continue;
                        }
                        if (outBufferIndex < 0) continue block0;
                        ByteBuffer bb = VideoEncoder.this.videoEncoder.getOutputBuffer(outBufferIndex);
                        if ((((VideoEncoder)VideoEncoder.this).videoInfo.flags & 2) != 0 && !VideoEncoder.this.spsPpsSetted && (buffers = VideoEncoder.this.decodeSpsPpsFromBuffer(bb.duplicate(), ((VideoEncoder)VideoEncoder.this).videoInfo.size)) != null) {
                            VideoEncoder.this.getH264Data.onSPSandPPS((ByteBuffer)buffers.first, (ByteBuffer)buffers.second);
                            VideoEncoder.this.spsPpsSetted = true;
                        }
                        ((VideoEncoder)VideoEncoder.this).videoInfo.presentationTimeUs = System.nanoTime() / 1000L - VideoEncoder.this.mPresentTimeUs;
                        VideoEncoder.this.getH264Data.getH264Data(bb, VideoEncoder.this.videoInfo);
                        VideoEncoder.this.videoEncoder.releaseOutputBuffer(outBufferIndex, false);
                    }
                }
            }
        });
        this.thread.start();
    }

    private void getDataFromSurface() {
        this.thread = new Thread(new Runnable(){

            @Override
            public void run() {
                block0: while (!Thread.interrupted()) {
                    ByteBuffer[] outputBuffers = VideoEncoder.this.videoEncoder.getOutputBuffers();
                    while (true) {
                        Pair buffers;
                        int outBufferIndex;
                        if ((outBufferIndex = VideoEncoder.this.videoEncoder.dequeueOutputBuffer(VideoEncoder.this.videoInfo, 0L)) == -2) {
                            MediaFormat mediaFormat = VideoEncoder.this.videoEncoder.getOutputFormat();
                            VideoEncoder.this.getH264Data.onVideoFormat(mediaFormat);
                            VideoEncoder.this.getH264Data.onSPSandPPS(mediaFormat.getByteBuffer("csd-0"), mediaFormat.getByteBuffer("csd-1"));
                            VideoEncoder.this.spsPpsSetted = true;
                            continue;
                        }
                        if (outBufferIndex < 0) continue block0;
                        ByteBuffer bb = outputBuffers[outBufferIndex];
                        if ((((VideoEncoder)VideoEncoder.this).videoInfo.flags & 2) != 0 && !VideoEncoder.this.spsPpsSetted && (buffers = VideoEncoder.this.decodeSpsPpsFromBuffer(bb.duplicate(), ((VideoEncoder)VideoEncoder.this).videoInfo.size)) != null) {
                            VideoEncoder.this.getH264Data.onSPSandPPS((ByteBuffer)buffers.first, (ByteBuffer)buffers.second);
                            VideoEncoder.this.spsPpsSetted = true;
                        }
                        ((VideoEncoder)VideoEncoder.this).videoInfo.presentationTimeUs = System.nanoTime() / 1000L - VideoEncoder.this.mPresentTimeUs;
                        VideoEncoder.this.getH264Data.getH264Data(bb, VideoEncoder.this.videoInfo);
                        VideoEncoder.this.videoEncoder.releaseOutputBuffer(outBufferIndex, false);
                    }
                }
            }
        });
        this.thread.start();
    }

    @RequiresApi(api=21)
    private void getDataFromEncoderAPI21(byte[] buffer) {
        int inBufferIndex = this.videoEncoder.dequeueInputBuffer(-1L);
        if (inBufferIndex >= 0) {
            ByteBuffer bb = this.videoEncoder.getInputBuffer(inBufferIndex);
            bb.put(buffer, 0, buffer.length);
            long pts = System.nanoTime() / 1000L - this.mPresentTimeUs;
            this.videoEncoder.queueInputBuffer(inBufferIndex, 0, buffer.length, pts, 0);
        }
        while (true) {
            Pair<ByteBuffer, ByteBuffer> buffers;
            int outBufferIndex;
            if ((outBufferIndex = this.videoEncoder.dequeueOutputBuffer(this.videoInfo, 0L)) == -2) {
                MediaFormat mediaFormat = this.videoEncoder.getOutputFormat();
                this.getH264Data.onVideoFormat(mediaFormat);
                this.getH264Data.onSPSandPPS(mediaFormat.getByteBuffer("csd-0"), mediaFormat.getByteBuffer("csd-1"));
                this.spsPpsSetted = true;
                continue;
            }
            if (outBufferIndex < 0) break;
            ByteBuffer bb = this.videoEncoder.getOutputBuffer(outBufferIndex);
            if ((this.videoInfo.flags & 2) != 0 && !this.spsPpsSetted && (buffers = this.decodeSpsPpsFromBuffer(bb.duplicate(), this.videoInfo.size)) != null) {
                this.getH264Data.onSPSandPPS((ByteBuffer)buffers.first, (ByteBuffer)buffers.second);
                this.spsPpsSetted = true;
            }
            this.getH264Data.getH264Data(bb, this.videoInfo);
            this.videoEncoder.releaseOutputBuffer(outBufferIndex, false);
        }
    }

    private void getDataFromEncoder(byte[] buffer) {
        ByteBuffer[] inputBuffers = this.videoEncoder.getInputBuffers();
        ByteBuffer[] outputBuffers = this.videoEncoder.getOutputBuffers();
        int inBufferIndex = this.videoEncoder.dequeueInputBuffer(-1L);
        if (inBufferIndex >= 0) {
            ByteBuffer bb = inputBuffers[inBufferIndex];
            bb.clear();
            bb.put(buffer, 0, buffer.length);
            long pts = System.nanoTime() / 1000L - this.mPresentTimeUs;
            this.videoEncoder.queueInputBuffer(inBufferIndex, 0, buffer.length, pts, 0);
        }
        while (true) {
            Pair<ByteBuffer, ByteBuffer> buffers;
            int outBufferIndex;
            if ((outBufferIndex = this.videoEncoder.dequeueOutputBuffer(this.videoInfo, 0L)) == -2) {
                MediaFormat mediaFormat = this.videoEncoder.getOutputFormat();
                this.getH264Data.onVideoFormat(mediaFormat);
                this.getH264Data.onSPSandPPS(mediaFormat.getByteBuffer("csd-0"), mediaFormat.getByteBuffer("csd-1"));
                this.spsPpsSetted = true;
                continue;
            }
            if (outBufferIndex < 0) break;
            ByteBuffer bb = outputBuffers[outBufferIndex];
            if ((this.videoInfo.flags & 2) != 0 && !this.spsPpsSetted && (buffers = this.decodeSpsPpsFromBuffer(bb.duplicate(), this.videoInfo.size)) != null) {
                this.getH264Data.onSPSandPPS((ByteBuffer)buffers.first, (ByteBuffer)buffers.second);
                this.spsPpsSetted = true;
            }
            this.getH264Data.getH264Data(bb, this.videoInfo);
            this.videoEncoder.releaseOutputBuffer(outBufferIndex, false);
        }
    }

    @RequiresApi(api=21)
    private MediaCodecInfo chooseVideoEncoderAPI21(String mime) {
        MediaCodecInfo[] mediaCodecInfos;
        MediaCodecList mediaCodecList = new MediaCodecList(1);
        for (MediaCodecInfo mci : mediaCodecInfos = mediaCodecList.getCodecInfos()) {
            String[] types;
            if (!mci.isEncoder()) continue;
            for (String type : types = mci.getSupportedTypes()) {
                if (!type.equalsIgnoreCase(mime)) continue;
                Log.i((String)this.TAG, (String)String.format("videoEncoder %s type supported: %s", mci.getName(), type));
                MediaCodecInfo.CodecCapabilities codecCapabilities = mci.getCapabilitiesForType(mime);
                for (int color : codecCapabilities.colorFormats) {
                    Log.i((String)this.TAG, (String)("Color supported: " + color));
                    if (color != FormatVideoEncoder.YUV420PLANAR.getFormatCodec() && color != FormatVideoEncoder.YUV420SEMIPLANAR.getFormatCodec() && color != FormatVideoEncoder.YUV420PACKEDPLANAR.getFormatCodec()) continue;
                    return mci;
                }
            }
        }
        return null;
    }

    private MediaCodecInfo chooseVideoEncoder(String mime) {
        int count = MediaCodecList.getCodecCount();
        for (int i = 0; i < count; ++i) {
            String[] types;
            MediaCodecInfo mci = MediaCodecList.getCodecInfoAt((int)i);
            if (!mci.isEncoder()) continue;
            for (String type : types = mci.getSupportedTypes()) {
                if (!type.equalsIgnoreCase(mime)) continue;
                Log.i((String)this.TAG, (String)String.format("videoEncoder %s type supported: %s", mci.getName(), type));
                MediaCodecInfo.CodecCapabilities codecCapabilities = mci.getCapabilitiesForType(mime);
                for (int color : codecCapabilities.colorFormats) {
                    Log.i((String)this.TAG, (String)("Color supported: " + color));
                    if (color != FormatVideoEncoder.YUV420PLANAR.getFormatCodec() && color != FormatVideoEncoder.YUV420SEMIPLANAR.getFormatCodec() && color != FormatVideoEncoder.YUV420PACKEDPLANAR.getFormatCodec()) continue;
                    return mci;
                }
            }
        }
        return null;
    }

    private void prepareBlackImage() {
        Bitmap b = Bitmap.createBitmap((int)this.width, (int)this.height, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas canvas = new Canvas(b);
        canvas.drawColor(-16777216);
        int x = b.getWidth();
        int y = b.getHeight();
        int[] data = new int[x * y];
        b.getPixels(data, 0, x, 0, 0, x, y);
        this.blackImage = YUVUtil.ARGBtoYUV420SemiPlanar(data, this.width, this.height);
    }

    public void startSendBlackImage() {
        this.sendBlackImage = true;
        if (Build.VERSION.SDK_INT >= 19 && this.isRunning()) {
            Bundle bundle = new Bundle();
            bundle.putInt("video-bitrate", 102400);
            try {
                this.videoEncoder.setParameters(bundle);
            }
            catch (IllegalStateException e) {
                Log.e((String)this.TAG, (String)"encoder need be running");
                e.printStackTrace();
            }
        }
    }

    public void stopSendBlackImage() {
        this.sendBlackImage = false;
        if (Build.VERSION.SDK_INT >= 19) {
            this.setVideoBitrateOnFly(this.bitRate);
        }
    }

    private Pair<ByteBuffer, ByteBuffer> decodeSpsPpsFromBuffer(ByteBuffer outputBuffer, int length) {
        byte[] mSPS = null;
        byte[] mPPS = null;
        byte[] csd = new byte[length];
        outputBuffer.get(csd, 0, length);
        int spsIndex = -1;
        int ppsIndex = -1;
        for (int i = 0; i < length - 4; ++i) {
            if (csd[i] != 0 || csd[i + 1] != 0 || csd[i + 2] != 0 || csd[i + 3] != 1) continue;
            if (spsIndex == -1) {
                spsIndex = i;
                continue;
            }
            ppsIndex = i;
            break;
        }
        if (spsIndex != -1 && ppsIndex != -1) {
            mSPS = new byte[ppsIndex];
            System.arraycopy(csd, spsIndex, mSPS, 0, ppsIndex);
            mPPS = new byte[length - ppsIndex];
            System.arraycopy(csd, ppsIndex, mPPS, 0, length - ppsIndex);
        }
        if (mSPS != null && mPPS != null) {
            return new Pair((Object)ByteBuffer.wrap(mSPS), (Object)ByteBuffer.wrap(mPPS));
        }
        return null;
    }
}

