/*
 * Decompiled with CFR 0.152.
 */
package com.pedro.encoder.utils.gl;

import android.graphics.Bitmap;
import android.util.Log;
import com.pedro.encoder.utils.gl.StreamObjectBase;
import com.pedro.encoder.utils.gl.gif.GifDecoder;
import com.pedro.encoder.utils.gl.watermark.WatermarkUtil;
import java.io.IOException;
import java.io.InputStream;

public class GifStreamObject
extends StreamObjectBase {
    private static final String TAG = "GifStreamObject";
    private int streamWidth;
    private int streamHeight;
    private int numFrames;
    private Bitmap[] gifBitmaps;
    private int[] gifDelayFrames;
    private long startDelayFrame;
    private int currentGifFrame;

    public GifStreamObject(int streamWidth, int streamHeight) {
        this.streamWidth = streamWidth;
        this.streamHeight = streamHeight;
    }

    public void load(InputStream inputStreamGif) throws IOException {
        GifDecoder gifDecoder = new GifDecoder();
        if (gifDecoder.read(inputStreamGif, inputStreamGif.available()) == 0) {
            Log.i((String)TAG, (String)"read gif ok");
            this.numFrames = gifDecoder.getFrameCount();
            this.gifDelayFrames = new int[this.numFrames];
            this.gifBitmaps = new Bitmap[this.numFrames];
            for (int i = 0; i < this.numFrames; ++i) {
                gifDecoder.advance();
                this.gifBitmaps[i] = gifDecoder.getNextFrame();
                this.gifDelayFrames[i] = gifDecoder.getNextDelay();
            }
        } else {
            throw new RuntimeException("read gif error");
        }
        this.resize(gifDecoder.getWidth(), gifDecoder.getHeight());
        this.setPosition(0, 0);
        Log.i((String)TAG, (String)"finish load gif frames!!!");
    }

    @Override
    public void resize(int width, int height) {
        for (int i = 0; i < this.numFrames; ++i) {
            this.gifBitmaps[i] = Bitmap.createScaledBitmap((Bitmap)this.gifBitmaps[i], (int)width, (int)height, (boolean)false);
        }
    }

    @Override
    public void setPosition(int positionX, int positionY) {
        WatermarkUtil watermarkUtil = new WatermarkUtil(this.streamWidth, this.streamHeight);
        for (int i = 0; i < this.numFrames; ++i) {
            this.gifBitmaps[i] = watermarkUtil.createWatermarkBitmap(this.gifBitmaps[i], positionX, positionY);
        }
    }

    @Override
    public void recycle() {
        for (int i = 0; i < this.numFrames; ++i) {
            this.gifBitmaps[i].recycle();
        }
    }

    @Override
    public int getNumFrames() {
        return this.numFrames;
    }

    public int[] getGifDelayFrames() {
        return this.gifDelayFrames;
    }

    public Bitmap[] getGifBitmaps() {
        return this.gifBitmaps;
    }

    @Override
    public int updateFrame() {
        if (this.startDelayFrame == 0L) {
            this.startDelayFrame = System.currentTimeMillis();
        }
        if (System.currentTimeMillis() - this.startDelayFrame >= (long)this.gifDelayFrames[this.currentGifFrame]) {
            this.currentGifFrame = this.currentGifFrame >= this.numFrames - 1 ? 0 : ++this.currentGifFrame;
            this.startDelayFrame = 0L;
        }
        return this.currentGifFrame;
    }
}

