/*
 * Decompiled with CFR 0.152.
 */
package com.pedro.encoder.input.gl;

import android.content.Context;
import android.graphics.SurfaceTexture;
import android.opengl.GLES20;
import android.opengl.Matrix;
import android.support.annotation.RequiresApi;
import android.view.Surface;
import com.pedro.encoder.R;
import com.pedro.encoder.input.gl.TextureLoader;
import com.pedro.encoder.utils.gl.GifStreamObject;
import com.pedro.encoder.utils.gl.GlUtil;
import com.pedro.encoder.utils.gl.ImageStreamObject;
import com.pedro.encoder.utils.gl.StreamObjectBase;
import com.pedro.encoder.utils.gl.TextStreamObject;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;

@RequiresApi(api=18)
public class TextureManagerWatermark {
    public static final String TAG = "TextureManager";
    private Context context;
    private static final int FLOAT_SIZE_BYTES = 4;
    private static final int TRIANGLE_VERTICES_DATA_STRIDE_BYTES = 20;
    private static final int TRIANGLE_VERTICES_DATA_POS_OFFSET = 0;
    private static final int TRIANGLE_VERTICES_DATA_UV_OFFSET = 3;
    private final float[] triangleVerticesData = new float[]{-1.0f, -1.0f, 0.0f, 0.0f, 0.0f, 1.0f, -1.0f, 0.0f, 1.0f, 0.0f, -1.0f, 1.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f, 0.0f, 1.0f, 1.0f};
    private FloatBuffer triangleVertices;
    private float[] mMVPMatrix = new float[16];
    private float[] mSTMatrix = new float[16];
    private int[] texturesID = new int[1];
    private int program = -1;
    private int textureID = -1;
    private int uMVPMatrixHandle = -1;
    private int uSTMatrixHandle = -1;
    private int aPositionHandle = -1;
    private int aTextureHandle = -1;
    private int waterMarkHandle = -1;
    private SurfaceTexture surfaceTexture;
    private Surface surface;
    private int[] streamObjectTextureId = null;
    private StreamObjectBase streamObjectBase = null;
    private TextureLoader textureLoader = new TextureLoader();

    public TextureManagerWatermark(Context context) {
        this.context = context;
        this.triangleVertices = ByteBuffer.allocateDirect(this.triangleVerticesData.length * 4).order(ByteOrder.nativeOrder()).asFloatBuffer();
        this.triangleVertices.put(this.triangleVerticesData).position(0);
        Matrix.setIdentityM((float[])this.mSTMatrix, (int)0);
    }

    public int getTextureId() {
        return this.textureID;
    }

    public SurfaceTexture getSurfaceTexture() {
        return this.surfaceTexture;
    }

    public Surface getSurface() {
        return this.surface;
    }

    public void updateFrame() {
        this.surfaceTexture.updateTexImage();
    }

    public void drawFrame(int width, int height) {
        GlUtil.checkGlError("onDrawFrame start");
        this.surfaceTexture.getTransformMatrix(this.mSTMatrix);
        GLES20.glViewport((int)0, (int)0, (int)width, (int)height);
        GLES20.glClearColor((float)0.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        GLES20.glClear((int)16640);
        GLES20.glUseProgram((int)this.program);
        GlUtil.checkGlError("glUseProgram");
        this.triangleVertices.position(0);
        GLES20.glVertexAttribPointer((int)this.aPositionHandle, (int)3, (int)5126, (boolean)false, (int)20, (Buffer)this.triangleVertices);
        GlUtil.checkGlError("glVertexAttribPointer maPosition");
        GLES20.glEnableVertexAttribArray((int)this.aPositionHandle);
        GlUtil.checkGlError("glEnableVertexAttribArray aPositionHandle");
        this.triangleVertices.position(3);
        GLES20.glVertexAttribPointer((int)this.aTextureHandle, (int)2, (int)5126, (boolean)false, (int)20, (Buffer)this.triangleVertices);
        GlUtil.checkGlError("glVertexAttribPointer aTextureHandle");
        GLES20.glEnableVertexAttribArray((int)this.aTextureHandle);
        GlUtil.checkGlError("glEnableVertexAttribArray aTextureHandle");
        Matrix.setIdentityM((float[])this.mMVPMatrix, (int)0);
        GLES20.glUniformMatrix4fv((int)this.uMVPMatrixHandle, (int)1, (boolean)false, (float[])this.mMVPMatrix, (int)0);
        GLES20.glUniformMatrix4fv((int)this.uSTMatrixHandle, (int)1, (boolean)false, (float[])this.mSTMatrix, (int)0);
        GLES20.glActiveTexture((int)33984);
        GLES20.glBindTexture((int)36197, (int)this.textureID);
        GLES20.glUniform1i((int)this.waterMarkHandle, (int)1);
        GLES20.glActiveTexture((int)33985);
        if (this.streamObjectTextureId != null) {
            if (this.streamObjectTextureId[0] == -1) {
                GLES20.glBindTexture((int)3553, (int)this.streamObjectTextureId[0]);
                this.streamObjectTextureId = null;
                this.streamObjectBase = null;
            } else {
                GLES20.glBindTexture((int)3553, (int)this.streamObjectTextureId[this.streamObjectBase.updateFrame()]);
            }
        }
        GLES20.glDrawArrays((int)5, (int)0, (int)4);
        GlUtil.checkGlError("glDrawArrays");
    }

    public void initGl() {
        GlUtil.checkGlError("create handlers start");
        String vertexShader = GlUtil.getStringFromRaw(this.context, R.raw.simple_vertex);
        String fragmentShader = GlUtil.getStringFromRaw(this.context, R.raw.watermark_fragment);
        this.program = GlUtil.createProgram(vertexShader, fragmentShader);
        this.aPositionHandle = GLES20.glGetAttribLocation((int)this.program, (String)"aPosition");
        this.aTextureHandle = GLES20.glGetAttribLocation((int)this.program, (String)"aTextureCoord");
        this.uMVPMatrixHandle = GLES20.glGetUniformLocation((int)this.program, (String)"uMVPMatrix");
        this.uSTMatrixHandle = GLES20.glGetUniformLocation((int)this.program, (String)"uSTMatrix");
        this.waterMarkHandle = GLES20.glGetUniformLocation((int)this.program, (String)"watermark");
        GlUtil.checkGlError("create handlers end");
        GlUtil.createExternalTextures(1, this.texturesID, 0);
        this.textureID = this.texturesID[0];
        GlUtil.checkGlError("glTexParameter");
        this.surfaceTexture = new SurfaceTexture(this.textureID);
        this.surface = new Surface(this.surfaceTexture);
    }

    public void release() {
        this.surfaceTexture = null;
        this.surface = null;
        this.streamObjectTextureId = null;
        this.streamObjectBase = null;
    }

    public void setImage(ImageStreamObject imageStreamObject) {
        this.streamObjectTextureId = null;
        this.streamObjectBase = imageStreamObject;
        this.textureLoader.setImageStreamObject(imageStreamObject);
        this.streamObjectTextureId = this.textureLoader.load();
    }

    public void setText(TextStreamObject textStreamObject) {
        this.streamObjectTextureId = null;
        this.streamObjectBase = textStreamObject;
        this.textureLoader.setTextStreamObject(textStreamObject);
        this.streamObjectTextureId = this.textureLoader.load();
    }

    public void setGif(GifStreamObject gifStreamObject) {
        this.streamObjectTextureId = null;
        this.streamObjectBase = gifStreamObject;
        this.textureLoader.setGifStreamObject(gifStreamObject);
        this.streamObjectTextureId = this.textureLoader.load();
    }

    public void clear() {
        this.streamObjectTextureId = new int[]{-1};
    }
}

