/*
 * Decompiled with CFR 0.152.
 */
package com.pedro.common;

import com.pedro.common.ExtensionsKt;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0010\b\n\u0002\b\u0012\n\u0002\u0010$\n\u0002\b\u0002\u0018\u0000 \"2\u00020\u0001:\u0001\"B\u0019\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\u0016\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0019\u001a\u00020\u0005J\b\u0010\u001a\u001a\u0004\u0018\u00010\u0005J\b\u0010\u001b\u001a\u0004\u0018\u00010\u0005J\u0006\u0010\u001c\u001a\u00020\u0005J\u0006\u0010\u001d\u001a\u00020\u0005J\u0006\u0010\u001e\u001a\u00020\u0005J\u0006\u0010\u001f\u001a\u00020\u0005J\u0014\u0010 \u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050!H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\t\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\u0005@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u001e\u0010\f\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\u0005@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000bR$\u0010\u000f\u001a\u0004\u0018\u00010\u000e2\b\u0010\b\u001a\u0004\u0018\u00010\u000e@BX\u0086\u000e\u00a2\u0006\n\n\u0002\u0010\u0012\u001a\u0004\b\u0010\u0010\u0011R\u001e\u0010\u0013\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\u0005@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u000bR\"\u0010\u0015\u001a\u0004\u0018\u00010\u00052\b\u0010\b\u001a\u0004\u0018\u00010\u0005@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u000bR\"\u0010\u0017\u001a\u0004\u0018\u00010\u00052\b\u0010\b\u001a\u0004\u0018\u00010\u0005@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u000b\u00a8\u0006#"}, d2={"Lcom/pedro/common/UrlParser;", "", "uri", "Ljava/net/URI;", "url", "", "<init>", "(Ljava/net/URI;Ljava/lang/String;)V", "value", "scheme", "getScheme", "()Ljava/lang/String;", "host", "getHost", "", "port", "getPort", "()Ljava/lang/Integer;", "Ljava/lang/Integer;", "path", "getPath", "query", "getQuery", "auth", "getAuth", "key", "getAuthUser", "getAuthPassword", "getAppName", "getStreamName", "getTcUrl", "getFullPath", "getAllQueries", "", "Companion", "common_release"})
@SourceDebugExtension(value={"SMAP\nUrlParser.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UrlParser.kt\ncom/pedro/common/UrlParser\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,105:1\n1#2:106\n1869#3,2:107\n*S KotlinDebug\n*F\n+ 1 UrlParser.kt\ncom/pedro/common/UrlParser\n*L\n99#1:107,2\n*E\n"})
public final class UrlParser {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String url;
    @NotNull
    private String scheme;
    @NotNull
    private String host;
    @Nullable
    private Integer port;
    @NotNull
    private String path;
    @Nullable
    private String query;
    @Nullable
    private String auth;

    private UrlParser(URI uri, String url) {
        this.url = url;
        this.scheme = "";
        this.host = "";
        this.path = "";
        String string = uri.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        String url2 = string;
        String string2 = uri.getScheme();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getScheme(...)");
        this.scheme = string2;
        String string3 = uri.getHost();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getHost(...)");
        this.host = string3;
        this.port = uri.getPort() < 0 ? null : Integer.valueOf(uri.getPort());
        String string4 = uri.getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"getPath(...)");
        this.path = StringsKt.removePrefix((String)string4, (CharSequence)"/");
        if (uri.getQuery() != null) {
            CharSequence charSequence = url2;
            String string5 = uri.getQuery();
            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"getQuery(...)");
            int i = StringsKt.indexOf$default((CharSequence)charSequence, (String)string5, (int)0, (boolean)false, (int)6, null);
            String string6 = url2.substring(i < 0 ? 0 : i);
            Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"substring(...)");
            this.query = string6;
        }
        this.auth = uri.getUserInfo();
    }

    @NotNull
    public final String getScheme() {
        return this.scheme;
    }

    @NotNull
    public final String getHost() {
        return this.host;
    }

    @Nullable
    public final Integer getPort() {
        return this.port;
    }

    @NotNull
    public final String getPath() {
        return this.path;
    }

    @Nullable
    public final String getQuery() {
        return this.query;
    }

    @Nullable
    public final String getAuth() {
        return this.auth;
    }

    @Nullable
    public final String getQuery(@NotNull String key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        return this.getAllQueries().get(key);
    }

    @Nullable
    public final String getAuthUser() {
        String[] stringArray;
        Object object = this.auth;
        if (object == null || (object = StringsKt.split$default((CharSequence)((CharSequence)object), (String[])(stringArray = new String[]{":"}), (boolean)false, (int)0, (int)6, null)) == null) {
            return null;
        }
        Object userInfo = object;
        return userInfo.size() == 2 ? (String)userInfo.get(0) : null;
    }

    @Nullable
    public final String getAuthPassword() {
        String[] stringArray;
        Object object = this.auth;
        if (object == null || (object = StringsKt.split$default((CharSequence)((CharSequence)object), (String[])(stringArray = new String[]{":"}), (boolean)false, (int)0, (int)6, null)) == null) {
            return null;
        }
        Object userInfo = object;
        return userInfo.size() == 2 ? (String)userInfo.get(1) : null;
    }

    @NotNull
    public final String getAppName() {
        String string;
        CharSequence charSequence;
        CharSequence charSequence2 = this.path;
        if (charSequence2.length() == 0) {
            boolean bl = false;
            charSequence = this.query;
            if (charSequence == null) {
                charSequence = "";
            }
        } else {
            charSequence = charSequence2;
        }
        String app = (String)charSequence;
        Integer[] indexes = ExtensionsKt.getIndexes(app, '/');
        switch (indexes.length) {
            case 0: {
                string = app;
                break;
            }
            case 1: {
                String string2 = app.substring(0, indexes[0]);
                string = string2;
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
                break;
            }
            default: {
                String string3 = app.substring(0, indexes[1]);
                string = string3;
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
            }
        }
        return string;
    }

    @NotNull
    public final String getStreamName() {
        return StringsKt.removePrefix((String)StringsKt.removePrefix((String)StringsKt.removePrefix((String)this.getFullPath(), (CharSequence)this.getAppName()), (CharSequence)"/"), (CharSequence)"?");
    }

    @NotNull
    public final String getTcUrl() {
        String port = this.port != null ? ":" + this.port : "";
        String appName = ((CharSequence)this.getAppName()).length() > 0 ? "/" + this.getAppName() : "";
        return this.scheme + "://" + this.host + port + appName;
    }

    @NotNull
    public final String getFullPath() {
        String fullPath = StringsKt.removePrefix((String)(this.path + (String)(this.query == null ? "" : "?" + this.query)), (CharSequence)"?");
        if (((CharSequence)fullPath).length() == 0) {
            String port = this.port != null ? ":" + this.port : "";
            return StringsKt.removePrefix((String)StringsKt.removePrefix((String)this.url, (CharSequence)(this.scheme + "://" + this.host + port)), (CharSequence)"/");
        }
        return fullPath;
    }

    private final Map<String, String> getAllQueries() {
        String[] stringArray;
        Object object = this.query;
        if (object == null || (object = StringsKt.split$default((CharSequence)((CharSequence)object), (String[])(stringArray = new String[]{"&"}), (boolean)false, (int)0, (int)6, null)) == null) {
            object = CollectionsKt.emptyList();
        }
        Object queries = object;
        HashMap map = new HashMap();
        Iterable $this$forEach$iv = (Iterable)queries;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String entry = (String)element$iv;
            boolean bl = false;
            CharSequence charSequence = entry;
            Pattern pattern = Pattern.compile("=");
            Intrinsics.checkNotNullExpressionValue((Object)pattern, (String)"compile(...)");
            List data = StringsKt.split((CharSequence)charSequence, (Pattern)pattern, (int)2);
            if (data.size() != 2) continue;
            ((Map)map).put(data.get(0), data.get(1));
        }
        return map;
    }

    public /* synthetic */ UrlParser(URI uri, String url, DefaultConstructorMarker $constructor_marker) {
        this(uri, url);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J!\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\t\u00a2\u0006\u0002\u0010\n\u00a8\u0006\u000b"}, d2={"Lcom/pedro/common/UrlParser$Companion;", "", "<init>", "()V", "parse", "Lcom/pedro/common/UrlParser;", "endpoint", "", "requiredProtocol", "", "(Ljava/lang/String;[Ljava/lang/String;)Lcom/pedro/common/UrlParser;", "common_release"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final UrlParser parse(@NotNull String endpoint, @NotNull String[] requiredProtocol) throws URISyntaxException {
            Intrinsics.checkNotNullParameter((Object)endpoint, (String)"endpoint");
            Intrinsics.checkNotNullParameter((Object)requiredProtocol, (String)"requiredProtocol");
            URI uri = new URI(endpoint);
            if (uri.getScheme() != null) {
                String string = uri.getScheme();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getScheme(...)");
                if (!ArraysKt.contains((Object[])requiredProtocol, (Object)((Object)StringsKt.trim((CharSequence)string)).toString())) {
                    throw new URISyntaxException(endpoint, "Invalid protocol: " + uri.getScheme());
                }
            }
            if (uri.getUserInfo() != null) {
                String string = uri.getUserInfo();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getUserInfo(...)");
                if (!StringsKt.contains$default((CharSequence)string, (CharSequence)":", (boolean)false, (int)2, null)) {
                    throw new URISyntaxException(endpoint, "Invalid auth. Auth must contain ':'");
                }
            }
            if (uri.getHost() == null) {
                throw new URISyntaxException(endpoint, "Invalid host: " + uri.getHost());
            }
            if (uri.getPath() == null) {
                throw new URISyntaxException(endpoint, "Invalid path: " + uri.getHost());
            }
            return new UrlParser(uri, endpoint, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

