/*
 * Decompiled with CFR 0.152.
 */
package com.pedro.common.av1;

import com.pedro.common.av1.Obu;
import com.pedro.common.av1.ObuType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0005\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u000b\u001a\u00020\fJ\u0018\u0010\r\u001a\u00020\f2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J$\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u000f0\u00112\u0006\u0010\u0013\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u000e\u0010\u0014\u001a\u00020\f2\u0006\u0010\u0015\u001a\u00020\u0012\u00a8\u0006\u0016"}, d2={"Lcom/pedro/common/av1/Av1Parser;", "", "<init>", "()V", "getObuType", "Lcom/pedro/common/av1/ObuType;", "header", "", "getObus", "", "Lcom/pedro/common/av1/Obu;", "av1Data", "", "readHeader", "offset", "", "readLeb128", "Lkotlin/Pair;", "", "data", "writeLeb128", "length", "common_release"})
@SourceDebugExtension(value={"SMAP\nAv1Parser.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Av1Parser.kt\ncom/pedro/common/av1/Av1Parser\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,104:1\n295#2,2:105\n*S KotlinDebug\n*F\n+ 1 Av1Parser.kt\ncom/pedro/common/av1/Av1Parser\n*L\n50#1:105,2\n*E\n"})
public final class Av1Parser {
    @NotNull
    public final ObuType getObuType(byte header) {
        ObuType obuType;
        Object v0;
        block2: {
            int value = (header & 0x7F & 0xF8) >>> 3;
            Iterable $this$firstOrNull$iv = (Iterable)ObuType.getEntries();
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                ObuType it = (ObuType)((Object)element$iv);
                boolean bl = false;
                if (!(it.getValue() == value)) continue;
                v0 = element$iv;
                break block2;
            }
            v0 = null;
        }
        if ((obuType = (ObuType)v0) == null) {
            obuType = ObuType.RESERVED;
        }
        return obuType;
    }

    @NotNull
    public final List<Obu> getObus(@NotNull byte[] av1Data) {
        byte[] data;
        Intrinsics.checkNotNullParameter((Object)av1Data, (String)"av1Data");
        List obuList = new ArrayList();
        for (int index = 0; index < av1Data.length; index += data.length) {
            byte[] header = this.readHeader(av1Data, index);
            Pair<Long, Integer> leb128Value = this.readLeb128(av1Data, index += header.length);
            byte[] length = ArraysKt.sliceArray((byte[])av1Data, (IntRange)RangesKt.until((int)index, (int)(index + ((Number)leb128Value.getSecond()).intValue())));
            data = ArraysKt.sliceArray((byte[])av1Data, (IntRange)RangesKt.until((int)(index += length.length), (int)(index + (int)((Number)leb128Value.getFirst()).longValue())));
            Obu obu = new Obu(header, length, data);
            obuList.add(obu);
        }
        return obuList;
    }

    private final byte[] readHeader(byte[] av1Data, int offset) {
        boolean containExtended;
        List header = new ArrayList();
        byte info = av1Data[offset];
        header.add(info);
        boolean bl = containExtended = (info >>> 2 & 1) == 1;
        if (containExtended) {
            header.add(av1Data[offset + 1]);
        }
        return CollectionsKt.toByteArray((Collection)header);
    }

    private final Pair<Long, Integer> readLeb128(byte[] data, int offset) {
        long result = 0L;
        int index = 0;
        byte b = 0;
        do {
            b = data[offset + index];
            result |= ((long)b & 0x7FL) << index * 7;
            ++index;
        } while ((b & 0x80) != 0);
        return new Pair((Object)result, (Object)index);
    }

    @NotNull
    public final byte[] writeLeb128(long length) {
        List result = new ArrayList();
        long remainingValue = length;
        do {
            byte by = (byte)(remainingValue & 0x7FL);
            if ((remainingValue >>>= 7) != 0L) {
                by = (byte)(by | 0xFFFFFF80);
            }
            result.add(by);
        } while (remainingValue != 0L);
        return CollectionsKt.toByteArray((Collection)result);
    }
}

