/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.common.options;

import com.google.devtools.common.options.Converter;
import com.google.devtools.common.options.Converters;
import com.google.devtools.common.options.OptionsParsingException;
import java.util.Arrays;

public abstract class EnumConverter<T extends Enum<T>>
implements Converter<T> {
    private final Class<T> enumType;
    private final String typeName;

    protected EnumConverter(Class<T> enumType, String typeName) {
        this.enumType = enumType;
        this.typeName = typeName;
    }

    @Override
    public T convert(String input) throws OptionsParsingException {
        for (Enum value : (Enum[])this.enumType.getEnumConstants()) {
            if (!value.toString().equalsIgnoreCase(input)) continue;
            return (T)value;
        }
        throw new OptionsParsingException("Not a valid " + this.typeName + ": '" + input + "' (should be " + this.getTypeDescription() + ")");
    }

    @Override
    public final String getTypeDescription() {
        return Converters.joinEnglishList(Arrays.asList(this.enumType.getEnumConstants())).toLowerCase();
    }
}

