/*
 * Decompiled with CFR 0.152.
 */
package com.github.pavlospt;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.RectF;
import android.graphics.Typeface;
import android.text.TextPaint;
import android.util.AttributeSet;
import android.view.View;
import com.github.pavlospt.R;

public class CircleView
extends View {
    private static int DEFAULT_TITLE_COLOR = -16711681;
    private static int DEFAULT_SUBTITLE_COLOR = -1;
    private static String DEFAULT_TITLE = "Title";
    private static String DEFAULT_SUBTITLE = "Subtitle";
    private static boolean DEFAULT_SHOW_TITLE = true;
    private static boolean DEFAULT_SHOW_SUBTITLE = true;
    private static float DEFAULT_TITLE_SIZE = 25.0f;
    private static float DEFAULT_SUBTITLE_SIZE = 20.0f;
    private static float DEFAULT_TITLE_SUBTITLE_SPACE = 0.0f;
    private static int DEFAULT_STROKE_COLOR = -16711681;
    private static int DEFAULT_BACKGROUND_COLOR = -1;
    private static int DEFAULT_FILL_COLOR = -12303292;
    private static float DEFAULT_STROKE_WIDTH = 5.0f;
    private static float DEFAULT_FILL_RADIUS = 0.9f;
    private static final int DEFAULT_VIEW_SIZE = 96;
    private int mTitleColor = DEFAULT_TITLE_COLOR;
    private int mSubtitleColor = DEFAULT_SUBTITLE_COLOR;
    private int mStrokeColor = DEFAULT_STROKE_COLOR;
    private int mBackgroundColor = DEFAULT_BACKGROUND_COLOR;
    private int mFillColor = DEFAULT_FILL_COLOR;
    private String mTitleText = DEFAULT_TITLE;
    private String mSubtitleText = DEFAULT_SUBTITLE;
    private float mTitleSize = DEFAULT_TITLE_SIZE;
    private float mSubtitleSize = DEFAULT_SUBTITLE_SIZE;
    private float mStrokeWidth = DEFAULT_STROKE_WIDTH;
    private float mFillRadius = DEFAULT_FILL_RADIUS;
    private float mTitleSubtitleSpace = DEFAULT_TITLE_SUBTITLE_SPACE;
    private boolean mShowTitle = DEFAULT_SHOW_TITLE;
    private boolean mShowSubtitle = DEFAULT_SHOW_SUBTITLE;
    private TextPaint mTitleTextPaint;
    private TextPaint mSubTextPaint;
    private Paint mStrokePaint;
    private Paint mBackgroundPaint;
    private Paint mFillPaint;
    private RectF mInnerRectF;
    private int mViewSize;

    public CircleView(Context context) {
        super(context);
        this.init(null, 0);
    }

    public CircleView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(attrs, 0);
    }

    public CircleView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.init(attrs, defStyle);
    }

    private void init(AttributeSet attrs, int defStyle) {
        TypedArray a = this.getContext().obtainStyledAttributes(attrs, R.styleable.CircleView, defStyle, 0);
        if (a.hasValue(R.styleable.CircleView_cv_titleText)) {
            this.mTitleText = a.getString(R.styleable.CircleView_cv_titleText);
        }
        if (a.hasValue(R.styleable.CircleView_cv_subtitleText)) {
            this.mSubtitleText = a.getString(R.styleable.CircleView_cv_subtitleText);
        }
        this.mTitleColor = a.getColor(R.styleable.CircleView_cv_titleColor, DEFAULT_TITLE_COLOR);
        this.mSubtitleColor = a.getColor(R.styleable.CircleView_cv_subtitleColor, DEFAULT_SUBTITLE_COLOR);
        this.mBackgroundColor = a.getColor(R.styleable.CircleView_cv_backgroundColorValue, DEFAULT_BACKGROUND_COLOR);
        this.mStrokeColor = a.getColor(R.styleable.CircleView_cv_strokeColorValue, DEFAULT_STROKE_COLOR);
        this.mFillColor = a.getColor(R.styleable.CircleView_cv_fillColor, DEFAULT_FILL_COLOR);
        this.mTitleSize = a.getDimension(R.styleable.CircleView_cv_titleSize, DEFAULT_TITLE_SIZE);
        this.mSubtitleSize = a.getDimension(R.styleable.CircleView_cv_subtitleSize, DEFAULT_SUBTITLE_SIZE);
        this.mStrokeWidth = a.getFloat(R.styleable.CircleView_cv_strokeWidthSize, DEFAULT_STROKE_WIDTH);
        this.mFillRadius = a.getFloat(R.styleable.CircleView_cv_fillRadius, DEFAULT_FILL_RADIUS);
        this.mTitleSubtitleSpace = a.getFloat(R.styleable.CircleView_cv_titleSubtitleSpace, DEFAULT_TITLE_SUBTITLE_SPACE);
        a.recycle();
        this.mTitleTextPaint = new TextPaint();
        this.mTitleTextPaint.setFlags(1);
        this.mTitleTextPaint.setTypeface(Typeface.defaultFromStyle((int)0));
        this.mTitleTextPaint.setTextAlign(Paint.Align.CENTER);
        this.mTitleTextPaint.setLinearText(true);
        this.mTitleTextPaint.setColor(this.mTitleColor);
        this.mTitleTextPaint.setTextSize(this.mTitleSize);
        this.mSubTextPaint = new TextPaint();
        this.mSubTextPaint.setFlags(1);
        this.mSubTextPaint.setTypeface(Typeface.defaultFromStyle((int)0));
        this.mSubTextPaint.setTextAlign(Paint.Align.CENTER);
        this.mSubTextPaint.setLinearText(true);
        this.mSubTextPaint.setColor(this.mSubtitleColor);
        this.mSubTextPaint.setTextSize(this.mSubtitleSize);
        this.mStrokePaint = new Paint();
        this.mStrokePaint.setFlags(1);
        this.mStrokePaint.setStyle(Paint.Style.STROKE);
        this.mStrokePaint.setColor(this.mStrokeColor);
        this.mStrokePaint.setStrokeWidth(this.mStrokeWidth);
        this.mBackgroundPaint = new Paint();
        this.mBackgroundPaint.setFlags(1);
        this.mBackgroundPaint.setStyle(Paint.Style.FILL);
        this.mBackgroundPaint.setColor(this.mBackgroundColor);
        this.mFillPaint = new Paint();
        this.mFillPaint.setFlags(1);
        this.mFillPaint.setStyle(Paint.Style.FILL);
        this.mFillPaint.setColor(this.mFillColor);
        this.mInnerRectF = new RectF();
    }

    private void invalidateTextPaints() {
        this.mTitleTextPaint.setColor(this.mTitleColor);
        this.mSubTextPaint.setColor(this.mSubtitleColor);
        this.mTitleTextPaint.setTextSize(this.mTitleSize);
        this.mSubTextPaint.setTextSize(this.mSubtitleSize);
        this.invalidate();
    }

    private void invalidatePaints() {
        this.mBackgroundPaint.setColor(this.mBackgroundColor);
        this.mStrokePaint.setColor(this.mStrokeColor);
        this.mFillPaint.setColor(this.mFillColor);
        this.invalidate();
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        int width = CircleView.resolveSize((int)96, (int)widthMeasureSpec);
        int height = CircleView.resolveSize((int)96, (int)heightMeasureSpec);
        this.mViewSize = Math.min(width, height);
        this.setMeasuredDimension(width, height);
    }

    protected void onDraw(Canvas canvas) {
        this.mInnerRectF.set(0.0f, 0.0f, (float)this.mViewSize, (float)this.mViewSize);
        this.mInnerRectF.offset((float)((this.getWidth() - this.mViewSize) / 2), (float)((this.getHeight() - this.mViewSize) / 2));
        int halfBorder = (int)(this.mStrokePaint.getStrokeWidth() / 2.0f + 0.5f);
        this.mInnerRectF.inset((float)halfBorder, (float)halfBorder);
        float centerX = this.mInnerRectF.centerX();
        float centerY = this.mInnerRectF.centerY();
        canvas.drawArc(this.mInnerRectF, 0.0f, 360.0f, true, this.mBackgroundPaint);
        float radius = (float)(this.mViewSize / 2) * this.mFillRadius;
        canvas.drawCircle(centerX, centerY, radius + 0.5f - this.mStrokePaint.getStrokeWidth(), this.mFillPaint);
        int xPos = (int)centerX;
        int yPos = (int)(centerY - (this.mTitleTextPaint.descent() + this.mTitleTextPaint.ascent()) / 2.0f);
        canvas.drawOval(this.mInnerRectF, this.mStrokePaint);
        if (this.mShowTitle) {
            canvas.drawText(this.mTitleText, (float)xPos, (float)yPos, (Paint)this.mTitleTextPaint);
        }
        if (this.mShowSubtitle) {
            canvas.drawText(this.mSubtitleText, (float)xPos, (float)(yPos + 20) + this.mTitleSubtitleSpace, (Paint)this.mSubTextPaint);
        }
    }

    public void setShowTitle(boolean flag) {
        this.mShowTitle = flag;
        this.invalidate();
    }

    public void setShowSubtitle(boolean flag) {
        this.mShowSubtitle = flag;
        this.invalidate();
    }

    public String getTitleText() {
        return this.mTitleText;
    }

    public void setTitleText(String title) {
        this.mTitleText = title;
        this.invalidate();
    }

    public String getSubtitleText() {
        return this.mSubtitleText;
    }

    public void setSubtitleText(String subtitle) {
        this.mSubtitleText = subtitle;
        this.invalidate();
    }

    public int getStrokeColor() {
        return this.mStrokeColor;
    }

    public int getBackgroundColor() {
        return this.mBackgroundColor;
    }

    public int getFillColor() {
        return this.mStrokeColor;
    }

    public void setStrokeColor(int strokeColor) {
        this.mStrokeColor = strokeColor;
        this.invalidatePaints();
    }

    public void setBackgroundColor(int backgroundColor) {
        this.mBackgroundColor = backgroundColor;
        this.invalidatePaints();
    }

    public void setFillColor(int fillColor) {
        this.mFillColor = fillColor;
        this.invalidatePaints();
    }

    public float getStrokeWidth() {
        return this.mStrokeWidth;
    }

    public void setBackgroundColor(float strokeWidth) {
        this.mStrokeWidth = strokeWidth;
        this.invalidate();
    }

    public float getFillRadius() {
        return this.mFillRadius;
    }

    public void setFillRadius(float fillRadius) {
        this.mFillRadius = fillRadius;
        this.invalidate();
    }

    public float getTitleSize() {
        return this.mTitleSize;
    }

    public void setTitleSize(float titleSize) {
        this.mTitleSize = titleSize;
        this.invalidateTextPaints();
    }

    public float getSubtitleSize() {
        return this.mSubtitleSize;
    }

    public void setSubtitleSize(float subtitleSize) {
        this.mSubtitleSize = subtitleSize;
        this.invalidateTextPaints();
    }

    public int getTitleColor() {
        return this.mTitleColor;
    }

    public void setTitleColor(int titleColor) {
        this.mTitleColor = titleColor;
        this.invalidateTextPaints();
    }

    public int getSubtitleColor() {
        return this.mSubtitleColor;
    }

    public void setSubtitleColor(int subtitleColor) {
        this.mSubtitleColor = subtitleColor;
        this.invalidateTextPaints();
    }

    public float getTitleSubtitleSpace() {
        return this.mTitleSubtitleSpace;
    }

    public void setTitleSubtitleSpace(float titleSubtitleSpace) {
        this.mTitleSubtitleSpace = titleSubtitleSpace;
        this.invalidateTextPaints();
    }
}

