/*
 * Decompiled with CFR 0.152.
 */
package com.passiondroid.imageeditorlib.views.cropimage;

import android.annotation.TargetApi;
import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.Region;
import android.os.Build;
import android.util.AttributeSet;
import android.util.Log;
import android.view.MotionEvent;
import android.view.ScaleGestureDetector;
import android.view.View;
import com.passiondroid.imageeditorlib.views.cropimage.BitmapUtils;
import com.passiondroid.imageeditorlib.views.cropimage.CropImageOptions;
import com.passiondroid.imageeditorlib.views.cropimage.CropImageView;
import com.passiondroid.imageeditorlib.views.cropimage.CropWindowHandler;
import com.passiondroid.imageeditorlib.views.cropimage.CropWindowMoveHandler;
import java.util.Arrays;

public class CropOverlayView
extends View {
    private ScaleGestureDetector mScaleDetector;
    private boolean mMultiTouchEnabled;
    private final CropWindowHandler mCropWindowHandler = new CropWindowHandler();
    private CropWindowChangeListener mCropWindowChangeListener;
    private final RectF mDrawRect = new RectF();
    private Paint mBorderPaint;
    private Paint mBorderCornerPaint;
    private Paint mGuidelinePaint;
    private Paint mBackgroundPaint;
    private Path mPath = new Path();
    private final float[] mBoundsPoints = new float[8];
    private final RectF mCalcBounds = new RectF();
    private int mViewWidth;
    private int mViewHeight;
    private float mBorderCornerOffset;
    private float mBorderCornerLength;
    private float mInitialCropWindowPaddingRatio;
    private float mTouchRadius;
    private float mSnapRadius;
    private CropWindowMoveHandler mMoveHandler;
    private boolean mFixAspectRatio;
    private int mAspectRatioX;
    private int mAspectRatioY;
    private float mTargetAspectRatio = (float)this.mAspectRatioX / (float)this.mAspectRatioY;
    private CropImageView.Guidelines mGuidelines;
    private CropImageView.CropShape mCropShape;
    private final Rect mInitialCropWindowRect = new Rect();
    private boolean initializedCropWindow;
    private Integer mOriginalLayerType;

    public CropOverlayView(Context context) {
        this(context, null);
    }

    public CropOverlayView(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    public void setCropWindowChangeListener(CropWindowChangeListener listener) {
        this.mCropWindowChangeListener = listener;
    }

    public RectF getCropWindowRect() {
        return this.mCropWindowHandler.getRect();
    }

    public void setCropWindowRect(RectF rect) {
        this.mCropWindowHandler.setRect(rect);
    }

    public void fixCurrentCropWindowRect() {
        RectF rect = this.getCropWindowRect();
        this.fixCropWindowRectByRules(rect);
        this.mCropWindowHandler.setRect(rect);
    }

    public void setBounds(float[] boundsPoints, int viewWidth, int viewHeight) {
        if (boundsPoints == null || !Arrays.equals(this.mBoundsPoints, boundsPoints)) {
            if (boundsPoints == null) {
                Arrays.fill(this.mBoundsPoints, 0.0f);
            } else {
                System.arraycopy(boundsPoints, 0, this.mBoundsPoints, 0, boundsPoints.length);
            }
            this.mViewWidth = viewWidth;
            this.mViewHeight = viewHeight;
            RectF cropRect = this.mCropWindowHandler.getRect();
            if (cropRect.width() == 0.0f || cropRect.height() == 0.0f) {
                this.initCropWindow();
            }
        }
    }

    public void resetCropOverlayView() {
        if (this.initializedCropWindow) {
            this.setCropWindowRect(BitmapUtils.EMPTY_RECT_F);
            this.initCropWindow();
            this.invalidate();
        }
    }

    public CropImageView.CropShape getCropShape() {
        return this.mCropShape;
    }

    public void setCropShape(CropImageView.CropShape cropShape) {
        if (this.mCropShape != cropShape) {
            this.mCropShape = cropShape;
            if (Build.VERSION.SDK_INT <= 17) {
                if (this.mCropShape == CropImageView.CropShape.OVAL) {
                    this.mOriginalLayerType = this.getLayerType();
                    if (this.mOriginalLayerType != 1) {
                        this.setLayerType(1, null);
                    } else {
                        this.mOriginalLayerType = null;
                    }
                } else if (this.mOriginalLayerType != null) {
                    this.setLayerType(this.mOriginalLayerType, null);
                    this.mOriginalLayerType = null;
                }
            }
            this.invalidate();
        }
    }

    public CropImageView.Guidelines getGuidelines() {
        return this.mGuidelines;
    }

    public void setGuidelines(CropImageView.Guidelines guidelines) {
        if (this.mGuidelines != guidelines) {
            this.mGuidelines = guidelines;
            if (this.initializedCropWindow) {
                this.invalidate();
            }
        }
    }

    public boolean isFixAspectRatio() {
        return this.mFixAspectRatio;
    }

    public void setFixedAspectRatio(boolean fixAspectRatio) {
        if (this.mFixAspectRatio != fixAspectRatio) {
            this.mFixAspectRatio = fixAspectRatio;
            if (this.initializedCropWindow) {
                this.initCropWindow();
                this.invalidate();
            }
        }
    }

    public int getAspectRatioX() {
        return this.mAspectRatioX;
    }

    public void setAspectRatioX(int aspectRatioX) {
        if (aspectRatioX <= 0) {
            throw new IllegalArgumentException("Cannot set aspect ratio value to a number less than or equal to 0.");
        }
        if (this.mAspectRatioX != aspectRatioX) {
            this.mAspectRatioX = aspectRatioX;
            this.mTargetAspectRatio = (float)this.mAspectRatioX / (float)this.mAspectRatioY;
            if (this.initializedCropWindow) {
                this.initCropWindow();
                this.invalidate();
            }
        }
    }

    public int getAspectRatioY() {
        return this.mAspectRatioY;
    }

    public void setAspectRatioY(int aspectRatioY) {
        if (aspectRatioY <= 0) {
            throw new IllegalArgumentException("Cannot set aspect ratio value to a number less than or equal to 0.");
        }
        if (this.mAspectRatioY != aspectRatioY) {
            this.mAspectRatioY = aspectRatioY;
            this.mTargetAspectRatio = (float)this.mAspectRatioX / (float)this.mAspectRatioY;
            if (this.initializedCropWindow) {
                this.initCropWindow();
                this.invalidate();
            }
        }
    }

    public void setSnapRadius(float snapRadius) {
        this.mSnapRadius = snapRadius;
    }

    public boolean setMultiTouchEnabled(boolean multiTouchEnabled) {
        if (this.mMultiTouchEnabled != multiTouchEnabled) {
            this.mMultiTouchEnabled = multiTouchEnabled;
            if (this.mMultiTouchEnabled && this.mScaleDetector == null) {
                this.mScaleDetector = new ScaleGestureDetector(this.getContext(), (ScaleGestureDetector.OnScaleGestureListener)new ScaleListener());
            }
            return true;
        }
        return false;
    }

    public void setMinCropResultSize(int minCropResultWidth, int minCropResultHeight) {
        this.mCropWindowHandler.setMinCropResultSize(minCropResultWidth, minCropResultHeight);
    }

    public void setMaxCropResultSize(int maxCropResultWidth, int maxCropResultHeight) {
        this.mCropWindowHandler.setMaxCropResultSize(maxCropResultWidth, maxCropResultHeight);
    }

    public void setCropWindowLimits(float maxWidth, float maxHeight, float scaleFactorWidth, float scaleFactorHeight) {
        this.mCropWindowHandler.setCropWindowLimits(maxWidth, maxHeight, scaleFactorWidth, scaleFactorHeight);
    }

    public Rect getInitialCropWindowRect() {
        return this.mInitialCropWindowRect;
    }

    public void setInitialCropWindowRect(Rect rect) {
        this.mInitialCropWindowRect.set(rect != null ? rect : BitmapUtils.EMPTY_RECT);
        if (this.initializedCropWindow) {
            this.initCropWindow();
            this.invalidate();
            this.callOnCropWindowChanged(false);
        }
    }

    public void resetCropWindowRect() {
        if (this.initializedCropWindow) {
            this.initCropWindow();
            this.invalidate();
            this.callOnCropWindowChanged(false);
        }
    }

    public void setInitialAttributeValues(CropImageOptions options) {
        this.mCropWindowHandler.setInitialAttributeValues(options);
        this.setCropShape(options.cropShape);
        this.setSnapRadius(options.snapRadius);
        this.setGuidelines(options.guidelines);
        this.setFixedAspectRatio(options.fixAspectRatio);
        this.setAspectRatioX(options.aspectRatioX);
        this.setAspectRatioY(options.aspectRatioY);
        this.setMultiTouchEnabled(options.multiTouchEnabled);
        this.mTouchRadius = options.touchRadius;
        this.mInitialCropWindowPaddingRatio = options.initialCropWindowPaddingRatio;
        this.mBorderPaint = CropOverlayView.getNewPaintOrNull(options.borderLineThickness, options.borderLineColor);
        this.mBorderCornerOffset = options.borderCornerOffset;
        this.mBorderCornerLength = options.borderCornerLength;
        this.mBorderCornerPaint = CropOverlayView.getNewPaintOrNull(options.borderCornerThickness, options.borderCornerColor);
        this.mGuidelinePaint = CropOverlayView.getNewPaintOrNull(options.guidelinesThickness, options.guidelinesColor);
        this.mBackgroundPaint = CropOverlayView.getNewPaint(options.backgroundColor);
    }

    private void initCropWindow() {
        float leftLimit = Math.max(BitmapUtils.getRectLeft(this.mBoundsPoints), 0.0f);
        float topLimit = Math.max(BitmapUtils.getRectTop(this.mBoundsPoints), 0.0f);
        float rightLimit = Math.min(BitmapUtils.getRectRight(this.mBoundsPoints), (float)this.getWidth());
        float bottomLimit = Math.min(BitmapUtils.getRectBottom(this.mBoundsPoints), (float)this.getHeight());
        if (rightLimit <= leftLimit || bottomLimit <= topLimit) {
            return;
        }
        RectF rect = new RectF();
        this.initializedCropWindow = true;
        float horizontalPadding = this.mInitialCropWindowPaddingRatio * (rightLimit - leftLimit);
        float verticalPadding = this.mInitialCropWindowPaddingRatio * (bottomLimit - topLimit);
        if (this.mInitialCropWindowRect.width() > 0 && this.mInitialCropWindowRect.height() > 0) {
            rect.left = leftLimit + (float)this.mInitialCropWindowRect.left / this.mCropWindowHandler.getScaleFactorWidth();
            rect.top = topLimit + (float)this.mInitialCropWindowRect.top / this.mCropWindowHandler.getScaleFactorHeight();
            rect.right = rect.left + (float)this.mInitialCropWindowRect.width() / this.mCropWindowHandler.getScaleFactorWidth();
            rect.bottom = rect.top + (float)this.mInitialCropWindowRect.height() / this.mCropWindowHandler.getScaleFactorHeight();
            rect.left = Math.max(leftLimit, rect.left);
            rect.top = Math.max(topLimit, rect.top);
            rect.right = Math.min(rightLimit, rect.right);
            rect.bottom = Math.min(bottomLimit, rect.bottom);
        } else if (this.mFixAspectRatio && rightLimit > leftLimit && bottomLimit > topLimit) {
            float bitmapAspectRatio = (rightLimit - leftLimit) / (bottomLimit - topLimit);
            if (bitmapAspectRatio > this.mTargetAspectRatio) {
                rect.top = topLimit + verticalPadding;
                rect.bottom = bottomLimit - verticalPadding;
                float centerX = (float)this.getWidth() / 2.0f;
                this.mTargetAspectRatio = (float)this.mAspectRatioX / (float)this.mAspectRatioY;
                float cropWidth = Math.max(this.mCropWindowHandler.getMinCropWidth(), rect.height() * this.mTargetAspectRatio);
                float halfCropWidth = cropWidth / 2.0f;
                rect.left = centerX - halfCropWidth;
                rect.right = centerX + halfCropWidth;
            } else {
                rect.left = leftLimit + horizontalPadding;
                rect.right = rightLimit - horizontalPadding;
                float centerY = (float)this.getHeight() / 2.0f;
                float cropHeight = Math.max(this.mCropWindowHandler.getMinCropHeight(), rect.width() / this.mTargetAspectRatio);
                float halfCropHeight = cropHeight / 2.0f;
                rect.top = centerY - halfCropHeight;
                rect.bottom = centerY + halfCropHeight;
            }
        } else {
            rect.left = leftLimit + horizontalPadding;
            rect.top = topLimit + verticalPadding;
            rect.right = rightLimit - horizontalPadding;
            rect.bottom = bottomLimit - verticalPadding;
        }
        this.fixCropWindowRectByRules(rect);
        this.mCropWindowHandler.setRect(rect);
    }

    private void fixCropWindowRectByRules(RectF rect) {
        float adj;
        if (rect.width() < this.mCropWindowHandler.getMinCropWidth()) {
            adj = (this.mCropWindowHandler.getMinCropWidth() - rect.width()) / 2.0f;
            rect.left -= adj;
            rect.right += adj;
        }
        if (rect.height() < this.mCropWindowHandler.getMinCropHeight()) {
            adj = (this.mCropWindowHandler.getMinCropHeight() - rect.height()) / 2.0f;
            rect.top -= adj;
            rect.bottom += adj;
        }
        if (rect.width() > this.mCropWindowHandler.getMaxCropWidth()) {
            adj = (rect.width() - this.mCropWindowHandler.getMaxCropWidth()) / 2.0f;
            rect.left += adj;
            rect.right -= adj;
        }
        if (rect.height() > this.mCropWindowHandler.getMaxCropHeight()) {
            adj = (rect.height() - this.mCropWindowHandler.getMaxCropHeight()) / 2.0f;
            rect.top += adj;
            rect.bottom -= adj;
        }
        this.calculateBounds(rect);
        if (this.mCalcBounds.width() > 0.0f && this.mCalcBounds.height() > 0.0f) {
            float leftLimit = Math.max(this.mCalcBounds.left, 0.0f);
            float topLimit = Math.max(this.mCalcBounds.top, 0.0f);
            float rightLimit = Math.min(this.mCalcBounds.right, (float)this.getWidth());
            float bottomLimit = Math.min(this.mCalcBounds.bottom, (float)this.getHeight());
            if (rect.left < leftLimit) {
                rect.left = leftLimit;
            }
            if (rect.top < topLimit) {
                rect.top = topLimit;
            }
            if (rect.right > rightLimit) {
                rect.right = rightLimit;
            }
            if (rect.bottom > bottomLimit) {
                rect.bottom = bottomLimit;
            }
        }
        if (this.mFixAspectRatio && (double)Math.abs(rect.width() - rect.height() * this.mTargetAspectRatio) > 0.1) {
            if (rect.width() > rect.height() * this.mTargetAspectRatio) {
                adj = Math.abs(rect.height() * this.mTargetAspectRatio - rect.width()) / 2.0f;
                rect.left += adj;
                rect.right -= adj;
            } else {
                adj = Math.abs(rect.width() / this.mTargetAspectRatio - rect.height()) / 2.0f;
                rect.top += adj;
                rect.bottom -= adj;
            }
        }
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        this.drawBackground(canvas);
        if (this.mCropWindowHandler.showGuidelines()) {
            if (this.mGuidelines == CropImageView.Guidelines.ON) {
                this.drawGuidelines(canvas);
            } else if (this.mGuidelines == CropImageView.Guidelines.ON_TOUCH && this.mMoveHandler != null) {
                this.drawGuidelines(canvas);
            }
        }
        this.drawBorders(canvas);
        this.drawCorners(canvas);
    }

    private void drawBackground(Canvas canvas) {
        RectF rect = this.mCropWindowHandler.getRect();
        float left = Math.max(BitmapUtils.getRectLeft(this.mBoundsPoints), 0.0f);
        float top = Math.max(BitmapUtils.getRectTop(this.mBoundsPoints), 0.0f);
        float right = Math.min(BitmapUtils.getRectRight(this.mBoundsPoints), (float)this.getWidth());
        float bottom = Math.min(BitmapUtils.getRectBottom(this.mBoundsPoints), (float)this.getHeight());
        if (this.mCropShape == CropImageView.CropShape.RECTANGLE) {
            if (!this.isNonStraightAngleRotated() || Build.VERSION.SDK_INT <= 17) {
                canvas.drawRect(left, top, right, rect.top, this.mBackgroundPaint);
                canvas.drawRect(left, rect.bottom, right, bottom, this.mBackgroundPaint);
                canvas.drawRect(left, rect.top, rect.left, rect.bottom, this.mBackgroundPaint);
                canvas.drawRect(rect.right, rect.top, right, rect.bottom, this.mBackgroundPaint);
            } else {
                this.mPath.reset();
                this.mPath.moveTo(this.mBoundsPoints[0], this.mBoundsPoints[1]);
                this.mPath.lineTo(this.mBoundsPoints[2], this.mBoundsPoints[3]);
                this.mPath.lineTo(this.mBoundsPoints[4], this.mBoundsPoints[5]);
                this.mPath.lineTo(this.mBoundsPoints[6], this.mBoundsPoints[7]);
                this.mPath.close();
                canvas.save();
                canvas.clipPath(this.mPath, Region.Op.INTERSECT);
                canvas.clipRect(rect, Region.Op.XOR);
                canvas.drawRect(left, top, right, bottom, this.mBackgroundPaint);
                canvas.restore();
            }
        } else {
            this.mPath.reset();
            if (Build.VERSION.SDK_INT <= 17 && this.mCropShape == CropImageView.CropShape.OVAL) {
                this.mDrawRect.set(rect.left + 2.0f, rect.top + 2.0f, rect.right - 2.0f, rect.bottom - 2.0f);
            } else {
                this.mDrawRect.set(rect.left, rect.top, rect.right, rect.bottom);
            }
            this.mPath.addOval(this.mDrawRect, Path.Direction.CW);
            canvas.save();
            canvas.clipPath(this.mPath, Region.Op.XOR);
            canvas.drawRect(left, top, right, bottom, this.mBackgroundPaint);
            canvas.restore();
        }
    }

    private void drawGuidelines(Canvas canvas) {
        if (this.mGuidelinePaint != null) {
            float sw = this.mBorderPaint != null ? this.mBorderPaint.getStrokeWidth() : 0.0f;
            RectF rect = this.mCropWindowHandler.getRect();
            rect.inset(sw, sw);
            float oneThirdCropWidth = rect.width() / 3.0f;
            float oneThirdCropHeight = rect.height() / 3.0f;
            if (this.mCropShape == CropImageView.CropShape.OVAL) {
                float w = rect.width() / 2.0f - sw;
                float h = rect.height() / 2.0f - sw;
                float x1 = rect.left + oneThirdCropWidth;
                float x2 = rect.right - oneThirdCropWidth;
                float yv = (float)((double)h * Math.sin(Math.acos((w - oneThirdCropWidth) / w)));
                canvas.drawLine(x1, rect.top + h - yv, x1, rect.bottom - h + yv, this.mGuidelinePaint);
                canvas.drawLine(x2, rect.top + h - yv, x2, rect.bottom - h + yv, this.mGuidelinePaint);
                float y1 = rect.top + oneThirdCropHeight;
                float y2 = rect.bottom - oneThirdCropHeight;
                float xv = (float)((double)w * Math.cos(Math.asin((h - oneThirdCropHeight) / h)));
                canvas.drawLine(rect.left + w - xv, y1, rect.right - w + xv, y1, this.mGuidelinePaint);
                canvas.drawLine(rect.left + w - xv, y2, rect.right - w + xv, y2, this.mGuidelinePaint);
            } else {
                float x1 = rect.left + oneThirdCropWidth;
                float x2 = rect.right - oneThirdCropWidth;
                canvas.drawLine(x1, rect.top, x1, rect.bottom, this.mGuidelinePaint);
                canvas.drawLine(x2, rect.top, x2, rect.bottom, this.mGuidelinePaint);
                float y1 = rect.top + oneThirdCropHeight;
                float y2 = rect.bottom - oneThirdCropHeight;
                canvas.drawLine(rect.left, y1, rect.right, y1, this.mGuidelinePaint);
                canvas.drawLine(rect.left, y2, rect.right, y2, this.mGuidelinePaint);
            }
        }
    }

    private void drawBorders(Canvas canvas) {
        if (this.mBorderPaint != null) {
            float w = this.mBorderPaint.getStrokeWidth();
            RectF rect = this.mCropWindowHandler.getRect();
            rect.inset(w / 2.0f, w / 2.0f);
            if (this.mCropShape == CropImageView.CropShape.RECTANGLE) {
                canvas.drawRect(rect, this.mBorderPaint);
            } else {
                canvas.drawOval(rect, this.mBorderPaint);
            }
        }
    }

    private void drawCorners(Canvas canvas) {
        if (this.mBorderCornerPaint != null) {
            float lineWidth = this.mBorderPaint != null ? this.mBorderPaint.getStrokeWidth() : 0.0f;
            float cornerWidth = this.mBorderCornerPaint.getStrokeWidth();
            float w = cornerWidth / 2.0f + (this.mCropShape == CropImageView.CropShape.RECTANGLE ? this.mBorderCornerOffset : 0.0f);
            RectF rect = this.mCropWindowHandler.getRect();
            rect.inset(w, w);
            float cornerOffset = (cornerWidth - lineWidth) / 2.0f;
            float cornerExtension = cornerWidth / 2.0f + cornerOffset;
            canvas.drawLine(rect.left - cornerOffset, rect.top - cornerExtension, rect.left - cornerOffset, rect.top + this.mBorderCornerLength, this.mBorderCornerPaint);
            canvas.drawLine(rect.left - cornerExtension, rect.top - cornerOffset, rect.left + this.mBorderCornerLength, rect.top - cornerOffset, this.mBorderCornerPaint);
            canvas.drawLine(rect.right + cornerOffset, rect.top - cornerExtension, rect.right + cornerOffset, rect.top + this.mBorderCornerLength, this.mBorderCornerPaint);
            canvas.drawLine(rect.right + cornerExtension, rect.top - cornerOffset, rect.right - this.mBorderCornerLength, rect.top - cornerOffset, this.mBorderCornerPaint);
            canvas.drawLine(rect.left - cornerOffset, rect.bottom + cornerExtension, rect.left - cornerOffset, rect.bottom - this.mBorderCornerLength, this.mBorderCornerPaint);
            canvas.drawLine(rect.left - cornerExtension, rect.bottom + cornerOffset, rect.left + this.mBorderCornerLength, rect.bottom + cornerOffset, this.mBorderCornerPaint);
            canvas.drawLine(rect.right + cornerOffset, rect.bottom + cornerExtension, rect.right + cornerOffset, rect.bottom - this.mBorderCornerLength, this.mBorderCornerPaint);
            canvas.drawLine(rect.right + cornerExtension, rect.bottom + cornerOffset, rect.right - this.mBorderCornerLength, rect.bottom + cornerOffset, this.mBorderCornerPaint);
        }
    }

    private static Paint getNewPaint(int color) {
        Paint paint = new Paint();
        paint.setColor(color);
        return paint;
    }

    private static Paint getNewPaintOrNull(float thickness, int color) {
        if (thickness > 0.0f) {
            Paint borderPaint = new Paint();
            borderPaint.setColor(color);
            borderPaint.setStrokeWidth(thickness);
            borderPaint.setStyle(Paint.Style.STROKE);
            borderPaint.setAntiAlias(true);
            return borderPaint;
        }
        return null;
    }

    public boolean onTouchEvent(MotionEvent event) {
        if (this.isEnabled()) {
            if (this.mMultiTouchEnabled) {
                this.mScaleDetector.onTouchEvent(event);
            }
            switch (event.getAction()) {
                case 0: {
                    this.onActionDown(event.getX(), event.getY());
                    return true;
                }
                case 1: 
                case 3: {
                    this.getParent().requestDisallowInterceptTouchEvent(false);
                    this.onActionUp();
                    return true;
                }
                case 2: {
                    this.onActionMove(event.getX(), event.getY());
                    this.getParent().requestDisallowInterceptTouchEvent(true);
                    return true;
                }
            }
            return false;
        }
        return false;
    }

    private void onActionDown(float x, float y) {
        this.mMoveHandler = this.mCropWindowHandler.getMoveHandler(x, y, this.mTouchRadius, this.mCropShape);
        if (this.mMoveHandler != null) {
            this.invalidate();
        }
    }

    private void onActionUp() {
        if (this.mMoveHandler != null) {
            this.mMoveHandler = null;
            this.callOnCropWindowChanged(false);
            this.invalidate();
        }
    }

    private void onActionMove(float x, float y) {
        if (this.mMoveHandler != null) {
            float snapRadius = this.mSnapRadius;
            RectF rect = this.mCropWindowHandler.getRect();
            if (this.calculateBounds(rect)) {
                snapRadius = 0.0f;
            }
            this.mMoveHandler.move(rect, x, y, this.mCalcBounds, this.mViewWidth, this.mViewHeight, snapRadius, this.mFixAspectRatio, this.mTargetAspectRatio);
            this.mCropWindowHandler.setRect(rect);
            this.callOnCropWindowChanged(true);
            this.invalidate();
        }
    }

    private boolean calculateBounds(RectF rect) {
        float left = BitmapUtils.getRectLeft(this.mBoundsPoints);
        float top = BitmapUtils.getRectTop(this.mBoundsPoints);
        float right = BitmapUtils.getRectRight(this.mBoundsPoints);
        float bottom = BitmapUtils.getRectBottom(this.mBoundsPoints);
        if (!this.isNonStraightAngleRotated()) {
            this.mCalcBounds.set(left, top, right, bottom);
            return false;
        }
        float x0 = this.mBoundsPoints[0];
        float y0 = this.mBoundsPoints[1];
        float x2 = this.mBoundsPoints[4];
        float y2 = this.mBoundsPoints[5];
        float x3 = this.mBoundsPoints[6];
        float y3 = this.mBoundsPoints[7];
        if (this.mBoundsPoints[7] < this.mBoundsPoints[1]) {
            if (this.mBoundsPoints[1] < this.mBoundsPoints[3]) {
                x0 = this.mBoundsPoints[6];
                y0 = this.mBoundsPoints[7];
                x2 = this.mBoundsPoints[2];
                y2 = this.mBoundsPoints[3];
                x3 = this.mBoundsPoints[4];
                y3 = this.mBoundsPoints[5];
            } else {
                x0 = this.mBoundsPoints[4];
                y0 = this.mBoundsPoints[5];
                x2 = this.mBoundsPoints[0];
                y2 = this.mBoundsPoints[1];
                x3 = this.mBoundsPoints[2];
                y3 = this.mBoundsPoints[3];
            }
        } else if (this.mBoundsPoints[1] > this.mBoundsPoints[3]) {
            x0 = this.mBoundsPoints[2];
            y0 = this.mBoundsPoints[3];
            x2 = this.mBoundsPoints[6];
            y2 = this.mBoundsPoints[7];
            x3 = this.mBoundsPoints[0];
            y3 = this.mBoundsPoints[1];
        }
        float a0 = (y3 - y0) / (x3 - x0);
        float a1 = -1.0f / a0;
        float b0 = y0 - a0 * x0;
        float b1 = y0 - a1 * x0;
        float b2 = y2 - a0 * x2;
        float b3 = y2 - a1 * x2;
        float c0 = (rect.centerY() - rect.top) / (rect.centerX() - rect.left);
        float c1 = -c0;
        float d0 = rect.top - c0 * rect.left;
        float d1 = rect.top - c1 * rect.right;
        left = Math.max(left, (d0 - b0) / (a0 - c0) < rect.right ? (d0 - b0) / (a0 - c0) : left);
        left = Math.max(left, (d0 - b1) / (a1 - c0) < rect.right ? (d0 - b1) / (a1 - c0) : left);
        left = Math.max(left, (d1 - b3) / (a1 - c1) < rect.right ? (d1 - b3) / (a1 - c1) : left);
        right = Math.min(right, (d1 - b1) / (a1 - c1) > rect.left ? (d1 - b1) / (a1 - c1) : right);
        right = Math.min(right, (d1 - b2) / (a0 - c1) > rect.left ? (d1 - b2) / (a0 - c1) : right);
        right = Math.min(right, (d0 - b2) / (a0 - c0) > rect.left ? (d0 - b2) / (a0 - c0) : right);
        top = Math.max(top, Math.max(a0 * left + b0, a1 * right + b1));
        bottom = Math.min(bottom, Math.min(a1 * left + b3, a0 * right + b2));
        this.mCalcBounds.left = left;
        this.mCalcBounds.top = top;
        this.mCalcBounds.right = right;
        this.mCalcBounds.bottom = bottom;
        return true;
    }

    private boolean isNonStraightAngleRotated() {
        return this.mBoundsPoints[0] != this.mBoundsPoints[6] && this.mBoundsPoints[1] != this.mBoundsPoints[7];
    }

    private void callOnCropWindowChanged(boolean inProgress) {
        try {
            if (this.mCropWindowChangeListener != null) {
                this.mCropWindowChangeListener.onCropWindowChanged(inProgress);
            }
        }
        catch (Exception e) {
            Log.e((String)"AIC", (String)"Exception in crop window changed", (Throwable)e);
        }
    }

    private class ScaleListener
    extends ScaleGestureDetector.SimpleOnScaleGestureListener {
        private ScaleListener() {
        }

        @TargetApi(value=11)
        public boolean onScale(ScaleGestureDetector detector) {
            RectF rect = CropOverlayView.this.mCropWindowHandler.getRect();
            float x = detector.getFocusX();
            float y = detector.getFocusY();
            float dY = detector.getCurrentSpanY() / 2.0f;
            float dX = detector.getCurrentSpanX() / 2.0f;
            float newTop = y - dY;
            float newLeft = x - dX;
            float newRight = x + dX;
            float newBottom = y + dY;
            if (newLeft < newRight && newTop <= newBottom && newLeft >= 0.0f && newRight <= CropOverlayView.this.mCropWindowHandler.getMaxCropWidth() && newTop >= 0.0f && newBottom <= CropOverlayView.this.mCropWindowHandler.getMaxCropHeight()) {
                rect.set(newLeft, newTop, newRight, newBottom);
                CropOverlayView.this.mCropWindowHandler.setRect(rect);
                CropOverlayView.this.invalidate();
            }
            return true;
        }
    }

    public static interface CropWindowChangeListener {
        public void onCropWindowChanged(boolean var1);
    }
}

