/*
 * Decompiled with CFR 0.152.
 */
package com.passiondroid.imageeditorlib.views.imagezoom.utils;

import android.content.ContentProviderClient;
import android.content.Context;
import android.database.Cursor;
import android.media.ExifInterface;
import android.net.Uri;
import android.os.Bundle;
import java.io.IOException;

public class ExifUtils {
    public static final String[] EXIF_TAGS = new String[]{"FNumber", "DateTime", "ExposureTime", "Flash", "FocalLength", "GPSAltitude", "GPSAltitudeRef", "GPSDateStamp", "GPSLatitude", "GPSLatitudeRef", "GPSLongitude", "GPSLongitudeRef", "GPSProcessingMethod", "GPSTimeStamp", "ImageLength", "ImageWidth", "ISOSpeedRatings", "Make", "Model", "WhiteBalance"};

    public static int getExifOrientation(String filepath) {
        if (null == filepath) {
            return 0;
        }
        ExifInterface exif = null;
        try {
            exif = new ExifInterface(filepath);
        }
        catch (IOException e) {
            return 0;
        }
        return ExifUtils.getExifOrientation(exif);
    }

    public static int getExifOrientation(ExifInterface exif) {
        int orientation;
        int degree = 0;
        if (exif != null && (orientation = exif.getAttributeInt("Orientation", -1)) != -1) {
            switch (orientation) {
                case 6: {
                    degree = 90;
                    break;
                }
                case 3: {
                    degree = 180;
                    break;
                }
                case 8: {
                    degree = 270;
                }
            }
        }
        return degree;
    }

    public static boolean loadAttributes(String filepath, Bundle out) {
        ExifInterface e;
        try {
            e = new ExifInterface(filepath);
        }
        catch (IOException e1) {
            e1.printStackTrace();
            return false;
        }
        for (String tag : EXIF_TAGS) {
            out.putString(tag, e.getAttribute(tag));
        }
        return true;
    }

    public static boolean saveAttributes(String filepath, Bundle bundle) {
        ExifInterface exif;
        try {
            exif = new ExifInterface(filepath);
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
        for (String tag : EXIF_TAGS) {
            if (!bundle.containsKey(tag)) continue;
            exif.setAttribute(tag, bundle.getString(tag));
        }
        try {
            exif.saveAttributes();
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    public static String getExifOrientation(int orientation) {
        switch (orientation) {
            case 0: {
                return String.valueOf(1);
            }
            case 90: {
                return String.valueOf(6);
            }
            case 180: {
                return String.valueOf(3);
            }
            case 270: {
                return String.valueOf(8);
            }
        }
        throw new AssertionError((Object)("invalid: " + orientation));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getExifOrientation(Context context, Uri uri) {
        String scheme = uri.getScheme();
        ContentProviderClient provider = null;
        if (scheme == null || "file".equals(scheme)) {
            return ExifUtils.getExifOrientation(uri.getPath());
        }
        if (scheme.equals("content")) {
            try {
                provider = context.getContentResolver().acquireContentProviderClient(uri);
            }
            catch (SecurityException e) {
                return 0;
            }
            if (provider != null) {
                Cursor result;
                try {
                    result = provider.query(uri, new String[]{"orientation", "_data"}, null, null, null);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    return 0;
                }
                if (result == null) {
                    return 0;
                }
                int orientationColumnIndex = result.getColumnIndex("orientation");
                int dataColumnIndex = result.getColumnIndex("_data");
                try {
                    if (result.getCount() > 0) {
                        result.moveToFirst();
                        int rotation = 0;
                        if (orientationColumnIndex > -1) {
                            rotation = result.getInt(orientationColumnIndex);
                        }
                        if (dataColumnIndex > -1) {
                            String path = result.getString(dataColumnIndex);
                            rotation |= ExifUtils.getExifOrientation(path);
                        }
                        int n = rotation;
                        return n;
                    }
                }
                finally {
                    result.close();
                }
            }
        }
        return 0;
    }
}

