/*
 * Decompiled with CFR 0.152.
 */
package com.passiondroid.imageeditorlib.views.imagezoom;

import android.content.Context;
import android.graphics.Matrix;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.util.Log;
import android.view.GestureDetector;
import android.view.MotionEvent;
import android.view.ScaleGestureDetector;
import android.view.ViewConfiguration;
import com.passiondroid.imageeditorlib.views.imagezoom.ImageViewTouchBase;

public class ImageViewTouch
extends ImageViewTouchBase {
    static final float SCROLL_DELTA_THRESHOLD = 1.0f;
    protected ScaleGestureDetector mScaleDetector;
    protected GestureDetector mGestureDetector;
    protected int mTouchSlop;
    protected float mScaleFactor;
    protected int mDoubleTapDirection;
    protected GestureDetector.OnGestureListener mGestureListener;
    protected ScaleGestureDetector.OnScaleGestureListener mScaleListener;
    protected boolean mDoubleTapEnabled = true;
    protected boolean mScaleEnabled = true;
    protected boolean mScrollEnabled = true;
    private OnImageViewTouchDoubleTapListener mDoubleTapListener;
    private OnImageViewTouchSingleTapListener mSingleTapListener;
    private OnImageFlingListener mFlingListener;

    public ImageViewTouch(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    @Override
    protected void init() {
        super.init();
        this.mTouchSlop = ViewConfiguration.get((Context)this.getContext()).getScaledTouchSlop();
        this.mGestureListener = this.getGestureListener();
        this.mScaleListener = this.getScaleListener();
        this.mScaleDetector = new ScaleGestureDetector(this.getContext(), this.mScaleListener);
        this.mGestureDetector = new GestureDetector(this.getContext(), this.mGestureListener, null, true);
        this.mDoubleTapDirection = 1;
    }

    public void setDoubleTapListener(OnImageViewTouchDoubleTapListener listener) {
        this.mDoubleTapListener = listener;
    }

    public void setSingleTapListener(OnImageViewTouchSingleTapListener listener) {
        this.mSingleTapListener = listener;
    }

    public void setFlingListener(OnImageFlingListener listener) {
        this.mFlingListener = listener;
    }

    public void setDoubleTapEnabled(boolean value) {
        this.mDoubleTapEnabled = value;
    }

    public void setScaleEnabled(boolean value) {
        this.mScaleEnabled = value;
        this.setDoubleTapEnabled(value);
    }

    public void setScrollEnabled(boolean value) {
        this.mScrollEnabled = value;
    }

    public boolean getDoubleTapEnabled() {
        return this.mDoubleTapEnabled;
    }

    protected GestureDetector.OnGestureListener getGestureListener() {
        return new GestureListener();
    }

    protected ScaleGestureDetector.OnScaleGestureListener getScaleListener() {
        return new ScaleListener();
    }

    @Override
    protected void _setImageDrawable(Drawable drawable2, Matrix initial_matrix, float min_zoom, float max_zoom) {
        super._setImageDrawable(drawable2, initial_matrix, min_zoom, max_zoom);
        this.mScaleFactor = this.getMaxScale() / 3.0f;
    }

    public boolean onTouchEvent(MotionEvent event) {
        this.mScaleDetector.onTouchEvent(event);
        if (!this.mScaleDetector.isInProgress()) {
            this.mGestureDetector.onTouchEvent(event);
        }
        int action = event.getAction();
        switch (action & 0xFF) {
            case 1: {
                if (!(this.getScale() < this.getMinScale())) break;
                this.zoomTo(this.getMinScale(), 500.0f);
            }
        }
        return true;
    }

    @Override
    protected void onZoomAnimationCompleted(float scale) {
        if (scale < this.getMinScale()) {
            this.zoomTo(this.getMinScale(), 50.0f);
        }
    }

    protected float onDoubleTapPost(float scale, float maxZoom) {
        if (this.mDoubleTapDirection == 1) {
            if (scale + this.mScaleFactor * 2.0f <= maxZoom) {
                return scale + this.mScaleFactor;
            }
            this.mDoubleTapDirection = -1;
            return maxZoom;
        }
        this.mDoubleTapDirection = 1;
        return 1.0f;
    }

    public boolean onScroll(MotionEvent e1, MotionEvent e2, float distanceX, float distanceY) {
        if (!this.mScrollEnabled) {
            return false;
        }
        if (e1 == null || e2 == null) {
            return false;
        }
        if (e1.getPointerCount() > 1 || e2.getPointerCount() > 1) {
            return false;
        }
        if (this.mScaleDetector.isInProgress()) {
            return false;
        }
        if (this.getScale() == 1.0f) {
            return false;
        }
        this.mUserScaled = true;
        this.scrollBy(-distanceX, -distanceY);
        this.invalidate();
        return true;
    }

    public boolean onFling(MotionEvent e1, MotionEvent e2, float velocityX, float velocityY) {
        if (!this.mScrollEnabled) {
            return false;
        }
        if (this.mFlingListener != null) {
            this.mFlingListener.onFling(e1, e2, velocityX, velocityY);
        }
        if (e1.getPointerCount() > 1 || e2.getPointerCount() > 1) {
            return false;
        }
        if (this.mScaleDetector.isInProgress()) {
            return false;
        }
        if (this.getScale() == 1.0f) {
            return false;
        }
        float diffX = e2.getX() - e1.getX();
        float diffY = e2.getY() - e1.getY();
        if (Math.abs(velocityX) > 800.0f || Math.abs(velocityY) > 800.0f) {
            this.mUserScaled = true;
            this.scrollBy(diffX / 2.0f, diffY / 2.0f, 300.0);
            this.invalidate();
            return true;
        }
        return false;
    }

    public boolean canScroll(int direction) {
        RectF bitmapRect = this.getBitmapRect();
        this.updateRect(bitmapRect, this.mScrollRect);
        Rect imageViewRect = new Rect();
        this.getGlobalVisibleRect(imageViewRect);
        if (null == bitmapRect) {
            return false;
        }
        if (bitmapRect.right >= (float)imageViewRect.right && direction < 0) {
            return Math.abs(bitmapRect.right - (float)imageViewRect.right) > 1.0f;
        }
        double bitmapScrollRectDelta = Math.abs(bitmapRect.left - this.mScrollRect.left);
        return bitmapScrollRectDelta > 1.0;
    }

    public void resetImage() {
        float scale;
        float targetScale = scale = this.getScale();
        targetScale = Math.min(this.getMaxScale(), Math.max(targetScale, this.getMinScale()));
        this.zoomTo(targetScale, 0.0f, 0.0f, 200.0f);
        this.invalidate();
    }

    public static interface OnImageFlingListener {
        public void onFling(MotionEvent var1, MotionEvent var2, float var3, float var4);
    }

    public static interface OnImageViewTouchSingleTapListener {
        public void onSingleTapConfirmed();
    }

    public static interface OnImageViewTouchDoubleTapListener {
        public void onDoubleTap();
    }

    public class ScaleListener
    extends ScaleGestureDetector.SimpleOnScaleGestureListener {
        protected boolean mScaled = false;

        public boolean onScale(ScaleGestureDetector detector) {
            float span = detector.getCurrentSpan() - detector.getPreviousSpan();
            float targetScale = ImageViewTouch.this.getScale() * detector.getScaleFactor();
            if (ImageViewTouch.this.mScaleEnabled) {
                if (this.mScaled && span != 0.0f) {
                    ImageViewTouch.this.mUserScaled = true;
                    targetScale = Math.min(ImageViewTouch.this.getMaxScale(), Math.max(targetScale, ImageViewTouch.this.getMinScale() - 0.1f));
                    ImageViewTouch.this.zoomTo(targetScale, detector.getFocusX(), detector.getFocusY());
                    ImageViewTouch.this.mDoubleTapDirection = 1;
                    ImageViewTouch.this.invalidate();
                    return true;
                }
                if (!this.mScaled) {
                    this.mScaled = true;
                }
            }
            return true;
        }
    }

    public class GestureListener
    extends GestureDetector.SimpleOnGestureListener {
        public boolean onSingleTapConfirmed(MotionEvent e) {
            if (null != ImageViewTouch.this.mSingleTapListener) {
                ImageViewTouch.this.mSingleTapListener.onSingleTapConfirmed();
            }
            return super.onSingleTapConfirmed(e);
        }

        public boolean onDoubleTap(MotionEvent e) {
            Log.i((String)"ImageViewTouchBase", (String)("onDoubleTap. double tap enabled? " + ImageViewTouch.this.mDoubleTapEnabled));
            if (ImageViewTouch.this.mDoubleTapEnabled) {
                float scale;
                ImageViewTouch.this.mUserScaled = true;
                float targetScale = scale = ImageViewTouch.this.getScale();
                targetScale = ImageViewTouch.this.onDoubleTapPost(scale, ImageViewTouch.this.getMaxScale());
                targetScale = Math.min(ImageViewTouch.this.getMaxScale(), Math.max(targetScale, ImageViewTouch.this.getMinScale()));
                ImageViewTouch.this.zoomTo(targetScale, e.getX(), e.getY(), 200.0f);
                ImageViewTouch.this.invalidate();
            }
            if (null != ImageViewTouch.this.mDoubleTapListener) {
                ImageViewTouch.this.mDoubleTapListener.onDoubleTap();
            }
            return super.onDoubleTap(e);
        }

        public void onLongPress(MotionEvent e) {
            if (ImageViewTouch.this.isLongClickable() && !ImageViewTouch.this.mScaleDetector.isInProgress()) {
                ImageViewTouch.this.setPressed(true);
                ImageViewTouch.this.performLongClick();
            }
        }

        public boolean onScroll(MotionEvent e1, MotionEvent e2, float distanceX, float distanceY) {
            return ImageViewTouch.this.onScroll(e1, e2, distanceX, distanceY);
        }

        public boolean onFling(MotionEvent e1, MotionEvent e2, float velocityX, float velocityY) {
            return ImageViewTouch.this.onFling(e1, e2, velocityX, velocityY);
        }
    }
}

