/*
 * Decompiled with CFR 0.152.
 */
package com.master.permissionhelper;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageInfo;
import android.net.Uri;
import android.util.Log;
import androidx.annotation.NonNull;
import androidx.core.app.ActivityCompat;
import androidx.core.content.ContextCompat;
import androidx.fragment.app.Fragment;
import java.util.ArrayList;

class PermissionHelperJava {
    private static final String TAG = "PermissionHelperJava";
    private static int REQUEST_CODE;
    private Activity activity;
    private Fragment fragment;
    private String[] permissions;
    private PermissionCallback mPermissionCallback;
    private boolean showRational;

    private PermissionHelperJava(Activity activity, Fragment fragment, String[] permissions, int requestCode) {
        this.activity = activity;
        this.fragment = fragment;
        this.permissions = permissions;
        REQUEST_CODE = requestCode;
        this.checkIfPermissionPresentInAndroidManifest();
    }

    public PermissionHelperJava(Activity activity, String[] permissions, int requestCode) {
        this.activity = activity;
        this.permissions = permissions;
        REQUEST_CODE = requestCode;
        this.checkIfPermissionPresentInAndroidManifest();
    }

    public PermissionHelperJava(Fragment fragment, String[] permissions, int requestCode) {
        this.fragment = fragment;
        this.permissions = permissions;
        REQUEST_CODE = requestCode;
        this.checkIfPermissionPresentInAndroidManifest();
    }

    private void checkIfPermissionPresentInAndroidManifest() {
        for (String permission : this.permissions) {
            if (this.hasPermissionInManifest(permission)) continue;
            throw new RuntimeException("Permission (" + permission + ") Not Declared in manifest");
        }
    }

    public void request(PermissionCallback permissionCallback) {
        this.mPermissionCallback = permissionCallback;
        if (!this.checkSelfPermission(this.permissions)) {
            this.showRational = this.shouldShowRational(this.permissions);
            if (this.activity != null) {
                ActivityCompat.requestPermissions((Activity)this.activity, (String[])this.filterNotGrantedPermission(this.permissions), (int)REQUEST_CODE);
            } else {
                this.fragment.requestPermissions(this.filterNotGrantedPermission(this.permissions), REQUEST_CODE);
            }
        } else {
            Log.i((String)TAG, (String)"PERMISSION: Permission Granted");
            if (this.mPermissionCallback != null) {
                this.mPermissionCallback.onPermissionGranted();
            }
        }
    }

    public void onRequestPermissionsResult(int requestCode, @NonNull String[] permissions, @NonNull int[] grantResults) {
        if (requestCode == REQUEST_CODE) {
            boolean denied = false;
            int i = 0;
            ArrayList<String> grantedPermissions = new ArrayList<String>();
            for (int grantResult : grantResults) {
                if (grantResult != 0) {
                    denied = true;
                } else {
                    grantedPermissions.add(permissions[i]);
                }
                ++i;
            }
            if (denied) {
                boolean currentShowRational = this.shouldShowRational(permissions);
                if (!this.showRational && !currentShowRational) {
                    Log.d((String)TAG, (String)"PERMISSION: Permission Denied By System");
                    if (this.mPermissionCallback != null) {
                        this.mPermissionCallback.onPermissionDeniedBySystem();
                    }
                } else {
                    Log.i((String)TAG, (String)"PERMISSION: Permission Denied");
                    if (!grantedPermissions.isEmpty() && this.mPermissionCallback != null) {
                        this.mPermissionCallback.onIndividualPermissionGranted(grantedPermissions.toArray(new String[grantedPermissions.size()]));
                    }
                    if (this.mPermissionCallback != null) {
                        this.mPermissionCallback.onPermissionDenied();
                    }
                }
            } else {
                Log.i((String)TAG, (String)"PERMISSION: Permission Granted");
                if (this.mPermissionCallback != null) {
                    this.mPermissionCallback.onPermissionGranted();
                }
            }
        }
    }

    private <T extends Context> T getContext() {
        if (this.activity != null) {
            return (T)this.activity;
        }
        return (T)this.fragment.getContext();
    }

    private String[] filterNotGrantedPermission(String[] permissions) {
        ArrayList<String> notGrantedPermission = new ArrayList<String>();
        for (String permission : permissions) {
            if (ContextCompat.checkSelfPermission(this.getContext(), (String)permission) == 0) continue;
            notGrantedPermission.add(permission);
        }
        return notGrantedPermission.toArray(new String[notGrantedPermission.size()]);
    }

    public boolean checkSelfPermission(String[] permissions) {
        for (String permission : permissions) {
            if (ContextCompat.checkSelfPermission(this.getContext(), (String)permission) == 0) continue;
            return false;
        }
        return true;
    }

    private boolean shouldShowRational(String[] permissions) {
        boolean currentShowRational = false;
        for (String permission : permissions) {
            if (this.activity != null) {
                if (!ActivityCompat.shouldShowRequestPermissionRationale((Activity)this.activity, (String)permission)) continue;
                currentShowRational = true;
                break;
            }
            if (!this.fragment.shouldShowRequestPermissionRationale(permission)) continue;
            currentShowRational = true;
            break;
        }
        return currentShowRational;
    }

    private boolean hasPermissionInManifest(String permission) {
        try {
            Activity context = this.activity != null ? this.activity : this.fragment.getActivity();
            PackageInfo info = context.getPackageManager().getPackageInfo(context.getPackageName(), 4096);
            if (info.requestedPermissions != null) {
                for (String p : info.requestedPermissions) {
                    if (!p.equals(permission)) continue;
                    return true;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }

    public void openAppDetailsActivity() {
        if (this.getContext() == null) {
            return;
        }
        Intent i = new Intent();
        i.setAction("android.settings.APPLICATION_DETAILS_SETTINGS");
        i.addCategory("android.intent.category.DEFAULT");
        i.setData(Uri.parse((String)("package:" + this.getContext().getPackageName())));
        i.addFlags(0x10000000);
        i.addFlags(0x40000000);
        i.addFlags(0x800000);
        this.getContext().startActivity(i);
    }

    public static interface PermissionCallback {
        public void onPermissionGranted();

        public void onIndividualPermissionGranted(String[] var1);

        public void onPermissionDenied();

        public void onPermissionDeniedBySystem();
    }
}

