/*
 * Decompiled with CFR 0.152.
 */
package panda.roid.location;

import android.location.Location;
import panda.lang.Strings;

public class LocationChecker {
    private static final int TWO_MINUTES = 120000;
    private Location current;

    public boolean isFineLocation(Location location) {
        if (LocationChecker.isBetterLocation(this.current, location)) {
            this.current = location;
            return true;
        }
        return false;
    }

    public static boolean isBetterLocation(Location current, Location location) {
        boolean isNewer;
        if (current == null) {
            return true;
        }
        long timeDelta = location.getTime() - current.getTime();
        boolean isSignificantlyNewer = timeDelta > 120000L;
        boolean isSignificantlyOlder = timeDelta < -120000L;
        boolean bl = isNewer = timeDelta > 0L;
        if (isSignificantlyNewer) {
            return true;
        }
        if (isSignificantlyOlder) {
            return false;
        }
        int accuracyDelta = (int)(location.getAccuracy() - current.getAccuracy());
        boolean isLessAccurate = accuracyDelta > 0;
        boolean isMoreAccurate = accuracyDelta < 0;
        boolean isSignificantlyLessAccurate = accuracyDelta > 200;
        boolean isFromSameProvider = Strings.equals((CharSequence)location.getProvider(), (CharSequence)current.getProvider());
        if (isMoreAccurate) {
            return true;
        }
        if (isNewer && !isLessAccurate) {
            return true;
        }
        return isNewer && !isSignificantlyLessAccurate && isFromSameProvider;
    }
}

