/*
 * Decompiled with CFR 0.152.
 */
package dreamers.graphics;

import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.Rect;
import android.view.animation.Interpolator;
import android.view.animation.LinearInterpolator;
import com.nineoldandroids.animation.Animator;
import com.nineoldandroids.animation.AnimatorListenerAdapter;
import com.nineoldandroids.animation.ObjectAnimator;
import dreamers.graphics.Ripple;
import dreamers.graphics.RippleDrawable;

class RippleBackground {
    private static final Interpolator LINEAR_INTERPOLATOR = new LinearInterpolator();
    private static final float GLOBAL_SPEED = 1.0f;
    private static final float WAVE_OPACITY_DECAY_VELOCITY = 3.0f;
    private static final float WAVE_OUTER_OPACITY_EXIT_VELOCITY_MAX = 4.5f;
    private static final float WAVE_OUTER_OPACITY_EXIT_VELOCITY_MIN = 1.5f;
    private static final float WAVE_OUTER_OPACITY_ENTER_VELOCITY = 10.0f;
    private static final float WAVE_OUTER_SIZE_INFLUENCE_MAX = 200.0f;
    private static final float WAVE_OUTER_SIZE_INFLUENCE_MIN = 40.0f;
    private final RippleDrawable mOwner;
    private final Rect mBounds;
    private int mColorOpaque;
    private int mColorAlpha;
    private float mOuterRadius;
    private float mDensity;
    private ObjectAnimator mAnimOuterOpacity;
    private Paint mTempPaint;
    private float mOuterOpacity = 0.0f;
    private float mOuterX;
    private float mOuterY;
    private boolean mHardwareAnimating;
    private boolean mCanUseHardware;
    private boolean mHasMaxRadius;
    private final AnimatorListenerAdapter mAnimationListener = new AnimatorListenerAdapter(){

        @Override
        public void onAnimationEnd(Animator animation) {
            RippleBackground.this.mHardwareAnimating = false;
        }
    };

    public RippleBackground(RippleDrawable owner, Rect bounds) {
        this.mOwner = owner;
        this.mBounds = bounds;
    }

    public void setup(int maxRadius, int color, float density) {
        this.mColorOpaque = color | 0xFF000000;
        this.mColorAlpha = Color.alpha((int)color) / 2;
        if (maxRadius != -1) {
            this.mHasMaxRadius = true;
            this.mOuterRadius = maxRadius;
        } else {
            float halfWidth = (float)this.mBounds.width() / 2.0f;
            float halfHeight = (float)this.mBounds.height() / 2.0f;
            this.mOuterRadius = (float)Math.sqrt(halfWidth * halfWidth + halfHeight * halfHeight);
        }
        this.mOuterX = 0.0f;
        this.mOuterY = 0.0f;
        this.mDensity = density;
    }

    public boolean isHardwareAnimating() {
        return this.mHardwareAnimating;
    }

    public void onHotspotBoundsChanged() {
        if (!this.mHasMaxRadius) {
            float halfWidth = (float)this.mBounds.width() / 2.0f;
            float halfHeight = (float)this.mBounds.height() / 2.0f;
            this.mOuterRadius = (float)Math.sqrt(halfWidth * halfWidth + halfHeight * halfHeight);
        }
    }

    public void setOuterOpacity(float a) {
        this.mOuterOpacity = a;
        this.invalidateSelf();
    }

    public float getOuterOpacity() {
        return this.mOuterOpacity;
    }

    public boolean draw(Canvas c, Paint p) {
        return this.drawSoftware(c, p);
    }

    public boolean shouldDraw() {
        int outerAlpha = (int)((float)this.mColorAlpha * this.mOuterOpacity + 0.5f);
        return this.mCanUseHardware && this.mHardwareAnimating || outerAlpha > 0 && this.mOuterRadius > 0.0f;
    }

    private boolean drawSoftware(Canvas c, Paint p) {
        boolean hasContent = false;
        p.setColor(this.mColorOpaque);
        int outerAlpha = (int)((float)this.mColorAlpha * this.mOuterOpacity + 0.5f);
        if (outerAlpha > 0 && this.mOuterRadius > 0.0f) {
            p.setAlpha(outerAlpha);
            p.setStyle(Paint.Style.FILL);
            c.drawCircle(this.mOuterX, this.mOuterY, this.mOuterRadius, p);
            hasContent = true;
        }
        return hasContent;
    }

    public void getBounds(Rect bounds) {
        int outerX = (int)this.mOuterX;
        int outerY = (int)this.mOuterY;
        int r = (int)this.mOuterRadius + 1;
        bounds.set(outerX - r, outerY - r, outerX + r, outerY + r);
    }

    public void enter() {
        this.cancel();
        int outerDuration = 100;
        ObjectAnimator outer = ObjectAnimator.ofFloat(this, "outerOpacity", 0.0f, 1.0f);
        outer.setAutoCancel(true);
        outer.setDuration(100L);
        outer.setInterpolator(LINEAR_INTERPOLATOR);
        this.mAnimOuterOpacity = outer;
        outer.start();
    }

    public void exit() {
        this.cancel();
        int opacityDuration = 333;
        float outerSizeInfluence = RippleBackground.constrain((this.mOuterRadius - 40.0f * this.mDensity) / (200.0f * this.mDensity), 0.0f, 1.0f);
        float outerOpacityVelocity = Ripple.lerp(1.5f, 4.5f, outerSizeInfluence);
        int inflectionDuration = Math.max(0, (int)(1000.0f * (1.0f - this.mOuterOpacity) / (3.0f + outerOpacityVelocity) + 0.5f));
        int inflectionOpacity = (int)((float)this.mColorAlpha * (this.mOuterOpacity + (float)inflectionDuration * outerOpacityVelocity * outerSizeInfluence / 1000.0f) + 0.5f);
        this.exitSoftware(333, inflectionDuration, inflectionOpacity);
    }

    public static float constrain(float amount, float low, float high) {
        return amount < low ? low : (amount > high ? high : amount);
    }

    public void jump() {
        this.endSoftwareAnimations();
    }

    private void endSoftwareAnimations() {
        if (this.mAnimOuterOpacity != null) {
            this.mAnimOuterOpacity.end();
            this.mAnimOuterOpacity = null;
        }
    }

    private Paint getTempPaint() {
        if (this.mTempPaint == null) {
            this.mTempPaint = new Paint();
        }
        return this.mTempPaint;
    }

    private void exitSoftware(int opacityDuration, int inflectionDuration, int inflectionOpacity) {
        ObjectAnimator outerOpacityAnim;
        if (inflectionDuration > 0) {
            outerOpacityAnim = ObjectAnimator.ofFloat(this, "outerOpacity", (float)inflectionOpacity / 255.0f);
            outerOpacityAnim.setAutoCancel(true);
            outerOpacityAnim.setDuration(inflectionDuration);
            outerOpacityAnim.setInterpolator(LINEAR_INTERPOLATOR);
            final int outerDuration = opacityDuration - inflectionDuration;
            if (outerDuration > 0) {
                outerOpacityAnim.addListener(new AnimatorListenerAdapter(){

                    @Override
                    public void onAnimationEnd(Animator animation) {
                        ObjectAnimator outerFadeOutAnim = ObjectAnimator.ofFloat(RippleBackground.this, "outerOpacity", 0.0f);
                        outerFadeOutAnim.setAutoCancel(true);
                        outerFadeOutAnim.setDuration(outerDuration);
                        outerFadeOutAnim.setInterpolator(LINEAR_INTERPOLATOR);
                        outerFadeOutAnim.addListener(RippleBackground.this.mAnimationListener);
                        RippleBackground.this.mAnimOuterOpacity = outerFadeOutAnim;
                        outerFadeOutAnim.start();
                    }

                    @Override
                    public void onAnimationCancel(Animator animation) {
                        animation.removeListener(this);
                    }
                });
            } else {
                outerOpacityAnim.addListener(this.mAnimationListener);
            }
        } else {
            outerOpacityAnim = ObjectAnimator.ofFloat(this, "outerOpacity", 0.0f);
            outerOpacityAnim.setAutoCancel(true);
            outerOpacityAnim.setDuration(opacityDuration);
            outerOpacityAnim.addListener(this.mAnimationListener);
        }
        this.mAnimOuterOpacity = outerOpacityAnim;
        outerOpacityAnim.start();
    }

    public void cancel() {
        this.cancelSoftwareAnimations();
    }

    private void cancelSoftwareAnimations() {
        if (this.mAnimOuterOpacity != null) {
            this.mAnimOuterOpacity.cancel();
            this.mAnimOuterOpacity = null;
        }
    }

    private void invalidateSelf() {
        this.mOwner.invalidateSelf();
    }
}

