/*
 * Decompiled with CFR 0.152.
 */
package io.codetail.animation;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.ObjectAnimator;
import android.annotation.TargetApi;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.Region;
import android.util.Property;
import android.view.View;
import java.util.HashMap;
import java.util.Map;

public class ViewRevealManager {
    public static final ClipRadiusProperty REVEAL = new ClipRadiusProperty();
    private Map<View, RevealValues> targets = new HashMap<View, RevealValues>();

    protected ObjectAnimator createAnimator(RevealValues data) {
        ObjectAnimator animator = ObjectAnimator.ofFloat((Object)data, (Property)REVEAL, (float[])new float[]{data.startRadius, data.endRadius});
        animator.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationStart(Animator animation) {
                RevealValues values = ViewRevealManager.getValues(animation);
                values.clip(true);
            }

            public void onAnimationEnd(Animator animation) {
                RevealValues values = ViewRevealManager.getValues(animation);
                values.clip(false);
                ViewRevealManager.this.targets.remove(values.target());
            }
        });
        this.targets.put(data.target(), data);
        return animator;
    }

    private static RevealValues getValues(Animator animator) {
        return (RevealValues)((ObjectAnimator)animator).getTarget();
    }

    public final Map<View, RevealValues> getTargets() {
        return this.targets;
    }

    protected boolean hasCustomerRevealAnimator() {
        return true;
    }

    public boolean isClipped(View child) {
        RevealValues data = this.targets.get(child);
        return data != null && data.isClipping();
    }

    public boolean transform(Canvas canvas, View child) {
        RevealValues revealData = this.targets.get(child);
        return revealData != null && revealData.applyTransformation(canvas, child);
    }

    static class ChangeViewLayerTypeAdapter
    extends AnimatorListenerAdapter {
        private RevealValues viewData;
        private int featuredLayerType;
        private int originalLayerType;

        ChangeViewLayerTypeAdapter(RevealValues viewData, int layerType) {
            this.viewData = viewData;
            this.featuredLayerType = layerType;
            this.originalLayerType = viewData.target.getLayerType();
        }

        public void onAnimationStart(Animator animation) {
            this.viewData.target().setLayerType(this.featuredLayerType, null);
        }

        public void onAnimationCancel(Animator animation) {
            this.viewData.target().setLayerType(this.originalLayerType, null);
        }

        public void onAnimationEnd(Animator animation) {
            this.viewData.target().setLayerType(this.originalLayerType, null);
        }
    }

    private static final class ClipRadiusProperty
    extends Property<RevealValues, Float> {
        ClipRadiusProperty() {
            super(Float.class, "supportCircularReveal");
        }

        public void set(RevealValues data, Float value) {
            data.radius(value.floatValue());
            data.target().invalidate();
        }

        public Float get(RevealValues v) {
            return Float.valueOf(v.radius());
        }
    }

    @TargetApi(value=21)
    public static final class RevealValues {
        private static final Paint debugPaint = new Paint(1);
        final int centerX;
        final int centerY;
        final float startRadius;
        final float endRadius;
        boolean clipping;
        float radius;
        View target;
        Path path = new Path();
        Region.Op op = Region.Op.REPLACE;

        public RevealValues(View target, int centerX, int centerY, float startRadius, float endRadius) {
            this.target = target;
            this.centerX = centerX;
            this.centerY = centerY;
            this.startRadius = startRadius;
            this.endRadius = endRadius;
        }

        public void radius(float radius) {
            this.radius = radius;
        }

        public float radius() {
            return this.radius;
        }

        public View target() {
            return this.target;
        }

        public void clip(boolean clipping) {
            this.clipping = clipping;
        }

        public boolean isClipping() {
            return this.clipping;
        }

        public Region.Op op() {
            return this.op;
        }

        public void op(Region.Op op) {
            this.op = op;
        }

        boolean applyTransformation(Canvas canvas, View child) {
            if (child != this.target || !this.clipping) {
                return false;
            }
            this.path.reset();
            this.path.addCircle(child.getX() + (float)this.centerX, child.getY() + (float)this.centerY, this.radius, Path.Direction.CW);
            child.invalidateOutline();
            canvas.clipPath(this.path, this.op);
            return true;
        }

        static {
            debugPaint.setColor(-16711936);
            debugPaint.setStyle(Paint.Style.FILL);
            debugPaint.setStrokeWidth(2.0f);
        }
    }
}

