/*
 * Decompiled with CFR 0.152.
 */
package io.codetail.animation;

import android.animation.Animator;
import android.animation.ObjectAnimator;
import android.os.Build;
import android.view.View;
import io.codetail.animation.RevealViewGroup;
import io.codetail.animation.ViewRevealManager;

public final class ViewAnimationUtils {
    private static final boolean DEBUG = false;
    private static final boolean LOLLIPOP_PLUS = Build.VERSION.SDK_INT >= 21;

    public static Animator createCircularReveal(View view, int centerX, int centerY, float startRadius, float endRadius) {
        return ViewAnimationUtils.createCircularReveal(view, centerX, centerY, startRadius, endRadius, 1);
    }

    public static Animator createCircularReveal(View view, int centerX, int centerY, float startRadius, float endRadius, int layerType) {
        if (!(view.getParent() instanceof RevealViewGroup)) {
            throw new IllegalArgumentException("Parent must be instance of RevealViewGroup");
        }
        RevealViewGroup viewGroup = (RevealViewGroup)view.getParent();
        ViewRevealManager rm = viewGroup.getViewRevealManager();
        if (!rm.hasCustomerRevealAnimator() && LOLLIPOP_PLUS) {
            return android.view.ViewAnimationUtils.createCircularReveal((View)view, (int)centerX, (int)centerY, (float)startRadius, (float)endRadius);
        }
        ViewRevealManager.RevealValues viewData = new ViewRevealManager.RevealValues(view, centerX, centerY, startRadius, endRadius);
        ObjectAnimator animator = rm.createAnimator(viewData);
        if (layerType != view.getLayerType()) {
            animator.addListener((Animator.AnimatorListener)new ViewRevealManager.ChangeViewLayerTypeAdapter(viewData, layerType));
        }
        return animator;
    }
}

