/*
 * Decompiled with CFR 0.152.
 */
package io.codetail.animation;

import android.animation.Animator;
import android.animation.ObjectAnimator;
import android.animation.TimeInterpolator;
import android.annotation.TargetApi;
import android.os.Build;
import android.util.Property;
import android.view.View;
import android.view.animation.AccelerateDecelerateInterpolator;
import io.codetail.animation.RevealAnimator;
import io.codetail.animation.SupportAnimator;
import io.codetail.animation.SupportAnimatorImpl;
import java.lang.ref.WeakReference;

public class ViewAnimationUtils {
    private static final boolean LOLLIPOP_PLUS = Build.VERSION.SDK_INT >= 21;
    public static final int SCALE_UP_DURATION = 500;

    @TargetApi(value=21)
    public static SupportAnimator createCircularReveal(View view, int centerX, int centerY, float startRadius, float endRadius) {
        return ViewAnimationUtils.createCircularReveal(view, centerX, centerY, startRadius, endRadius, 1);
    }

    @TargetApi(value=21)
    public static SupportAnimator createCircularReveal(View view, int centerX, int centerY, float startRadius, float endRadius, int layerType) {
        if (!(view.getParent() instanceof RevealAnimator)) {
            throw new IllegalArgumentException("View must be inside RevealFrameLayout or RevealLinearLayout.");
        }
        RevealAnimator revealLayout = (RevealAnimator)view.getParent();
        revealLayout.attachRevealInfo(new RevealAnimator.RevealInfo(centerX, centerY, startRadius, endRadius, new WeakReference<View>(view)));
        if (LOLLIPOP_PLUS) {
            return new SupportAnimatorImpl(android.view.ViewAnimationUtils.createCircularReveal((View)view, (int)centerX, (int)centerY, (float)startRadius, (float)endRadius), revealLayout);
        }
        ObjectAnimator reveal = ObjectAnimator.ofFloat((Object)revealLayout, (Property)RevealAnimator.CLIP_RADIUS, (float[])new float[]{startRadius, endRadius});
        reveal.addListener((Animator.AnimatorListener)new RevealAnimator.RevealFinishedIceCreamSandwich(revealLayout, layerType));
        return new SupportAnimatorImpl((Animator)reveal, revealLayout);
    }

    @Deprecated
    public static void liftingFromBottom(View view, float baseRotation, float fromY, int duration, int startDelay) {
        view.setRotationX(baseRotation);
        view.setTranslationY(fromY);
        view.animate().setInterpolator((TimeInterpolator)new AccelerateDecelerateInterpolator()).setDuration((long)duration).setStartDelay((long)startDelay).rotationX(0.0f).translationY(0.0f).start();
    }

    @Deprecated
    public static void liftingFromBottom(View view, float baseRotation, int duration, int startDelay) {
        view.setRotationX(baseRotation);
        view.setTranslationY((float)(view.getHeight() / 3));
        view.animate().setInterpolator((TimeInterpolator)new AccelerateDecelerateInterpolator()).setDuration((long)duration).setStartDelay((long)startDelay).rotationX(0.0f).translationY(0.0f).start();
    }

    @Deprecated
    public static void liftingFromBottom(View view, float baseRotation, int duration) {
        view.setRotationX(baseRotation);
        view.setTranslationY((float)(view.getHeight() / 3));
        view.animate().setInterpolator((TimeInterpolator)new AccelerateDecelerateInterpolator()).setDuration((long)duration).rotationX(0.0f).translationY(0.0f).start();
    }
}

