/*
 * Decompiled with CFR 0.152.
 */
package io.codetail.animation;

import android.annotation.TargetApi;
import android.os.Build;
import android.view.View;
import android.view.animation.AccelerateDecelerateInterpolator;
import android.view.animation.Interpolator;
import com.nineoldandroids.animation.Animator;
import com.nineoldandroids.animation.ObjectAnimator;
import com.nineoldandroids.util.Property;
import com.nineoldandroids.view.ViewHelper;
import com.nineoldandroids.view.ViewPropertyAnimator;
import io.codetail.animation.RevealAnimator;
import io.codetail.animation.SupportAnimator;
import io.codetail.animation.SupportAnimatorLollipop;
import io.codetail.animation.SupportAnimatorPreL;
import java.lang.ref.WeakReference;

public class ViewAnimationUtils {
    private static final boolean LOLLIPOP_PLUS = Build.VERSION.SDK_INT >= 21;
    public static final int SCALE_UP_DURATION = 500;

    @TargetApi(value=21)
    public static SupportAnimator createCircularReveal(View view, int centerX, int centerY, float startRadius, float endRadius) {
        if (!(view.getParent() instanceof RevealAnimator)) {
            throw new IllegalArgumentException("View must be inside RevealFrameLayout or RevealLinearLayout.");
        }
        RevealAnimator revealLayout = (RevealAnimator)view.getParent();
        revealLayout.attachRevealInfo(new RevealAnimator.RevealInfo(centerX, centerY, startRadius, endRadius, new WeakReference<View>(view)));
        if (LOLLIPOP_PLUS) {
            return new SupportAnimatorLollipop(android.view.ViewAnimationUtils.createCircularReveal((View)view, (int)centerX, (int)centerY, (float)startRadius, (float)endRadius), revealLayout);
        }
        ObjectAnimator reveal = ObjectAnimator.ofFloat((Object)revealLayout, (Property)RevealAnimator.CLIP_RADIUS, (float[])new float[]{startRadius, endRadius});
        reveal.addListener(ViewAnimationUtils.getRevealFinishListener(revealLayout));
        return new SupportAnimatorPreL((Animator)reveal, revealLayout);
    }

    private static Animator.AnimatorListener getRevealFinishListener(RevealAnimator target) {
        if (Build.VERSION.SDK_INT >= 18) {
            return new RevealAnimator.RevealFinishedJellyBeanMr2(target);
        }
        if (Build.VERSION.SDK_INT >= 14) {
            return new RevealAnimator.RevealFinishedIceCreamSandwich(target);
        }
        return new RevealAnimator.RevealFinishedGingerbread(target);
    }

    @Deprecated
    public static void liftingFromBottom(View view, float baseRotation, float fromY, int duration, int startDelay) {
        ViewHelper.setRotationX((View)view, (float)baseRotation);
        ViewHelper.setTranslationY((View)view, (float)fromY);
        ViewPropertyAnimator.animate((View)view).setInterpolator((Interpolator)new AccelerateDecelerateInterpolator()).setDuration((long)duration).setStartDelay((long)startDelay).rotationX(0.0f).translationY(0.0f).start();
    }

    @Deprecated
    public static void liftingFromBottom(View view, float baseRotation, int duration, int startDelay) {
        ViewHelper.setRotationX((View)view, (float)baseRotation);
        ViewHelper.setTranslationY((View)view, (float)(view.getHeight() / 3));
        ViewPropertyAnimator.animate((View)view).setInterpolator((Interpolator)new AccelerateDecelerateInterpolator()).setDuration((long)duration).setStartDelay((long)startDelay).rotationX(0.0f).translationY(0.0f).start();
    }

    @Deprecated
    public static void liftingFromBottom(View view, float baseRotation, int duration) {
        ViewHelper.setRotationX((View)view, (float)baseRotation);
        ViewHelper.setTranslationY((View)view, (float)(view.getHeight() / 3));
        ViewPropertyAnimator.animate((View)view).setInterpolator((Interpolator)new AccelerateDecelerateInterpolator()).setDuration((long)duration).rotationX(0.0f).translationY(0.0f).start();
    }

    static class SimpleAnimationListener
    implements Animator.AnimatorListener {
        SimpleAnimationListener() {
        }

        public void onAnimationStart(Animator animation) {
        }

        public void onAnimationEnd(Animator animation) {
        }

        public void onAnimationCancel(Animator animation) {
        }

        public void onAnimationRepeat(Animator animation) {
        }
    }
}

