/*
 * Decompiled with CFR 0.152.
 */
package io.codetail.animation;

import android.annotation.TargetApi;
import android.graphics.Rect;
import android.view.View;
import com.nineoldandroids.animation.Animator;
import com.nineoldandroids.util.FloatProperty;
import io.codetail.animation.SupportAnimator;
import io.codetail.animation.ViewAnimationUtils;
import java.lang.ref.WeakReference;

public interface RevealAnimator {
    public static final RevealRadius CLIP_RADIUS = new RevealRadius();

    public void onRevealAnimationStart();

    public void onRevealAnimationEnd();

    public void onRevealAnimationCancel();

    public void setRevealRadius(float var1);

    public float getRevealRadius();

    public void invalidate(Rect var1);

    public void attachRevealInfo(RevealInfo var1);

    public SupportAnimator startReverseAnimation();

    public static class RevealRadius
    extends FloatProperty<RevealAnimator> {
        public RevealRadius() {
            super("revealRadius");
        }

        public void setValue(RevealAnimator object, float value) {
            object.setRevealRadius(value);
        }

        public Float get(RevealAnimator object) {
            return Float.valueOf(object.getRevealRadius());
        }
    }

    public static class RevealFinishedJellyBeanMr2
    extends RevealFinishedIceCreamSandwich {
        @TargetApi(value=11)
        RevealFinishedJellyBeanMr2(RevealAnimator target) {
            super(target);
            this.mFeaturedLayerType = 2;
        }
    }

    @TargetApi(value=11)
    public static class RevealFinishedIceCreamSandwich
    extends RevealFinishedGingerbread {
        int mFeaturedLayerType;
        int mLayerType;

        RevealFinishedIceCreamSandwich(RevealAnimator target) {
            super(target);
            this.mLayerType = ((View)target).getLayerType();
            this.mFeaturedLayerType = 1;
        }

        @Override
        public void onAnimationCancel(Animator animation) {
            ((View)this.mReference.get()).setLayerType(this.mLayerType, null);
            super.onAnimationEnd(animation);
        }

        @Override
        public void onAnimationStart(Animator animation) {
            ((View)this.mReference.get()).setLayerType(this.mFeaturedLayerType, null);
            super.onAnimationStart(animation);
        }

        @Override
        public void onAnimationEnd(Animator animation) {
            ((View)this.mReference.get()).setLayerType(this.mLayerType, null);
            super.onAnimationEnd(animation);
        }
    }

    public static class RevealFinishedGingerbread
    extends ViewAnimationUtils.SimpleAnimationListener {
        WeakReference<RevealAnimator> mReference;

        RevealFinishedGingerbread(RevealAnimator target) {
            this.mReference = new WeakReference<RevealAnimator>(target);
        }

        @Override
        public void onAnimationStart(Animator animation) {
            RevealAnimator target = (RevealAnimator)this.mReference.get();
            target.onRevealAnimationStart();
        }

        @Override
        public void onAnimationCancel(Animator animation) {
            RevealAnimator target = (RevealAnimator)this.mReference.get();
            target.onRevealAnimationCancel();
        }

        @Override
        public void onAnimationEnd(Animator animation) {
            RevealAnimator target = (RevealAnimator)this.mReference.get();
            target.onRevealAnimationEnd();
        }
    }

    public static class RevealInfo {
        public final int centerX;
        public final int centerY;
        public final float startRadius;
        public final float endRadius;
        public final WeakReference<View> target;

        public RevealInfo(int centerX, int centerY, float startRadius, float endRadius, WeakReference<View> target) {
            this.centerX = centerX;
            this.centerY = centerY;
            this.startRadius = startRadius;
            this.endRadius = endRadius;
            this.target = target;
        }

        public View getTarget() {
            return (View)this.target.get();
        }

        public boolean hasTarget() {
            return this.getTarget() != null;
        }
    }
}

