/*
 * Decompiled with CFR 0.152.
 */
package io.codetail.widget;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Path;
import android.util.AttributeSet;
import android.view.View;
import android.widget.FrameLayout;
import io.codetail.animation.RevealAnimator;

public class RevealFrameLayout
extends FrameLayout
implements RevealAnimator {
    Path mRevealPath = new Path();
    boolean mClipOutlines;
    float mCenterX;
    float mCenterY;
    float mRadius;
    View mTarget;

    public RevealFrameLayout(Context context) {
        this(context, null);
    }

    public RevealFrameLayout(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public RevealFrameLayout(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
    }

    @Override
    public void setTarget(View view) {
        this.mTarget = view;
    }

    @Override
    public void setCenter(float centerX, float centerY) {
        this.mCenterX = centerX;
        this.mCenterY = centerY;
    }

    @Override
    public void setClipOutlines(boolean clip) {
        this.mClipOutlines = clip;
    }

    @Override
    public void setRevealRadius(float radius) {
        this.mRadius = radius;
        this.invalidate();
    }

    @Override
    public float getRevealRadius() {
        return this.mRadius;
    }

    protected boolean drawChild(Canvas canvas, View child, long drawingTime) {
        if (!this.mClipOutlines && child != this.mTarget) {
            return super.drawChild(canvas, child, drawingTime);
        }
        int state = canvas.save();
        this.mRevealPath.reset();
        this.mRevealPath.addCircle(this.mCenterX, this.mCenterY, this.mRadius, Path.Direction.CW);
        canvas.clipPath(this.mRevealPath);
        boolean isInvalided = super.drawChild(canvas, child, drawingTime);
        canvas.restoreToCount(state);
        return isInvalided;
    }
}

