/*
 * Decompiled with CFR 0.152.
 */
package io.codetail.animation;

import android.annotation.TargetApi;
import android.graphics.Rect;
import android.os.Build;
import android.view.View;
import android.view.animation.AccelerateDecelerateInterpolator;
import android.view.animation.Interpolator;
import com.nineoldandroids.animation.Animator;
import com.nineoldandroids.animation.ObjectAnimator;
import com.nineoldandroids.view.ViewHelper;
import com.nineoldandroids.view.ViewPropertyAnimator;
import io.codetail.animation.RevealAnimator;
import io.codetail.animation.SupportAnimator;
import io.codetail.animation.SupportAnimatorLollipop;
import io.codetail.animation.SupportAnimatorPreL;

public class ViewAnimationUtils {
    private static final boolean LOLLIPOP_PLUS = Build.VERSION.SDK_INT >= 21;
    public static final int SCALE_UP_DURATION = 500;

    @TargetApi(value=21)
    public static SupportAnimator createCircularReveal(View view, int centerX, int centerY, float startRadius, float endRadius) {
        if (LOLLIPOP_PLUS) {
            return new SupportAnimatorLollipop(android.view.ViewAnimationUtils.createCircularReveal((View)view, (int)centerX, (int)centerY, (float)startRadius, (float)endRadius));
        }
        if (!(view.getParent() instanceof RevealAnimator)) {
            throw new IllegalArgumentException("View must be inside RevealFrameLayout or RevealLinearLayout.");
        }
        RevealAnimator revealLayout = (RevealAnimator)view.getParent();
        revealLayout.setTarget(view);
        revealLayout.setCenter(centerX, centerY);
        Rect bounds = new Rect();
        view.getHitRect(bounds);
        ObjectAnimator reveal = ObjectAnimator.ofFloat((Object)revealLayout, (String)"revealRadius", (float[])new float[]{startRadius, endRadius});
        reveal.addListener(ViewAnimationUtils.getRevealFinishListener(revealLayout, bounds));
        return new SupportAnimatorPreL((Animator)reveal);
    }

    static Animator.AnimatorListener getRevealFinishListener(RevealAnimator target, Rect bounds) {
        if (Build.VERSION.SDK_INT >= 18) {
            return new RevealAnimator.RevealFinishedJellyBeanMr2(target, bounds);
        }
        if (Build.VERSION.SDK_INT >= 14) {
            return new RevealAnimator.RevealFinishedIceCreamSandwich(target, bounds);
        }
        return new RevealAnimator.RevealFinishedGingerbread(target, bounds);
    }

    public static void liftingFromBottom(View view, float baseRotation, float fromY, int duration, int startDelay) {
        ViewHelper.setRotationX((View)view, (float)baseRotation);
        ViewHelper.setTranslationY((View)view, (float)fromY);
        ViewPropertyAnimator.animate((View)view).setInterpolator((Interpolator)new AccelerateDecelerateInterpolator()).setDuration((long)duration).setStartDelay((long)startDelay).rotationX(0.0f).translationY(0.0f).start();
    }

    public static void liftingFromBottom(View view, float baseRotation, int duration, int startDelay) {
        ViewHelper.setRotationX((View)view, (float)baseRotation);
        ViewHelper.setTranslationY((View)view, (float)(view.getHeight() / 3));
        ViewPropertyAnimator.animate((View)view).setInterpolator((Interpolator)new AccelerateDecelerateInterpolator()).setDuration((long)duration).setStartDelay((long)startDelay).rotationX(0.0f).translationY(0.0f).start();
    }

    public static void liftingFromBottom(View view, float baseRotation, int duration) {
        ViewHelper.setRotationX((View)view, (float)baseRotation);
        ViewHelper.setTranslationY((View)view, (float)(view.getHeight() / 3));
        ViewPropertyAnimator.animate((View)view).setInterpolator((Interpolator)new AccelerateDecelerateInterpolator()).setDuration((long)duration).rotationX(0.0f).translationY(0.0f).start();
    }

    public static class SimpleAnimationListener
    implements Animator.AnimatorListener {
        public void onAnimationStart(Animator animation) {
        }

        public void onAnimationEnd(Animator animation) {
        }

        public void onAnimationCancel(Animator animation) {
        }

        public void onAnimationRepeat(Animator animation) {
        }
    }
}

