/*
 * Decompiled with CFR 0.152.
 */
import java.io.IOException;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.http.client.utils.URLEncodedUtils;
import org.apache.http.message.BasicNameValuePair;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class OutscraperClient {
    private String privateApiKey;
    private String privateApiURL = "https://api.app.outscraper.com";
    private HttpClient client = HttpClient.newHttpClient();

    public OutscraperClient(String apiKey) {
        this.privateApiKey = apiKey;
    }

    private JSONArray getData(JSONObject json) {
        try {
            return (JSONArray)json.get("data");
        }
        catch (JSONException e) {
            e.printStackTrace();
            return null;
        }
    }

    private JSONObject getAPIRequest(String path, HashMap<String, Object> parameters) {
        ArrayList<BasicNameValuePair> parametersList = new ArrayList<BasicNameValuePair>(parameters.size());
        for (Map.Entry<String, Object> entry : parameters.entrySet()) {
            parametersList.add(new BasicNameValuePair(entry.getKey(), String.valueOf(entry.getValue())));
        }
        String url = this.privateApiURL + path + "?" + URLEncodedUtils.format(parametersList, (String)"utf-8");
        HttpRequest request = HttpRequest.newBuilder().GET().header("accept", "application/json").header("X-API-KEY", this.privateApiKey).header("client", "Java SDK").uri(URI.create(url)).build();
        try {
            HttpResponse<String> response = this.client.send(request, HttpResponse.BodyHandlers.ofString());
            String body = response.body();
            try {
                return new JSONObject(body);
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        return null;
    }

    public JSONObject getRequestArchive(String requestId) {
        return this.getAPIRequest("/requests/" + requestId, new HashMap<String, Object>(){});
    }

    public JSONArray googleSearch(HashMap<String, Object> parameters) {
        parameters.put("async", false);
        JSONObject response = this.getAPIRequest("/google-search-v3", parameters);
        return this.getData(response);
    }

    public JSONArray googleMapsSearch(HashMap<String, Object> parameters) {
        parameters.put("async", false);
        JSONObject response = this.getAPIRequest("/maps/search-v2", parameters);
        return this.getData(response);
    }

    public JSONArray googleMapsReviews(HashMap<String, Object> parameters) {
        parameters.put("async", false);
        JSONObject response = this.getAPIRequest("/maps/reviews-v3", parameters);
        return this.getData(response);
    }

    public JSONArray emailsAndContacts(HashMap<String, Object> parameters) {
        parameters.put("async", false);
        JSONObject response = this.getAPIRequest("/emails-and-contacts", parameters);
        return this.getData(response);
    }

    public JSONArray phonesEnricher(HashMap<String, Object> parameters) {
        parameters.put("async", false);
        JSONObject response = this.getAPIRequest("/phones-enricher", parameters);
        return this.getData(response);
    }
}

