/*
 * Decompiled with CFR 0.152.
 */
package oupson.apng;

import android.content.Context;
import android.content.SharedPreferences;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.widget.ImageView;
import java.io.File;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.ByteStreamsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.anko.AnkoAsyncContext;
import org.jetbrains.anko.AsyncKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import oupson.apng.APNGDisassembler;
import oupson.apng.ApngAnimator;
import oupson.apng.BitmapDrawable;
import oupson.apng.CustomAnimationDrawable;
import oupson.apng.Frame;
import oupson.apng.Loader;
import oupson.apng.exceptions.NotApngException;
import oupson.apng.utils.ApngAnimatorOptions;
import oupson.apng.utils.Utils;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u0090\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\n\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010-\u001a\u00020\u00072\u0006\u0010.\u001a\u00020\u0019J \u0010/\u001a\u00020\u00072\u0016\u00100\u001a\u0012\u0012\u0004\u0012\u00020\u00140\u0010j\b\u0012\u0004\u0012\u00020\u0014`\u0012H\u0002J+\u00101\u001a\u00020\u00072\u0006\u00102\u001a\u0002032\n\b\u0002\u0010'\u001a\u0004\u0018\u00010\u00112\n\b\u0002\u00104\u001a\u0004\u0018\u000105\u00a2\u0006\u0002\u00106J+\u00101\u001a\u00020\u00072\u0006\u00107\u001a\u0002082\n\b\u0002\u0010'\u001a\u0004\u0018\u00010\u00112\n\b\u0002\u00104\u001a\u0004\u0018\u000105\u00a2\u0006\u0002\u00109J)\u00101\u001a\u00020\u00072\u0006\u0010:\u001a\u00020;2\n\b\u0002\u0010'\u001a\u0004\u0018\u00010\u00112\b\u00104\u001a\u0004\u0018\u000105\u00a2\u0006\u0002\u0010<J+\u00101\u001a\u00020\u00072\u0006\u0010=\u001a\u00020>2\n\b\u0002\u0010'\u001a\u0004\u0018\u00010\u00112\n\b\u0002\u00104\u001a\u0004\u0018\u000105\u00a2\u0006\u0002\u0010?J\u000e\u0010@\u001a\u00020\u00002\u0006\u0010\u0016\u001a\u00020\u0017J\u000e\u0010 \u001a\u00020\u00072\u0006\u0010.\u001a\u00020\u0019J+\u0010A\u001a\u00020\u00072\u0006\u0010B\u001a\u00020C2\n\b\u0002\u0010'\u001a\u0004\u0018\u00010\u00112\n\b\u0002\u00104\u001a\u0004\u0018\u000105\u00a2\u0006\u0002\u0010DJ\u001a\u0010E\u001a\u00020\u00072\u0012\u0010F\u001a\u000e\u0012\u0004\u0012\u00020\u0000\u0012\u0004\u0012\u00020\u00070\u000eJ\u0006\u0010G\u001a\u00020\u0007J\u0006\u0010H\u001a\u00020\u0007J\u0014\u0010I\u001a\u00020\u00072\f\u0010J\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006J\b\u0010K\u001a\u00020\u0007H\u0002J\b\u0010L\u001a\u00020\tH\u0002R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u0000\u0012\u0004\u0012\u00020\u00070\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\"\u0010\u000f\u001a\u0016\u0012\u0004\u0012\u00020\u0011\u0018\u00010\u0010j\n\u0012\u0004\u0012\u00020\u0011\u0018\u0001`\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0013\u001a\u0012\u0012\u0004\u0012\u00020\u00140\u0010j\b\u0012\u0004\u0012\u00020\u0014`\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0015\u001a\u0012\u0012\u0004\u0012\u00020\f0\u0010j\b\u0012\u0004\u0012\u00020\f`\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0016\u001a\u0004\u0018\u00010\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0018\u001a\u00020\u0019X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u001a\"\u0004\b\u001b\u0010\u001cR$\u0010\u001e\u001a\u00020\u00192\u0006\u0010\u001d\u001a\u00020\u0019@BX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001e\u0010\u001a\"\u0004\b\u001f\u0010\u001cR\u001a\u0010 \u001a\u00020\u0019X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b!\u0010\u001a\"\u0004\b\"\u0010\u001cR\u0010\u0010#\u001a\u0004\u0018\u00010$X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010%\u001a\u00020&X\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010'\u001a\u0004\u0018\u00010\u00112\b\u0010\u001d\u001a\u0004\u0018\u00010\u0011@FX\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010,\u001a\u0004\b(\u0010)\"\u0004\b*\u0010+\u00a8\u0006M"}, d2={"Loupson/apng/ApngAnimator;", "", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "AnimationLoopListener", "Lkotlin/Function0;", "", "activeAnimation", "Loupson/apng/CustomAnimationDrawable;", "anim", "bitmapBuffer", "Landroid/graphics/Bitmap;", "doOnLoaded", "Lkotlin/Function1;", "duration", "Ljava/util/ArrayList;", "", "Lkotlin/collections/ArrayList;", "frames", "Loupson/apng/Frame;", "generatedFrame", "imageView", "Landroid/widget/ImageView;", "isApng", "", "()Z", "setApng", "(Z)V", "value", "isPlaying", "setPlaying", "loadNotApng", "getLoadNotApng", "setLoadNotApng", "scaleType", "Landroid/widget/ImageView$ScaleType;", "sharedPreferences", "Landroid/content/SharedPreferences;", "speed", "getSpeed", "()Ljava/lang/Float;", "setSpeed", "(Ljava/lang/Float;)V", "Ljava/lang/Float;", "centerCrop", "boolean", "draw", "extractedFrame", "load", "uri", "Landroid/net/Uri;", "apngAnimatorOptions", "Loupson/apng/utils/ApngAnimatorOptions;", "(Landroid/net/Uri;Ljava/lang/Float;Loupson/apng/utils/ApngAnimatorOptions;)V", "file", "Ljava/io/File;", "(Ljava/io/File;Ljava/lang/Float;Loupson/apng/utils/ApngAnimatorOptions;)V", "byteArray", "", "([BLjava/lang/Float;Loupson/apng/utils/ApngAnimatorOptions;)V", "string", "", "(Ljava/lang/String;Ljava/lang/Float;Loupson/apng/utils/ApngAnimatorOptions;)V", "loadInto", "loadUrl", "url", "Ljava/net/URL;", "(Ljava/net/URL;Ljava/lang/Float;Loupson/apng/utils/ApngAnimatorOptions;)V", "onLoaded", "f", "pause", "play", "setOnAnimationLoopListener", "animationLoopListener", "setupAnimationDrawableAndStart", "toAnimationDrawable", "apng_library_release"})
public final class ApngAnimator {
    private boolean isPlaying;
    private ArrayList<Frame> frames;
    private final ArrayList<Bitmap> generatedFrame;
    @Nullable
    private Float speed;
    private Bitmap bitmapBuffer;
    private ImageView imageView;
    private CustomAnimationDrawable anim;
    private CustomAnimationDrawable activeAnimation;
    private Function1<? super ApngAnimator, Unit> doOnLoaded;
    private Function0<Unit> AnimationLoopListener;
    private ArrayList<Float> duration;
    private ImageView.ScaleType scaleType;
    private boolean isApng;
    private boolean loadNotApng;
    private final SharedPreferences sharedPreferences;
    private final Context context;

    public final boolean isPlaying() {
        return this.isPlaying;
    }

    private final void setPlaying(boolean value) {
        this.isPlaying = value;
    }

    @Nullable
    public final Float getSpeed() {
        return this.speed;
    }

    public final void setSpeed(@Nullable Float value) {
        if (this.isApng) {
            this.speed = value;
            try {
                this.pause();
                this.play();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public final boolean isApng() {
        return this.isApng;
    }

    public final void setApng(boolean bl) {
        this.isApng = bl;
    }

    public final boolean getLoadNotApng() {
        return this.loadNotApng;
    }

    public final void setLoadNotApng(boolean bl) {
        this.loadNotApng = bl;
    }

    public final void loadNotApng(boolean bl) {
        SharedPreferences.Editor editor = this.sharedPreferences.edit();
        editor.putBoolean("loadNotApng", bl);
        editor.apply();
    }

    @NotNull
    public final ApngAnimator loadInto(@NotNull ImageView imageView) {
        Intrinsics.checkParameterIsNotNull((Object)imageView, (String)"imageView");
        this.imageView = imageView;
        return this;
    }

    public final void load(@NotNull File file, @Nullable Float speed, @Nullable ApngAnimatorOptions apngAnimatorOptions) {
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        AsyncKt.doAsync$default((Object)this, null, (Function1)((Function1)new Function1<AnkoAsyncContext<ApngAnimator>, Unit>(this, file, speed, apngAnimatorOptions){
            final /* synthetic */ ApngAnimator this$0;
            final /* synthetic */ File $file;
            final /* synthetic */ Float $speed;
            final /* synthetic */ ApngAnimatorOptions $apngAnimatorOptions;

            public final void invoke(@NotNull AnkoAsyncContext<ApngAnimator> $receiver) {
                Intrinsics.checkParameterIsNotNull($receiver, (String)"receiver$0");
                byte[] bytes = FilesKt.readBytes((File)this.$file);
                if (Utils.Companion.isApng(bytes)) {
                    ArrayList<Frame> arrayList;
                    this.this$0.setApng(true);
                    this.this$0.setSpeed(this.$speed);
                    ArrayList<Frame> $receiver2 = arrayList = APNGDisassembler.Companion.disassemble(FilesKt.readBytes((File)this.$file)).getFrames();
                    ApngAnimator.access$draw(this.this$0, $receiver2);
                    ApngAnimatorOptions apngAnimatorOptions = this.$apngAnimatorOptions;
                    ApngAnimator.access$setScaleType$p(this.this$0, (ImageView.ScaleType)(apngAnimatorOptions != null ? apngAnimatorOptions.getScaleType() : null));
                    ApngAnimator.access$setupAnimationDrawableAndStart(this.this$0);
                } else if (this.this$0.getLoadNotApng()) {
                    AsyncKt.runOnUiThread((Context)ApngAnimator.access$getContext$p(this.this$0), (Function1)((Function1)new Function1<Context, Unit>(this, bytes){
                        final /* synthetic */ load.1 this$0;
                        final /* synthetic */ byte[] $bytes;

                        public final void invoke(@NotNull Context $receiver) {
                            block2: {
                                Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
                                ImageView imageView = ApngAnimator.access$getImageView$p(this.this$0.this$0);
                                if (imageView != null) {
                                    ImageView.ScaleType scaleType = ApngAnimator.access$getScaleType$p(this.this$0.this$0);
                                    if (scaleType == null) {
                                        scaleType = ImageView.ScaleType.FIT_CENTER;
                                    }
                                    imageView.setScaleType(scaleType);
                                }
                                ImageView imageView2 = ApngAnimator.access$getImageView$p(this.this$0.this$0);
                                if (imageView2 == null) break block2;
                                imageView2.setImageBitmap(BitmapFactory.decodeByteArray((byte[])this.$bytes, (int)0, (int)this.$bytes.length));
                            }
                        }
                        {
                            this.this$0 = var1_1;
                            this.$bytes = byArray;
                            super(1);
                        }
                    }));
                } else {
                    throw (Throwable)new NotApngException();
                }
            }
            {
                this.this$0 = apngAnimator;
                this.$file = file;
                this.$speed = f;
                this.$apngAnimatorOptions = apngAnimatorOptions;
                super(1);
            }
        }), (int)1, null);
    }

    public static /* synthetic */ void load$default(ApngAnimator apngAnimator, File file, Float f, ApngAnimatorOptions apngAnimatorOptions, int n, Object object) {
        if ((n & 2) != 0) {
            f = null;
        }
        if ((n & 4) != 0) {
            apngAnimatorOptions = null;
        }
        apngAnimator.load(file, f, apngAnimatorOptions);
    }

    public final void load(@NotNull Uri uri, @Nullable Float speed, @Nullable ApngAnimatorOptions apngAnimatorOptions) {
        Intrinsics.checkParameterIsNotNull((Object)uri, (String)"uri");
        AsyncKt.doAsync$default((Object)this, null, (Function1)((Function1)new Function1<AnkoAsyncContext<ApngAnimator>, Unit>(this, uri, speed, apngAnimatorOptions){
            final /* synthetic */ ApngAnimator this$0;
            final /* synthetic */ Uri $uri;
            final /* synthetic */ Float $speed;
            final /* synthetic */ ApngAnimatorOptions $apngAnimatorOptions;

            public final void invoke(@NotNull AnkoAsyncContext<ApngAnimator> $receiver) {
                Intrinsics.checkParameterIsNotNull($receiver, (String)"receiver$0");
                InputStream inputStream = ApngAnimator.access$getContext$p(this.this$0).getContentResolver().openInputStream(this.$uri);
                Intrinsics.checkExpressionValueIsNotNull((Object)inputStream, (String)"context.contentResolver.openInputStream(uri)");
                byte[] bytes = ByteStreamsKt.readBytes((InputStream)inputStream);
                if (Utils.Companion.isApng(bytes)) {
                    ArrayList<Frame> arrayList;
                    this.this$0.setApng(true);
                    this.this$0.setSpeed(this.$speed);
                    ArrayList<Frame> $receiver2 = arrayList = APNGDisassembler.Companion.disassemble(bytes).getFrames();
                    ApngAnimator.access$draw(this.this$0, $receiver2);
                    ApngAnimatorOptions apngAnimatorOptions = this.$apngAnimatorOptions;
                    ApngAnimator.access$setScaleType$p(this.this$0, (ImageView.ScaleType)(apngAnimatorOptions != null ? apngAnimatorOptions.getScaleType() : null));
                    ApngAnimator.access$setupAnimationDrawableAndStart(this.this$0);
                } else if (this.this$0.getLoadNotApng()) {
                    AsyncKt.runOnUiThread((Context)ApngAnimator.access$getContext$p(this.this$0), (Function1)((Function1)new Function1<Context, Unit>(this, bytes){
                        final /* synthetic */ load.2 this$0;
                        final /* synthetic */ byte[] $bytes;

                        public final void invoke(@NotNull Context $receiver) {
                            block2: {
                                Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
                                ImageView imageView = ApngAnimator.access$getImageView$p(this.this$0.this$0);
                                if (imageView != null) {
                                    ImageView.ScaleType scaleType = ApngAnimator.access$getScaleType$p(this.this$0.this$0);
                                    if (scaleType == null) {
                                        scaleType = ImageView.ScaleType.FIT_CENTER;
                                    }
                                    imageView.setScaleType(scaleType);
                                }
                                ImageView imageView2 = ApngAnimator.access$getImageView$p(this.this$0.this$0);
                                if (imageView2 == null) break block2;
                                imageView2.setImageBitmap(BitmapFactory.decodeByteArray((byte[])this.$bytes, (int)0, (int)this.$bytes.length));
                            }
                        }
                        {
                            this.this$0 = var1_1;
                            this.$bytes = byArray;
                            super(1);
                        }
                    }));
                } else {
                    throw (Throwable)new NotApngException();
                }
            }
            {
                this.this$0 = apngAnimator;
                this.$uri = uri;
                this.$speed = f;
                this.$apngAnimatorOptions = apngAnimatorOptions;
                super(1);
            }
        }), (int)1, null);
    }

    public static /* synthetic */ void load$default(ApngAnimator apngAnimator, Uri uri, Float f, ApngAnimatorOptions apngAnimatorOptions, int n, Object object) {
        if ((n & 2) != 0) {
            f = null;
        }
        if ((n & 4) != 0) {
            apngAnimatorOptions = null;
        }
        apngAnimator.load(uri, f, apngAnimatorOptions);
    }

    public final void loadUrl(@NotNull URL url, @Nullable Float speed, @Nullable ApngAnimatorOptions apngAnimatorOptions) {
        Intrinsics.checkParameterIsNotNull((Object)url, (String)"url");
        AsyncKt.doAsync((Object)this, (Function1)loadUrl.1.INSTANCE, (Function1)((Function1)new Function1<AnkoAsyncContext<ApngAnimator>, Unit>(this, speed, url, apngAnimatorOptions){
            final /* synthetic */ ApngAnimator this$0;
            final /* synthetic */ Float $speed;
            final /* synthetic */ URL $url;
            final /* synthetic */ ApngAnimatorOptions $apngAnimatorOptions;

            public final void invoke(@NotNull AnkoAsyncContext<ApngAnimator> $receiver) {
                byte[] byArray;
                Intrinsics.checkParameterIsNotNull($receiver, (String)"receiver$0");
                this.this$0.setSpeed(this.$speed);
                byte[] $receiver2 = byArray = Loader.Companion.load(ApngAnimator.access$getContext$p(this.this$0), this.$url);
                if (Utils.Companion.isApng($receiver2)) {
                    ArrayList<Frame> arrayList;
                    this.this$0.setApng(true);
                    ArrayList<Frame> $receiver3 = arrayList = APNGDisassembler.Companion.disassemble($receiver2).getFrames();
                    ApngAnimator.access$draw(this.this$0, $receiver3);
                    ApngAnimatorOptions apngAnimatorOptions = this.$apngAnimatorOptions;
                    ApngAnimator.access$setScaleType$p(this.this$0, (ImageView.ScaleType)(apngAnimatorOptions != null ? apngAnimatorOptions.getScaleType() : null));
                    ApngAnimator.access$setupAnimationDrawableAndStart(this.this$0);
                } else if (this.this$0.getLoadNotApng()) {
                    AsyncKt.runOnUiThread((Context)ApngAnimator.access$getContext$p(this.this$0), (Function1)((Function1)new Function1<Context, Unit>($receiver2, this){
                        final /* synthetic */ byte[] $this_apply;
                        final /* synthetic */ loadUrl.2 this$0;
                        {
                            this.$this_apply = byArray;
                            this.this$0 = var2_2;
                            super(1);
                        }

                        public final void invoke(@NotNull Context $receiver) {
                            block2: {
                                Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
                                ImageView imageView = ApngAnimator.access$getImageView$p(this.this$0.this$0);
                                if (imageView != null) {
                                    ImageView.ScaleType scaleType = ApngAnimator.access$getScaleType$p(this.this$0.this$0);
                                    if (scaleType == null) {
                                        scaleType = ImageView.ScaleType.FIT_CENTER;
                                    }
                                    imageView.setScaleType(scaleType);
                                }
                                ImageView imageView2 = ApngAnimator.access$getImageView$p(this.this$0.this$0);
                                if (imageView2 == null) break block2;
                                imageView2.setImageBitmap(BitmapFactory.decodeByteArray((byte[])this.$this_apply, (int)0, (int)this.$this_apply.length));
                            }
                        }
                    }));
                } else {
                    throw (Throwable)new NotApngException();
                }
            }
            {
                this.this$0 = apngAnimator;
                this.$speed = f;
                this.$url = uRL;
                this.$apngAnimatorOptions = apngAnimatorOptions;
                super(1);
            }
        }));
    }

    public static /* synthetic */ void loadUrl$default(ApngAnimator apngAnimator, URL uRL, Float f, ApngAnimatorOptions apngAnimatorOptions, int n, Object object) {
        if ((n & 2) != 0) {
            f = null;
        }
        if ((n & 4) != 0) {
            apngAnimatorOptions = null;
        }
        apngAnimator.loadUrl(uRL, f, apngAnimatorOptions);
    }

    public final void load(@NotNull byte[] byteArray, @Nullable Float speed, @Nullable ApngAnimatorOptions apngAnimatorOptions) {
        Intrinsics.checkParameterIsNotNull((Object)byteArray, (String)"byteArray");
        AsyncKt.doAsync$default((Object)this, null, (Function1)((Function1)new Function1<AnkoAsyncContext<ApngAnimator>, Unit>(this, speed, byteArray, apngAnimatorOptions){
            final /* synthetic */ ApngAnimator this$0;
            final /* synthetic */ Float $speed;
            final /* synthetic */ byte[] $byteArray;
            final /* synthetic */ ApngAnimatorOptions $apngAnimatorOptions;

            public final void invoke(@NotNull AnkoAsyncContext<ApngAnimator> $receiver) {
                Intrinsics.checkParameterIsNotNull($receiver, (String)"receiver$0");
                this.this$0.setSpeed(this.$speed);
                if (Utils.Companion.isApng(this.$byteArray)) {
                    ArrayList<Frame> arrayList;
                    this.this$0.setApng(true);
                    ArrayList<Frame> $receiver2 = arrayList = APNGDisassembler.Companion.disassemble(this.$byteArray).getFrames();
                    ApngAnimator.access$draw(this.this$0, $receiver2);
                    ApngAnimatorOptions apngAnimatorOptions = this.$apngAnimatorOptions;
                    ApngAnimator.access$setScaleType$p(this.this$0, (ImageView.ScaleType)(apngAnimatorOptions != null ? apngAnimatorOptions.getScaleType() : null));
                    ApngAnimator.access$setupAnimationDrawableAndStart(this.this$0);
                } else if (this.this$0.getLoadNotApng()) {
                    AsyncKt.runOnUiThread((Context)ApngAnimator.access$getContext$p(this.this$0), (Function1)((Function1)new Function1<Context, Unit>(this){
                        final /* synthetic */ load.3 this$0;

                        public final void invoke(@NotNull Context $receiver) {
                            block2: {
                                Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
                                ImageView imageView = ApngAnimator.access$getImageView$p(this.this$0.this$0);
                                if (imageView != null) {
                                    ImageView.ScaleType scaleType = ApngAnimator.access$getScaleType$p(this.this$0.this$0);
                                    if (scaleType == null) {
                                        scaleType = ImageView.ScaleType.FIT_CENTER;
                                    }
                                    imageView.setScaleType(scaleType);
                                }
                                ImageView imageView2 = ApngAnimator.access$getImageView$p(this.this$0.this$0);
                                if (imageView2 == null) break block2;
                                imageView2.setImageBitmap(BitmapFactory.decodeByteArray((byte[])this.this$0.$byteArray, (int)0, (int)this.this$0.$byteArray.length));
                            }
                        }
                        {
                            this.this$0 = var1_1;
                            super(1);
                        }
                    }));
                } else {
                    throw (Throwable)new NotApngException();
                }
            }
            {
                this.this$0 = apngAnimator;
                this.$speed = f;
                this.$byteArray = byArray;
                this.$apngAnimatorOptions = apngAnimatorOptions;
                super(1);
            }
        }), (int)1, null);
    }

    public static /* synthetic */ void load$default(ApngAnimator apngAnimator, byte[] byArray, Float f, ApngAnimatorOptions apngAnimatorOptions, int n, Object object) {
        if ((n & 2) != 0) {
            f = null;
        }
        apngAnimator.load(byArray, f, apngAnimatorOptions);
    }

    public final void load(@NotNull String string, @Nullable Float speed, @Nullable ApngAnimatorOptions apngAnimatorOptions) {
        Intrinsics.checkParameterIsNotNull((Object)string, (String)"string");
        AsyncKt.doAsync$default((Object)this, null, (Function1)((Function1)new Function1<AnkoAsyncContext<ApngAnimator>, Unit>(this, speed, string, apngAnimatorOptions){
            final /* synthetic */ ApngAnimator this$0;
            final /* synthetic */ Float $speed;
            final /* synthetic */ String $string;
            final /* synthetic */ ApngAnimatorOptions $apngAnimatorOptions;

            public final void invoke(@NotNull AnkoAsyncContext<ApngAnimator> $receiver) {
                Intrinsics.checkParameterIsNotNull($receiver, (String)"receiver$0");
                this.this$0.setSpeed(this.$speed);
                if (StringsKt.contains$default((CharSequence)this.$string, (CharSequence)"http", (boolean)false, (int)2, null) || StringsKt.contains$default((CharSequence)this.$string, (CharSequence)"https", (boolean)false, (int)2, null)) {
                    URL url = new URL(this.$string);
                    this.this$0.loadUrl(url, this.$speed, this.$apngAnimatorOptions);
                } else if (new File(this.$string).exists()) {
                    String pathToLoad = StringsKt.startsWith$default((String)this.$string, (String)"content://", (boolean)false, (int)2, null) ? this.$string : "file://" + this.$string;
                    pathToLoad = StringsKt.replace$default((String)StringsKt.replace$default((String)pathToLoad, (String)"%", (String)"%25", (boolean)false, (int)4, null), (String)"#", (String)"%23", (boolean)false, (int)4, null);
                    InputStream inputStream = ApngAnimator.access$getContext$p(this.this$0).getContentResolver().openInputStream(Uri.parse((String)pathToLoad));
                    Intrinsics.checkExpressionValueIsNotNull((Object)inputStream, (String)"context.contentResolver.\u2026am(Uri.parse(pathToLoad))");
                    byte[] bytes = ByteStreamsKt.readBytes((InputStream)inputStream);
                    if (Utils.Companion.isApng(bytes)) {
                        this.this$0.load(bytes, this.$speed, this.$apngAnimatorOptions);
                    } else if (this.this$0.getLoadNotApng()) {
                        AsyncKt.runOnUiThread((Context)ApngAnimator.access$getContext$p(this.this$0), (Function1)((Function1)new Function1<Context, Unit>(this, bytes){
                            final /* synthetic */ load.4 this$0;
                            final /* synthetic */ byte[] $bytes;

                            public final void invoke(@NotNull Context $receiver) {
                                block0: {
                                    Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
                                    ImageView imageView = ApngAnimator.access$getImageView$p(this.this$0.this$0);
                                    if (imageView == null) break block0;
                                    imageView.setImageBitmap(BitmapFactory.decodeByteArray((byte[])this.$bytes, (int)0, (int)this.$bytes.length));
                                }
                            }
                            {
                                this.this$0 = var1_1;
                                this.$bytes = byArray;
                                super(1);
                            }
                        }));
                    } else {
                        throw (Throwable)new NotApngException();
                    }
                }
            }
            {
                this.this$0 = apngAnimator;
                this.$speed = f;
                this.$string = string;
                this.$apngAnimatorOptions = apngAnimatorOptions;
                super(1);
            }
        }), (int)1, null);
    }

    public static /* synthetic */ void load$default(ApngAnimator apngAnimator, String string, Float f, ApngAnimatorOptions apngAnimatorOptions, int n, Object object) {
        if ((n & 2) != 0) {
            f = null;
        }
        if ((n & 4) != 0) {
            apngAnimatorOptions = null;
        }
        apngAnimator.load(string, f, apngAnimatorOptions);
    }

    private final void setupAnimationDrawableAndStart() {
        AsyncKt.doAsync$default((Object)this, null, (Function1)((Function1)new Function1<AnkoAsyncContext<ApngAnimator>, Unit>(this){
            final /* synthetic */ ApngAnimator this$0;

            public final void invoke(@NotNull AnkoAsyncContext<ApngAnimator> $receiver) {
                Intrinsics.checkParameterIsNotNull($receiver, (String)"receiver$0");
                ApngAnimator.access$setAnim$p(this.this$0, ApngAnimator.access$toAnimationDrawable(this.this$0));
                ApngAnimator.access$setActiveAnimation$p(this.this$0, ApngAnimator.access$getAnim$p(this.this$0));
                AsyncKt.uiThread($receiver, (Function1)((Function1)new Function1<ApngAnimator, Unit>(this){
                    final /* synthetic */ setupAnimationDrawableAndStart.1 this$0;

                    public final void invoke(@NotNull ApngAnimator it) {
                        Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                        ImageView imageView = ApngAnimator.access$getImageView$p(this.this$0.this$0);
                        if (imageView != null) {
                            ImageView imageView2;
                            ImageView $receiver = imageView2 = imageView;
                            ImageView.ScaleType scaleType = ApngAnimator.access$getScaleType$p(this.this$0.this$0);
                            if (scaleType == null) {
                                scaleType = ImageView.ScaleType.FIT_CENTER;
                            }
                            $receiver.setScaleType(scaleType);
                            $receiver.setImageBitmap((Bitmap)ApngAnimator.access$getGeneratedFrame$p(this.this$0.this$0).get(0));
                            $receiver.setImageDrawable((Drawable)ApngAnimator.access$getActiveAnimation$p(this.this$0.this$0));
                        }
                        CustomAnimationDrawable customAnimationDrawable = ApngAnimator.access$getActiveAnimation$p(this.this$0.this$0);
                        if (customAnimationDrawable != null) {
                            customAnimationDrawable.start();
                        }
                        ApngAnimator.access$setPlaying$p(this.this$0.this$0, true);
                        ApngAnimator.access$getDoOnLoaded$p(this.this$0.this$0).invoke((Object)this.this$0.this$0);
                    }
                    {
                        this.this$0 = var1_1;
                        super(1);
                    }
                }));
            }
            {
                this.this$0 = apngAnimator;
                super(1);
            }
        }), (int)1, null);
    }

    /*
     * WARNING - void declaration
     */
    private final void draw(ArrayList<Frame> extractedFrame) {
        this.duration = new ArrayList();
        this.frames = extractedFrame;
        Integer n = this.frames.get(0).getMaxWidth();
        if (n == null) {
            Intrinsics.throwNpe();
        }
        int n2 = n;
        Integer n3 = this.frames.get(0).getMaxHeight();
        if (n3 == null) {
            Intrinsics.throwNpe();
        }
        this.bitmapBuffer = Bitmap.createBitmap((int)n2, (int)n3, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        int n4 = 0;
        int n5 = this.frames.size();
        while (n4 < n5) {
            Frame it;
            void i;
            Intrinsics.checkExpressionValueIsNotNull((Object)this.frames.get((int)i), (String)"frames[i]");
            Integer n6 = this.frames.get(0).getMaxWidth();
            if (n6 == null) {
                Intrinsics.throwNpe();
            }
            int n7 = n6;
            Integer n8 = this.frames.get(0).getMaxHeight();
            if (n8 == null) {
                Intrinsics.throwNpe();
            }
            Bitmap btm = Bitmap.createBitmap((int)n7, (int)n8, (Bitmap.Config)Bitmap.Config.ARGB_8888);
            Canvas canvas = new Canvas(btm);
            Bitmap current = BitmapFactory.decodeByteArray((byte[])it.getByteArray(), (int)0, (int)it.getByteArray().length).copy(Bitmap.Config.ARGB_8888, true);
            canvas.drawBitmap(this.bitmapBuffer, 0.0f, 0.0f, null);
            if (it.getBlend_op() == Utils.Companion.blend_op.APNG_BLEND_OP_SOURCE) {
                Integer n9 = it.getX_offsets();
                if (n9 == null) {
                    Intrinsics.throwNpe();
                }
                float f = n9.intValue();
                Integer n10 = it.getY_offsets();
                if (n10 == null) {
                    Intrinsics.throwNpe();
                }
                float f2 = n10.intValue();
                Integer n11 = it.getX_offsets();
                if (n11 == null) {
                    Intrinsics.throwNpe();
                }
                float f3 = n11.intValue();
                Bitmap bitmap = current;
                Intrinsics.checkExpressionValueIsNotNull((Object)bitmap, (String)"current");
                float f4 = f3 + (float)bitmap.getWidth();
                Integer n12 = it.getY_offsets();
                if (n12 == null) {
                    Intrinsics.throwNpe();
                }
                canvas.drawRect(f, f2, f4, (float)n12.intValue() + (float)current.getHeight(), (Paint)((Function0)draw.1.INSTANCE).invoke());
            }
            Integer n13 = it.getX_offsets();
            if (n13 == null) {
                Intrinsics.throwNpe();
            }
            float f = n13.intValue();
            Integer n14 = it.getY_offsets();
            if (n14 == null) {
                Intrinsics.throwNpe();
            }
            canvas.drawBitmap(current, f, (float)n14.intValue(), null);
            this.generatedFrame.add(btm);
            if (this.frames.get((int)i).getDispose_op() != Utils.Companion.dispose_op.APNG_DISPOSE_OP_PREVIOUS) {
                if (it.getDispose_op() == Utils.Companion.dispose_op.APNG_DISPOSE_OP_BACKGROUND) {
                    Integer n15 = this.frames.get(0).getMaxWidth();
                    if (n15 == null) {
                        Intrinsics.throwNpe();
                    }
                    int n16 = n15;
                    Integer n17 = this.frames.get(0).getMaxHeight();
                    if (n17 == null) {
                        Intrinsics.throwNpe();
                    }
                    Bitmap res = Bitmap.createBitmap((int)n16, (int)n17, (Bitmap.Config)Bitmap.Config.ARGB_8888);
                    Canvas can = new Canvas(res);
                    can.drawBitmap(btm, 0.0f, 0.0f, null);
                    Integer n18 = it.getX_offsets();
                    if (n18 == null) {
                        Intrinsics.throwNpe();
                    }
                    float f5 = n18.intValue();
                    Integer n19 = it.getY_offsets();
                    if (n19 == null) {
                        Intrinsics.throwNpe();
                    }
                    float f6 = n19.intValue();
                    Integer n20 = it.getX_offsets();
                    if (n20 == null) {
                        Intrinsics.throwNpe();
                    }
                    float f7 = (float)n20.intValue() + (float)it.getWidth();
                    Integer n21 = it.getY_offsets();
                    if (n21 == null) {
                        Intrinsics.throwNpe();
                    }
                    can.drawRect(f5, f6, f7, (float)n21.intValue() + (float)it.getHeight(), (Paint)((Function0)draw.2.INSTANCE).invoke());
                    this.bitmapBuffer = res;
                } else {
                    this.bitmapBuffer = btm;
                }
            }
            ArrayList<Float> arrayList = this.duration;
            if (arrayList != null) {
                Float f8 = this.speed;
                arrayList.add(Float.valueOf(it.getDelay() / (f8 != null ? f8.floatValue() : 1.0f)));
            }
            ++i;
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void pause() {
        if (this.isApng) {
            this.setPlaying(false);
            CustomAnimationDrawable animResume = new CustomAnimationDrawable();
            CustomAnimationDrawable customAnimationDrawable = this.activeAnimation;
            if (customAnimationDrawable != null) {
                customAnimationDrawable.stop();
            }
            CustomAnimationDrawable customAnimationDrawable2 = this.activeAnimation;
            if (customAnimationDrawable2 == null) {
                Intrinsics.throwNpe();
            }
            Drawable currentFrame = customAnimationDrawable2.getCurrent();
            ArrayList<Float> dura = new ArrayList<Float>();
            int n = 0;
            CustomAnimationDrawable customAnimationDrawable3 = this.anim;
            Integer n2 = customAnimationDrawable3 != null ? Integer.valueOf(customAnimationDrawable3.getNumberOfFrames()) : null;
            if (n2 == null) {
                Intrinsics.throwNpe();
            }
            int n3 = n2;
            while (n < n3) {
                void i;
                Drawable checkFrame;
                CustomAnimationDrawable customAnimationDrawable4 = this.activeAnimation;
                if (customAnimationDrawable4 == null) {
                    Intrinsics.throwNpe();
                }
                if ((checkFrame = customAnimationDrawable4.getFrame((int)i)) == currentFrame) {
                    Drawable frame;
                    int k;
                    void frameIndex;
                    void var8_8 = frameIndex = i;
                    CustomAnimationDrawable customAnimationDrawable5 = this.activeAnimation;
                    if (customAnimationDrawable5 == null) {
                        Intrinsics.throwNpe();
                    }
                    int n4 = customAnimationDrawable5.getNumberOfFrames();
                    while (var8_8 < n4) {
                        CustomAnimationDrawable customAnimationDrawable6 = this.activeAnimation;
                        if (customAnimationDrawable6 == null) {
                            Intrinsics.throwNpe();
                        }
                        frame = customAnimationDrawable6.getFrame(k);
                        ArrayList<Float> arrayList = this.duration;
                        if (arrayList == null) {
                            Intrinsics.throwNpe();
                        }
                        Float f = this.speed;
                        animResume.addFrame(frame, (int)(((Number)arrayList.get(k)).floatValue() / (f != null ? f.floatValue() : 1.0f)));
                        ArrayList<Float> arrayList2 = this.duration;
                        if (arrayList2 == null) {
                            Intrinsics.throwNpe();
                        }
                        dura.add(arrayList2.get(k));
                        ++k;
                    }
                    n4 = frameIndex;
                    for (k = 0; k < n4; ++k) {
                        CustomAnimationDrawable customAnimationDrawable7 = this.activeAnimation;
                        if (customAnimationDrawable7 == null) {
                            Intrinsics.throwNpe();
                        }
                        frame = customAnimationDrawable7.getFrame(k);
                        ArrayList<Float> arrayList = this.duration;
                        if (arrayList == null) {
                            Intrinsics.throwNpe();
                        }
                        Float f = this.speed;
                        animResume.addFrame(frame, (int)(((Number)arrayList.get(k)).floatValue() / (f != null ? f.floatValue() : 1.0f)));
                        ArrayList<Float> arrayList3 = this.duration;
                        if (arrayList3 == null) {
                            Intrinsics.throwNpe();
                        }
                        dura.add(arrayList3.get(k));
                    }
                    this.activeAnimation = animResume;
                    ImageView imageView = this.imageView;
                    if (imageView != null) {
                        imageView.setImageDrawable((Drawable)this.activeAnimation);
                    }
                    CustomAnimationDrawable customAnimationDrawable8 = this.activeAnimation;
                    if (customAnimationDrawable8 != null) {
                        customAnimationDrawable8.setOnAnimationLoopListener(this.AnimationLoopListener);
                    }
                    ImageView imageView2 = this.imageView;
                    if (imageView2 != null) {
                        imageView2.invalidate();
                    }
                    this.duration = dura;
                    break;
                }
                ++i;
            }
        }
    }

    public final void play() {
        block1: {
            if (!this.isApng) break block1;
            this.setPlaying(true);
            CustomAnimationDrawable customAnimationDrawable = this.activeAnimation;
            if (customAnimationDrawable != null) {
                customAnimationDrawable.start();
            }
        }
    }

    public final void setOnAnimationLoopListener(@NotNull Function0<Unit> animationLoopListener) {
        block1: {
            Intrinsics.checkParameterIsNotNull(animationLoopListener, (String)"animationLoopListener");
            if (!this.isApng) break block1;
            this.AnimationLoopListener = animationLoopListener;
            CustomAnimationDrawable customAnimationDrawable = this.anim;
            if (customAnimationDrawable != null) {
                customAnimationDrawable.setOnAnimationLoopListener(animationLoopListener);
            }
        }
    }

    public final void onLoaded(@NotNull Function1<? super ApngAnimator, Unit> f) {
        Intrinsics.checkParameterIsNotNull(f, (String)"f");
        this.doOnLoaded = f;
    }

    public final void centerCrop(boolean bl) {
        if (this.isApng) {
            if (bl) {
                ImageView imageView = this.imageView;
                if (imageView != null) {
                    imageView.setScaleType(ImageView.ScaleType.CENTER_CROP);
                }
                this.pause();
                this.play();
            } else {
                ImageView imageView = this.imageView;
                if (imageView != null) {
                    imageView.setScaleType((ImageView.ScaleType)null);
                }
                this.pause();
                this.play();
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final CustomAnimationDrawable toAnimationDrawable() {
        if (this.isApng) {
            CustomAnimationDrawable customAnimationDrawable;
            CustomAnimationDrawable $receiver = customAnimationDrawable = new CustomAnimationDrawable();
            int n = 0;
            int n2 = this.generatedFrame.size();
            while (n < n2) {
                void i;
                Bitmap bitmap = this.generatedFrame.get((int)i);
                Intrinsics.checkExpressionValueIsNotNull((Object)bitmap, (String)"generatedFrame[i]");
                Float f = this.speed;
                $receiver.addFrame(new BitmapDrawable(bitmap), (int)((float)((int)this.frames.get((int)i).getDelay()) / (f != null ? f.floatValue() : 1.0f)));
                ++i;
            }
            return customAnimationDrawable;
        }
        throw (Throwable)new NotApngException();
    }

    public ApngAnimator(@NotNull Context context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        this.context = context;
        this.isPlaying = true;
        this.frames = new ArrayList();
        this.generatedFrame = new ArrayList();
        this.doOnLoaded = doOnLoaded.1.INSTANCE;
        this.AnimationLoopListener = AnimationLoopListener.1.INSTANCE;
        this.loadNotApng = true;
        SharedPreferences sharedPreferences = this.context.getSharedPreferences("apngAnimator", 0);
        Intrinsics.checkExpressionValueIsNotNull((Object)sharedPreferences, (String)"context.getSharedPrefere\u2026r\", Context.MODE_PRIVATE)");
        this.sharedPreferences = sharedPreferences;
        this.loadNotApng = this.sharedPreferences.getBoolean("loadNotApng", true);
    }

    public static final /* synthetic */ void access$draw(ApngAnimator $this, @NotNull ArrayList extractedFrame) {
        $this.draw(extractedFrame);
    }

    @Nullable
    public static final /* synthetic */ ImageView.ScaleType access$getScaleType$p(ApngAnimator $this) {
        return $this.scaleType;
    }

    public static final /* synthetic */ void access$setScaleType$p(ApngAnimator $this, @Nullable ImageView.ScaleType scaleType) {
        $this.scaleType = scaleType;
    }

    public static final /* synthetic */ void access$setupAnimationDrawableAndStart(ApngAnimator $this) {
        $this.setupAnimationDrawableAndStart();
    }

    @NotNull
    public static final /* synthetic */ Context access$getContext$p(ApngAnimator $this) {
        return $this.context;
    }

    @Nullable
    public static final /* synthetic */ ImageView access$getImageView$p(ApngAnimator $this) {
        return $this.imageView;
    }

    public static final /* synthetic */ void access$setImageView$p(ApngAnimator $this, @Nullable ImageView imageView) {
        $this.imageView = imageView;
    }

    @Nullable
    public static final /* synthetic */ CustomAnimationDrawable access$getAnim$p(ApngAnimator $this) {
        return $this.anim;
    }

    public static final /* synthetic */ void access$setAnim$p(ApngAnimator $this, @Nullable CustomAnimationDrawable customAnimationDrawable) {
        $this.anim = customAnimationDrawable;
    }

    @NotNull
    public static final /* synthetic */ CustomAnimationDrawable access$toAnimationDrawable(ApngAnimator $this) {
        return $this.toAnimationDrawable();
    }

    @Nullable
    public static final /* synthetic */ CustomAnimationDrawable access$getActiveAnimation$p(ApngAnimator $this) {
        return $this.activeAnimation;
    }

    public static final /* synthetic */ void access$setActiveAnimation$p(ApngAnimator $this, @Nullable CustomAnimationDrawable customAnimationDrawable) {
        $this.activeAnimation = customAnimationDrawable;
    }

    @NotNull
    public static final /* synthetic */ ArrayList access$getGeneratedFrame$p(ApngAnimator $this) {
        return $this.generatedFrame;
    }

    public static final /* synthetic */ boolean access$isPlaying$p(ApngAnimator $this) {
        return $this.isPlaying;
    }

    public static final /* synthetic */ void access$setPlaying$p(ApngAnimator $this, boolean bl) {
        $this.setPlaying(bl);
    }

    @NotNull
    public static final /* synthetic */ Function1 access$getDoOnLoaded$p(ApngAnimator $this) {
        return $this.doOnLoaded;
    }

    public static final /* synthetic */ void access$setDoOnLoaded$p(ApngAnimator $this, @NotNull Function1 function1) {
        $this.doOnLoaded = function1;
    }
}

