/*
 * Decompiled with CFR 0.152.
 */
package oupson.apng.imageUtils;

import android.annotation.SuppressLint;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Color;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Random;

@Deprecated
public class PnnQuantizer {
    private final short SHORT_MAX = Short.MAX_VALUE;
    private final char BYTE_MAX = (char)255;
    private boolean hasTransparency = false;
    private boolean hasSemiTransparency = false;
    protected int width;
    protected int height;
    protected int[] pixels = null;
    private Integer m_transparentColor;
    @SuppressLint(value={"UseSparseArrays"})
    private final HashMap<Integer, short[]> closestMap = new HashMap();

    public PnnQuantizer(String fname) {
        this.fromBitmap(fname);
    }

    public PnnQuantizer(Bitmap bitmap) {
        this.fromBitmap(bitmap);
    }

    private void fromBitmap(Bitmap bitmap) {
        this.width = bitmap.getWidth();
        this.height = bitmap.getHeight();
        this.pixels = new int[this.width * this.height];
        bitmap.getPixels(this.pixels, 0, this.width, 0, 0, this.width, this.height);
    }

    private void fromBitmap(String fname) {
        Bitmap bitmap = BitmapFactory.decodeFile((String)fname);
        this.fromBitmap(bitmap);
    }

    private int getColorIndex(int c) {
        if (this.hasSemiTransparency) {
            return (Color.alpha((int)c) & 0xF0) << 8 | (Color.red((int)c) & 0xF0) << 4 | Color.green((int)c) & 0xF0 | Color.blue((int)c) >> 4;
        }
        if (this.hasTransparency) {
            return (Color.alpha((int)c) & 0x80) << 8 | (Color.red((int)c) & 0xF8) << 7 | (Color.green((int)c) & 0xF8) << 2 | Color.blue((int)c) >> 3;
        }
        return (Color.red((int)c) & 0xF8) << 8 | (Color.green((int)c) & 0xFC) << 3 | Color.blue((int)c) >> 3;
    }

    private double sqr(double value) {
        return value * value;
    }

    private void find_nn(Pnnbin[] bins, int idx) {
        int nn = 0;
        double err = 1.0E100;
        Pnnbin bin1 = bins[idx];
        int n1 = bin1.cnt;
        double wa = bin1.ac;
        double wr = bin1.rc;
        double wg = bin1.gc;
        double wb = bin1.bc;
        int i = bin1.fw;
        while (i != 0) {
            double nerr = this.sqr(bins[i].ac - wa) + this.sqr(bins[i].rc - wr) + this.sqr(bins[i].gc - wg) + this.sqr(bins[i].bc - wb);
            double n2 = bins[i].cnt;
            if (!((nerr *= (double)n1 * n2 / ((double)n1 + n2)) >= err)) {
                err = nerr;
                nn = i;
            }
            i = bins[i].fw;
        }
        bin1.err = err;
        bin1.nn = nn;
    }

    private Integer[] pnnquan(int[] pixels, int nMaxColors, boolean quan_sqrt) {
        int h;
        int l2;
        int l;
        double err;
        int i;
        Pnnbin[] bins = new Pnnbin[65536];
        int[] heap = new int[65537];
        for (int pixel : pixels) {
            int index = this.getColorIndex(pixel);
            if (bins[index] == null) {
                bins[index] = new Pnnbin();
            }
            Pnnbin tb = bins[index];
            tb.ac += (double)Color.alpha((int)pixel);
            tb.rc += (double)Color.red((int)pixel);
            tb.gc += (double)Color.green((int)pixel);
            tb.bc += (double)Color.blue((int)pixel);
            ++tb.cnt;
        }
        int maxbins = 0;
        for (i = 0; i < bins.length; ++i) {
            if (bins[i] == null) continue;
            double d = 1.0 / (double)bins[i].cnt;
            bins[i].ac *= d;
            bins[i].rc *= d;
            bins[i].gc *= d;
            bins[i].bc *= d;
            if (quan_sqrt) {
                bins[i].cnt = (int)Math.sqrt(bins[i].cnt);
            }
            bins[maxbins++] = bins[i];
        }
        for (i = 0; i < maxbins - 1; ++i) {
            bins[i].fw = i + 1;
            bins[i + 1].bk = i;
        }
        int i2 = 0;
        while (i2 < maxbins) {
            this.find_nn(bins, i2);
            err = bins[i2].err;
            l = heap[0] = heap[0] + 1;
            while (l > 1) {
                int n;
                l2 = l >> 1;
                h = heap[l2];
                if (bins[n].err <= err) break;
                heap[l] = h;
                l = l2;
            }
            heap[l] = i2++;
        }
        int extbins = maxbins - nMaxColors;
        int i3 = 0;
        while (i3 < extbins) {
            Pnnbin tb;
            while (true) {
                int b1 = heap[1];
                tb = bins[b1];
                if (tb.tm >= tb.mtm && bins[tb.nn].mtm <= tb.tm) break;
                if (tb.mtm == 65535) {
                    int n = heap[0];
                    heap[0] = n - 1;
                    b1 = heap[1] = heap[n];
                } else {
                    this.find_nn(bins, b1);
                    tb.tm = i3;
                }
                err = bins[b1].err;
                l = 1;
                while ((l2 = l + l) <= heap[0]) {
                    int n;
                    if (l2 < heap[0] && bins[heap[l2]].err > bins[heap[l2 + 1]].err) {
                        ++l2;
                    }
                    h = heap[l2];
                    if (err <= bins[n].err) break;
                    heap[l] = h;
                    l = l2;
                }
                heap[l] = b1;
            }
            Pnnbin nb = bins[tb.nn];
            double n1 = tb.cnt;
            double n2 = nb.cnt;
            double d = 1.0 / (n1 + n2);
            tb.ac = d * (n1 * tb.ac + n2 * nb.ac);
            tb.rc = d * (n1 * tb.rc + n2 * nb.rc);
            tb.gc = d * (n1 * tb.gc + n2 * nb.gc);
            tb.bc = d * (n1 * tb.bc + n2 * nb.bc);
            tb.cnt += nb.cnt;
            tb.mtm = ++i3;
            bins[nb.bk].fw = nb.fw;
            bins[nb.fw].bk = nb.bk;
            nb.mtm = 65535;
        }
        ArrayList<Integer> palette = new ArrayList<Integer>();
        int k = 0;
        int i4 = 0;
        while (true) {
            assert (bins[i4] != null);
            int alpha = (int)Math.rint(bins[i4].ac);
            palette.add(Color.argb((int)alpha, (int)((int)Math.rint(bins[i4].rc)), (int)((int)Math.rint(bins[i4].gc)), (int)((int)Math.rint(bins[i4].bc))));
            if (this.hasTransparency && ((Integer)palette.get(k)).equals(this.m_transparentColor)) {
                Integer temp = (Integer)palette.get(0);
                palette.set(0, (Integer)palette.get(k));
                palette.set(k, temp);
            }
            if ((i4 = bins[i4].fw) == 0) break;
            k = (short)(k + 1);
        }
        return palette.toArray(new Integer[0]);
    }

    private short nearestColorIndex(Integer[] palette, int[] squares3, int c) {
        int k = 0;
        int mindist = Short.MAX_VALUE;
        for (int i = 0; i < palette.length; i = (int)((short)(i + 1))) {
            int bdist;
            int gdist;
            int rdist;
            int c2 = palette[i];
            int adist = Math.abs(Color.alpha((int)c2) - Color.alpha((int)c));
            int curdist = squares3[adist];
            if (curdist > mindist || (curdist += squares3[rdist = Math.abs(Color.red((int)c2) - Color.red((int)c))]) > mindist || (curdist += squares3[gdist = Math.abs(Color.green((int)c2) - Color.green((int)c))]) > mindist || (curdist += squares3[bdist = Math.abs(Color.blue((int)c2) - Color.blue((int)c))]) > mindist) continue;
            mindist = curdist;
            k = i;
        }
        return (short)k;
    }

    private short closestColorIndex(Integer[] palette, int c) {
        short k;
        short[] closest = new short[5];
        short[] got = this.closestMap.get(c);
        if (got == null) {
            closest[3] = Short.MAX_VALUE;
            closest[2] = Short.MAX_VALUE;
            for (k = 0; k < palette.length; k = (short)(k + 1)) {
                int c2 = palette[k];
                closest[4] = (short)(Math.abs(Color.alpha((int)c) - Color.alpha((int)c2)) + Math.abs(Color.red((int)c) - Color.red((int)c2)) + Math.abs(Color.green((int)c) - Color.green((int)c2)) + Math.abs(Color.blue((int)c) - Color.blue((int)c2)));
                if (closest[4] < closest[2]) {
                    closest[1] = closest[0];
                    closest[3] = closest[2];
                    closest[0] = k;
                    closest[2] = closest[4];
                    continue;
                }
                if (closest[4] >= closest[3]) continue;
                closest[1] = k;
                closest[3] = closest[4];
            }
            if (closest[3] == Short.MAX_VALUE) {
                closest[2] = 0;
            }
        } else {
            closest = got;
        }
        Random rand = new Random();
        k = closest[2] == 0 || rand.nextInt(Short.MAX_VALUE) % (closest[3] + closest[2]) <= closest[3] ? closest[0] : closest[1];
        this.closestMap.put(c, closest);
        return k;
    }

    boolean quantize_image(int[] pixels, Integer[] palette, int[] qPixels, boolean dither) {
        int nMaxColors = palette.length;
        int[] sqr_tbl = new int[511];
        for (int i = -255; i <= 255; ++i) {
            sqr_tbl[i + 255] = i * i;
        }
        int[] squares3 = new int[sqr_tbl.length - 255];
        for (int i = 0; i < squares3.length; ++i) {
            squares3[i] = sqr_tbl[i + 255];
        }
        int pixelIndex = 0;
        if (dither) {
            int i;
            boolean odd_scanline = false;
            int DJ = 4;
            int DITHER_MAX = 20;
            int err_len = (this.width + 2) * 4;
            int[] clamp = new int[1024];
            int[] limtb = new int[512];
            short[] erowerr = new short[err_len];
            short[] orowerr = new short[err_len];
            int[] lookup = new int[65536];
            for (i = 0; i < 256; ++i) {
                clamp[i] = 0;
                clamp[i + 256] = (short)i;
                clamp[i + 512] = 255;
                clamp[i + 768] = 255;
                limtb[i] = -20;
                limtb[i + 256] = 20;
            }
            for (i = -20; i <= 20; ++i) {
                limtb[i + 256] = i;
            }
            for (i = 0; i < this.height; i = (int)((short)(i + 1))) {
                short[] row1;
                short[] row0;
                int dir;
                if (odd_scanline) {
                    dir = -1;
                    pixelIndex += this.width - 1;
                    row0 = orowerr;
                    row1 = erowerr;
                } else {
                    dir = 1;
                    row0 = erowerr;
                    row1 = orowerr;
                }
                int cursor0 = 4;
                int cursor1 = this.width * 4;
                row1[cursor1 + 3] = 0;
                row1[cursor1 + 2] = 0;
                row1[cursor1 + 1] = 0;
                row1[cursor1] = 0;
                for (int j = 0; j < this.width; j = (int)((short)(j + 1))) {
                    int c = pixels[pixelIndex];
                    int r_pix = clamp[(row0[cursor0] + 4104 >> 4) + Color.red((int)c)];
                    int g_pix = clamp[(row0[cursor0 + 1] + 4104 >> 4) + Color.green((int)c)];
                    int b_pix = clamp[(row0[cursor0 + 2] + 4104 >> 4) + Color.blue((int)c)];
                    int a_pix = clamp[(row0[cursor0 + 3] + 4104 >> 4) + Color.alpha((int)c)];
                    int c1 = Color.argb((int)a_pix, (int)r_pix, (int)g_pix, (int)b_pix);
                    int offset = this.getColorIndex(c1);
                    if (lookup[offset] == 0) {
                        lookup[offset] = this.nearestColorIndex(palette, squares3, c1) + 1;
                    }
                    int c2 = qPixels[pixelIndex] = palette[lookup[offset] - 1].intValue();
                    r_pix = limtb[r_pix - Color.red((int)c2) + 256];
                    g_pix = limtb[g_pix - Color.green((int)c2) + 256];
                    b_pix = limtb[b_pix - Color.blue((int)c2) + 256];
                    a_pix = limtb[a_pix - Color.alpha((int)c2) + 256];
                    int k = r_pix * 2;
                    row1[cursor1 - 4] = (short)r_pix;
                    int n = cursor1 + 4;
                    row1[n] = (short)(row1[n] + (r_pix += k));
                    int n2 = cursor1;
                    row1[n2] = (short)(row1[n2] + (r_pix += k));
                    int n3 = cursor0 + 4;
                    row0[n3] = (short)(row0[n3] + (r_pix += k));
                    k = g_pix * 2;
                    row1[cursor1 + 1 - 4] = (short)g_pix;
                    int n4 = cursor1 + 1 + 4;
                    row1[n4] = (short)(row1[n4] + (g_pix += k));
                    int n5 = cursor1 + 1;
                    row1[n5] = (short)(row1[n5] + (g_pix += k));
                    int n6 = cursor0 + 1 + 4;
                    row0[n6] = (short)(row0[n6] + (g_pix += k));
                    k = b_pix * 2;
                    row1[cursor1 + 2 - 4] = (short)b_pix;
                    int n7 = cursor1 + 2 + 4;
                    row1[n7] = (short)(row1[n7] + (b_pix += k));
                    int n8 = cursor1 + 2;
                    row1[n8] = (short)(row1[n8] + (b_pix += k));
                    int n9 = cursor0 + 2 + 4;
                    row0[n9] = (short)(row0[n9] + (b_pix += k));
                    k = a_pix * 2;
                    row1[cursor1 + 3 - 4] = (short)a_pix;
                    int n10 = cursor1 + 3 + 4;
                    row1[n10] = (short)(row1[n10] + (a_pix += k));
                    int n11 = cursor1 + 3;
                    row1[n11] = (short)(row1[n11] + (a_pix += k));
                    int n12 = cursor0 + 3 + 4;
                    row0[n12] = (short)(row0[n12] + (a_pix += k));
                    cursor0 += 4;
                    cursor1 -= 4;
                    pixelIndex += dir;
                }
                if (i % 2 == 1) {
                    pixelIndex += this.width + 1;
                }
                odd_scanline = !odd_scanline;
            }
            return true;
        }
        if (this.hasSemiTransparency || nMaxColors < 256) {
            for (int i = 0; i < qPixels.length; ++i) {
                qPixels[i] = palette[this.nearestColorIndex(palette, squares3, pixels[i])];
            }
        } else {
            for (int i = 0; i < qPixels.length; ++i) {
                qPixels[i] = palette[this.closestColorIndex(palette, pixels[i])];
            }
        }
        return true;
    }

    private Bitmap quantize_image(int[] pixels, int[] qPixels) {
        int i;
        int pixelIndex = 0;
        boolean odd_scanline = false;
        int DJ = 4;
        int DITHER_MAX = 20;
        int err_len = (this.width + 2) * 4;
        short[] clamp = new short[1024];
        int[] limtb = new int[512];
        short[] erowerr = new short[err_len];
        short[] orowerr = new short[err_len];
        int[] lookup = new int[65536];
        for (i = 0; i < 256; ++i) {
            clamp[i] = 0;
            clamp[i + 256] = (short)i;
            clamp[i + 512] = 255;
            clamp[i + 768] = 255;
            limtb[i] = -20;
            limtb[i + 256] = 20;
        }
        for (i = -20; i <= 20; ++i) {
            limtb[i + 256] = i;
        }
        for (i = 0; i < this.height; ++i) {
            short[] row1;
            short[] row0;
            int dir;
            if (odd_scanline) {
                dir = -1;
                pixelIndex += this.width - 1;
                row0 = orowerr;
                row1 = erowerr;
            } else {
                dir = 1;
                row0 = erowerr;
                row1 = orowerr;
            }
            int cursor0 = 4;
            int cursor1 = this.width * 4;
            row1[cursor1 + 3] = 0;
            row1[cursor1 + 2] = 0;
            row1[cursor1 + 1] = 0;
            row1[cursor1] = 0;
            for (int j = 0; j < this.width; j = (int)((short)(j + 1))) {
                int c = pixels[pixelIndex];
                int r_pix = clamp[(row0[cursor0] + 4104 >> 4) + Color.red((int)c)];
                int g_pix = clamp[(row0[cursor0 + 1] + 4104 >> 4) + Color.green((int)c)];
                int b_pix = clamp[(row0[cursor0 + 2] + 4104 >> 4) + Color.blue((int)c)];
                int a_pix = clamp[(row0[cursor0 + 3] + 4104 >> 4) + Color.alpha((int)c)];
                int c1 = Color.argb((int)a_pix, (int)r_pix, (int)g_pix, (int)b_pix);
                int offset = this.getColorIndex(c1);
                if (lookup[offset] == 0) {
                    int argb1 = Color.argb((int)255, (int)(Color.red((int)c1) & 0xF8), (int)(Color.green((int)c1) & 0xFC), (int)(Color.blue((int)c1) & 0xF8));
                    if (this.hasSemiTransparency) {
                        argb1 = Color.argb((int)(Color.alpha((int)c1) & 0xF0), (int)(Color.red((int)c1) & 0xF0), (int)(Color.green((int)c1) & 0xF0), (int)(Color.blue((int)c1) & 0xF0));
                    } else if (this.hasTransparency) {
                        argb1 = Color.argb((int)(Color.alpha((int)c1) < 255 ? 0 : 255), (int)(Color.red((int)c1) & 0xF8), (int)(Color.green((int)c1) & 0xF8), (int)(Color.blue((int)c1) & 0xF8));
                    }
                    lookup[offset] = argb1;
                }
                int c2 = qPixels[pixelIndex] = lookup[offset];
                r_pix = limtb[r_pix - Color.red((int)c2) + 256];
                g_pix = limtb[g_pix - Color.green((int)c2) + 256];
                b_pix = limtb[b_pix - Color.blue((int)c2) + 256];
                a_pix = limtb[a_pix - Color.alpha((int)c2) + 256];
                int k = r_pix * 2;
                row1[cursor1 - 4] = (short)r_pix;
                int n = cursor1 + 4;
                row1[n] = (short)(row1[n] + (r_pix += k));
                int n2 = cursor1;
                row1[n2] = (short)(row1[n2] + (r_pix += k));
                int n3 = cursor0 + 4;
                row0[n3] = (short)(row0[n3] + (r_pix += k));
                k = g_pix * 2;
                row1[cursor1 + 1 - 4] = (short)g_pix;
                int n4 = cursor1 + 1 + 4;
                row1[n4] = (short)(row1[n4] + (g_pix += k));
                int n5 = cursor1 + 1;
                row1[n5] = (short)(row1[n5] + (g_pix += k));
                int n6 = cursor0 + 1 + 4;
                row0[n6] = (short)(row0[n6] + (g_pix += k));
                k = b_pix * 2;
                row1[cursor1 + 2 - 4] = (short)b_pix;
                int n7 = cursor1 + 2 + 4;
                row1[n7] = (short)(row1[n7] + (b_pix += k));
                int n8 = cursor1 + 2;
                row1[n8] = (short)(row1[n8] + (b_pix += k));
                int n9 = cursor0 + 2 + 4;
                row0[n9] = (short)(row0[n9] + (b_pix += k));
                k = a_pix * 2;
                row1[cursor1 + 3 - 4] = (short)a_pix;
                int n10 = cursor1 + 3 + 4;
                row1[n10] = (short)(row1[n10] + (a_pix += k));
                int n11 = cursor1 + 3;
                row1[n11] = (short)(row1[n11] + (a_pix += k));
                int n12 = cursor0 + 3 + 4;
                row0[n12] = (short)(row0[n12] + (a_pix += k));
                cursor0 += 4;
                cursor1 -= 4;
                pixelIndex += dir;
            }
            if (i % 2 == 1) {
                pixelIndex += this.width + 1;
            }
            odd_scanline = !odd_scanline;
        }
        if (this.hasTransparency) {
            return Bitmap.createBitmap((int[])qPixels, (int)this.width, (int)this.height, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        }
        return Bitmap.createBitmap((int[])qPixels, (int)this.width, (int)this.height, (Bitmap.Config)Bitmap.Config.RGB_565);
    }

    public Bitmap convert(int nMaxColors, boolean dither) {
        int[] cPixels = new int[this.pixels.length];
        for (int i = 0; i < cPixels.length; ++i) {
            int pixel = this.pixels[i];
            int alfa = pixel >> 24 & 0xFF;
            int r = pixel >> 16 & 0xFF;
            int g = pixel >> 8 & 0xFF;
            int b = pixel & 0xFF;
            cPixels[i] = Color.argb((int)alfa, (int)r, (int)g, (int)b);
            if (alfa >= 255) continue;
            this.hasSemiTransparency = true;
            if (alfa != 0) continue;
            this.hasTransparency = true;
            this.m_transparentColor = cPixels[i];
        }
        if (nMaxColors > 256) {
            int[] qPixels = new int[cPixels.length];
            return this.quantize_image(cPixels, qPixels);
        }
        boolean quan_sqrt = nMaxColors > 255;
        Integer[] palette = new Integer[nMaxColors];
        if (nMaxColors > 2) {
            palette = this.pnnquan(cPixels, nMaxColors, quan_sqrt);
        } else if (this.hasSemiTransparency) {
            palette[0] = Color.argb((int)0, (int)0, (int)0, (int)0);
            palette[1] = -16777216;
        } else {
            palette[0] = -16777216;
            palette[1] = -1;
        }
        int[] qPixels = new int[cPixels.length];
        this.quantize_image(cPixels, palette, qPixels, dither);
        this.closestMap.clear();
        if (this.hasTransparency) {
            return Bitmap.createBitmap((int[])qPixels, (int)this.width, (int)this.height, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        }
        return Bitmap.createBitmap((int[])qPixels, (int)this.width, (int)this.height, (Bitmap.Config)Bitmap.Config.RGB_565);
    }

    private static final class Pnnbin {
        double ac = 0.0;
        double rc = 0.0;
        double gc = 0.0;
        double bc = 0.0;
        double err = 0.0;
        int cnt = 0;
        int nn;
        int fw;
        int bk;
        int tm;
        int mtm;

        private Pnnbin() {
        }
    }
}

