/*
 * Decompiled with CFR 0.152.
 */
package oupson.apng.imageUtils;

import android.graphics.Bitmap;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.zip.CRC32;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Deprecated(message="It now integrated in ApngEncoder and will be removed after the 1.10 release")
@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0015\b\u0007\u0018\u0000 02\u00020\u0001:\u00010B\u0005\u00a2\u0006\u0002\u0010\u0002J,\u0010\u001a\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\u00142\b\b\u0002\u0010\u000b\u001a\u00020\f2\b\b\u0002\u0010\r\u001a\u00020\u00042\b\b\u0002\u0010\u0006\u001a\u00020\u0004J \u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u00102\u0006\u0010\u001e\u001a\u00020\u00042\u0006\u0010\u0019\u001a\u00020\u0004H\u0002J \u0010\u001f\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u00102\u0006\u0010\u001e\u001a\u00020\u00042\u0006\u0010\u0019\u001a\u00020\u0004H\u0002J\u0006\u0010 \u001a\u00020\u001cJ\u0018\u0010!\u001a\u00020\u00102\u0006\u0010\"\u001a\u00020\u00102\u0006\u0010#\u001a\u00020\u0004H\u0002J\u0018\u0010$\u001a\u00020\u00042\u0006\u0010%\u001a\u00020\u00042\u0006\u0010&\u001a\u00020\u0004H\u0002J\u0018\u0010'\u001a\u00020\u00042\u0006\u0010(\u001a\u00020\u00102\u0006\u0010&\u001a\u00020\u0004H\u0002J \u0010'\u001a\u00020\u00042\u0006\u0010(\u001a\u00020\u00102\u0006\u0010)\u001a\u00020\u00042\u0006\u0010&\u001a\u00020\u0004H\u0002J\b\u0010*\u001a\u00020\u001cH\u0002J\b\u0010+\u001a\u00020\u001cH\u0002J\b\u0010,\u001a\u00020\fH\u0002J\u0018\u0010-\u001a\u00020\u00042\u0006\u0010.\u001a\u00020\u00042\u0006\u0010&\u001a\u00020\u0004H\u0002J\u0018\u0010/\u001a\u00020\u00042\u0006\u0010.\u001a\u00020\u00042\u0006\u0010&\u001a\u00020\u0004H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0013\u001a\u0004\u0018\u00010\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0015\u001a\u0004\u0018\u00010\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0017\u001a\u0004\u0018\u00010\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0018\u001a\u0004\u0018\u00010\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00061"}, d2={"Loupson/apng/imageUtils/PngEncoder;", "", "()V", "bytePos", "", "bytesPerPixel", "compressionLevel", "crc", "Ljava/util/zip/CRC32;", "crcValue", "", "encodeAlpha", "", "filter", "height", "idat", "", "iend", "ihdr", "image", "Landroid/graphics/Bitmap;", "leftBytes", "maxPos", "pngBytes", "priorRow", "width", "encode", "filterSub", "", "pixels", "startPos", "filterUp", "release", "resizeByteArray", "array", "newLength", "writeByte", "b", "offset", "writeBytes", "data", "nBytes", "writeEnd", "writeHeader", "writeImageData", "writeInt2", "n", "writeInt4", "Companion", "apng_library_release"})
public final class PngEncoder {
    private boolean encodeAlpha = true;
    private final byte[] ihdr = new byte[]{73, 72, 68, 82};
    private final byte[] idat = new byte[]{73, 68, 65, 84};
    private final byte[] iend = new byte[]{73, 69, 78, 68};
    private Bitmap image;
    private byte[] pngBytes;
    private byte[] priorRow;
    private byte[] leftBytes;
    private int width;
    private int height;
    private int bytePos;
    private int maxPos;
    private CRC32 crc = new CRC32();
    private long crcValue;
    private int filter;
    private int bytesPerPixel;
    private int compressionLevel;
    private static final int FILTER_NONE = 0;
    private static final int FILTER_SUB = 1;
    private static final int FILTER_UP = 2;
    private static final int FILTER_LAST = 2;
    @NotNull
    public static final Companion Companion = new Companion(null);

    @NotNull
    public final byte[] encode(@NotNull Bitmap image, boolean encodeAlpha, int filter, int compressionLevel) {
        int n;
        Intrinsics.checkNotNullParameter((Object)image, (String)"image");
        this.filter = 0;
        if (filter <= 2) {
            this.filter = filter;
        }
        if (0 <= (n = compressionLevel) && 9 >= n) {
            this.compressionLevel = compressionLevel;
        }
        this.encodeAlpha = encodeAlpha;
        byte[] pngIdBytes = new byte[]{-119, 80, 78, 71, 13, 10, 26, 10};
        this.width = image.getWidth();
        this.height = image.getHeight();
        this.image = image;
        this.pngBytes = new byte[(this.width + 1) * this.height * 3 + 200];
        this.maxPos = 0;
        this.bytePos = this.writeBytes(pngIdBytes, 0);
        this.writeHeader();
        if (!this.writeImageData()) {
            throw (Throwable)new Exception();
        }
        this.writeEnd();
        Intrinsics.checkNotNull((Object)this.pngBytes);
        this.pngBytes = this.resizeByteArray(this.pngBytes, this.maxPos);
        Intrinsics.checkNotNull((Object)this.pngBytes);
        return this.pngBytes;
    }

    public static /* synthetic */ byte[] encode$default(PngEncoder pngEncoder, Bitmap bitmap, boolean bl, int n, int n2, int n3, Object object) {
        if ((n3 & 2) != 0) {
            bl = false;
        }
        if ((n3 & 4) != 0) {
            n = 0;
        }
        if ((n3 & 8) != 0) {
            n2 = 0;
        }
        return pngEncoder.encode(bitmap, bl, n, n2);
    }

    private final byte[] resizeByteArray(byte[] array, int newLength) {
        byte[] newArray = new byte[newLength];
        int oldLength = array.length;
        boolean bl = false;
        System.arraycopy(array, 0, newArray, 0, Math.min(oldLength, newLength));
        return newArray;
    }

    public final void release() {
        Bitmap bitmap = this.image;
        if (bitmap != null) {
            bitmap.recycle();
        }
        this.image = null;
        this.pngBytes = null;
    }

    private final int writeBytes(byte[] data, int offset) {
        int n = this.maxPos;
        int n2 = offset + data.length;
        boolean bl = false;
        this.maxPos = Math.max(n, n2);
        int n3 = data.length + offset;
        Intrinsics.checkNotNull((Object)this.pngBytes);
        if (n3 > this.pngBytes.length) {
            Intrinsics.checkNotNull((Object)this.pngBytes);
            Intrinsics.checkNotNull((Object)this.pngBytes);
            n = 1000;
            n2 = data.length;
            bl = false;
            this.pngBytes = this.resizeByteArray(this.pngBytes, this.pngBytes.length + Math.max(n, n2));
        }
        Intrinsics.checkNotNull((Object)this.pngBytes);
        System.arraycopy(data, 0, this.pngBytes, offset, data.length);
        return offset + data.length;
    }

    private final int writeBytes(byte[] data, int nBytes, int offset) {
        int n = this.maxPos;
        int n2 = offset + nBytes;
        boolean bl = false;
        this.maxPos = Math.max(n, n2);
        Intrinsics.checkNotNull((Object)this.pngBytes);
        if (nBytes + offset > this.pngBytes.length) {
            Intrinsics.checkNotNull((Object)this.pngBytes);
            Intrinsics.checkNotNull((Object)this.pngBytes);
            n = 1000;
            n2 = 0;
            this.pngBytes = this.resizeByteArray(this.pngBytes, this.pngBytes.length + Math.max(n, nBytes));
        }
        Intrinsics.checkNotNull((Object)this.pngBytes);
        System.arraycopy(data, 0, this.pngBytes, offset, nBytes);
        return offset + nBytes;
    }

    private final int writeInt2(int n, int offset) {
        byte[] temp = new byte[]{(byte)(n >> 8 & 0xFF), (byte)(n & 0xFF)};
        return this.writeBytes(temp, offset);
    }

    private final int writeInt4(int n, int offset) {
        byte[] temp = new byte[]{(byte)(n >> 24 & 0xFF), (byte)(n >> 16 & 0xFF), (byte)(n >> 8 & 0xFF), (byte)(n & 0xFF)};
        return this.writeBytes(temp, offset);
    }

    private final int writeByte(int b, int offset) {
        byte[] temp = new byte[]{(byte)b};
        return this.writeBytes(temp, offset);
    }

    private final void writeHeader() {
        int startPos = this.bytePos = this.writeInt4(13, this.bytePos);
        this.bytePos = this.writeBytes(this.ihdr, this.bytePos);
        Bitmap bitmap = this.image;
        Intrinsics.checkNotNull((Object)bitmap);
        this.width = bitmap.getWidth();
        Bitmap bitmap2 = this.image;
        Intrinsics.checkNotNull((Object)bitmap2);
        this.height = bitmap2.getHeight();
        this.bytePos = this.writeInt4(this.width, this.bytePos);
        this.bytePos = this.writeInt4(this.height, this.bytePos);
        this.bytePos = this.writeByte(8, this.bytePos);
        this.bytePos = this.writeByte(this.encodeAlpha ? 6 : 2, this.bytePos);
        this.bytePos = this.writeByte(0, this.bytePos);
        this.bytePos = this.writeByte(0, this.bytePos);
        this.bytePos = this.writeByte(0, this.bytePos);
        this.crc.reset();
        Intrinsics.checkNotNull((Object)this.pngBytes);
        this.crc.update(this.pngBytes, startPos, this.bytePos - startPos);
        this.crcValue = this.crc.getValue();
        this.bytePos = this.writeInt4((int)this.crcValue, this.bytePos);
    }

    private final void filterSub(byte[] pixels, int startPos, int width) {
        int offset = this.bytesPerPixel;
        int actualStart = startPos + offset;
        int nBytes = width * this.bytesPerPixel;
        int leftInsert = offset;
        int leftExtract = 0;
        for (int i = actualStart; i < startPos + nBytes; ++i) {
            Intrinsics.checkNotNull((Object)this.leftBytes);
            this.leftBytes[leftInsert] = pixels[i];
            byte by = pixels[i];
            Intrinsics.checkNotNull((Object)this.leftBytes);
            pixels[i] = (byte)((by - this.leftBytes[leftExtract]) % 256);
            leftInsert = (leftInsert + 1) % 15;
            leftExtract = (leftExtract + 1) % 15;
        }
    }

    private final void filterUp(byte[] pixels, int startPos, int width) {
        int nBytes = width * this.bytesPerPixel;
        byte currentByte = 0;
        for (int i = 0; i < nBytes; ++i) {
            currentByte = pixels[startPos + i];
            byte by = pixels[startPos + i];
            Intrinsics.checkNotNull((Object)this.priorRow);
            pixels[startPos + i] = (byte)((by - this.priorRow[i]) % 256);
            Intrinsics.checkNotNull((Object)this.priorRow);
            this.priorRow[i] = currentByte;
        }
    }

    /*
     * WARNING - void declaration
     */
    private final boolean writeImageData() {
        int startRow = 0;
        int nRows = 0;
        byte[] scanLines = null;
        int scanPos = 0;
        int startPos = 0;
        byte[] compressedLines = null;
        int nCompressed = 0;
        this.bytesPerPixel = this.encodeAlpha ? 4 : 3;
        Deflater scrunch = new Deflater(this.compressionLevel);
        ByteArrayOutputStream outBytes = new ByteArrayOutputStream(1024);
        DeflaterOutputStream compBytes = new DeflaterOutputStream((OutputStream)outBytes, scrunch);
        try {
            for (int rowsLeft = this.height; rowsLeft > 0; rowsLeft -= nRows) {
                int n = Short.MAX_VALUE / (this.width * (this.bytesPerPixel + 1));
                int n2 = 0;
                nRows = Math.min(n, rowsLeft);
                n = 1;
                n2 = 0;
                nRows = Math.max(nRows, n);
                int[] pixels = new int[this.width * nRows];
                Bitmap bitmap = this.image;
                Intrinsics.checkNotNull((Object)bitmap);
                bitmap.getPixels(pixels, 0, this.width, 0, startRow, this.width, nRows);
                scanLines = new byte[this.width * nRows * this.bytesPerPixel + nRows];
                if (this.filter == 1) {
                    this.leftBytes = new byte[16];
                }
                if (this.filter == 2) {
                    this.priorRow = new byte[this.width * this.bytesPerPixel];
                }
                scanPos = 0;
                startPos = 1;
                n2 = 0;
                int n3 = this.width * nRows;
                while (n2 < n3) {
                    void i;
                    if (i % this.width == false) {
                        scanLines[scanPos++] = (byte)this.filter;
                        startPos = scanPos;
                    }
                    scanLines[scanPos++] = (byte)(pixels[i] >> 16 & 0xFF);
                    scanLines[scanPos++] = (byte)(pixels[i] >> 8 & 0xFF);
                    scanLines[scanPos++] = (byte)(pixels[i] & 0xFF);
                    if (this.encodeAlpha) {
                        scanLines[scanPos++] = (byte)(pixels[i] >> 24 & 0xFF);
                    }
                    if (i % this.width == this.width - 1 && this.filter != 0) {
                        if (this.filter == 1) {
                            this.filterSub(scanLines, startPos, this.width);
                        }
                        if (this.filter == 2) {
                            this.filterUp(scanLines, startPos, this.width);
                        }
                    }
                    ++i;
                }
                compBytes.write(scanLines, 0, scanPos);
                startRow += nRows;
            }
            compBytes.close();
            byte[] byArray = outBytes.toByteArray();
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"outBytes.toByteArray()");
            compressedLines = byArray;
            nCompressed = compressedLines.length;
            this.crc.reset();
            this.bytePos = this.writeInt4(nCompressed, this.bytePos);
            this.bytePos = this.writeBytes(this.idat, this.bytePos);
            this.crc.update(this.idat);
            this.bytePos = this.writeBytes(compressedLines, nCompressed, this.bytePos);
            this.crc.update(compressedLines, 0, nCompressed);
            this.crcValue = this.crc.getValue();
            this.bytePos = this.writeInt4((int)this.crcValue, this.bytePos);
            scrunch.finish();
            scrunch.end();
            return true;
        }
        catch (IOException e) {
            System.err.println(e.toString());
            return false;
        }
    }

    private final void writeEnd() {
        this.bytePos = this.writeInt4(0, this.bytePos);
        this.bytePos = this.writeBytes(this.iend, this.bytePos);
        this.crc.reset();
        this.crc.update(this.iend);
        this.crcValue = this.crc.getValue();
        this.bytePos = this.writeInt4((int)this.crcValue, this.bytePos);
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Loupson/apng/imageUtils/PngEncoder$Companion;", "", "()V", "FILTER_LAST", "", "FILTER_NONE", "FILTER_SUB", "FILTER_UP", "apng_library_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

