/*
 * Decompiled with CFR 0.152.
 */
package oupson.apng.imageUtils;

import android.graphics.Bitmap;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.zip.CRC32;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\u0018\u0000 \u00032\u00020\u0001:\u0001\u0003B\u0005\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0004"}, d2={"Loupson/apng/imageUtils/PngEncoder;", "", "()V", "Companion", "apng_library_release"})
public final class PngEncoder {
    private static boolean encodeAlpha;
    private static final int FILTER_NONE = 0;
    private static final int FILTER_SUB = 1;
    private static final int FILTER_UP = 2;
    private static final int FILTER_LAST = 2;
    private static final byte[] IHDR;
    private static final byte[] IDAT;
    private static final byte[] IEND;
    private static Bitmap image;
    private static byte[] pngBytes;
    private static byte[] priorRow;
    private static byte[] leftBytes;
    private static int width;
    private static int height;
    private static int bytePos;
    private static int maxPos;
    private static CRC32 crc;
    private static long crcValue;
    private static int filter;
    private static int bytesPerPixel;
    private static int compressionLevel;
    public static final Companion Companion;

    static {
        Companion = new Companion(null);
        encodeAlpha = true;
        IHDR = new byte[]{73, 72, 68, 82};
        IDAT = new byte[]{73, 68, 65, 84};
        IEND = new byte[]{73, 69, 78, 68};
        crc = new CRC32();
    }

    public static final /* synthetic */ void access$setCrc$cp(CRC32 cRC32) {
        crc = cRC32;
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u0012\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0013\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J,\u0010\u001e\u001a\u00020\t2\u0006\u0010\u0017\u001a\u00020\u00182\b\b\u0002\u0010\u0013\u001a\u00020\u00142\b\b\u0002\u0010\u0015\u001a\u00020\u00042\b\b\u0002\u0010\u000e\u001a\u00020\u0004J \u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\t2\u0006\u0010\"\u001a\u00020\u00042\u0006\u0010\u001d\u001a\u00020\u0004H\u0002J \u0010#\u001a\u00020 2\u0006\u0010!\u001a\u00020\t2\u0006\u0010\"\u001a\u00020\u00042\u0006\u0010\u001d\u001a\u00020\u0004H\u0002J\u0018\u0010$\u001a\u00020\t2\u0006\u0010%\u001a\u00020\t2\u0006\u0010&\u001a\u00020\u0004H\u0002J\u0018\u0010'\u001a\u00020\u00042\u0006\u0010(\u001a\u00020\u00042\u0006\u0010)\u001a\u00020\u0004H\u0002J\u0018\u0010*\u001a\u00020\u00042\u0006\u0010+\u001a\u00020\t2\u0006\u0010)\u001a\u00020\u0004H\u0002J \u0010*\u001a\u00020\u00042\u0006\u0010+\u001a\u00020\t2\u0006\u0010,\u001a\u00020\u00042\u0006\u0010)\u001a\u00020\u0004H\u0002J\b\u0010-\u001a\u00020 H\u0002J\b\u0010.\u001a\u00020 H\u0002J\b\u0010/\u001a\u00020\u0014H\u0002J\u0018\u00100\u001a\u00020\u00042\u0006\u00101\u001a\u00020\u00042\u0006\u0010)\u001a\u00020\u0004H\u0002J\u0018\u00102\u001a\u00020\u00042\u0006\u00101\u001a\u00020\u00042\u0006\u0010)\u001a\u00020\u0004H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0017\u001a\u0004\u0018\u00010\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0019\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001b\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001c\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00063"}, d2={"Loupson/apng/imageUtils/PngEncoder$Companion;", "", "()V", "FILTER_LAST", "", "FILTER_NONE", "FILTER_SUB", "FILTER_UP", "IDAT", "", "IEND", "IHDR", "bytePos", "bytesPerPixel", "compressionLevel", "crc", "Ljava/util/zip/CRC32;", "crcValue", "", "encodeAlpha", "", "filter", "height", "image", "Landroid/graphics/Bitmap;", "leftBytes", "maxPos", "pngBytes", "priorRow", "width", "encode", "filterSub", "", "pixels", "startPos", "filterUp", "resizeByteArray", "array", "newLength", "writeByte", "b", "offset", "writeBytes", "data", "nBytes", "writeEnd", "writeHeader", "writeImageData", "writeInt2", "n", "writeInt4", "apng_library_release"})
    public static final class Companion {
        @NotNull
        public final byte[] encode(@NotNull Bitmap image, boolean encodeAlpha, int filter, int compressionLevel) {
            byte[] byArray;
            int n;
            Intrinsics.checkParameterIsNotNull((Object)image, (String)"image");
            filter = 0;
            if (filter <= 2) {
                filter = filter;
            }
            if (0 <= (n = compressionLevel) && 9 >= n) {
                compressionLevel = compressionLevel;
            }
            encodeAlpha = encodeAlpha;
            byte[] pngIdBytes = new byte[]{-119, 80, 78, 71, 13, 10, 26, 10};
            width = image.getWidth();
            height = image.getHeight();
            image = image;
            pngBytes = new byte[(width + 1) * height * 3 + 200];
            maxPos = 0;
            bytePos = this.writeBytes(pngIdBytes, 0);
            this.writeHeader();
            if (this.writeImageData()) {
                this.writeEnd();
                byArray = pngBytes;
                if (byArray == null) {
                    Intrinsics.throwNpe();
                }
            } else {
                throw (Throwable)new Exception();
            }
            pngBytes = this.resizeByteArray(byArray, maxPos);
            byte[] byArray2 = pngBytes;
            if (byArray2 == null) {
                Intrinsics.throwNpe();
            }
            return byArray2;
        }

        public static /* synthetic */ byte[] encode$default(Companion companion, Bitmap bitmap, boolean bl, int n, int n2, int n3, Object object) {
            if ((n3 & 2) != 0) {
                bl = false;
            }
            if ((n3 & 4) != 0) {
                n = 0;
            }
            if ((n3 & 8) != 0) {
                n2 = 0;
            }
            return companion.encode(bitmap, bl, n, n2);
        }

        private final byte[] resizeByteArray(byte[] array, int newLength) {
            byte[] newArray = new byte[newLength];
            int oldLength = array.length;
            int n = 0;
            byte[] byArray = newArray;
            int n2 = 0;
            byte[] byArray2 = array;
            boolean bl = false;
            int n3 = Math.min(oldLength, newLength);
            System.arraycopy(byArray2, n2, byArray, n, n3);
            return newArray;
        }

        private final int writeBytes(byte[] data, int offset) {
            int n = maxPos;
            int n2 = offset + data.length;
            boolean bl = false;
            maxPos = Math.max(n, n2);
            int n3 = data.length + offset;
            byte[] byArray = pngBytes;
            if (byArray == null) {
                Intrinsics.throwNpe();
            }
            if (n3 > byArray.length) {
                byte[] byArray2 = pngBytes;
                if (byArray2 == null) {
                    Intrinsics.throwNpe();
                }
                byte[] byArray3 = pngBytes;
                if (byArray3 == null) {
                    Intrinsics.throwNpe();
                }
                n = 1000;
                n2 = data.length;
                int n4 = byArray3.length;
                byte[] byArray4 = byArray2;
                Companion companion = this;
                bl = false;
                int n5 = Math.max(n, n2);
                pngBytes = companion.resizeByteArray(byArray4, n4 + n5);
            }
            byte[] byArray5 = pngBytes;
            if (byArray5 == null) {
                Intrinsics.throwNpe();
            }
            System.arraycopy(data, 0, byArray5, offset, data.length);
            return offset + data.length;
        }

        private final int writeBytes(byte[] data, int nBytes, int offset) {
            int n = maxPos;
            int n2 = offset + nBytes;
            boolean bl = false;
            maxPos = Math.max(n, n2);
            byte[] byArray = pngBytes;
            if (byArray == null) {
                Intrinsics.throwNpe();
            }
            if (nBytes + offset > byArray.length) {
                byte[] byArray2 = pngBytes;
                if (byArray2 == null) {
                    Intrinsics.throwNpe();
                }
                byte[] byArray3 = pngBytes;
                if (byArray3 == null) {
                    Intrinsics.throwNpe();
                }
                n = 1000;
                int n3 = byArray3.length;
                byte[] byArray4 = byArray2;
                Companion companion = this;
                n2 = 0;
                int n4 = Math.max(n, nBytes);
                pngBytes = companion.resizeByteArray(byArray4, n3 + n4);
            }
            byte[] byArray5 = pngBytes;
            if (byArray5 == null) {
                Intrinsics.throwNpe();
            }
            System.arraycopy(data, 0, byArray5, offset, nBytes);
            return offset + nBytes;
        }

        private final int writeInt2(int n, int offset) {
            byte[] temp = new byte[]{(byte)(n >> 8 & 0xFF), (byte)(n & 0xFF)};
            return this.writeBytes(temp, offset);
        }

        private final int writeInt4(int n, int offset) {
            byte[] temp = new byte[]{(byte)(n >> 24 & 0xFF), (byte)(n >> 16 & 0xFF), (byte)(n >> 8 & 0xFF), (byte)(n & 0xFF)};
            return this.writeBytes(temp, offset);
        }

        private final int writeByte(int b, int offset) {
            byte[] temp = new byte[]{(byte)b};
            return this.writeBytes(temp, offset);
        }

        private final void writeHeader() {
            bytePos = this.writeInt4(13, bytePos);
            int startPos = bytePos;
            bytePos = this.writeBytes(IHDR, bytePos);
            Bitmap bitmap = image;
            if (bitmap == null) {
                Intrinsics.throwNpe();
            }
            width = bitmap.getWidth();
            Bitmap bitmap2 = image;
            if (bitmap2 == null) {
                Intrinsics.throwNpe();
            }
            height = bitmap2.getHeight();
            bytePos = this.writeInt4(width, bytePos);
            bytePos = this.writeInt4(height, bytePos);
            bytePos = this.writeByte(8, bytePos);
            bytePos = this.writeByte(encodeAlpha ? 6 : 2, bytePos);
            bytePos = this.writeByte(0, bytePos);
            bytePos = this.writeByte(0, bytePos);
            bytePos = this.writeByte(0, bytePos);
            crc.reset();
            CRC32 cRC32 = crc;
            byte[] byArray = pngBytes;
            if (byArray == null) {
                Intrinsics.throwNpe();
            }
            cRC32.update(byArray, startPos, bytePos - startPos);
            crcValue = crc.getValue();
            bytePos = this.writeInt4((int)crcValue, bytePos);
        }

        private final void filterSub(byte[] pixels, int startPos, int width) {
            int offset = bytesPerPixel;
            int actualStart = startPos + offset;
            int nBytes = width * bytesPerPixel;
            int leftInsert = offset;
            int leftExtract = 0;
            for (int i = actualStart; i < startPos + nBytes; ++i) {
                byte[] byArray = leftBytes;
                if (byArray == null) {
                    Intrinsics.throwNpe();
                }
                byArray[leftInsert] = pixels[i];
                byte by = pixels[i];
                byte[] byArray2 = leftBytes;
                if (byArray2 == null) {
                    Intrinsics.throwNpe();
                }
                pixels[i] = (byte)((by - byArray2[leftExtract]) % 256);
                leftInsert = (leftInsert + 1) % 15;
                leftExtract = (leftExtract + 1) % 15;
            }
        }

        private final void filterUp(byte[] pixels, int startPos, int width) {
            int nBytes = width * bytesPerPixel;
            byte currentByte = 0;
            for (int i = 0; i < nBytes; ++i) {
                currentByte = pixels[startPos + i];
                byte by = pixels[startPos + i];
                byte[] byArray = priorRow;
                if (byArray == null) {
                    Intrinsics.throwNpe();
                }
                pixels[startPos + i] = (byte)((by - byArray[i]) % 256);
                byte[] byArray2 = priorRow;
                if (byArray2 == null) {
                    Intrinsics.throwNpe();
                }
                byArray2[i] = currentByte;
            }
        }

        /*
         * WARNING - void declaration
         */
        private final boolean writeImageData() {
            int startRow = 0;
            int nRows = 0;
            byte[] scanLines = null;
            int scanPos = 0;
            int startPos = 0;
            byte[] compressedLines = null;
            int nCompressed = 0;
            bytesPerPixel = encodeAlpha ? 4 : 3;
            Deflater scrunch = new Deflater(compressionLevel);
            ByteArrayOutputStream outBytes = new ByteArrayOutputStream(1024);
            DeflaterOutputStream compBytes = new DeflaterOutputStream((OutputStream)outBytes, scrunch);
            try {
                for (int rowsLeft = height; rowsLeft > 0; rowsLeft -= nRows) {
                    int n = Short.MAX_VALUE / (width * (bytesPerPixel + 1));
                    int n2 = 0;
                    nRows = Math.min(n, rowsLeft);
                    n = 1;
                    n2 = 0;
                    nRows = Math.max(nRows, n);
                    int[] pixels = new int[width * nRows];
                    Bitmap bitmap = image;
                    if (bitmap == null) {
                        Intrinsics.throwNpe();
                    }
                    bitmap.getPixels(pixels, 0, width, 0, startRow, width, nRows);
                    scanLines = new byte[width * nRows * bytesPerPixel + nRows];
                    if (filter == 1) {
                        leftBytes = new byte[16];
                    }
                    if (filter == 2) {
                        priorRow = new byte[width * bytesPerPixel];
                    }
                    scanPos = 0;
                    startPos = 1;
                    n2 = 0;
                    int n3 = width * nRows;
                    while (n2 < n3) {
                        void i;
                        if (i % width == false) {
                            scanLines[scanPos++] = (byte)filter;
                            startPos = scanPos;
                        }
                        scanLines[scanPos++] = (byte)(pixels[i] >> 16 & 0xFF);
                        scanLines[scanPos++] = (byte)(pixels[i] >> 8 & 0xFF);
                        scanLines[scanPos++] = (byte)(pixels[i] & 0xFF);
                        if (encodeAlpha) {
                            scanLines[scanPos++] = (byte)(pixels[i] >> 24 & 0xFF);
                        }
                        if (i % width == width - 1 && filter != 0) {
                            if (filter == 1) {
                                this.filterSub(scanLines, startPos, width);
                            }
                            if (filter == 2) {
                                this.filterUp(scanLines, startPos, width);
                            }
                        }
                        ++i;
                    }
                    compBytes.write(scanLines, 0, scanPos);
                    startRow += nRows;
                }
                compBytes.close();
                byte[] byArray = outBytes.toByteArray();
                Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"outBytes.toByteArray()");
                compressedLines = byArray;
                nCompressed = compressedLines.length;
                crc.reset();
                bytePos = this.writeInt4(nCompressed, bytePos);
                bytePos = this.writeBytes(IDAT, bytePos);
                crc.update(IDAT);
                bytePos = this.writeBytes(compressedLines, nCompressed, bytePos);
                crc.update(compressedLines, 0, nCompressed);
                crcValue = crc.getValue();
                bytePos = this.writeInt4((int)crcValue, bytePos);
                scrunch.finish();
                scrunch.end();
                return true;
            }
            catch (IOException e) {
                System.err.println(e.toString());
                return false;
            }
        }

        private final void writeEnd() {
            bytePos = this.writeInt4(0, bytePos);
            bytePos = this.writeBytes(IEND, bytePos);
            crc.reset();
            crc.update(IEND);
            crcValue = crc.getValue();
            bytePos = this.writeInt4((int)crcValue, bytePos);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

