/*
 * Decompiled with CFR 0.152.
 */
package oupson.apng.decoder;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Canvas;
import android.graphics.ImageDecoder;
import android.graphics.Paint;
import android.graphics.drawable.AnimatedImageDrawable;
import android.graphics.drawable.AnimationDrawable;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.os.Build;
import android.widget.ImageView;
import androidx.annotation.RawRes;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.net.URL;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.zip.CRC32;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.io.ByteStreamsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.GlobalScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import oupson.apng.APNGDisassembler;
import oupson.apng.Loader;
import oupson.apng.chunks.IHDR;
import oupson.apng.chunks.fcTL;
import oupson.apng.decoder.ApngDecoder;
import oupson.apng.decoder.ApngDecoder$Companion$WhenMappings;
import oupson.apng.exceptions.BadApng;
import oupson.apng.exceptions.BadCRC;
import oupson.apng.utils.Utils;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0004\u0018\u0000 \u00042\u00020\u0001:\u0002\u0003\u0004B\u0005\u00a2\u0006\u0002\u0010\u0002\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\u0005"}, d2={"Loupson/apng/decoder/ApngDecoder;", "", "()V", "Callback", "Companion", "apng_library_release"})
public final class ApngDecoder {
    private static final String TAG = "ApngDecoder";
    private static final Lazy clearPaint$delegate;
    public static final Companion Companion;

    static {
        Companion = new Companion(null);
        clearPaint$delegate = LazyKt.lazy((Function0)Companion.clearPaint.2.INSTANCE);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final Drawable decodeApng(@NotNull Context context, @NotNull InputStream inStream, float speed) {
        return Companion.decodeApng(context, inStream, speed);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final Drawable decodeApng(@NotNull Context context, @NotNull InputStream inStream) {
        return oupson.apng.decoder.ApngDecoder$Companion.decodeApng$default(Companion, context, inStream, 0.0f, 4, null);
    }

    @JvmStatic
    @NotNull
    public static final Drawable decodeApng(@NotNull Context context, @NotNull File file, float speed) {
        return Companion.decodeApng(context, file, speed);
    }

    @JvmStatic
    @NotNull
    public static final Drawable decodeApng(@NotNull Context context, @NotNull Uri uri, float speed) {
        return Companion.decodeApng(context, uri, speed);
    }

    @JvmStatic
    @NotNull
    public static final Drawable decodeApng(@NotNull Context context, @RawRes int res, float speed) {
        return Companion.decodeApng(context, res, speed);
    }

    @JvmStatic
    @Nullable
    public static final Object decodeApng(@NotNull Context this_, @NotNull URL context, float url, @NotNull Continuation<? super Drawable> speed) {
        return Companion.decodeApng(this_, context, url, speed);
    }

    @JvmStatic
    @JvmOverloads
    public static final void decodeApngAsyncInto(@NotNull Context context, @NotNull File file, @NotNull ImageView imageView, float speed, @Nullable Callback callback) {
        Companion.decodeApngAsyncInto(context, file, imageView, speed, callback);
    }

    @JvmStatic
    @JvmOverloads
    public static final void decodeApngAsyncInto(@NotNull Context context, @NotNull File file, @NotNull ImageView imageView, float speed) {
        oupson.apng.decoder.ApngDecoder$Companion.decodeApngAsyncInto$default(Companion, context, file, imageView, speed, null, 16, null);
    }

    @JvmStatic
    @JvmOverloads
    public static final void decodeApngAsyncInto(@NotNull Context context, @NotNull File file, @NotNull ImageView imageView) {
        oupson.apng.decoder.ApngDecoder$Companion.decodeApngAsyncInto$default(Companion, context, file, imageView, 0.0f, null, 24, null);
    }

    @JvmStatic
    @JvmOverloads
    public static final void decodeApngAsyncInto(@NotNull Context context, @NotNull Uri uri, @NotNull ImageView imageView, float speed, @Nullable Callback callback) {
        Companion.decodeApngAsyncInto(context, uri, imageView, speed, callback);
    }

    @JvmStatic
    @JvmOverloads
    public static final void decodeApngAsyncInto(@NotNull Context context, @NotNull Uri uri, @NotNull ImageView imageView, float speed) {
        oupson.apng.decoder.ApngDecoder$Companion.decodeApngAsyncInto$default(Companion, context, uri, imageView, speed, null, 16, null);
    }

    @JvmStatic
    @JvmOverloads
    public static final void decodeApngAsyncInto(@NotNull Context context, @NotNull Uri uri, @NotNull ImageView imageView) {
        oupson.apng.decoder.ApngDecoder$Companion.decodeApngAsyncInto$default(Companion, context, uri, imageView, 0.0f, null, 24, null);
    }

    @JvmStatic
    @JvmOverloads
    public static final void decodeApngAsyncInto(@NotNull Context context, @RawRes int res, @NotNull ImageView imageView, float speed, @Nullable Callback callback) {
        Companion.decodeApngAsyncInto(context, res, imageView, speed, callback);
    }

    @JvmStatic
    @JvmOverloads
    public static final void decodeApngAsyncInto(@NotNull Context context, @RawRes int res, @NotNull ImageView imageView, float speed) {
        oupson.apng.decoder.ApngDecoder$Companion.decodeApngAsyncInto$default(Companion, context, res, imageView, speed, null, 16, null);
    }

    @JvmStatic
    @JvmOverloads
    public static final void decodeApngAsyncInto(@NotNull Context context, @RawRes int res, @NotNull ImageView imageView) {
        oupson.apng.decoder.ApngDecoder$Companion.decodeApngAsyncInto$default(Companion, context, res, imageView, 0.0f, null, 24, null);
    }

    @JvmStatic
    @JvmOverloads
    public static final void decodeApngAsyncInto(@NotNull Context context, @NotNull URL url, @NotNull ImageView imageView, float speed, @Nullable Callback callback) {
        Companion.decodeApngAsyncInto(context, url, imageView, speed, callback);
    }

    @JvmStatic
    @JvmOverloads
    public static final void decodeApngAsyncInto(@NotNull Context context, @NotNull URL url, @NotNull ImageView imageView, float speed) {
        oupson.apng.decoder.ApngDecoder$Companion.decodeApngAsyncInto$default(Companion, context, url, imageView, speed, null, 16, null);
    }

    @JvmStatic
    @JvmOverloads
    public static final void decodeApngAsyncInto(@NotNull Context context, @NotNull URL url, @NotNull ImageView imageView) {
        oupson.apng.decoder.ApngDecoder$Companion.decodeApngAsyncInto$default(Companion, context, url, imageView, 0.0f, null, 24, null);
    }

    @JvmStatic
    @JvmOverloads
    public static final void decodeApngAsyncInto(@NotNull Context context, @NotNull String string, @NotNull ImageView imageView, float speed, @Nullable Callback callback) {
        Companion.decodeApngAsyncInto(context, string, imageView, speed, callback);
    }

    @JvmStatic
    @JvmOverloads
    public static final void decodeApngAsyncInto(@NotNull Context context, @NotNull String string, @NotNull ImageView imageView, float speed) {
        oupson.apng.decoder.ApngDecoder$Companion.decodeApngAsyncInto$default(Companion, context, string, imageView, speed, null, 16, null);
    }

    @JvmStatic
    @JvmOverloads
    public static final void decodeApngAsyncInto(@NotNull Context context, @NotNull String string, @NotNull ImageView imageView) {
        oupson.apng.decoder.ApngDecoder$Companion.decodeApngAsyncInto$default(Companion, context, string, imageView, 0.0f, null, 24, null);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\bf\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H&J\u0010\u0010\u0006\u001a\u00020\u00032\u0006\u0010\u0007\u001a\u00020\bH&\u00a8\u0006\t"}, d2={"Loupson/apng/decoder/ApngDecoder$Callback;", "", "onError", "", "error", "Ljava/lang/Exception;", "onSuccess", "drawable", "Landroid/graphics/drawable/Drawable;", "apng_library_release"})
    public static interface Callback {
        public void onSuccess(@NotNull Drawable var1);

        public void onError(@NotNull Exception var1);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\"\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\b\b\u0002\u0010\u0011\u001a\u00020\u0012H\u0007J\"\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0013\u001a\u00020\u00142\b\b\u0002\u0010\u0011\u001a\u00020\u0012H\u0007J\"\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0015\u001a\u00020\u00162\b\b\u0002\u0010\u0011\u001a\u00020\u0012H\u0007J+\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0017\u001a\u00020\u00182\b\b\u0002\u0010\u0011\u001a\u00020\u0012H\u0087@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0019J$\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\b\b\u0001\u0010\u001a\u001a\u00020\u001b2\b\b\u0002\u0010\u0011\u001a\u00020\u0012H\u0007J6\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u001e\u001a\u00020\u001f2\b\b\u0002\u0010\u0011\u001a\u00020\u00122\n\b\u0002\u0010 \u001a\u0004\u0018\u00010!H\u0007J6\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u001e\u001a\u00020\u001f2\b\b\u0002\u0010\u0011\u001a\u00020\u00122\n\b\u0002\u0010 \u001a\u0004\u0018\u00010!H\u0007J6\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u001e\u001a\u00020\u001f2\b\b\u0002\u0010\u0011\u001a\u00020\u00122\n\b\u0002\u0010 \u001a\u0004\u0018\u00010!H\u0007J8\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\r\u001a\u00020\u000e2\b\b\u0001\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001e\u001a\u00020\u001f2\b\b\u0002\u0010\u0011\u001a\u00020\u00122\n\b\u0002\u0010 \u001a\u0004\u0018\u00010!H\u0007J6\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\"\u001a\u00020\u00042\u0006\u0010\u001e\u001a\u00020\u001f2\b\b\u0002\u0010\u0011\u001a\u00020\u00122\n\b\u0002\u0010 \u001a\u0004\u0018\u00010!H\u0007J \u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020\u001b2\u0006\u0010(\u001a\u00020\u001bH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u0005\u001a\u00020\u00068BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\t\u0010\n\u001a\u0004\b\u0007\u0010\b\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006)"}, d2={"Loupson/apng/decoder/ApngDecoder$Companion;", "", "()V", "TAG", "", "clearPaint", "Landroid/graphics/Paint;", "getClearPaint", "()Landroid/graphics/Paint;", "clearPaint$delegate", "Lkotlin/Lazy;", "decodeApng", "Landroid/graphics/drawable/Drawable;", "context", "Landroid/content/Context;", "uri", "Landroid/net/Uri;", "speed", "", "file", "Ljava/io/File;", "inStream", "Ljava/io/InputStream;", "url", "Ljava/net/URL;", "(Landroid/content/Context;Ljava/net/URL;FLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "res", "", "decodeApngAsyncInto", "", "imageView", "Landroid/widget/ImageView;", "callback", "Loupson/apng/decoder/ApngDecoder$Callback;", "string", "generateIhdr", "", "ihdrOfApng", "Loupson/apng/chunks/IHDR;", "width", "height", "apng_library_release"})
    public static final class Companion {
        private final Paint getClearPaint() {
            Lazy lazy = clearPaint$delegate;
            Companion companion = Companion;
            Object var3_3 = null;
            boolean bl = false;
            return (Paint)lazy.getValue();
        }

        @JvmStatic
        @JvmOverloads
        @NotNull
        public final Drawable decodeApng(@NotNull Context context, @NotNull InputStream inStream, float speed) {
            Drawable drawable;
            Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
            Intrinsics.checkParameterIsNotNull((Object)inStream, (String)"inStream");
            BufferedInputStream inputStream = new BufferedInputStream(inStream);
            byte[] bytes = new byte[8];
            inputStream.mark(0);
            inputStream.read(bytes);
            if (Utils.Companion.isPng(bytes)) {
                ArrayList png = null;
                ArrayList cover = null;
                float delay = -1.0f;
                int yOffset = -1;
                int xOffset = -1;
                byte[] plte2 = null;
                byte[] tnrs2 = null;
                int maxWidth = 0;
                int maxHeight = 0;
                Utils.Companion.BlendOp blendOp = Utils.Companion.BlendOp.APNG_BLEND_OP_SOURCE;
                Utils.Companion.DisposeOp disposeOp = Utils.Companion.DisposeOp.APNG_DISPOSE_OP_NONE;
                IHDR ihdr = new IHDR();
                boolean isApng = false;
                AnimationDrawable animationDrawable = new AnimationDrawable();
                boolean bl = false;
                boolean bl2 = false;
                AnimationDrawable $this$apply = animationDrawable;
                boolean bl3 = false;
                $this$apply.setOneShot(false);
                AnimationDrawable drawable2 = animationDrawable;
                Bitmap buffer = null;
                int byteRead = 0;
                byte[] lengthChunk = new byte[4];
                while ((byteRead = inputStream.read(lengthChunk)) != -1) {
                    int length = Utils.Companion.parseLength(lengthChunk);
                    byte[] chunk = new byte[length + 8];
                    byteRead = inputStream.read(chunk);
                    byte[] byteArray = ArraysKt.plus((byte[])lengthChunk, (byte[])chunk);
                    int i = 4;
                    byte[] byArray = byteArray;
                    int n = byteArray.length - 4;
                    int n2 = byteArray.length;
                    Object object = Utils.Companion;
                    int n3 = 0;
                    byte[] byArray2 = ArraysKt.copyOfRange((byte[])byArray, (int)n, (int)n2);
                    int chunkCRC = ((Utils.Companion)object).parseLength(byArray2);
                    CRC32 crc = new CRC32();
                    byte[] byArray3 = byteArray;
                    n2 = byteArray.length - 4;
                    object = crc;
                    n3 = 0;
                    byArray2 = ArraysKt.copyOfRange((byte[])byArray3, (int)i, (int)n2);
                    object.update(byArray2);
                    if (chunkCRC == (int)crc.getValue()) {
                        Object crC32;
                        Object iend;
                        Object object2 = byteArray;
                        n3 = i + 4;
                        boolean bl4 = false;
                        byte[] name = ArraysKt.copyOfRange((byte[])object2, (int)i, (int)n3);
                        object2 = name;
                        byte[] byArray4 = Utils.Companion.getFcTL();
                        bl4 = false;
                        if (Arrays.equals(object2, byArray4)) {
                            if (png == null) {
                                Boolean bl5;
                                Boolean bl6;
                                Object it;
                                Unit unit;
                                boolean bl7;
                                Object it2;
                                ArrayList arrayList = cover;
                                if (arrayList != null) {
                                    object2 = arrayList;
                                    boolean bl8 = false;
                                    bl4 = false;
                                    it2 = object2;
                                    bl7 = false;
                                    it2.addAll(ArraysKt.asList((byte[])Utils.Companion.to4Bytes(0)));
                                    byte[] iend2 = new byte[]{73, 69, 78, 68};
                                    CRC32 crC322 = new CRC32();
                                    crC322.update(iend2, 0, iend2.length);
                                    it2.addAll(ArraysKt.asList((byte[])iend2));
                                    it2.addAll(ArraysKt.asList((byte[])Utils.Companion.to4Bytes((int)crC322.getValue())));
                                    APNGDisassembler.Companion.getApng().setCover(BitmapFactory.decodeByteArray((byte[])CollectionsKt.toByteArray((Collection)((Collection)it2)), (int)0, (int)it2.size()));
                                    unit = Unit.INSTANCE;
                                } else {
                                    unit = null;
                                }
                                png = new ArrayList();
                                fcTL fcTL2 = new fcTL();
                                fcTL2.parse(byteArray);
                                delay = fcTL2.getDelay();
                                yOffset = fcTL2.getYOffset();
                                xOffset = fcTL2.getXOffset();
                                blendOp = fcTL2.getBlendOp();
                                disposeOp = fcTL2.getDisposeOp();
                                int width = fcTL2.getPngWidth();
                                int height = fcTL2.getPngHeight();
                                if (xOffset + width > maxWidth) {
                                    throw (Throwable)new BadApng("`xOffset` + `width` must be <= `IHDR` width");
                                }
                                if (yOffset + height > maxHeight) {
                                    throw (Throwable)new BadApng("`yOffset` + `height` must be <= `IHDR` height");
                                }
                                png.addAll(ArraysKt.asList((byte[])Utils.Companion.getPngSignature()));
                                png.addAll(ArraysKt.asList((byte[])this.generateIhdr(ihdr, width, height)));
                                if (plte2 != null) {
                                    it2 = plte2;
                                    bl7 = false;
                                    boolean iend2 = false;
                                    it = it2;
                                    boolean bl9 = false;
                                    bl6 = png.addAll(ArraysKt.asList((byte[])it));
                                } else {
                                    bl6 = null;
                                }
                                if (tnrs2 != null) {
                                    it2 = tnrs2;
                                    bl7 = false;
                                    boolean iend2 = false;
                                    it = it2;
                                    boolean bl10 = false;
                                    bl5 = png.addAll(ArraysKt.asList((byte[])it));
                                } else {
                                    bl5 = null;
                                }
                            } else {
                                Boolean bl11;
                                Boolean bl12;
                                byte[] it;
                                boolean bl13;
                                boolean bl14;
                                byte[] byArray5;
                                png.addAll(ArraysKt.asList((byte[])Utils.Companion.to4Bytes(0)));
                                iend = new byte[]{73, 69, 78, 68};
                                crC32 = new CRC32();
                                ((CRC32)crC32).update((byte[])iend, 0, ((Object)iend).length);
                                png.addAll(ArraysKt.asList((byte[])iend));
                                png.addAll(ArraysKt.asList((byte[])Utils.Companion.to4Bytes((int)((CRC32)crC32).getValue())));
                                Bitmap btm = Bitmap.createBitmap((int)maxWidth, (int)maxHeight, (Bitmap.Config)Bitmap.Config.ARGB_8888);
                                Bitmap decoded = BitmapFactory.decodeByteArray((byte[])CollectionsKt.toByteArray((Collection)png), (int)0, (int)png.size());
                                Canvas canvas = new Canvas(btm);
                                Bitmap bitmap = buffer;
                                if (bitmap == null) {
                                    Intrinsics.throwNpe();
                                }
                                canvas.drawBitmap(bitmap, 0.0f, 0.0f, null);
                                if (blendOp == Utils.Companion.BlendOp.APNG_BLEND_OP_SOURCE) {
                                    float f = xOffset;
                                    float f2 = yOffset;
                                    float f3 = xOffset;
                                    Bitmap bitmap2 = decoded;
                                    Intrinsics.checkExpressionValueIsNotNull((Object)bitmap2, (String)"decoded");
                                    canvas.drawRect(f, f2, f3 + (float)bitmap2.getWidth(), (float)yOffset + (float)decoded.getHeight(), this.getClearPaint());
                                }
                                canvas.drawBitmap(decoded, (float)xOffset, (float)yOffset, null);
                                drawable2.addFrame((Drawable)new BitmapDrawable(context.getResources(), btm), (int)(delay / speed));
                                switch (ApngDecoder$Companion$WhenMappings.$EnumSwitchMapping$0[disposeOp.ordinal()]) {
                                    case 1: {
                                        break;
                                    }
                                    case 2: {
                                        Bitmap res = Bitmap.createBitmap((int)maxWidth, (int)maxHeight, (Bitmap.Config)Bitmap.Config.ARGB_8888);
                                        Canvas can = new Canvas(res);
                                        can.drawBitmap(btm, 0.0f, 0.0f, null);
                                        float f = xOffset;
                                        float f4 = yOffset;
                                        float f5 = xOffset;
                                        Bitmap bitmap3 = decoded;
                                        Intrinsics.checkExpressionValueIsNotNull((Object)bitmap3, (String)"decoded");
                                        can.drawRect(f, f4, f5 + (float)bitmap3.getWidth(), (float)yOffset + (float)decoded.getHeight(), this.getClearPaint());
                                        buffer = res;
                                        break;
                                    }
                                    default: {
                                        buffer = btm;
                                    }
                                }
                                png = new ArrayList();
                                fcTL fcTL3 = new fcTL();
                                fcTL3.parse(byteArray);
                                delay = fcTL3.getDelay();
                                yOffset = fcTL3.getYOffset();
                                xOffset = fcTL3.getXOffset();
                                blendOp = fcTL3.getBlendOp();
                                disposeOp = fcTL3.getDisposeOp();
                                int width = fcTL3.getPngWidth();
                                int height = fcTL3.getPngHeight();
                                png.addAll(ArraysKt.asList((byte[])Utils.Companion.getPngSignature()));
                                png.addAll(ArraysKt.asList((byte[])this.generateIhdr(ihdr, width, height)));
                                if (plte2 != null) {
                                    byArray5 = plte2;
                                    bl14 = false;
                                    bl13 = false;
                                    it = byArray5;
                                    boolean bl15 = false;
                                    bl12 = png.addAll(ArraysKt.asList((byte[])it));
                                } else {
                                    bl12 = null;
                                }
                                if (tnrs2 != null) {
                                    byArray5 = tnrs2;
                                    bl14 = false;
                                    bl13 = false;
                                    it = byArray5;
                                    boolean bl16 = false;
                                    bl11 = png.addAll(ArraysKt.asList((byte[])it));
                                } else {
                                    bl11 = null;
                                }
                            }
                        } else {
                            iend = name;
                            crC32 = Utils.Companion.getIEND();
                            int btm = 0;
                            if (Arrays.equals(iend, (byte[])crC32)) {
                                if (isApng && png != null) {
                                    png.addAll(ArraysKt.asList((byte[])Utils.Companion.to4Bytes(0)));
                                    iend = new byte[]{73, 69, 78, 68};
                                    crC32 = new CRC32();
                                    ((CRC32)crC32).update((byte[])iend, 0, ((byte[])iend).length);
                                    png.addAll(ArraysKt.asList((byte[])iend));
                                    png.addAll(ArraysKt.asList((byte[])Utils.Companion.to4Bytes((int)((CRC32)crC32).getValue())));
                                    Bitmap btm2 = Bitmap.createBitmap((int)maxWidth, (int)maxHeight, (Bitmap.Config)Bitmap.Config.ARGB_8888);
                                    Bitmap decoded = BitmapFactory.decodeByteArray((byte[])CollectionsKt.toByteArray((Collection)png), (int)0, (int)png.size());
                                    Canvas canvas = new Canvas(btm2);
                                    Bitmap bitmap = buffer;
                                    if (bitmap == null) {
                                        Intrinsics.throwNpe();
                                    }
                                    canvas.drawBitmap(bitmap, 0.0f, 0.0f, null);
                                    if (blendOp == Utils.Companion.BlendOp.APNG_BLEND_OP_SOURCE) {
                                        float f = xOffset;
                                        float f6 = yOffset;
                                        float f7 = xOffset;
                                        Bitmap bitmap4 = decoded;
                                        Intrinsics.checkExpressionValueIsNotNull((Object)bitmap4, (String)"decoded");
                                        canvas.drawRect(f, f6, f7 + (float)bitmap4.getWidth(), (float)yOffset + (float)decoded.getHeight(), this.getClearPaint());
                                    }
                                    canvas.drawBitmap(decoded, (float)xOffset, (float)yOffset, null);
                                    drawable2.addFrame((Drawable)new BitmapDrawable(context.getResources(), btm2), (int)(delay / speed));
                                    switch (ApngDecoder$Companion$WhenMappings.$EnumSwitchMapping$1[disposeOp.ordinal()]) {
                                        case 1: {
                                            break;
                                        }
                                        case 2: {
                                            Bitmap res = Bitmap.createBitmap((int)maxWidth, (int)maxHeight, (Bitmap.Config)Bitmap.Config.ARGB_8888);
                                            Canvas can = new Canvas(res);
                                            can.drawBitmap(btm2, 0.0f, 0.0f, null);
                                            float f = xOffset;
                                            float f8 = yOffset;
                                            float f9 = xOffset;
                                            Bitmap bitmap5 = decoded;
                                            Intrinsics.checkExpressionValueIsNotNull((Object)bitmap5, (String)"decoded");
                                            can.drawRect(f, f8, f9 + (float)bitmap5.getWidth(), (float)yOffset + (float)decoded.getHeight(), this.getClearPaint());
                                            buffer = res;
                                            break;
                                        }
                                        default: {
                                            buffer = btm2;
                                            break;
                                        }
                                    }
                                } else {
                                    ArrayList arrayList = cover;
                                    if (arrayList != null) {
                                        iend = arrayList;
                                        boolean crC323 = false;
                                        btm = 0;
                                        byte[] it = iend;
                                        boolean bl17 = false;
                                        it.addAll(ArraysKt.asList((byte[])Utils.Companion.to4Bytes(0)));
                                        byte[] iend3 = new byte[]{73, 69, 78, 68};
                                        CRC32 crC324 = new CRC32();
                                        crC324.update(iend3, 0, iend3.length);
                                        it.addAll(ArraysKt.asList((byte[])iend3));
                                        it.addAll(ArraysKt.asList((byte[])Utils.Companion.to4Bytes((int)crC324.getValue())));
                                        inputStream.close();
                                        return (Drawable)new BitmapDrawable(context.getResources(), BitmapFactory.decodeByteArray((byte[])CollectionsKt.toByteArray((Collection)((Collection)it)), (int)0, (int)it.size()));
                                    }
                                }
                            } else {
                                Object body;
                                iend = name;
                                crC32 = Utils.Companion.getIDAT();
                                btm = 0;
                                if (Arrays.equals(iend, (byte[])crC32)) {
                                    if (png == null) {
                                        if (cover == null) {
                                            cover = new ArrayList();
                                            cover.addAll(ArraysKt.asList((byte[])Utils.Companion.getPngSignature()));
                                            cover.addAll(ArraysKt.asList((byte[])this.generateIhdr(ihdr, maxWidth, maxHeight)));
                                        }
                                        crC32 = byteArray;
                                        btm = i - 4;
                                        object = Utils.Companion;
                                        int n4 = 0;
                                        byArray2 = ArraysKt.copyOfRange((byte[])crC32, (int)btm, (int)i);
                                        int bodySize = ((Utils.Companion)object).parseLength(byArray2);
                                        crC32 = byteArray;
                                        btm = i - 4;
                                        object = cover;
                                        n4 = 0;
                                        byArray2 = ArraysKt.copyOfRange((byte[])crC32, (int)btm, (int)i);
                                        ((ArrayList)object).addAll(ArraysKt.asList((byte[])byArray2));
                                        body = new ArrayList();
                                        ((ArrayList)body).addAll(ArraysKt.asList((byte[])new byte[]{73, 68, 65, 84}));
                                        byte[] btm2 = byteArray;
                                        n4 = i + 4;
                                        int n5 = i + 4 + bodySize;
                                        object = body;
                                        boolean bl18 = false;
                                        byArray2 = ArraysKt.copyOfRange((byte[])btm2, (int)n4, (int)n5);
                                        ((ArrayList)object).addAll(ArraysKt.asList((byte[])byArray2));
                                        CRC32 crC33 = new CRC32();
                                        crC33.update(CollectionsKt.toByteArray((Collection)((Collection)body)), 0, ((ArrayList)body).size());
                                        cover.addAll((Collection)body);
                                        cover.addAll(ArraysKt.asList((byte[])Utils.Companion.to4Bytes((int)crC33.getValue())));
                                    } else {
                                        body = byteArray;
                                        int crC34 = i - 4;
                                        object = Utils.Companion;
                                        int n6 = 0;
                                        byArray2 = ArraysKt.copyOfRange((byte[])body, (int)crC34, (int)i);
                                        int bodySize = ((Utils.Companion)object).parseLength(byArray2);
                                        body = byteArray;
                                        crC34 = i - 4;
                                        object = png;
                                        n6 = 0;
                                        byArray2 = ArraysKt.copyOfRange((byte[])body, (int)crC34, (int)i);
                                        ((ArrayList)object).addAll(ArraysKt.asList((byte[])byArray2));
                                        body = new ArrayList();
                                        ((ArrayList)body).addAll(ArraysKt.asList((byte[])new byte[]{73, 68, 65, 84}));
                                        Object crC33 = byteArray;
                                        n6 = i + 4;
                                        int n7 = i + 4 + bodySize;
                                        object = body;
                                        boolean bl19 = false;
                                        byArray2 = ArraysKt.copyOfRange((byte[])crC33, (int)n6, (int)n7);
                                        ((ArrayList)object).addAll(ArraysKt.asList((byte[])byArray2));
                                        crC33 = new CRC32();
                                        ((CRC32)crC33).update(CollectionsKt.toByteArray((Collection)((Collection)body)), 0, ((ArrayList)body).size());
                                        png.addAll((Collection)body);
                                        png.addAll(ArraysKt.asList((byte[])Utils.Companion.to4Bytes((int)((CRC32)crC33).getValue())));
                                    }
                                } else {
                                    byte[] bodySize = name;
                                    body = Utils.Companion.getFdAT();
                                    crC34 = 0;
                                    if (Arrays.equals(bodySize, (byte[])body)) {
                                        body = byteArray;
                                        crC34 = i - 4;
                                        object = Utils.Companion;
                                        int n8 = 0;
                                        byArray2 = ArraysKt.copyOfRange((byte[])body, (int)crC34, (int)i);
                                        int bodySize2 = ((Utils.Companion)object).parseLength(byArray2);
                                        ArrayList arrayList = png;
                                        Boolean bl20 = arrayList != null ? Boolean.valueOf(arrayList.addAll(ArraysKt.asList((byte[])Utils.Companion.to4Bytes(bodySize2 - 4)))) : null;
                                        body = new ArrayList();
                                        ((ArrayList)body).addAll(ArraysKt.asList((byte[])new byte[]{73, 68, 65, 84}));
                                        Object crC34 = byteArray;
                                        n8 = i + 8;
                                        int n9 = i + 4 + bodySize2;
                                        object = body;
                                        boolean bl21 = false;
                                        byArray2 = ArraysKt.copyOfRange((byte[])crC34, (int)n8, (int)n9);
                                        ((ArrayList)object).addAll(ArraysKt.asList((byte[])byArray2));
                                        crC34 = new CRC32();
                                        ((CRC32)crC34).update(CollectionsKt.toByteArray((Collection)((Collection)body)), 0, ((ArrayList)body).size());
                                        ArrayList arrayList2 = png;
                                        Boolean bl22 = arrayList2 != null ? Boolean.valueOf(arrayList2.addAll((Collection)body)) : null;
                                        ArrayList arrayList3 = png;
                                        Boolean bl23 = arrayList3 != null ? Boolean.valueOf(arrayList3.addAll(ArraysKt.asList((byte[])Utils.Companion.to4Bytes((int)((CRC32)crC34).getValue())))) : null;
                                    } else {
                                        object2 = name;
                                        byArray4 = Utils.Companion.getPlte();
                                        bl4 = false;
                                        if (Arrays.equals(object2, byArray4)) {
                                            plte2 = byteArray;
                                        } else {
                                            object2 = name;
                                            byArray4 = Utils.Companion.getTnrs();
                                            bl4 = false;
                                            if (Arrays.equals(object2, byArray4)) {
                                                tnrs2 = byteArray;
                                            } else {
                                                object2 = name;
                                                byArray4 = Utils.Companion.getIHDR();
                                                bl4 = false;
                                                if (Arrays.equals(object2, byArray4)) {
                                                    ihdr.parse(byteArray);
                                                    maxWidth = ihdr.getPngWidth();
                                                    maxHeight = ihdr.getPngHeight();
                                                    buffer = Bitmap.createBitmap((int)maxWidth, (int)maxHeight, (Bitmap.Config)Bitmap.Config.ARGB_8888);
                                                } else {
                                                    object2 = name;
                                                    byArray4 = Utils.Companion.getAcTL();
                                                    bl4 = false;
                                                    if (Arrays.equals(object2, byArray4)) {
                                                        isApng = true;
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    } else {
                        throw (Throwable)new BadCRC();
                    }
                    if (byteRead != -1) continue;
                }
                inputStream.close();
                return (Drawable)drawable2;
            }
            inputStream.reset();
            if (Build.VERSION.SDK_INT >= 28) {
                byte[] bytesRead = ByteStreamsKt.readBytes((InputStream)inputStream);
                inputStream.close();
                ByteBuffer buf = ByteBuffer.wrap(bytesRead);
                ImageDecoder.Source source = ImageDecoder.createSource((ByteBuffer)buf);
                Intrinsics.checkExpressionValueIsNotNull((Object)source, (String)"ImageDecoder.createSource(buf)");
                ImageDecoder.Source source2 = source;
                Drawable drawable3 = ImageDecoder.decodeDrawable((ImageDecoder.Source)source2);
                drawable = drawable3;
                Intrinsics.checkExpressionValueIsNotNull((Object)drawable3, (String)"ImageDecoder.decodeDrawable(source)");
            } else {
                Drawable drawable4 = Drawable.createFromStream((InputStream)inputStream, null);
                drawable = drawable4;
                Intrinsics.checkExpressionValueIsNotNull((Object)drawable4, (String)"Drawable.createFromStrea\u2026ull\n                    )");
            }
            return drawable;
        }

        public static /* synthetic */ Drawable decodeApng$default(Companion companion, Context context, InputStream inputStream, float f, int n, Object object) {
            if ((n & 4) != 0) {
                f = 1.0f;
            }
            return companion.decodeApng(context, inputStream, f);
        }

        @JvmStatic
        @JvmOverloads
        @NotNull
        public final Drawable decodeApng(@NotNull Context context, @NotNull InputStream inStream) {
            return oupson.apng.decoder.ApngDecoder$Companion.decodeApng$default(this, context, inStream, 0.0f, 4, null);
        }

        @JvmStatic
        @NotNull
        public final Drawable decodeApng(@NotNull Context context, @NotNull File file, float speed) {
            Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
            Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
            return this.decodeApng(context, new FileInputStream(file), speed);
        }

        public static /* synthetic */ Drawable decodeApng$default(Companion companion, Context context, File file, float f, int n, Object object) {
            if ((n & 4) != 0) {
                f = 1.0f;
            }
            return companion.decodeApng(context, file, f);
        }

        @JvmStatic
        @NotNull
        public final Drawable decodeApng(@NotNull Context context, @NotNull Uri uri, float speed) {
            Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
            Intrinsics.checkParameterIsNotNull((Object)uri, (String)"uri");
            InputStream inputStream = context.getContentResolver().openInputStream(uri);
            if (inputStream == null) {
                throw (Throwable)new Exception("Failed to open InputStream, InputStream is null");
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)inputStream, (String)"context.contentResolver.\u2026am, InputStream is null\")");
            InputStream inputStream2 = inputStream;
            return this.decodeApng(context, inputStream2, speed);
        }

        public static /* synthetic */ Drawable decodeApng$default(Companion companion, Context context, Uri uri, float f, int n, Object object) {
            if ((n & 4) != 0) {
                f = 1.0f;
            }
            return companion.decodeApng(context, uri, f);
        }

        @JvmStatic
        @NotNull
        public final Drawable decodeApng(@NotNull Context context, @RawRes int res, float speed) {
            Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
            InputStream inputStream = context.getResources().openRawResource(res);
            Intrinsics.checkExpressionValueIsNotNull((Object)inputStream, (String)"context.resources.openRawResource(res)");
            return this.decodeApng(context, inputStream, speed);
        }

        public static /* synthetic */ Drawable decodeApng$default(Companion companion, Context context, int n, float f, int n2, Object object) {
            if ((n2 & 4) != 0) {
                f = 1.0f;
            }
            return companion.decodeApng(context, n, f);
        }

        @JvmStatic
        @Nullable
        public final Object decodeApng(@NotNull Context context, @NotNull URL url, float speed, @NotNull Continuation<? super Drawable> $completion) {
            return BuildersKt.withContext((CoroutineContext)((CoroutineContext)Dispatchers.getIO()), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Drawable>, Object>(context, url, speed, null){
                private CoroutineScope p$;
                Object L$0;
                Object L$1;
                Object L$2;
                int label;
                final /* synthetic */ Context $context;
                final /* synthetic */ URL $url;
                final /* synthetic */ float $speed;

                /*
                 * Unable to fully structure code
                 */
                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    var9_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)$result);
                            $this$withContext = this.p$;
                            var4_4 = this.$context;
                            var3_5 = ApngDecoder.Companion;
                            this.L$0 = $this$withContext;
                            this.L$1 = var3_5;
                            this.L$2 = var4_4;
                            this.label = 1;
                            v0 = Loader.Companion.load(this.$context, this.$url, (Continuation<? super File>)this);
                            if (v0 == var9_2) {
                                return var9_2;
                            }
                            ** GOTO lbl22
                        }
                        case 1: {
                            var4_4 = (Context)this.L$2;
                            var3_5 = (Companion)this.L$1;
                            $this$withContext = (CoroutineScope)this.L$0;
                            ResultKt.throwOnFailure((Object)$result);
                            v0 = $result;
lbl22:
                            // 2 sources

                            var7_6 = v0;
                            var8_7 = (File)var7_6;
                            return var3_5.decodeApng(var4_4, new FileInputStream(var8_7), this.$speed);
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }
                {
                    this.$context = context;
                    this.$url = uRL;
                    this.$speed = f;
                    super(2, continuation);
                }

                @NotNull
                public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> completion) {
                    Intrinsics.checkParameterIsNotNull(completion, (String)"completion");
                    Function2<CoroutineScope, Continuation<? super Drawable>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                    CoroutineScope coroutineScope = function2.p$ = (CoroutineScope)value;
                    return function2;
                }

                public final Object invoke(Object object, Object object2) {
                    return (this.create(object, (Continuation)object2)).invokeSuspend(Unit.INSTANCE);
                }
            }), $completion);
        }

        public static /* synthetic */ Object decodeApng$default(Companion companion, Context context, URL uRL, float f, Continuation continuation, int n, Object object) {
            if ((n & 4) != 0) {
                f = 1.0f;
            }
            return companion.decodeApng(context, uRL, f, (Continuation<? super Drawable>)continuation);
        }

        @JvmStatic
        @JvmOverloads
        public final void decodeApngAsyncInto(@NotNull Context context, @NotNull File file, @NotNull ImageView imageView, float speed, @Nullable Callback callback) {
            Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
            Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
            Intrinsics.checkParameterIsNotNull((Object)imageView, (String)"imageView");
            BuildersKt.launch$default((CoroutineScope)((CoroutineScope)GlobalScope.INSTANCE), (CoroutineContext)((CoroutineContext)Dispatchers.getIO()), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(context, file, speed, imageView, callback, null){
                private CoroutineScope p$;
                Object L$0;
                Object L$1;
                int label;
                final /* synthetic */ Context $context;
                final /* synthetic */ File $file;
                final /* synthetic */ float $speed;
                final /* synthetic */ ImageView $imageView;
                final /* synthetic */ Callback $callback;

                /*
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)$result);
                            CoroutineScope $this$launch = this.p$;
                            Drawable drawable = ApngDecoder.Companion.decodeApng(this.$context, new FileInputStream(this.$file), this.$speed);
                            this.L$0 = $this$launch;
                            this.L$1 = drawable;
                            this.label = 1;
                            Object object2 = BuildersKt.withContext((CoroutineContext)((CoroutineContext)Dispatchers.getMain()), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, drawable, null){
                                private CoroutineScope p$;
                                int label;
                                final /* synthetic */ decodeApngAsyncInto.1 this$0;
                                final /* synthetic */ Drawable $drawable;

                                @Nullable
                                public final Object invokeSuspend(@NotNull Object $result) {
                                    Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                    switch (this.label) {
                                        case 0: {
                                            Unit unit;
                                            ResultKt.throwOnFailure((Object)$result);
                                            CoroutineScope $this$withContext = this.p$;
                                            this.this$0.$imageView.setImageDrawable(this.$drawable);
                                            Drawable drawable = this.$drawable;
                                            if (!(drawable instanceof AnimationDrawable)) {
                                                drawable = null;
                                            }
                                            AnimationDrawable animationDrawable = (AnimationDrawable)drawable;
                                            if (animationDrawable != null) {
                                                animationDrawable.start();
                                            }
                                            if (Build.VERSION.SDK_INT >= 28) {
                                                Drawable drawable2 = this.$drawable;
                                                if (!(drawable2 instanceof AnimatedImageDrawable)) {
                                                    drawable2 = null;
                                                }
                                                AnimatedImageDrawable animatedImageDrawable = (AnimatedImageDrawable)drawable2;
                                                if (animatedImageDrawable != null) {
                                                    animatedImageDrawable.start();
                                                }
                                            }
                                            Callback callback = this.this$0.$callback;
                                            if (callback != null) {
                                                callback.onSuccess(this.$drawable);
                                                unit = Unit.INSTANCE;
                                            } else {
                                                unit = null;
                                            }
                                            return unit;
                                        }
                                    }
                                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                }
                                {
                                    this.this$0 = var1_1;
                                    this.$drawable = drawable;
                                    super(2, continuation);
                                }

                                @NotNull
                                public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> completion) {
                                    Intrinsics.checkParameterIsNotNull(completion, (String)"completion");
                                    Function2<CoroutineScope, Continuation<? super Unit>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                                    CoroutineScope coroutineScope = function2.p$ = (CoroutineScope)value;
                                    return function2;
                                }

                                public final Object invoke(Object object, Object object2) {
                                    return (this.create(object, (Continuation)object2)).invokeSuspend(Unit.INSTANCE);
                                }
                            }), (Continuation)this);
                            if (object2 != object) return Unit.INSTANCE;
                            return object;
                        }
                        case 1: {
                            Object object3;
                            Object object2;
                            Drawable drawable = (Drawable)this.L$1;
                            CoroutineScope $this$launch = (CoroutineScope)this.L$0;
                            try {
                                ResultKt.throwOnFailure((Object)$result);
                                object2 = $result;
                                return Unit.INSTANCE;
                            }
                            catch (Exception e) {
                                this.L$0 = $this$launch;
                                this.L$1 = e;
                                this.label = 2;
                                object3 = BuildersKt.withContext((CoroutineContext)((CoroutineContext)Dispatchers.getMain()), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, e, null){
                                    private CoroutineScope p$;
                                    int label;
                                    final /* synthetic */ decodeApngAsyncInto.1 this$0;
                                    final /* synthetic */ Exception $e;

                                    @Nullable
                                    public final Object invokeSuspend(@NotNull Object $result) {
                                        Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                        switch (this.label) {
                                            case 0: {
                                                Unit unit;
                                                ResultKt.throwOnFailure((Object)$result);
                                                CoroutineScope $this$withContext = this.p$;
                                                Callback callback = this.this$0.$callback;
                                                if (callback != null) {
                                                    callback.onError(this.$e);
                                                    unit = Unit.INSTANCE;
                                                } else {
                                                    unit = null;
                                                }
                                                return unit;
                                            }
                                        }
                                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                    }
                                    {
                                        this.this$0 = var1_1;
                                        this.$e = exception;
                                        super(2, continuation);
                                    }

                                    @NotNull
                                    public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> completion) {
                                        Intrinsics.checkParameterIsNotNull(completion, (String)"completion");
                                        Function2<CoroutineScope, Continuation<? super Unit>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                                        CoroutineScope coroutineScope = function2.p$ = (CoroutineScope)value;
                                        return function2;
                                    }

                                    public final Object invoke(Object object, Object object2) {
                                        return (this.create(object, (Continuation)object2)).invokeSuspend(Unit.INSTANCE);
                                    }
                                }), (Continuation)this);
                                if (object3 != object) return Unit.INSTANCE;
                                return object;
                            }
                        }
                        case 2: {
                            Exception e = (Exception)this.L$1;
                            CoroutineScope $this$launch = (CoroutineScope)this.L$0;
                            ResultKt.throwOnFailure((Object)$result);
                            Object object3 = $result;
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }
                {
                    this.$context = context;
                    this.$file = file;
                    this.$speed = f;
                    this.$imageView = imageView;
                    this.$callback = callback;
                    super(2, continuation);
                }

                @NotNull
                public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> completion) {
                    Intrinsics.checkParameterIsNotNull(completion, (String)"completion");
                    Function2<CoroutineScope, Continuation<? super Unit>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                    CoroutineScope coroutineScope = function2.p$ = (CoroutineScope)value;
                    return function2;
                }

                public final Object invoke(Object object, Object object2) {
                    return (this.create(object, (Continuation)object2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)2, null);
        }

        public static /* synthetic */ void decodeApngAsyncInto$default(Companion companion, Context context, File file, ImageView imageView, float f, Callback callback, int n, Object object) {
            if ((n & 8) != 0) {
                f = 1.0f;
            }
            if ((n & 0x10) != 0) {
                callback = null;
            }
            companion.decodeApngAsyncInto(context, file, imageView, f, callback);
        }

        @JvmStatic
        @JvmOverloads
        public final void decodeApngAsyncInto(@NotNull Context context, @NotNull File file, @NotNull ImageView imageView, float speed) {
            oupson.apng.decoder.ApngDecoder$Companion.decodeApngAsyncInto$default(this, context, file, imageView, speed, null, 16, null);
        }

        @JvmStatic
        @JvmOverloads
        public final void decodeApngAsyncInto(@NotNull Context context, @NotNull File file, @NotNull ImageView imageView) {
            oupson.apng.decoder.ApngDecoder$Companion.decodeApngAsyncInto$default(this, context, file, imageView, 0.0f, null, 24, null);
        }

        @JvmStatic
        @JvmOverloads
        public final void decodeApngAsyncInto(@NotNull Context context, @NotNull Uri uri, @NotNull ImageView imageView, float speed, @Nullable Callback callback) {
            Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
            Intrinsics.checkParameterIsNotNull((Object)uri, (String)"uri");
            Intrinsics.checkParameterIsNotNull((Object)imageView, (String)"imageView");
            InputStream inputStream = context.getContentResolver().openInputStream(uri);
            if (inputStream == null) {
                throw (Throwable)new Exception("Failed to open InputStream, InputStream is null");
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)inputStream, (String)"context.contentResolver.\u2026am, InputStream is null\")");
            InputStream inputStream2 = inputStream;
            BuildersKt.launch$default((CoroutineScope)((CoroutineScope)GlobalScope.INSTANCE), (CoroutineContext)((CoroutineContext)Dispatchers.getIO()), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(context, inputStream2, speed, imageView, callback, null){
                private CoroutineScope p$;
                Object L$0;
                Object L$1;
                int label;
                final /* synthetic */ Context $context;
                final /* synthetic */ InputStream $inputStream;
                final /* synthetic */ float $speed;
                final /* synthetic */ ImageView $imageView;
                final /* synthetic */ Callback $callback;

                /*
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)$result);
                            CoroutineScope $this$launch = this.p$;
                            Drawable drawable = ApngDecoder.Companion.decodeApng(this.$context, this.$inputStream, this.$speed);
                            this.L$0 = $this$launch;
                            this.L$1 = drawable;
                            this.label = 1;
                            Object object2 = BuildersKt.withContext((CoroutineContext)((CoroutineContext)Dispatchers.getMain()), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, drawable, null){
                                private CoroutineScope p$;
                                int label;
                                final /* synthetic */ decodeApngAsyncInto.2 this$0;
                                final /* synthetic */ Drawable $drawable;

                                @Nullable
                                public final Object invokeSuspend(@NotNull Object $result) {
                                    Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                    switch (this.label) {
                                        case 0: {
                                            Unit unit;
                                            ResultKt.throwOnFailure((Object)$result);
                                            CoroutineScope $this$withContext = this.p$;
                                            this.this$0.$imageView.setImageDrawable(this.$drawable);
                                            Drawable drawable = this.$drawable;
                                            if (!(drawable instanceof AnimationDrawable)) {
                                                drawable = null;
                                            }
                                            AnimationDrawable animationDrawable = (AnimationDrawable)drawable;
                                            if (animationDrawable != null) {
                                                animationDrawable.start();
                                            }
                                            if (Build.VERSION.SDK_INT >= 28) {
                                                Drawable drawable2 = this.$drawable;
                                                if (!(drawable2 instanceof AnimatedImageDrawable)) {
                                                    drawable2 = null;
                                                }
                                                AnimatedImageDrawable animatedImageDrawable = (AnimatedImageDrawable)drawable2;
                                                if (animatedImageDrawable != null) {
                                                    animatedImageDrawable.start();
                                                }
                                            }
                                            Callback callback = this.this$0.$callback;
                                            if (callback != null) {
                                                callback.onSuccess(this.$drawable);
                                                unit = Unit.INSTANCE;
                                            } else {
                                                unit = null;
                                            }
                                            return unit;
                                        }
                                    }
                                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                }
                                {
                                    this.this$0 = var1_1;
                                    this.$drawable = drawable;
                                    super(2, continuation);
                                }

                                @NotNull
                                public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> completion) {
                                    Intrinsics.checkParameterIsNotNull(completion, (String)"completion");
                                    Function2<CoroutineScope, Continuation<? super Unit>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                                    CoroutineScope coroutineScope = function2.p$ = (CoroutineScope)value;
                                    return function2;
                                }

                                public final Object invoke(Object object, Object object2) {
                                    return (this.create(object, (Continuation)object2)).invokeSuspend(Unit.INSTANCE);
                                }
                            }), (Continuation)this);
                            if (object2 != object) return Unit.INSTANCE;
                            return object;
                        }
                        case 1: {
                            Object object3;
                            Object object2;
                            Drawable drawable = (Drawable)this.L$1;
                            CoroutineScope $this$launch = (CoroutineScope)this.L$0;
                            try {
                                ResultKt.throwOnFailure((Object)$result);
                                object2 = $result;
                                return Unit.INSTANCE;
                            }
                            catch (Exception e) {
                                this.L$0 = $this$launch;
                                this.L$1 = e;
                                this.label = 2;
                                object3 = BuildersKt.withContext((CoroutineContext)((CoroutineContext)Dispatchers.getMain()), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, e, null){
                                    private CoroutineScope p$;
                                    int label;
                                    final /* synthetic */ decodeApngAsyncInto.2 this$0;
                                    final /* synthetic */ Exception $e;

                                    @Nullable
                                    public final Object invokeSuspend(@NotNull Object $result) {
                                        Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                        switch (this.label) {
                                            case 0: {
                                                Unit unit;
                                                ResultKt.throwOnFailure((Object)$result);
                                                CoroutineScope $this$withContext = this.p$;
                                                Callback callback = this.this$0.$callback;
                                                if (callback != null) {
                                                    callback.onError(this.$e);
                                                    unit = Unit.INSTANCE;
                                                } else {
                                                    unit = null;
                                                }
                                                return unit;
                                            }
                                        }
                                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                    }
                                    {
                                        this.this$0 = var1_1;
                                        this.$e = exception;
                                        super(2, continuation);
                                    }

                                    @NotNull
                                    public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> completion) {
                                        Intrinsics.checkParameterIsNotNull(completion, (String)"completion");
                                        Function2<CoroutineScope, Continuation<? super Unit>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                                        CoroutineScope coroutineScope = function2.p$ = (CoroutineScope)value;
                                        return function2;
                                    }

                                    public final Object invoke(Object object, Object object2) {
                                        return (this.create(object, (Continuation)object2)).invokeSuspend(Unit.INSTANCE);
                                    }
                                }), (Continuation)this);
                                if (object3 != object) return Unit.INSTANCE;
                                return object;
                            }
                        }
                        case 2: {
                            Exception e = (Exception)this.L$1;
                            CoroutineScope $this$launch = (CoroutineScope)this.L$0;
                            ResultKt.throwOnFailure((Object)$result);
                            Object object3 = $result;
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }
                {
                    this.$context = context;
                    this.$inputStream = inputStream;
                    this.$speed = f;
                    this.$imageView = imageView;
                    this.$callback = callback;
                    super(2, continuation);
                }

                @NotNull
                public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> completion) {
                    Intrinsics.checkParameterIsNotNull(completion, (String)"completion");
                    Function2<CoroutineScope, Continuation<? super Unit>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                    CoroutineScope coroutineScope = function2.p$ = (CoroutineScope)value;
                    return function2;
                }

                public final Object invoke(Object object, Object object2) {
                    return (this.create(object, (Continuation)object2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)2, null);
        }

        public static /* synthetic */ void decodeApngAsyncInto$default(Companion companion, Context context, Uri uri, ImageView imageView, float f, Callback callback, int n, Object object) {
            if ((n & 8) != 0) {
                f = 1.0f;
            }
            if ((n & 0x10) != 0) {
                callback = null;
            }
            companion.decodeApngAsyncInto(context, uri, imageView, f, callback);
        }

        @JvmStatic
        @JvmOverloads
        public final void decodeApngAsyncInto(@NotNull Context context, @NotNull Uri uri, @NotNull ImageView imageView, float speed) {
            oupson.apng.decoder.ApngDecoder$Companion.decodeApngAsyncInto$default(this, context, uri, imageView, speed, null, 16, null);
        }

        @JvmStatic
        @JvmOverloads
        public final void decodeApngAsyncInto(@NotNull Context context, @NotNull Uri uri, @NotNull ImageView imageView) {
            oupson.apng.decoder.ApngDecoder$Companion.decodeApngAsyncInto$default(this, context, uri, imageView, 0.0f, null, 24, null);
        }

        @JvmStatic
        @JvmOverloads
        public final void decodeApngAsyncInto(@NotNull Context context, @RawRes int res, @NotNull ImageView imageView, float speed, @Nullable Callback callback) {
            Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
            Intrinsics.checkParameterIsNotNull((Object)imageView, (String)"imageView");
            BuildersKt.launch$default((CoroutineScope)((CoroutineScope)GlobalScope.INSTANCE), (CoroutineContext)((CoroutineContext)Dispatchers.getIO()), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(context, res, speed, imageView, callback, null){
                private CoroutineScope p$;
                Object L$0;
                Object L$1;
                int label;
                final /* synthetic */ Context $context;
                final /* synthetic */ int $res;
                final /* synthetic */ float $speed;
                final /* synthetic */ ImageView $imageView;
                final /* synthetic */ Callback $callback;

                /*
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)$result);
                            CoroutineScope $this$launch = this.p$;
                            InputStream inputStream = this.$context.getResources().openRawResource(this.$res);
                            Intrinsics.checkExpressionValueIsNotNull((Object)inputStream, (String)"context.resources.openRawResource(res)");
                            Drawable drawable = ApngDecoder.Companion.decodeApng(this.$context, inputStream, this.$speed);
                            this.L$0 = $this$launch;
                            this.L$1 = drawable;
                            this.label = 1;
                            Object object2 = BuildersKt.withContext((CoroutineContext)((CoroutineContext)Dispatchers.getMain()), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, drawable, null){
                                private CoroutineScope p$;
                                int label;
                                final /* synthetic */ decodeApngAsyncInto.3 this$0;
                                final /* synthetic */ Drawable $drawable;

                                @Nullable
                                public final Object invokeSuspend(@NotNull Object $result) {
                                    Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                    switch (this.label) {
                                        case 0: {
                                            Unit unit;
                                            ResultKt.throwOnFailure((Object)$result);
                                            CoroutineScope $this$withContext = this.p$;
                                            this.this$0.$imageView.setImageDrawable(this.$drawable);
                                            Drawable drawable = this.$drawable;
                                            if (!(drawable instanceof AnimationDrawable)) {
                                                drawable = null;
                                            }
                                            AnimationDrawable animationDrawable = (AnimationDrawable)drawable;
                                            if (animationDrawable != null) {
                                                animationDrawable.start();
                                            }
                                            if (Build.VERSION.SDK_INT >= 28) {
                                                Drawable drawable2 = this.$drawable;
                                                if (!(drawable2 instanceof AnimatedImageDrawable)) {
                                                    drawable2 = null;
                                                }
                                                AnimatedImageDrawable animatedImageDrawable = (AnimatedImageDrawable)drawable2;
                                                if (animatedImageDrawable != null) {
                                                    animatedImageDrawable.start();
                                                }
                                            }
                                            Callback callback = this.this$0.$callback;
                                            if (callback != null) {
                                                callback.onSuccess(this.$drawable);
                                                unit = Unit.INSTANCE;
                                            } else {
                                                unit = null;
                                            }
                                            return unit;
                                        }
                                    }
                                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                }
                                {
                                    this.this$0 = var1_1;
                                    this.$drawable = drawable;
                                    super(2, continuation);
                                }

                                @NotNull
                                public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> completion) {
                                    Intrinsics.checkParameterIsNotNull(completion, (String)"completion");
                                    Function2<CoroutineScope, Continuation<? super Unit>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                                    CoroutineScope coroutineScope = function2.p$ = (CoroutineScope)value;
                                    return function2;
                                }

                                public final Object invoke(Object object, Object object2) {
                                    return (this.create(object, (Continuation)object2)).invokeSuspend(Unit.INSTANCE);
                                }
                            }), (Continuation)this);
                            if (object2 != object) return Unit.INSTANCE;
                            return object;
                        }
                        case 1: {
                            Object object3;
                            Object object2;
                            Drawable drawable = (Drawable)this.L$1;
                            CoroutineScope $this$launch = (CoroutineScope)this.L$0;
                            try {
                                ResultKt.throwOnFailure((Object)$result);
                                object2 = $result;
                                return Unit.INSTANCE;
                            }
                            catch (Exception e) {
                                this.L$0 = $this$launch;
                                this.L$1 = e;
                                this.label = 2;
                                object3 = BuildersKt.withContext((CoroutineContext)((CoroutineContext)Dispatchers.getMain()), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, e, null){
                                    private CoroutineScope p$;
                                    int label;
                                    final /* synthetic */ decodeApngAsyncInto.3 this$0;
                                    final /* synthetic */ Exception $e;

                                    @Nullable
                                    public final Object invokeSuspend(@NotNull Object $result) {
                                        Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                        switch (this.label) {
                                            case 0: {
                                                Unit unit;
                                                ResultKt.throwOnFailure((Object)$result);
                                                CoroutineScope $this$withContext = this.p$;
                                                Callback callback = this.this$0.$callback;
                                                if (callback != null) {
                                                    callback.onError(this.$e);
                                                    unit = Unit.INSTANCE;
                                                } else {
                                                    unit = null;
                                                }
                                                return unit;
                                            }
                                        }
                                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                    }
                                    {
                                        this.this$0 = var1_1;
                                        this.$e = exception;
                                        super(2, continuation);
                                    }

                                    @NotNull
                                    public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> completion) {
                                        Intrinsics.checkParameterIsNotNull(completion, (String)"completion");
                                        Function2<CoroutineScope, Continuation<? super Unit>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                                        CoroutineScope coroutineScope = function2.p$ = (CoroutineScope)value;
                                        return function2;
                                    }

                                    public final Object invoke(Object object, Object object2) {
                                        return (this.create(object, (Continuation)object2)).invokeSuspend(Unit.INSTANCE);
                                    }
                                }), (Continuation)this);
                                if (object3 != object) return Unit.INSTANCE;
                                return object;
                            }
                        }
                        case 2: {
                            Exception e = (Exception)this.L$1;
                            CoroutineScope $this$launch = (CoroutineScope)this.L$0;
                            ResultKt.throwOnFailure((Object)$result);
                            Object object3 = $result;
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }
                {
                    this.$context = context;
                    this.$res = n;
                    this.$speed = f;
                    this.$imageView = imageView;
                    this.$callback = callback;
                    super(2, continuation);
                }

                @NotNull
                public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> completion) {
                    Intrinsics.checkParameterIsNotNull(completion, (String)"completion");
                    Function2<CoroutineScope, Continuation<? super Unit>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                    CoroutineScope coroutineScope = function2.p$ = (CoroutineScope)value;
                    return function2;
                }

                public final Object invoke(Object object, Object object2) {
                    return (this.create(object, (Continuation)object2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)2, null);
        }

        public static /* synthetic */ void decodeApngAsyncInto$default(Companion companion, Context context, int n, ImageView imageView, float f, Callback callback, int n2, Object object) {
            if ((n2 & 8) != 0) {
                f = 1.0f;
            }
            if ((n2 & 0x10) != 0) {
                callback = null;
            }
            companion.decodeApngAsyncInto(context, n, imageView, f, callback);
        }

        @JvmStatic
        @JvmOverloads
        public final void decodeApngAsyncInto(@NotNull Context context, @RawRes int res, @NotNull ImageView imageView, float speed) {
            oupson.apng.decoder.ApngDecoder$Companion.decodeApngAsyncInto$default(this, context, res, imageView, speed, null, 16, null);
        }

        @JvmStatic
        @JvmOverloads
        public final void decodeApngAsyncInto(@NotNull Context context, @RawRes int res, @NotNull ImageView imageView) {
            oupson.apng.decoder.ApngDecoder$Companion.decodeApngAsyncInto$default(this, context, res, imageView, 0.0f, null, 24, null);
        }

        @JvmStatic
        @JvmOverloads
        public final void decodeApngAsyncInto(@NotNull Context context, @NotNull URL url, @NotNull ImageView imageView, float speed, @Nullable Callback callback) {
            Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
            Intrinsics.checkParameterIsNotNull((Object)url, (String)"url");
            Intrinsics.checkParameterIsNotNull((Object)imageView, (String)"imageView");
            BuildersKt.launch$default((CoroutineScope)((CoroutineScope)GlobalScope.INSTANCE), (CoroutineContext)((CoroutineContext)Dispatchers.getIO()), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(context, url, speed, imageView, callback, null){
                private CoroutineScope p$;
                Object L$0;
                Object L$1;
                Object L$2;
                int label;
                final /* synthetic */ Context $context;
                final /* synthetic */ URL $url;
                final /* synthetic */ float $speed;
                final /* synthetic */ ImageView $imageView;
                final /* synthetic */ Callback $callback;

                /*
                 * Unable to fully structure code
                 */
                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    var10_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)$result);
                            $this$launch = this.p$;
                            var5_5 = this.$context;
                            var4_6 = ApngDecoder.Companion;
                            this.L$0 = $this$launch;
                            this.L$1 = var4_6;
                            this.L$2 = var5_5;
                            this.label = 1;
                            v0 = Loader.Companion.load(this.$context, this.$url, (Continuation<? super File>)this);
                            ** if (v0 != var10_2) goto lbl17
lbl16:
                            // 1 sources

                            return var10_2;
lbl17:
                            // 1 sources

                            ** GOTO lbl26
                        }
                        case 1: {
                            var5_5 = (Context)this.L$2;
                            var4_6 = (Companion)this.L$1;
                            $this$launch = (CoroutineScope)this.L$0;
                            ResultKt.throwOnFailure((Object)$result);
                            v0 = $result;
lbl26:
                            // 2 sources

                            var8_7 = v0;
                            var9_8 = (File)var8_7;
                            drawable = var4_6.decodeApng(var5_5, new FileInputStream(var9_8), this.$speed);
                            this.L$0 = $this$launch;
                            this.L$1 = drawable;
                            this.label = 2;
                            v1 = BuildersKt.withContext((CoroutineContext)((CoroutineContext)Dispatchers.getMain()), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, drawable, null){
                                private CoroutineScope p$;
                                int label;
                                final /* synthetic */ decodeApngAsyncInto.4 this$0;
                                final /* synthetic */ Drawable $drawable;

                                @Nullable
                                public final Object invokeSuspend(@NotNull Object $result) {
                                    Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                    switch (this.label) {
                                        case 0: {
                                            Unit unit;
                                            ResultKt.throwOnFailure((Object)$result);
                                            CoroutineScope $this$withContext = this.p$;
                                            this.this$0.$imageView.setImageDrawable(this.$drawable);
                                            Drawable drawable = this.$drawable;
                                            if (!(drawable instanceof AnimationDrawable)) {
                                                drawable = null;
                                            }
                                            AnimationDrawable animationDrawable = (AnimationDrawable)drawable;
                                            if (animationDrawable != null) {
                                                animationDrawable.start();
                                            }
                                            if (Build.VERSION.SDK_INT >= 28) {
                                                Drawable drawable2 = this.$drawable;
                                                if (!(drawable2 instanceof AnimatedImageDrawable)) {
                                                    drawable2 = null;
                                                }
                                                AnimatedImageDrawable animatedImageDrawable = (AnimatedImageDrawable)drawable2;
                                                if (animatedImageDrawable != null) {
                                                    animatedImageDrawable.start();
                                                }
                                            }
                                            Callback callback = this.this$0.$callback;
                                            if (callback != null) {
                                                callback.onSuccess(this.$drawable);
                                                unit = Unit.INSTANCE;
                                            } else {
                                                unit = null;
                                            }
                                            return unit;
                                        }
                                    }
                                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                }
                                {
                                    this.this$0 = var1_1;
                                    this.$drawable = drawable;
                                    super(2, continuation);
                                }

                                @NotNull
                                public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> completion) {
                                    Intrinsics.checkParameterIsNotNull(completion, (String)"completion");
                                    Function2<CoroutineScope, Continuation<? super Unit>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                                    CoroutineScope coroutineScope = function2.p$ = (CoroutineScope)value;
                                    return function2;
                                }

                                public final Object invoke(Object object, Object object2) {
                                    return (this.create(object, (Continuation)object2)).invokeSuspend(Unit.INSTANCE);
                                }
                            }), (Continuation)this);
                            ** if (v1 != var10_2) goto lbl35
lbl34:
                            // 1 sources

                            return var10_2;
lbl35:
                            // 1 sources

                            ** GOTO lbl57
                        }
                        case 2: {
                            drawable = (Drawable)this.L$1;
                            $this$launch = (CoroutineScope)this.L$0;
                            try {
                                ResultKt.throwOnFailure((Object)$result);
                                v1 = $result;
                                ** GOTO lbl57
                            }
                            catch (Exception e) {
                                this.L$0 = $this$launch;
                                this.L$1 = e;
                                this.label = 3;
                                v2 = BuildersKt.withContext((CoroutineContext)((CoroutineContext)Dispatchers.getMain()), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, e, null){
                                    private CoroutineScope p$;
                                    int label;
                                    final /* synthetic */ decodeApngAsyncInto.4 this$0;
                                    final /* synthetic */ Exception $e;

                                    @Nullable
                                    public final Object invokeSuspend(@NotNull Object $result) {
                                        Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                        switch (this.label) {
                                            case 0: {
                                                Unit unit;
                                                ResultKt.throwOnFailure((Object)$result);
                                                CoroutineScope $this$withContext = this.p$;
                                                Callback callback = this.this$0.$callback;
                                                if (callback != null) {
                                                    callback.onError(this.$e);
                                                    unit = Unit.INSTANCE;
                                                } else {
                                                    unit = null;
                                                }
                                                return unit;
                                            }
                                        }
                                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                    }
                                    {
                                        this.this$0 = var1_1;
                                        this.$e = exception;
                                        super(2, continuation);
                                    }

                                    @NotNull
                                    public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> completion) {
                                        Intrinsics.checkParameterIsNotNull(completion, (String)"completion");
                                        Function2<CoroutineScope, Continuation<? super Unit>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                                        CoroutineScope coroutineScope = function2.p$ = (CoroutineScope)value;
                                        return function2;
                                    }

                                    public final Object invoke(Object object, Object object2) {
                                        return (this.create(object, (Continuation)object2)).invokeSuspend(Unit.INSTANCE);
                                    }
                                }), (Continuation)this);
                                if (v2 == var10_2) {
                                    return var10_2;
                                }
                                ** GOTO lbl57
                            }
                        }
                        case 3: {
                            e = (Exception)this.L$1;
                            $this$launch = (CoroutineScope)this.L$0;
                            ResultKt.throwOnFailure((Object)$result);
                            v2 = $result;
lbl57:
                            // 4 sources

                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }
                {
                    this.$context = context;
                    this.$url = uRL;
                    this.$speed = f;
                    this.$imageView = imageView;
                    this.$callback = callback;
                    super(2, continuation);
                }

                @NotNull
                public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> completion) {
                    Intrinsics.checkParameterIsNotNull(completion, (String)"completion");
                    Function2<CoroutineScope, Continuation<? super Unit>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                    CoroutineScope coroutineScope = function2.p$ = (CoroutineScope)value;
                    return function2;
                }

                public final Object invoke(Object object, Object object2) {
                    return (this.create(object, (Continuation)object2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)2, null);
        }

        public static /* synthetic */ void decodeApngAsyncInto$default(Companion companion, Context context, URL uRL, ImageView imageView, float f, Callback callback, int n, Object object) {
            if ((n & 8) != 0) {
                f = 1.0f;
            }
            if ((n & 0x10) != 0) {
                callback = null;
            }
            companion.decodeApngAsyncInto(context, uRL, imageView, f, callback);
        }

        @JvmStatic
        @JvmOverloads
        public final void decodeApngAsyncInto(@NotNull Context context, @NotNull URL url, @NotNull ImageView imageView, float speed) {
            oupson.apng.decoder.ApngDecoder$Companion.decodeApngAsyncInto$default(this, context, url, imageView, speed, null, 16, null);
        }

        @JvmStatic
        @JvmOverloads
        public final void decodeApngAsyncInto(@NotNull Context context, @NotNull URL url, @NotNull ImageView imageView) {
            oupson.apng.decoder.ApngDecoder$Companion.decodeApngAsyncInto$default(this, context, url, imageView, 0.0f, null, 24, null);
        }

        @JvmStatic
        @JvmOverloads
        public final void decodeApngAsyncInto(@NotNull Context context, @NotNull String string, @NotNull ImageView imageView, float speed, @Nullable Callback callback) {
            Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
            Intrinsics.checkParameterIsNotNull((Object)string, (String)"string");
            Intrinsics.checkParameterIsNotNull((Object)imageView, (String)"imageView");
            BuildersKt.launch$default((CoroutineScope)((CoroutineScope)GlobalScope.INSTANCE), (CoroutineContext)((CoroutineContext)Dispatchers.getIO()), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(string, context, imageView, speed, callback, null){
                private CoroutineScope p$;
                Object L$0;
                Object L$1;
                int label;
                final /* synthetic */ String $string;
                final /* synthetic */ Context $context;
                final /* synthetic */ ImageView $imageView;
                final /* synthetic */ float $speed;
                final /* synthetic */ Callback $callback;

                /*
                 * Exception decompiling
                 */
                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    /*
                     * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
                     * 
                     * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [5[CASE], 3[SWITCH]], but top level block is 1[TRYBLOCK]
                     *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
                     *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
                     *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
                     *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
                     *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
                     *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
                     *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
                     *     at org.benf.cfr.reader.entities.Method.dump(Method.java:598)
                     *     at org.benf.cfr.reader.entities.classfilehelpers.ClassFileDumperAnonymousInner.dumpWithArgs(ClassFileDumperAnonymousInner.java:87)
                     *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.ConstructorInvokationAnonymousInner.dumpInner(ConstructorInvokationAnonymousInner.java:82)
                     *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractExpression.dumpWithOuterPrecedence(AbstractExpression.java:142)
                     *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.CastExpression.dumpInner(CastExpression.java:114)
                     *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractExpression.dumpWithOuterPrecedence(AbstractExpression.java:139)
                     *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.CastExpression.dumpInner(CastExpression.java:114)
                     *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractExpression.dumpWithOuterPrecedence(AbstractExpression.java:142)
                     *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractExpression.dump(AbstractExpression.java:98)
                     *     at org.benf.cfr.reader.state.TypeUsageCollectingDumper.dump(TypeUsageCollectingDumper.java:194)
                     *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.StaticFunctionInvokation.dumpInner(StaticFunctionInvokation.java:143)
                     *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractExpression.dumpWithOuterPrecedence(AbstractExpression.java:142)
                     *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractExpression.dump(AbstractExpression.java:98)
                     *     at org.benf.cfr.reader.state.TypeUsageCollectingDumper.dump(TypeUsageCollectingDumper.java:194)
                     *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredExpressionStatement.dump(StructuredExpressionStatement.java:29)
                     *     at org.benf.cfr.reader.state.TypeUsageCollectingDumper.dump(TypeUsageCollectingDumper.java:194)
                     *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.dump(Op04StructuredStatement.java:220)
                     *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.Block.dump(Block.java:564)
                     *     at org.benf.cfr.reader.state.TypeUsageCollectingDumper.dump(TypeUsageCollectingDumper.java:194)
                     *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.dump(Op04StructuredStatement.java:220)
                     *     at org.benf.cfr.reader.entities.attributes.AttributeCode.dump(AttributeCode.java:135)
                     *     at org.benf.cfr.reader.state.TypeUsageCollectingDumper.dump(TypeUsageCollectingDumper.java:194)
                     *     at org.benf.cfr.reader.entities.Method.dump(Method.java:627)
                     *     at org.benf.cfr.reader.entities.classfilehelpers.AbstractClassFileDumper.dumpMethods(AbstractClassFileDumper.java:211)
                     *     at org.benf.cfr.reader.entities.classfilehelpers.ClassFileDumperNormal.dump(ClassFileDumperNormal.java:70)
                     *     at org.benf.cfr.reader.entities.ClassFile.dumpNamedInnerClasses(ClassFile.java:1161)
                     *     at org.benf.cfr.reader.entities.classfilehelpers.ClassFileDumperNormal.dump(ClassFileDumperNormal.java:71)
                     *     at org.benf.cfr.reader.entities.ClassFile.dump(ClassFile.java:1167)
                     *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:952)
                     *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
                     *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
                     *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
                     *     at org.benf.cfr.reader.Main.main(Main.java:54)
                     */
                    throw new IllegalStateException("Decompilation failed");
                }
                {
                    this.$string = string;
                    this.$context = context;
                    this.$imageView = imageView;
                    this.$speed = f;
                    this.$callback = callback;
                    super(2, continuation);
                }

                @NotNull
                public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> completion) {
                    Intrinsics.checkParameterIsNotNull(completion, (String)"completion");
                    Function2<CoroutineScope, Continuation<? super Unit>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                    CoroutineScope coroutineScope = function2.p$ = (CoroutineScope)value;
                    return function2;
                }

                public final Object invoke(Object object, Object object2) {
                    return (this.create(object, (Continuation)object2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)2, null);
        }

        public static /* synthetic */ void decodeApngAsyncInto$default(Companion companion, Context context, String string, ImageView imageView, float f, Callback callback, int n, Object object) {
            if ((n & 8) != 0) {
                f = 1.0f;
            }
            if ((n & 0x10) != 0) {
                callback = null;
            }
            companion.decodeApngAsyncInto(context, string, imageView, f, callback);
        }

        @JvmStatic
        @JvmOverloads
        public final void decodeApngAsyncInto(@NotNull Context context, @NotNull String string, @NotNull ImageView imageView, float speed) {
            oupson.apng.decoder.ApngDecoder$Companion.decodeApngAsyncInto$default(this, context, string, imageView, speed, null, 16, null);
        }

        @JvmStatic
        @JvmOverloads
        public final void decodeApngAsyncInto(@NotNull Context context, @NotNull String string, @NotNull ImageView imageView) {
            oupson.apng.decoder.ApngDecoder$Companion.decodeApngAsyncInto$default(this, context, string, imageView, 0.0f, null, 24, null);
        }

        private final byte[] generateIhdr(IHDR ihdrOfApng, int width, int height) {
            ArrayList ihdr = new ArrayList();
            ArrayList ihdrBody = new ArrayList();
            ihdr.addAll(ArraysKt.asList((byte[])Utils.Companion.to4Bytes(ihdrOfApng.getBody().length)));
            ihdrBody.addAll(ArraysKt.asList((byte[])new byte[]{(byte)73, (byte)72, (byte)68, (byte)82}));
            ihdrBody.addAll(ArraysKt.asList((byte[])Utils.Companion.to4Bytes(width)));
            ihdrBody.addAll(ArraysKt.asList((byte[])Utils.Companion.to4Bytes(height)));
            byte[] byArray = ihdrOfApng.getBody();
            int n = 8;
            int n2 = 13;
            ArrayList arrayList = ihdrBody;
            boolean bl = false;
            byte[] byArray2 = ArraysKt.copyOfRange((byte[])byArray, (int)n, (int)n2);
            arrayList.addAll(ArraysKt.asList((byte[])byArray2));
            CRC32 crC32 = new CRC32();
            crC32.update(CollectionsKt.toByteArray((Collection)ihdrBody), 0, ihdrBody.size());
            ihdr.addAll(ihdrBody);
            ihdr.addAll(ArraysKt.asList((byte[])Utils.Companion.to4Bytes((int)crC32.getValue())));
            return CollectionsKt.toByteArray((Collection)ihdr);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

