/*
 * Decompiled with CFR 0.152.
 */
package oshi.jna.platform.windows;

import com.sun.jna.Pointer;
import com.sun.jna.WString;
import com.sun.jna.platform.win32.COM.COMException;
import com.sun.jna.platform.win32.COM.COMUtils;
import com.sun.jna.platform.win32.OleAuto;
import com.sun.jna.platform.win32.Variant;
import com.sun.jna.platform.win32.WTypes;
import com.sun.jna.platform.win32.WinNT;
import com.sun.jna.ptr.IntByReference;
import com.sun.jna.ptr.PointerByReference;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeoutException;
import oshi.jna.platform.windows.Ole32;
import oshi.jna.platform.windows.Wbemcli;

public class WbemcliUtil {
    public static final WbemcliUtil INSTANCE = new WbemcliUtil();
    public static final String DEFAULT_NAMESPACE = "ROOT\\CIMV2";

    public static <T extends Enum<T>> WmiQuery<T> createQuery(String nameSpace, String wmiClassName, Class<T> propertyEnum) {
        WbemcliUtil wbemcliUtil = INSTANCE;
        wbemcliUtil.getClass();
        return wbemcliUtil.new WmiQuery<T>(nameSpace, wmiClassName, propertyEnum);
    }

    public static <T extends Enum<T>> WmiQuery<T> createQuery(String wmiClassName, Class<T> propertyEnum) {
        return WbemcliUtil.createQuery(DEFAULT_NAMESPACE, wmiClassName, propertyEnum);
    }

    public static boolean hasNamespace(String namespace) {
        String ns = namespace;
        if (namespace.toUpperCase().startsWith("ROOT\\")) {
            ns = namespace.substring(5);
        }
        WmiQuery<NamespaceProperty> namespaceQuery = WbemcliUtil.createQuery("ROOT", "__NAMESPACE", NamespaceProperty.class);
        WmiResult<NamespaceProperty> namespaces = WbemcliUtil.queryWMI(namespaceQuery);
        for (int i = 0; i < namespaces.getResultCount(); ++i) {
            if (!ns.equalsIgnoreCase((String)namespaces.getValue(NamespaceProperty.NAME, i))) continue;
            return true;
        }
        return false;
    }

    public static <T extends Enum<T>> WmiResult<T> queryWMI(WmiQuery<T> query) {
        try {
            return WbemcliUtil.queryWMI(query, -1);
        }
        catch (TimeoutException e) {
            throw new COMException("Got a WMI timeout when infinite wait was specified. This should never happen.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T extends Enum<T>> WmiResult<T> queryWMI(WmiQuery<T> query, int timeout) throws TimeoutException {
        if (((Enum[])query.getPropertyEnum().getEnumConstants()).length < 1) {
            throw new IllegalArgumentException("The query's property enum has no values.");
        }
        Wbemcli.IWbemServices svc = WbemcliUtil.connectServer(query.getNameSpace());
        try {
            WmiResult<T> wmiResult;
            Wbemcli.IEnumWbemClassObject enumerator = WbemcliUtil.selectProperties(svc, query);
            try {
                wmiResult = WbemcliUtil.enumerateProperties(enumerator, query.getPropertyEnum(), timeout);
            }
            catch (Throwable throwable) {
                enumerator.Release();
                throw throwable;
            }
            enumerator.Release();
            return wmiResult;
        }
        finally {
            svc.Release();
        }
    }

    public static Wbemcli.IWbemServices connectServer(String namespace) {
        PointerByReference pSvc = new PointerByReference();
        Wbemcli.IWbemLocator loc = Wbemcli.IWbemLocator.create();
        if (loc == null) {
            throw new COMException("Could not create IWbemLocator.");
        }
        WTypes.BSTR namespaceStr = OleAuto.INSTANCE.SysAllocString(namespace);
        WinNT.HRESULT hres = loc.ConnectServer(namespaceStr, null, null, null, 0, null, null, pSvc);
        OleAuto.INSTANCE.SysFreeString(namespaceStr);
        loc.Release();
        if (COMUtils.FAILED((WinNT.HRESULT)hres)) {
            throw new COMException(String.format("Could not connect to namespace %s. Error %08x", namespace, hres.intValue()));
        }
        hres = Ole32.INSTANCE.CoSetProxyBlanket(pSvc.getValue(), 10, 0, null, 3, 3, null, 0);
        if (COMUtils.FAILED((WinNT.HRESULT)hres)) {
            new Wbemcli.IWbemServices(pSvc.getValue()).Release();
            throw new COMException(String.format("Could not set proxy blanket. Error %08x", hres.intValue()));
        }
        return new Wbemcli.IWbemServices(pSvc.getValue());
    }

    public static <T extends Enum<T>> Wbemcli.IEnumWbemClassObject selectProperties(Wbemcli.IWbemServices svc, WmiQuery<T> query) {
        PointerByReference pEnumerator = new PointerByReference();
        Enum[] props = (Enum[])query.getPropertyEnum().getEnumConstants();
        StringBuilder sb = new StringBuilder("SELECT ");
        sb.append(props[0].name());
        for (int i = 1; i < props.length; ++i) {
            sb.append(',').append(props[i].name());
        }
        sb.append(" FROM ").append(query.getWmiClassName());
        WTypes.BSTR queryStr = OleAuto.INSTANCE.SysAllocString(sb.toString().replaceAll("\\\\", "\\\\\\\\"));
        WTypes.BSTR wql = OleAuto.INSTANCE.SysAllocString("WQL");
        WinNT.HRESULT hres = svc.ExecQuery(wql, queryStr, 48, null, pEnumerator);
        OleAuto.INSTANCE.SysFreeString(queryStr);
        OleAuto.INSTANCE.SysFreeString(wql);
        if (COMUtils.FAILED((WinNT.HRESULT)hres)) {
            throw new COMException(String.format("Query '%s' failed. Error %08x", sb.toString(), hres.intValue()));
        }
        return new Wbemcli.IEnumWbemClassObject(pEnumerator.getValue());
    }

    public static <T extends Enum<T>> WmiResult<T> enumerateProperties(Wbemcli.IEnumWbemClassObject enumerator, Class<T> propertyEnum, int timeout) throws TimeoutException {
        WbemcliUtil wbemcliUtil = INSTANCE;
        wbemcliUtil.getClass();
        WmiResult<T> values = wbemcliUtil.new WmiResult<T>(propertyEnum);
        PointerByReference pclsObj = new PointerByReference();
        IntByReference uReturn = new IntByReference(0);
        HashMap<Enum, WString> wstrMap = new HashMap<Enum, WString>();
        WinNT.HRESULT hres = null;
        for (Enum property : (Enum[])propertyEnum.getEnumConstants()) {
            wstrMap.put(property, new WString(property.name()));
        }
        while (enumerator.getPointer() != Pointer.NULL && (hres = enumerator.Next(timeout, 1, pclsObj, uReturn)).intValue() != 1 && hres.intValue() != 262149) {
            if (hres.intValue() == 262148) {
                throw new TimeoutException("No results after " + timeout + " ms.");
            }
            if (COMUtils.FAILED((WinNT.HRESULT)hres)) {
                throw new COMException(String.format("Failed to enumerate results. Error %08x", hres.intValue()));
            }
            Variant.VARIANT.ByReference pVal = new Variant.VARIANT.ByReference();
            IntByReference pType = new IntByReference();
            Wbemcli.IWbemClassObject clsObj = new Wbemcli.IWbemClassObject(pclsObj.getValue());
            for (Enum property : (Enum[])propertyEnum.getEnumConstants()) {
                clsObj.Get((WString)wstrMap.get(property), 0, pVal, pType, null);
                int vtType = pVal.getValue() == null ? Integer.valueOf(1) : pVal.getVarType();
                int cimType = pType.getValue();
                switch (vtType) {
                    case 8: {
                        ((WmiResult)values).add(vtType, cimType, property, pVal.stringValue());
                        break;
                    }
                    case 3: {
                        ((WmiResult)values).add(vtType, cimType, property, pVal.intValue());
                        break;
                    }
                    case 17: {
                        ((WmiResult)values).add(vtType, cimType, property, pVal.byteValue());
                        break;
                    }
                    case 2: {
                        ((WmiResult)values).add(vtType, cimType, property, pVal.shortValue());
                        break;
                    }
                    case 11: {
                        ((WmiResult)values).add(vtType, cimType, property, pVal.booleanValue());
                        break;
                    }
                    case 4: {
                        ((WmiResult)values).add(vtType, cimType, property, Float.valueOf(pVal.floatValue()));
                        break;
                    }
                    case 5: {
                        ((WmiResult)values).add(vtType, cimType, property, pVal.doubleValue());
                        break;
                    }
                    default: {
                        ((WmiResult)values).add(vtType, cimType, property, pVal.getValue());
                    }
                }
                OleAuto.INSTANCE.VariantClear((Variant.VARIANT)pVal);
            }
            clsObj.Release();
            ((WmiResult)values).incrementResultCount();
        }
        return values;
    }

    public class WmiResult<T extends Enum<T>> {
        private Map<T, List<Object>> propertyMap;
        private Map<T, Integer> vtTypeMap;
        private Map<T, Integer> cimTypeMap;
        private int resultCount = 0;

        public WmiResult(Class<T> propertyEnum) {
            this.propertyMap = new EnumMap<T, List<Object>>(propertyEnum);
            this.vtTypeMap = new EnumMap<T, Integer>(propertyEnum);
            this.cimTypeMap = new EnumMap<T, Integer>(propertyEnum);
            for (Enum type : (Enum[])propertyEnum.getEnumConstants()) {
                this.propertyMap.put(type, new ArrayList());
                this.vtTypeMap.put(type, 1);
                this.cimTypeMap.put(type, 0);
            }
        }

        public Object getValue(T property, int index) {
            return this.propertyMap.get(property).get(index);
        }

        public int getVtType(T property) {
            return this.vtTypeMap.get(property);
        }

        public int getCIMType(T property) {
            return this.cimTypeMap.get(property);
        }

        private void add(int vtType, int cimType, T property, Object o) {
            this.propertyMap.get(property).add(o);
            if (vtType != 1 && this.vtTypeMap.get(property).equals(1)) {
                this.vtTypeMap.put(property, vtType);
            }
            if (this.cimTypeMap.get(property).equals(0)) {
                this.cimTypeMap.put(property, cimType);
            }
        }

        public int getResultCount() {
            return this.resultCount;
        }

        private void incrementResultCount() {
            ++this.resultCount;
        }
    }

    public class WmiQuery<T extends Enum<T>> {
        private String nameSpace;
        private String wmiClassName;
        private Class<T> propertyEnum;

        public WmiQuery(String nameSpace, String wmiClassName, Class<T> propertyEnum) {
            this.nameSpace = nameSpace;
            this.wmiClassName = wmiClassName;
            this.propertyEnum = propertyEnum;
        }

        public Class<T> getPropertyEnum() {
            return this.propertyEnum;
        }

        public String getNameSpace() {
            return this.nameSpace;
        }

        public void setNameSpace(String nameSpace) {
            this.nameSpace = nameSpace;
        }

        public String getWmiClassName() {
            return this.wmiClassName;
        }

        public void setWmiClassName(String wmiClassName) {
            this.wmiClassName = wmiClassName;
        }
    }

    private static enum NamespaceProperty {
        NAME;

    }
}

