/*
 * Decompiled with CFR 0.152.
 */
package oshi.hardware.platform.windows;

import com.sun.jna.platform.win32.Kernel32;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import oshi.hardware.Disks;
import oshi.hardware.HWDiskStore;
import oshi.hardware.HWPartition;
import oshi.jna.platform.windows.PdhUtil;
import oshi.util.MapUtil;
import oshi.util.ParseUtil;
import oshi.util.platform.windows.PerfDataUtil;
import oshi.util.platform.windows.WmiUtil;

public class WindowsDisks
implements Disks {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = LoggerFactory.getLogger(WindowsDisks.class);
    private static Map<String, Long> readMap = new HashMap<String, Long>();
    private static Map<String, Long> readByteMap = new HashMap<String, Long>();
    private static Map<String, Long> writeMap = new HashMap<String, Long>();
    private static Map<String, Long> writeByteMap = new HashMap<String, Long>();
    private static Map<String, Long> xferTimeMap = new HashMap<String, Long>();
    private static Map<String, Long> timeStampMap = new HashMap<String, Long>();
    private static Map<String, List<String>> driveToPartitionMap = new HashMap<String, List<String>>();
    private static Map<String, String> partitionToLogicalDriveMap = new HashMap<String, String>();
    private static Map<String, HWPartition> partitionMap = new HashMap<String, HWPartition>();
    private static final Pattern DEVICE_ID = Pattern.compile(".*\\.DeviceID=\"(.*)\"");
    private static final int BUFSIZE = 255;
    private static final WmiUtil.WmiQuery<DiskDriveProperty> DISK_DRIVE_QUERY = WmiUtil.createQuery("Win32_DiskDrive", DiskDriveProperty.class);
    private static final WmiUtil.WmiQuery<DriveToPartitionProperty> DRIVE_TO_PARTITION_QUERY = WmiUtil.createQuery("Win32_DiskDriveToDiskPartition", DriveToPartitionProperty.class);
    private static final WmiUtil.WmiQuery<DriveToPartitionProperty> DISK_TO_PARTITION_QUERY = WmiUtil.createQuery("Win32_LogicalDiskToPartition", DriveToPartitionProperty.class);
    private static final WmiUtil.WmiQuery<DiskPartitionProperty> PARTITION_QUERY = WmiUtil.createQuery("Win32_DiskPartition", DiskPartitionProperty.class);
    private static final String PDH_DISK_READS_FORMAT = "\\PhysicalDisk(%s)\\Disk Reads/sec";
    private static final String PDH_DISK_READ_BYTES_FORMAT = "\\PhysicalDisk(%s)\\Disk Read Bytes/sec";
    private static final String PDH_DISK_WRITES_FORMAT = "\\PhysicalDisk(%s)\\Disk Writes/sec";
    private static final String PDH_DISK_WRITE_BYTES_FORMAT = "\\PhysicalDisk(%s)\\Disk Write Bytes/sec";
    private static final String PDH_DISK_TIME_FORMAT = "\\PhysicalDisk(%s)\\%% Disk Time";
    private static final String PHYSICALDRIVE_PREFIX = "\\\\.\\PHYSICALDRIVE";

    public static boolean updateDiskStats(HWDiskStore diskStore) {
        String index = null;
        HWPartition[] partitions = diskStore.getPartitions();
        if (partitions.length > 0) {
            index = Integer.toString(partitions[0].getMajor());
        } else if (diskStore.getName().startsWith(PHYSICALDRIVE_PREFIX)) {
            index = diskStore.getName().substring(PHYSICALDRIVE_PREFIX.length(), diskStore.getName().length());
        } else {
            LOG.warn("Couldn't match index for {}", (Object)diskStore.getName());
            return false;
        }
        WindowsDisks.populateReadWriteMaps(index);
        if (readMap.containsKey(index)) {
            diskStore.setReads(MapUtil.getOrDefault(readMap, index, 0L));
            diskStore.setReadBytes(MapUtil.getOrDefault(readByteMap, index, 0L));
            diskStore.setWrites(MapUtil.getOrDefault(writeMap, index, 0L));
            diskStore.setWriteBytes(MapUtil.getOrDefault(writeByteMap, index, 0L));
            diskStore.setTransferTime(MapUtil.getOrDefault(xferTimeMap, index, 0L));
            diskStore.setTimeStamp(MapUtil.getOrDefault(timeStampMap, index, 0L));
            return true;
        }
        return false;
    }

    @Override
    public HWDiskStore[] getDisks() {
        ArrayList<HWDiskStore> result = new ArrayList<HWDiskStore>();
        WindowsDisks.populateReadWriteMaps(null);
        this.populatePartitionMaps();
        WmiUtil.WmiResult<DiskDriveProperty> vals = WmiUtil.queryWMI(DISK_DRIVE_QUERY);
        for (int i = 0; i < vals.getResultCount(); ++i) {
            HWDiskStore ds = new HWDiskStore();
            ds.setName(vals.getString(DiskDriveProperty.NAME, i));
            ds.setModel(String.format("%s %s", vals.getString(DiskDriveProperty.MODEL, i), vals.getString(DiskDriveProperty.MANUFACTURER, i)).trim());
            ds.setSerial(ParseUtil.hexStringToString(vals.getString(DiskDriveProperty.SERIALNUMBER, i)));
            String index = vals.getInteger(DiskDriveProperty.INDEX, i).toString();
            ds.setReads(MapUtil.getOrDefault(readMap, index, 0L));
            ds.setReadBytes(MapUtil.getOrDefault(readByteMap, index, 0L));
            ds.setWrites(MapUtil.getOrDefault(writeMap, index, 0L));
            ds.setWriteBytes(MapUtil.getOrDefault(writeByteMap, index, 0L));
            ds.setTransferTime(MapUtil.getOrDefault(xferTimeMap, index, 0L));
            ds.setTimeStamp(MapUtil.getOrDefault(timeStampMap, index, 0L));
            ds.setSize(ParseUtil.parseLongOrDefault(vals.getString(DiskDriveProperty.SIZE, i), 0L));
            ArrayList<HWPartition> partitions = new ArrayList<HWPartition>();
            List<String> partList = driveToPartitionMap.get(ds.getName());
            if (partList != null && !partList.isEmpty()) {
                for (String part : partList) {
                    if (!partitionMap.containsKey(part)) continue;
                    partitions.add(partitionMap.get(part));
                }
            }
            ds.setPartitions(partitions.toArray(new HWPartition[partitions.size()]));
            result.add(ds);
        }
        return result.toArray(new HWDiskStore[result.size()]);
    }

    private static void populateReadWriteMaps(String index) {
        PdhUtil.PdhEnumObjectItems objectItems;
        if (index == null) {
            readMap.clear();
            readByteMap.clear();
            writeMap.clear();
            writeByteMap.clear();
            xferTimeMap.clear();
            timeStampMap.clear();
        }
        try {
            objectItems = PdhUtil.PdhEnumObjectItems(null, null, "PhysicalDisk", 100);
        }
        catch (PdhUtil.PdhException e) {
            LOG.error("Unable to enumerate instances for PhysicalDisk.");
            return;
        }
        List<String> instances = objectItems.getInstances();
        instances.remove("_Total");
        for (String i : instances) {
            String xferTimeString;
            String writeBytesString;
            String writeString;
            String readBytesString;
            String name = ParseUtil.whitespaces.split(i)[0];
            String readString = String.format(PDH_DISK_READS_FORMAT, i);
            if (!PerfDataUtil.isCounter(readString)) {
                PerfDataUtil.addCounter(readString);
            }
            if (!PerfDataUtil.isCounter(readBytesString = String.format(PDH_DISK_READ_BYTES_FORMAT, i))) {
                PerfDataUtil.addCounter(readBytesString);
            }
            if (!PerfDataUtil.isCounter(writeString = String.format(PDH_DISK_WRITES_FORMAT, i))) {
                PerfDataUtil.addCounter(writeString);
            }
            if (!PerfDataUtil.isCounter(writeBytesString = String.format(PDH_DISK_WRITE_BYTES_FORMAT, i))) {
                PerfDataUtil.addCounter(writeBytesString);
            }
            if (!PerfDataUtil.isCounter(xferTimeString = String.format(PDH_DISK_TIME_FORMAT, i))) {
                PerfDataUtil.addCounter(xferTimeString);
            }
            readMap.put(name, PerfDataUtil.queryCounter(readString));
            readByteMap.put(name, PerfDataUtil.queryCounter(readBytesString));
            writeMap.put(name, PerfDataUtil.queryCounter(writeString));
            writeByteMap.put(name, PerfDataUtil.queryCounter(writeBytesString));
            xferTimeMap.put(name, PerfDataUtil.queryCounter(xferTimeString) / 10000L);
            timeStampMap.put(name, PerfDataUtil.queryCounterTimestamp(xferTimeString));
        }
    }

    private void populatePartitionMaps() {
        Matcher mDep;
        Matcher mAnt;
        driveToPartitionMap.clear();
        partitionToLogicalDriveMap.clear();
        partitionMap.clear();
        WmiUtil.WmiResult<DriveToPartitionProperty> drivePartitionMap = WmiUtil.queryWMI(DRIVE_TO_PARTITION_QUERY);
        for (int i = 0; i < drivePartitionMap.getResultCount(); ++i) {
            mAnt = DEVICE_ID.matcher(drivePartitionMap.getString(DriveToPartitionProperty.ANTECEDENT, i));
            mDep = DEVICE_ID.matcher(drivePartitionMap.getString(DriveToPartitionProperty.DEPENDENT, i));
            if (!mAnt.matches() || !mDep.matches()) continue;
            MapUtil.createNewListIfAbsent(driveToPartitionMap, mAnt.group(1).replaceAll("\\\\\\\\", "\\\\")).add(mDep.group(1));
        }
        WmiUtil.WmiResult<DriveToPartitionProperty> diskPartitionMap = WmiUtil.queryWMI(DISK_TO_PARTITION_QUERY);
        for (int i = 0; i < diskPartitionMap.getResultCount(); ++i) {
            mAnt = DEVICE_ID.matcher(diskPartitionMap.getString(DriveToPartitionProperty.ANTECEDENT, i));
            mDep = DEVICE_ID.matcher(diskPartitionMap.getString(DriveToPartitionProperty.DEPENDENT, i));
            if (!mAnt.matches() || !mDep.matches()) continue;
            partitionToLogicalDriveMap.put(mAnt.group(1), mDep.group(1) + "\\");
        }
        WmiUtil.WmiResult<DiskPartitionProperty> hwPartitionQueryMap = WmiUtil.queryWMI(PARTITION_QUERY);
        for (int i = 0; i < hwPartitionQueryMap.getResultCount(); ++i) {
            String deviceID = hwPartitionQueryMap.getString(DiskPartitionProperty.DEVICEID, i);
            String logicalDrive = MapUtil.getOrDefault(partitionToLogicalDriveMap, deviceID, "");
            String uuid = "";
            if (!logicalDrive.isEmpty()) {
                char[] volumeChr = new char[255];
                Kernel32.INSTANCE.GetVolumeNameForVolumeMountPoint(logicalDrive, volumeChr, 255);
                uuid = ParseUtil.parseUuidOrDefault(new String(volumeChr).trim(), "");
            }
            partitionMap.put(deviceID, new HWPartition(hwPartitionQueryMap.getString(DiskPartitionProperty.NAME, i), hwPartitionQueryMap.getString(DiskPartitionProperty.TYPE, i), hwPartitionQueryMap.getString(DiskPartitionProperty.DESCRIPTION, i), uuid, ParseUtil.parseLongOrDefault(hwPartitionQueryMap.getString(DiskPartitionProperty.SIZE, i), 0L), hwPartitionQueryMap.getInteger(DiskPartitionProperty.DISKINDEX, i), hwPartitionQueryMap.getInteger(DiskPartitionProperty.INDEX, i), logicalDrive));
        }
    }

    static enum DiskPartitionProperty {
        DESCRIPTION,
        DEVICEID,
        DISKINDEX,
        INDEX,
        NAME,
        SIZE,
        TYPE;

    }

    static enum DriveToPartitionProperty {
        ANTECEDENT,
        DEPENDENT;

    }

    static enum DiskDriveProperty {
        INDEX,
        MANUFACTURER,
        MODEL,
        NAME,
        SERIALNUMBER,
        SIZE;

    }
}

