/*
 * Decompiled with CFR 0.152.
 */
package oshi.software.os.windows;

import com.sun.jna.platform.win32.Kernel32;
import com.sun.jna.platform.win32.WinNT;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import oshi.software.os.FileSystem;
import oshi.software.os.OSFileStore;
import oshi.util.ParseUtil;
import oshi.util.platform.windows.PerfDataUtil;
import oshi.util.platform.windows.WmiUtil;

public class WindowsFileSystem
implements FileSystem {
    private static final long serialVersionUID = 1L;
    private static final int BUFSIZE = 255;
    private static final int SEM_FAILCRITICALERRORS = 1;
    private static final WmiUtil.WmiQuery<LogicalDiskProperty> LOGICAL_DISK_QUERY = WmiUtil.createQuery("Win32_LogicalDisk", LogicalDiskProperty.class);
    private static final String HANDLE_COUNT_COUNTER = "\\Process(_Total)\\Handle Count";
    private static final long maxWindowsHandles = System.getenv("ProgramFiles(x86)") == null ? 0xFF8000L : 0xFF0000L;

    public WindowsFileSystem() {
        Kernel32.INSTANCE.SetErrorMode(1);
    }

    @Override
    public OSFileStore[] getFileStores() {
        ArrayList<OSFileStore> result = this.getLocalVolumes();
        HashMap<String, OSFileStore> volumeMap = new HashMap<String, OSFileStore>();
        for (OSFileStore volume : result) {
            volumeMap.put(volume.getMount(), volume);
        }
        for (OSFileStore wmiVolume : this.getWmiVolumes()) {
            if (volumeMap.containsKey(wmiVolume.getMount())) {
                ((OSFileStore)volumeMap.get(wmiVolume.getMount())).setName(wmiVolume.getName());
                continue;
            }
            result.add(wmiVolume);
        }
        return result.toArray(new OSFileStore[result.size()]);
    }

    private ArrayList<OSFileStore> getLocalVolumes() {
        boolean retVal;
        ArrayList<OSFileStore> fs = new ArrayList<OSFileStore>();
        char[] aVolume = new char[255];
        WinNT.HANDLE hVol = Kernel32.INSTANCE.FindFirstVolume(aVolume, 255);
        if (hVol == WinNT.INVALID_HANDLE_VALUE) {
            return fs;
        }
        do {
            char[] fstype = new char[16];
            char[] name = new char[255];
            char[] mount = new char[255];
            WinNT.LARGE_INTEGER userFreeBytes = new WinNT.LARGE_INTEGER(0L);
            WinNT.LARGE_INTEGER totalBytes = new WinNT.LARGE_INTEGER(0L);
            WinNT.LARGE_INTEGER systemFreeBytes = new WinNT.LARGE_INTEGER(0L);
            String volume = new String(aVolume).trim();
            Kernel32.INSTANCE.GetVolumeInformation(volume, name, 255, null, null, null, fstype, 16);
            Kernel32.INSTANCE.GetVolumePathNamesForVolumeName(volume, mount, 255, null);
            Kernel32.INSTANCE.GetDiskFreeSpaceEx(volume, userFreeBytes, totalBytes, systemFreeBytes);
            String strMount = new String(mount).trim();
            String strName = new String(name).trim();
            String strFsType = new String(fstype).trim();
            String uuid = ParseUtil.parseUuidOrDefault(volume, "");
            if (strMount.isEmpty()) continue;
            fs.add(new OSFileStore(String.format("%s (%s)", strName, strMount), volume, strMount, this.getDriveType(strMount), strFsType, uuid, systemFreeBytes.getValue(), totalBytes.getValue()));
        } while (retVal = Kernel32.INSTANCE.FindNextVolume(hVol, aVolume, 255));
        Kernel32.INSTANCE.FindVolumeClose(hVol);
        return fs;
    }

    private List<OSFileStore> getWmiVolumes() {
        ArrayList<OSFileStore> fs = new ArrayList<OSFileStore>();
        WmiUtil.WmiResult<LogicalDiskProperty> drives = WmiUtil.queryWMI(LOGICAL_DISK_QUERY);
        for (int i = 0; i < drives.getResultCount(); ++i) {
            String volume;
            long free = (Long)drives.get(LogicalDiskProperty.FREESPACE).get(i);
            long total = (Long)drives.get(LogicalDiskProperty.SIZE).get(i);
            String description = (String)drives.get(LogicalDiskProperty.DESCRIPTION).get(i);
            String name = (String)drives.get(LogicalDiskProperty.NAME).get(i);
            long type = (Long)drives.get(LogicalDiskProperty.DRIVETYPE).get(i);
            if (type != 4L) {
                char[] chrVolume = new char[255];
                Kernel32.INSTANCE.GetVolumeNameForVolumeMountPoint(name + "\\", chrVolume, 255);
                volume = new String(chrVolume).trim();
            } else {
                volume = (String)drives.get(LogicalDiskProperty.PROVIDERNAME).get(i);
                String[] split = volume.split("\\\\");
                if (split.length > 1 && split[split.length - 1].length() > 0) {
                    description = split[split.length - 1];
                }
            }
            fs.add(new OSFileStore(String.format("%s (%s)", description, name), volume, name + "\\", this.getDriveType(name), (String)drives.get(LogicalDiskProperty.FILESYSTEM).get(i), "", free, total));
        }
        return fs;
    }

    private String getDriveType(String drive) {
        switch (Kernel32.INSTANCE.GetDriveType(drive)) {
            case 2: {
                return "Removable drive";
            }
            case 3: {
                return "Fixed drive";
            }
            case 4: {
                return "Network drive";
            }
            case 5: {
                return "CD-ROM";
            }
            case 6: {
                return "RAM drive";
            }
        }
        return "Unknown drive type";
    }

    @Override
    public long getOpenFileDescriptors() {
        if (!PerfDataUtil.isCounter(HANDLE_COUNT_COUNTER)) {
            PerfDataUtil.addCounter(HANDLE_COUNT_COUNTER);
        }
        return PerfDataUtil.queryCounter(HANDLE_COUNT_COUNTER);
    }

    @Override
    public long getMaxFileDescriptors() {
        return maxWindowsHandles;
    }

    static enum LogicalDiskProperty implements WmiUtil.WmiProperty
    {
        DESCRIPTION(WmiUtil.ValueType.STRING),
        DRIVETYPE(WmiUtil.ValueType.UINT32),
        FILESYSTEM(WmiUtil.ValueType.STRING),
        FREESPACE(WmiUtil.ValueType.UINT64),
        NAME(WmiUtil.ValueType.STRING),
        PROVIDERNAME(WmiUtil.ValueType.STRING),
        SIZE(WmiUtil.ValueType.UINT64);

        private WmiUtil.ValueType type;

        private LogicalDiskProperty(WmiUtil.ValueType type) {
            this.type = type;
        }

        @Override
        public WmiUtil.ValueType getType() {
            return this.type;
        }
    }
}

