/*
 * Decompiled with CFR 0.152.
 */
package oshi.hardware.platform.windows;

import java.util.Calendar;
import oshi.hardware.common.AbstractFirmware;
import oshi.util.platform.windows.WmiUtil;

final class WindowsFirmware
extends AbstractFirmware {
    private static final long serialVersionUID = 1L;

    WindowsFirmware() {
        this.init();
    }

    private void init() {
        WmiUtil.WmiQuery<BiosProperty> biosQuery = WmiUtil.createQuery("Win32_BIOS where PrimaryBIOS=true", BiosProperty.class);
        WmiUtil.WmiResult<BiosProperty> win32BIOS = WmiUtil.queryWMI(biosQuery);
        if (win32BIOS.getResultCount() > 0) {
            this.setManufacturer((String)win32BIOS.get(BiosProperty.MANUFACTURER).get(0));
            this.setName((String)win32BIOS.get(BiosProperty.NAME).get(0));
            this.setDescription((String)win32BIOS.get(BiosProperty.DESCRIPTION).get(0));
            this.setVersion((String)win32BIOS.get(BiosProperty.VERSION).get(0));
            Calendar c = Calendar.getInstance();
            c.setTimeInMillis((Long)win32BIOS.get(BiosProperty.RELEASEDATE).get(0));
            this.setReleaseDate(String.format("%04d-%02d-%02d", c.get(1), c.get(2) + 1, c.get(5)));
        }
    }

    static enum BiosProperty implements WmiUtil.WmiProperty
    {
        MANUFACTURER(WmiUtil.ValueType.STRING),
        NAME(WmiUtil.ValueType.STRING),
        DESCRIPTION(WmiUtil.ValueType.STRING),
        VERSION(WmiUtil.ValueType.STRING),
        RELEASEDATE(WmiUtil.ValueType.DATETIME);

        private WmiUtil.ValueType type;

        private BiosProperty(WmiUtil.ValueType type) {
            this.type = type;
        }

        @Override
        public WmiUtil.ValueType getType() {
            return this.type;
        }
    }
}

