/*
 * Decompiled with CFR 0.152.
 */
package oshi.hardware.platform.windows;

import com.sun.jna.platform.win32.Kernel32;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import oshi.hardware.Disks;
import oshi.hardware.HWDiskStore;
import oshi.hardware.HWPartition;
import oshi.jna.platform.windows.PdhUtilJNA;
import oshi.util.MapUtil;
import oshi.util.ParseUtil;
import oshi.util.platform.windows.PdhUtil;
import oshi.util.platform.windows.WmiUtil;

public class WindowsDisks
implements Disks {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG;
    private static Map<String, Long> readMap;
    private static Map<String, Long> readByteMap;
    private static Map<String, Long> writeMap;
    private static Map<String, Long> writeByteMap;
    private static Map<String, Long> xferTimeMap;
    private static Map<String, Long> timeStampMap;
    private static Map<String, List<String>> driveToPartitionMap;
    private static Map<String, String> partitionToLogicalDriveMap;
    private static Map<String, HWPartition> partitionMap;
    private static final Pattern DEVICE_ID;
    private static final int BUFSIZE = 255;
    private static final String DISK_DRIVE_CLASS = "Win32_DiskDrive";
    private static final WmiProperty[] DRIVE_PROPERTIES;
    private static final String[] DRIVE_STRINGS;
    private static final WmiUtil.ValueType[] DRIVE_TYPES;
    private static final WmiProperty[] DISK_TO_PARTITION_PROPERTIES;
    private static final String[] DISK_TO_PARTITION_STRINGS;
    private static final WmiUtil.ValueType[] DISK_TO_PARTITION_TYPES;
    private static final WmiProperty[] PARTITION_PROPERTIES;
    private static final String[] PARTITION_STRINGS;
    private static final WmiUtil.ValueType[] PARTITION_TYPES;
    private static final String PDH_DISK_READS_FORMAT = "\\PhysicalDisk(%s)\\Disk Reads/sec";
    private static final String PDH_DISK_READ_BYTES_FORMAT = "\\PhysicalDisk(%s)\\Disk Read Bytes/sec";
    private static final String PDH_DISK_WRITES_FORMAT = "\\PhysicalDisk(%s)\\Disk Writes/sec";
    private static final String PDH_DISK_WRITE_BYTES_FORMAT = "\\PhysicalDisk(%s)\\Disk Write Bytes/sec";
    private static final String PDH_DISK_TIME_FORMAT = "\\PhysicalDisk(%s)\\%% Disk Time";
    private static final String PHYSICALDRIVE_PREFIX = "\\\\.\\PHYSICALDRIVE";

    public static boolean updateDiskStats(HWDiskStore diskStore) {
        String index = null;
        HWPartition[] partitions = diskStore.getPartitions();
        if (partitions.length > 0) {
            index = Integer.toString(partitions[0].getMajor());
        } else if (diskStore.getName().startsWith(PHYSICALDRIVE_PREFIX)) {
            index = diskStore.getName().substring(PHYSICALDRIVE_PREFIX.length(), diskStore.getName().length());
        } else {
            LOG.warn("Couldn't match index for {}", (Object)diskStore.getName());
            return false;
        }
        WindowsDisks.populateReadWriteMaps(index);
        if (readMap.containsKey(index)) {
            diskStore.setReads(MapUtil.getOrDefault(readMap, index, 0L));
            diskStore.setReadBytes(MapUtil.getOrDefault(readByteMap, index, 0L));
            diskStore.setWrites(MapUtil.getOrDefault(writeMap, index, 0L));
            diskStore.setWriteBytes(MapUtil.getOrDefault(writeByteMap, index, 0L));
            diskStore.setTransferTime(MapUtil.getOrDefault(xferTimeMap, index, 0L));
            diskStore.setTimeStamp(MapUtil.getOrDefault(timeStampMap, index, 0L));
            return true;
        }
        return false;
    }

    @Override
    public HWDiskStore[] getDisks() {
        ArrayList<HWDiskStore> result = new ArrayList<HWDiskStore>();
        WindowsDisks.populateReadWriteMaps(null);
        this.populatePartitionMaps();
        Map<String, List<Object>> vals = WmiUtil.selectObjectsFrom(null, DISK_DRIVE_CLASS, DRIVE_STRINGS, null, DRIVE_TYPES);
        for (int i = 0; i < vals.get(WmiProperty.NAME.name()).size(); ++i) {
            HWDiskStore ds = new HWDiskStore();
            ds.setName((String)vals.get(WmiProperty.NAME.name()).get(i));
            ds.setModel(String.format("%s %s", vals.get(WmiProperty.MODEL.name()).get(i), vals.get(WmiProperty.MANUFACTURER.name()).get(i)).trim());
            ds.setSerial(ParseUtil.hexStringToString((String)vals.get(WmiProperty.SERIALNUMBER.name()).get(i)));
            String index = vals.get(WmiProperty.INDEX.name()).get(i).toString();
            ds.setReads(MapUtil.getOrDefault(readMap, index, 0L));
            ds.setReadBytes(MapUtil.getOrDefault(readByteMap, index, 0L));
            ds.setWrites(MapUtil.getOrDefault(writeMap, index, 0L));
            ds.setWriteBytes(MapUtil.getOrDefault(writeByteMap, index, 0L));
            ds.setTransferTime(MapUtil.getOrDefault(xferTimeMap, index, 0L));
            ds.setTimeStamp(MapUtil.getOrDefault(timeStampMap, index, 0L));
            ds.setSize((Long)vals.get(WmiProperty.SIZE.name()).get(i));
            ArrayList<HWPartition> partitions = new ArrayList<HWPartition>();
            List<String> partList = driveToPartitionMap.get(ds.getName());
            if (partList != null && !partList.isEmpty()) {
                for (String part : partList) {
                    partitions.add(partitionMap.get(part));
                }
            }
            ds.setPartitions(partitions.toArray(new HWPartition[partitions.size()]));
            result.add(ds);
        }
        return result.toArray(new HWDiskStore[result.size()]);
    }

    private static void populateReadWriteMaps(String index) {
        if (index == null) {
            readMap.clear();
            readByteMap.clear();
            writeMap.clear();
            writeByteMap.clear();
            xferTimeMap.clear();
            timeStampMap.clear();
        }
        List<String> instances = PdhUtilJNA.PdhEnumObjectItemInstances(null, null, "PhysicalDisk", 100);
        instances.remove("_Total");
        for (String i : instances) {
            String xferTimeString;
            String writeBytesString;
            String writeString;
            String readBytesString;
            String name = ParseUtil.whitespaces.split(i)[0];
            String readString = String.format(PDH_DISK_READS_FORMAT, i);
            if (!PdhUtil.isCounter(readString)) {
                PdhUtil.addCounter(readString);
            }
            if (!PdhUtil.isCounter(readBytesString = String.format(PDH_DISK_READ_BYTES_FORMAT, i))) {
                PdhUtil.addCounter(readBytesString);
            }
            if (!PdhUtil.isCounter(writeString = String.format(PDH_DISK_WRITES_FORMAT, i))) {
                PdhUtil.addCounter(writeString);
            }
            if (!PdhUtil.isCounter(writeBytesString = String.format(PDH_DISK_WRITE_BYTES_FORMAT, i))) {
                PdhUtil.addCounter(writeBytesString);
            }
            if (!PdhUtil.isCounter(xferTimeString = String.format(PDH_DISK_TIME_FORMAT, i))) {
                PdhUtil.addCounter(xferTimeString);
            }
            readMap.put(name, PdhUtil.queryCounter(readString));
            readByteMap.put(name, PdhUtil.queryCounter(readBytesString));
            writeMap.put(name, PdhUtil.queryCounter(writeString));
            writeByteMap.put(name, PdhUtil.queryCounter(writeBytesString));
            xferTimeMap.put(name, PdhUtil.queryCounter(xferTimeString) / 10000L);
            timeStampMap.put(name, PdhUtil.queryCounterTimestamp(xferTimeString));
        }
    }

    private void populatePartitionMaps() {
        Matcher mDep;
        Matcher mAnt;
        int i;
        driveToPartitionMap.clear();
        partitionToLogicalDriveMap.clear();
        partitionMap.clear();
        Map<String, List<Object>> partitionQueryMap = WmiUtil.selectObjectsFrom(null, "Win32_DiskDriveToDiskPartition", DISK_TO_PARTITION_STRINGS, null, DISK_TO_PARTITION_TYPES);
        for (i = 0; i < partitionQueryMap.get(WmiProperty.ANTECEDENT.name()).size(); ++i) {
            mAnt = DEVICE_ID.matcher((String)partitionQueryMap.get(WmiProperty.ANTECEDENT.name()).get(i));
            mDep = DEVICE_ID.matcher((String)partitionQueryMap.get(WmiProperty.DEPENDENT.name()).get(i));
            if (!mAnt.matches() || !mDep.matches()) continue;
            MapUtil.createNewListIfAbsent(driveToPartitionMap, mAnt.group(1).replaceAll("\\\\\\\\", "\\\\")).add(mDep.group(1));
        }
        partitionQueryMap = WmiUtil.selectObjectsFrom(null, "Win32_LogicalDiskToPartition", DISK_TO_PARTITION_STRINGS, null, DISK_TO_PARTITION_TYPES);
        for (i = 0; i < partitionQueryMap.get(WmiProperty.ANTECEDENT.name()).size(); ++i) {
            mAnt = DEVICE_ID.matcher((String)partitionQueryMap.get(WmiProperty.ANTECEDENT.name()).get(i));
            mDep = DEVICE_ID.matcher((String)partitionQueryMap.get(WmiProperty.DEPENDENT.name()).get(i));
            if (!mAnt.matches() || !mDep.matches()) continue;
            partitionToLogicalDriveMap.put(mAnt.group(1), mDep.group(1) + "\\");
        }
        Map<String, List<Object>> hwPartitionQueryMap = WmiUtil.selectObjectsFrom(null, "Win32_DiskPartition", PARTITION_STRINGS, null, PARTITION_TYPES);
        for (int i2 = 0; i2 < hwPartitionQueryMap.get(WmiProperty.NAME.name()).size(); ++i2) {
            String deviceID = (String)hwPartitionQueryMap.get(WmiProperty.DEVICEID.name()).get(i2);
            String logicalDrive = MapUtil.getOrDefault(partitionToLogicalDriveMap, deviceID, "");
            String uuid = "";
            if (!logicalDrive.isEmpty()) {
                char[] volumeChr = new char[255];
                Kernel32.INSTANCE.GetVolumeNameForVolumeMountPoint(logicalDrive, volumeChr, 255);
                uuid = ParseUtil.parseUuidOrDefault(new String(volumeChr).trim(), "");
            }
            partitionMap.put(deviceID, new HWPartition((String)hwPartitionQueryMap.get(WmiProperty.NAME.name()).get(i2), (String)hwPartitionQueryMap.get(WmiProperty.TYPE.name()).get(i2), (String)hwPartitionQueryMap.get(WmiProperty.DESCRIPTION.name()).get(i2), uuid, (Long)hwPartitionQueryMap.get(WmiProperty.SIZE.name()).get(i2), ((Long)hwPartitionQueryMap.get(WmiProperty.DISKINDEX.name()).get(i2)).intValue(), ((Long)hwPartitionQueryMap.get(WmiProperty.INDEX.name()).get(i2)).intValue(), logicalDrive));
        }
    }

    static {
        int i;
        LOG = LoggerFactory.getLogger(WindowsDisks.class);
        readMap = new HashMap<String, Long>();
        readByteMap = new HashMap<String, Long>();
        writeMap = new HashMap<String, Long>();
        writeByteMap = new HashMap<String, Long>();
        xferTimeMap = new HashMap<String, Long>();
        timeStampMap = new HashMap<String, Long>();
        driveToPartitionMap = new HashMap<String, List<String>>();
        partitionToLogicalDriveMap = new HashMap<String, String>();
        partitionMap = new HashMap<String, HWPartition>();
        DEVICE_ID = Pattern.compile(".*\\.DeviceID=\"(.*)\"");
        DRIVE_PROPERTIES = new WmiProperty[]{WmiProperty.NAME, WmiProperty.MANUFACTURER, WmiProperty.MODEL, WmiProperty.SERIALNUMBER, WmiProperty.SIZE, WmiProperty.INDEX};
        DRIVE_STRINGS = new String[DRIVE_PROPERTIES.length];
        for (i = 0; i < DRIVE_PROPERTIES.length; ++i) {
            WindowsDisks.DRIVE_STRINGS[i] = DRIVE_PROPERTIES[i].name();
        }
        DRIVE_TYPES = new WmiUtil.ValueType[DRIVE_PROPERTIES.length];
        for (i = 0; i < DRIVE_PROPERTIES.length; ++i) {
            WindowsDisks.DRIVE_TYPES[i] = DRIVE_PROPERTIES[i].getType();
        }
        DISK_TO_PARTITION_PROPERTIES = new WmiProperty[]{WmiProperty.ANTECEDENT, WmiProperty.DEPENDENT};
        DISK_TO_PARTITION_STRINGS = new String[DISK_TO_PARTITION_PROPERTIES.length];
        for (i = 0; i < DISK_TO_PARTITION_PROPERTIES.length; ++i) {
            WindowsDisks.DISK_TO_PARTITION_STRINGS[i] = DISK_TO_PARTITION_PROPERTIES[i].name();
        }
        DISK_TO_PARTITION_TYPES = new WmiUtil.ValueType[DISK_TO_PARTITION_PROPERTIES.length];
        for (i = 0; i < DISK_TO_PARTITION_PROPERTIES.length; ++i) {
            WindowsDisks.DISK_TO_PARTITION_TYPES[i] = DISK_TO_PARTITION_PROPERTIES[i].getType();
        }
        PARTITION_PROPERTIES = new WmiProperty[]{WmiProperty.NAME, WmiProperty.TYPE, WmiProperty.DESCRIPTION, WmiProperty.DEVICEID, WmiProperty.SIZE, WmiProperty.DISKINDEX, WmiProperty.INDEX};
        PARTITION_STRINGS = new String[PARTITION_PROPERTIES.length];
        for (i = 0; i < PARTITION_PROPERTIES.length; ++i) {
            WindowsDisks.PARTITION_STRINGS[i] = PARTITION_PROPERTIES[i].name();
        }
        PARTITION_TYPES = new WmiUtil.ValueType[PARTITION_PROPERTIES.length];
        for (i = 0; i < PARTITION_PROPERTIES.length; ++i) {
            WindowsDisks.PARTITION_TYPES[i] = PARTITION_PROPERTIES[i].getType();
        }
    }

    static enum WmiProperty {
        ANTECEDENT(WmiUtil.ValueType.STRING),
        DEPENDENT(WmiUtil.ValueType.STRING),
        DESCRIPTION(WmiUtil.ValueType.STRING),
        DEVICEID(WmiUtil.ValueType.STRING),
        DISKINDEX(WmiUtil.ValueType.UINT32),
        INDEX(WmiUtil.ValueType.UINT32),
        MANUFACTURER(WmiUtil.ValueType.STRING),
        MODEL(WmiUtil.ValueType.STRING),
        NAME(WmiUtil.ValueType.STRING),
        SERIALNUMBER(WmiUtil.ValueType.STRING),
        SIZE(WmiUtil.ValueType.UINT64),
        TYPE(WmiUtil.ValueType.STRING);

        private WmiUtil.ValueType type;

        public WmiUtil.ValueType getType() {
            return this.type;
        }

        private WmiProperty(WmiUtil.ValueType type) {
            this.type = type;
        }
    }
}

