/*
 * Decompiled with CFR 0.152.
 */
package oshi.software.os.unix.freebsd;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import oshi.jna.platform.linux.Libc;
import oshi.software.common.AbstractOperatingSystem;
import oshi.software.os.FileSystem;
import oshi.software.os.NetworkParams;
import oshi.software.os.OSProcess;
import oshi.software.os.OperatingSystem;
import oshi.software.os.unix.freebsd.FreeBsdFileSystem;
import oshi.software.os.unix.freebsd.FreeBsdNetworkParams;
import oshi.software.os.unix.freebsd.FreeBsdOSVersionInfoEx;
import oshi.util.ExecutingCommand;
import oshi.util.LsofUtil;
import oshi.util.MapUtil;
import oshi.util.ParseUtil;
import oshi.util.platform.unix.freebsd.BsdSysctlUtil;

public class FreeBsdOperatingSystem
extends AbstractOperatingSystem {
    private static final long serialVersionUID = 1L;

    public FreeBsdOperatingSystem() {
        this.manufacturer = "Unix/BSD";
        this.family = BsdSysctlUtil.sysctl("kern.ostype", "FreeBSD");
        this.version = new FreeBsdOSVersionInfoEx();
    }

    @Override
    public FileSystem getFileSystem() {
        return new FreeBsdFileSystem();
    }

    @Override
    public OSProcess[] getProcesses(int limit, OperatingSystem.ProcessSort sort) {
        List<OSProcess> procs = this.getProcessListFromPS("ps -awwxo state,pid,ppid,user,uid,group,gid,nlwp,pri,vsz,rss,etimes,systime,time,comm,args", -1);
        List<OSProcess> sorted = this.processSort(procs, limit, sort);
        return sorted.toArray(new OSProcess[sorted.size()]);
    }

    @Override
    public OSProcess getProcess(int pid) {
        List<OSProcess> procs = this.getProcessListFromPS("ps -awwxo state,pid,ppid,user,uid,group,gid,nlwp,pri,vsz,rss,etimes,systime,time,comm,args -p ", pid);
        if (procs.isEmpty()) {
            return null;
        }
        return procs.get(0);
    }

    private List<OSProcess> getProcessListFromPS(String psCommand, int pid) {
        Map<Integer, String> cwdMap = LsofUtil.getCwdMap(pid);
        ArrayList<OSProcess> procs = new ArrayList<OSProcess>();
        List<String> procList = ExecutingCommand.runNative(psCommand + (pid < 0 ? "" : Integer.valueOf(pid)));
        if (procList.isEmpty() || procList.size() < 2) {
            return procs;
        }
        procList.remove(0);
        for (String proc : procList) {
            String[] split = proc.trim().split("\\s+", 16);
            if (split.length < 16) continue;
            long now = System.currentTimeMillis();
            OSProcess fproc = new OSProcess();
            switch (split[0].charAt(0)) {
                case 'R': {
                    fproc.setState(OSProcess.State.RUNNING);
                    break;
                }
                case 'I': 
                case 'S': {
                    fproc.setState(OSProcess.State.SLEEPING);
                    break;
                }
                case 'D': 
                case 'L': 
                case 'U': {
                    fproc.setState(OSProcess.State.WAITING);
                    break;
                }
                case 'Z': {
                    fproc.setState(OSProcess.State.ZOMBIE);
                    break;
                }
                case 'T': {
                    fproc.setState(OSProcess.State.STOPPED);
                    break;
                }
                default: {
                    fproc.setState(OSProcess.State.OTHER);
                }
            }
            fproc.setProcessID(ParseUtil.parseIntOrDefault(split[1], 0));
            fproc.setParentProcessID(ParseUtil.parseIntOrDefault(split[2], 0));
            fproc.setUser(split[3]);
            fproc.setUserID(split[4]);
            fproc.setGroup(split[5]);
            fproc.setGroupID(split[6]);
            fproc.setThreadCount(ParseUtil.parseIntOrDefault(split[7], 0));
            fproc.setPriority(ParseUtil.parseIntOrDefault(split[8], 0));
            fproc.setVirtualSize(ParseUtil.parseLongOrDefault(split[9], 0L) * 1024L);
            fproc.setResidentSetSize(ParseUtil.parseLongOrDefault(split[10], 0L) * 1024L);
            long elapsedTime = ParseUtil.parseDHMSOrDefault(split[11], 0L);
            fproc.setUpTime(elapsedTime < 1L ? 1L : elapsedTime);
            fproc.setStartTime(now - fproc.getUpTime());
            fproc.setKernelTime(ParseUtil.parseDHMSOrDefault(split[12], 0L));
            fproc.setUserTime(ParseUtil.parseDHMSOrDefault(split[13], 0L) - fproc.getKernelTime());
            fproc.setPath(split[14]);
            fproc.setName(fproc.getPath().substring(fproc.getPath().lastIndexOf(47) + 1));
            fproc.setCommandLine(split[15]);
            fproc.setCurrentWorkingDirectory(MapUtil.getOrDefault(cwdMap, fproc.getProcessID(), ""));
            procs.add(fproc);
        }
        return procs;
    }

    @Override
    public int getProcessId() {
        return Libc.INSTANCE.getpid();
    }

    @Override
    public int getProcessCount() {
        List<String> procList = ExecutingCommand.runNative("ps -axo pid");
        if (!procList.isEmpty()) {
            return procList.size() - 1;
        }
        return 0;
    }

    @Override
    public int getThreadCount() {
        int threads = 0;
        for (String proc : ExecutingCommand.runNative("ps -axo nlwp")) {
            threads += ParseUtil.parseIntOrDefault(proc.trim(), 0);
        }
        return threads;
    }

    @Override
    public NetworkParams getNetworkParams() {
        return new FreeBsdNetworkParams();
    }
}

