/*
 * Decompiled with CFR 0.152.
 */
package oshi.software.common;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import oshi.software.os.OSProcess;
import oshi.software.os.OperatingSystem;
import oshi.software.os.OperatingSystemVersion;

public abstract class AbstractOperatingSystem
implements OperatingSystem {
    private static final long serialVersionUID = 1L;
    protected String manufacturer;
    protected String family;
    protected OperatingSystemVersion version;
    protected int bitness = System.getProperty("os.arch").indexOf("64") != -1 ? 64 : 32;
    private static final Comparator<OSProcess> CPU_DESC_SORT = new Comparator<OSProcess>(){

        @Override
        public int compare(OSProcess p1, OSProcess p2) {
            return Double.compare(p2.calculateCpuPercent(), p1.calculateCpuPercent());
        }
    };
    private static final Comparator<OSProcess> RSS_DESC_SORT = new Comparator<OSProcess>(){

        @Override
        public int compare(OSProcess p1, OSProcess p2) {
            return Long.compare(p2.getResidentSetSize(), p1.getResidentSetSize());
        }
    };
    private static final Comparator<OSProcess> UPTIME_DESC_SORT = new Comparator<OSProcess>(){

        @Override
        public int compare(OSProcess p1, OSProcess p2) {
            return Long.compare(p2.getUpTime(), p1.getUpTime());
        }
    };
    private static final Comparator<OSProcess> UPTIME_ASC_SORT = new Comparator<OSProcess>(){

        @Override
        public int compare(OSProcess p1, OSProcess p2) {
            return Long.compare(p1.getUpTime(), p2.getUpTime());
        }
    };
    private static final Comparator<OSProcess> PID_ASC_SORT = new Comparator<OSProcess>(){

        @Override
        public int compare(OSProcess p1, OSProcess p2) {
            return Integer.compare(p1.getProcessID(), p2.getProcessID());
        }
    };
    private static final Comparator<OSProcess> PARENTPID_ASC_SORT = new Comparator<OSProcess>(){

        @Override
        public int compare(OSProcess p1, OSProcess p2) {
            return Integer.compare(p1.getParentProcessID(), p2.getParentProcessID());
        }
    };
    private static final Comparator<OSProcess> NAME_ASC_SORT = new Comparator<OSProcess>(){

        @Override
        public int compare(OSProcess p1, OSProcess p2) {
            return p1.getName().toLowerCase().compareTo(p2.getName().toLowerCase());
        }
    };

    @Override
    public OperatingSystemVersion getVersion() {
        return this.version;
    }

    @Override
    public String getFamily() {
        return this.family;
    }

    @Override
    public String getManufacturer() {
        return this.manufacturer;
    }

    protected List<OSProcess> processSort(List<OSProcess> processes, int limit, OperatingSystem.ProcessSort sort) {
        if (sort != null) {
            switch (sort) {
                case CPU: {
                    Collections.sort(processes, CPU_DESC_SORT);
                    break;
                }
                case MEMORY: {
                    Collections.sort(processes, RSS_DESC_SORT);
                    break;
                }
                case OLDEST: {
                    Collections.sort(processes, UPTIME_DESC_SORT);
                    break;
                }
                case NEWEST: {
                    Collections.sort(processes, UPTIME_ASC_SORT);
                    break;
                }
                case PID: {
                    Collections.sort(processes, PID_ASC_SORT);
                    break;
                }
                case PARENTPID: {
                    Collections.sort(processes, PARENTPID_ASC_SORT);
                    break;
                }
                case NAME: {
                    Collections.sort(processes, NAME_ASC_SORT);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unimplemented enum type: " + sort.toString());
                }
            }
        }
        int maxProcs = processes.size();
        if (limit <= 0 || maxProcs <= limit) {
            return processes;
        }
        maxProcs = limit;
        ArrayList<OSProcess> procs = new ArrayList<OSProcess>();
        for (int i = 0; i < maxProcs; ++i) {
            procs.add(processes.get(i));
        }
        return procs;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getManufacturer()).append(' ').append(this.getFamily()).append(' ').append(this.getVersion().toString());
        return sb.toString();
    }

    @Override
    public OSProcess[] getProcesses(int limit, OperatingSystem.ProcessSort sort) {
        return this.getProcesses(limit, sort, false);
    }

    @Override
    public List<OSProcess> getProcesses(Collection<Integer> pids) {
        ArrayList<OSProcess> returnValue = new ArrayList<OSProcess>(pids.size());
        for (Integer pid : pids) {
            OSProcess process = this.getProcess(pid);
            if (process == null) continue;
            returnValue.add(process);
        }
        return returnValue;
    }

    @Override
    public int getBitness() {
        return this.bitness;
    }
}

