/*
 * Decompiled with CFR 0.152.
 */
package oshi.software.os.windows;

import com.sun.jna.platform.win32.COM.WbemcliUtil;
import com.sun.jna.platform.win32.Kernel32;
import com.sun.jna.platform.win32.WinNT;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import oshi.software.os.FileSystem;
import oshi.software.os.OSFileStore;
import oshi.util.ParseUtil;
import oshi.util.platform.windows.PerfDataUtil;
import oshi.util.platform.windows.WmiUtil;

public class WindowsFileSystem
implements FileSystem {
    private static final long serialVersionUID = 1L;
    private static final int BUFSIZE = 255;
    private static final int SEM_FAILCRITICALERRORS = 1;
    private final transient WbemcliUtil.WmiQuery<LogicalDiskProperty> LOGICAL_DISK_QUERY = new WbemcliUtil.WmiQuery("Win32_LogicalDisk", LogicalDiskProperty.class);
    private transient PerfDataUtil.PerfCounter handleCountCounter = null;
    private transient WbemcliUtil.WmiQuery<HandleCountProperty> handleCountQuery = null;
    private static final long MAX_WINDOWS_HANDLES = System.getenv("ProgramFiles(x86)") == null ? 0xFF8000L : 0xFF0000L;

    public WindowsFileSystem() {
        Kernel32.INSTANCE.SetErrorMode(1);
        this.initPdhCounters();
    }

    private void initPdhCounters() {
        this.handleCountCounter = PerfDataUtil.createCounter("Process", "_Total", "Handle Count");
        if (!PerfDataUtil.addCounterToQuery(this.handleCountCounter)) {
            this.handleCountCounter = null;
            this.handleCountQuery = new WbemcliUtil.WmiQuery("Win32_Process", HandleCountProperty.class);
        }
    }

    @Override
    public OSFileStore[] getFileStores() {
        ArrayList<OSFileStore> result = this.getLocalVolumes();
        HashMap<String, OSFileStore> volumeMap = new HashMap<String, OSFileStore>();
        for (OSFileStore volume : result) {
            volumeMap.put(volume.getMount(), volume);
        }
        for (OSFileStore wmiVolume : this.getWmiVolumes()) {
            if (volumeMap.containsKey(wmiVolume.getMount())) {
                ((OSFileStore)volumeMap.get(wmiVolume.getMount())).setName(wmiVolume.getName());
                continue;
            }
            result.add(wmiVolume);
        }
        return result.toArray(new OSFileStore[result.size()]);
    }

    private ArrayList<OSFileStore> getLocalVolumes() {
        boolean retVal;
        ArrayList<OSFileStore> fs = new ArrayList<OSFileStore>();
        char[] aVolume = new char[255];
        WinNT.HANDLE hVol = Kernel32.INSTANCE.FindFirstVolume(aVolume, 255);
        if (hVol == WinNT.INVALID_HANDLE_VALUE) {
            return fs;
        }
        do {
            char[] fstype = new char[16];
            char[] name = new char[255];
            char[] mount = new char[255];
            WinNT.LARGE_INTEGER userFreeBytes = new WinNT.LARGE_INTEGER(0L);
            WinNT.LARGE_INTEGER totalBytes = new WinNT.LARGE_INTEGER(0L);
            WinNT.LARGE_INTEGER systemFreeBytes = new WinNT.LARGE_INTEGER(0L);
            String volume = new String(aVolume).trim();
            Kernel32.INSTANCE.GetVolumeInformation(volume, name, 255, null, null, null, fstype, 16);
            Kernel32.INSTANCE.GetVolumePathNamesForVolumeName(volume, mount, 255, null);
            Kernel32.INSTANCE.GetDiskFreeSpaceEx(volume, userFreeBytes, totalBytes, systemFreeBytes);
            String strMount = new String(mount).trim();
            String strName = new String(name).trim();
            String strFsType = new String(fstype).trim();
            String uuid = ParseUtil.parseUuidOrDefault(volume, "");
            if (strMount.isEmpty()) continue;
            OSFileStore osStore = new OSFileStore();
            osStore.setName(String.format("%s (%s)", strName, strMount));
            osStore.setVolume(volume);
            osStore.setMount(strMount);
            osStore.setDescription(this.getDriveType(strMount));
            osStore.setType(strFsType);
            osStore.setUUID(uuid);
            osStore.setUsableSpace(systemFreeBytes.getValue());
            osStore.setTotalSpace(totalBytes.getValue());
            fs.add(osStore);
        } while (retVal = Kernel32.INSTANCE.FindNextVolume(hVol, aVolume, 255));
        Kernel32.INSTANCE.FindVolumeClose(hVol);
        return fs;
    }

    private List<OSFileStore> getWmiVolumes() {
        ArrayList<OSFileStore> fs = new ArrayList<OSFileStore>();
        WbemcliUtil.WmiResult<LogicalDiskProperty> drives = WmiUtil.queryWMI(this.LOGICAL_DISK_QUERY);
        for (int i = 0; i < drives.getResultCount(); ++i) {
            String volume;
            long free = WmiUtil.getUint64(drives, LogicalDiskProperty.FREESPACE, i);
            long total = WmiUtil.getUint64(drives, LogicalDiskProperty.SIZE, i);
            String description = WmiUtil.getString(drives, LogicalDiskProperty.DESCRIPTION, i);
            String name = WmiUtil.getString(drives, LogicalDiskProperty.NAME, i);
            int type = WmiUtil.getUint32(drives, LogicalDiskProperty.DRIVETYPE, i);
            if (type != 4) {
                char[] chrVolume = new char[255];
                Kernel32.INSTANCE.GetVolumeNameForVolumeMountPoint(name + "\\", chrVolume, 255);
                volume = new String(chrVolume).trim();
            } else {
                volume = WmiUtil.getString(drives, LogicalDiskProperty.PROVIDERNAME, i);
                String[] split = volume.split("\\\\");
                if (split.length > 1 && split[split.length - 1].length() > 0) {
                    description = split[split.length - 1];
                }
            }
            OSFileStore osStore = new OSFileStore();
            osStore.setName(String.format("%s (%s)", description, name));
            osStore.setVolume(volume);
            osStore.setMount(name + "\\");
            osStore.setDescription(this.getDriveType(name));
            osStore.setType(WmiUtil.getString(drives, LogicalDiskProperty.FILESYSTEM, i));
            osStore.setUUID("");
            osStore.setUsableSpace(free);
            osStore.setTotalSpace(total);
            fs.add(osStore);
        }
        return fs;
    }

    private String getDriveType(String drive) {
        switch (Kernel32.INSTANCE.GetDriveType(drive)) {
            case 2: {
                return "Removable drive";
            }
            case 3: {
                return "Fixed drive";
            }
            case 4: {
                return "Network drive";
            }
            case 5: {
                return "CD-ROM";
            }
            case 6: {
                return "RAM drive";
            }
        }
        return "Unknown drive type";
    }

    @Override
    public long getOpenFileDescriptors() {
        if (this.handleCountCounter != null) {
            PerfDataUtil.updateQuery(this.handleCountCounter);
            return PerfDataUtil.queryCounter(this.handleCountCounter);
        }
        WbemcliUtil.WmiResult<HandleCountProperty> result = WmiUtil.queryWMI(this.handleCountQuery);
        long descriptors = 0L;
        for (int i = 0; i < result.getResultCount(); ++i) {
            descriptors += (long)WmiUtil.getUint32(result, HandleCountProperty.HANDLECOUNT, i);
        }
        return descriptors;
    }

    @Override
    public long getMaxFileDescriptors() {
        return MAX_WINDOWS_HANDLES;
    }

    static enum HandleCountProperty {
        HANDLECOUNT;

    }

    static enum LogicalDiskProperty {
        DESCRIPTION,
        DRIVETYPE,
        FILESYSTEM,
        FREESPACE,
        NAME,
        PROVIDERNAME,
        SIZE;

    }
}

