/*
 * Decompiled with CFR 0.152.
 */
package oshi.hardware.platform.windows;

import com.sun.jna.platform.win32.COM.WbemcliUtil;
import com.sun.jna.platform.win32.Kernel32;
import com.sun.jna.platform.win32.PdhUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import oshi.hardware.Disks;
import oshi.hardware.HWDiskStore;
import oshi.hardware.HWPartition;
import oshi.util.MapUtil;
import oshi.util.ParseUtil;
import oshi.util.platform.windows.PerfDataUtil;
import oshi.util.platform.windows.WmiUtil;

public class WindowsDisks
implements Disks {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = LoggerFactory.getLogger(WindowsDisks.class);
    private static Map<String, Long> readMap = new HashMap<String, Long>();
    private static Map<String, Long> readByteMap = new HashMap<String, Long>();
    private static Map<String, Long> writeMap = new HashMap<String, Long>();
    private static Map<String, Long> writeByteMap = new HashMap<String, Long>();
    private static Map<String, Long> queueLengthMap = new HashMap<String, Long>();
    private static Map<String, Long> xferTimeMap = new HashMap<String, Long>();
    private static Map<String, Long> timeStampMap = new HashMap<String, Long>();
    private static Map<String, List<String>> driveToPartitionMap = new HashMap<String, List<String>>();
    private static Map<String, String> partitionToLogicalDriveMap = new HashMap<String, String>();
    private static Map<String, HWPartition> partitionMap = new HashMap<String, HWPartition>();
    private static final String PHYSICALDRIVE_PREFIX = "\\\\.\\PHYSICALDRIVE";
    private static final String PHYSICAL_DISK = "PhysicalDisk";
    private static final String PHYSICAL_DISK_LOCALIZED = PdhUtil.PdhLookupPerfNameByIndex(null, (int)PdhUtil.PdhLookupPerfIndexByEnglishName((String)"PhysicalDisk"));
    private static final String TOTAL_INSTANCE = "_Total";
    private static final Pattern DEVICE_ID = Pattern.compile(".*\\.DeviceID=\"(.*)\"");
    private static final int BUFSIZE = 255;
    private static final WbemcliUtil.WmiQuery<DiskDriveProperty> DISK_DRIVE_QUERY = new WbemcliUtil.WmiQuery("Win32_DiskDrive", DiskDriveProperty.class);
    private static final WbemcliUtil.WmiQuery<DriveToPartitionProperty> DRIVE_TO_PARTITION_QUERY = new WbemcliUtil.WmiQuery("Win32_DiskDriveToDiskPartition", DriveToPartitionProperty.class);
    private static final WbemcliUtil.WmiQuery<DriveToPartitionProperty> DISK_TO_PARTITION_QUERY = new WbemcliUtil.WmiQuery("Win32_LogicalDiskToPartition", DriveToPartitionProperty.class);
    private static final WbemcliUtil.WmiQuery<DiskPartitionProperty> PARTITION_QUERY = new WbemcliUtil.WmiQuery("Win32_DiskPartition", DiskPartitionProperty.class);
    private static Map<String, PerfDataUtil.PerfCounter> diskReadsCounterMap = new HashMap<String, PerfDataUtil.PerfCounter>();
    private static Map<String, PerfDataUtil.PerfCounter> diskReadBytesCounterMap = new HashMap<String, PerfDataUtil.PerfCounter>();
    private static Map<String, PerfDataUtil.PerfCounter> diskWritesCounterMap = new HashMap<String, PerfDataUtil.PerfCounter>();
    private static Map<String, PerfDataUtil.PerfCounter> diskWriteBytesCounterMap = new HashMap<String, PerfDataUtil.PerfCounter>();
    private static Map<String, PerfDataUtil.PerfCounter> diskQueueLengthCounterMap = new HashMap<String, PerfDataUtil.PerfCounter>();
    private static Map<String, PerfDataUtil.PerfCounter> diskXferTimeCounterMap = new HashMap<String, PerfDataUtil.PerfCounter>();
    private static WbemcliUtil.WmiQuery<PhysicalDiskProperty> physicalDiskQuery = null;

    public static boolean updateDiskStats(HWDiskStore diskStore) {
        String index = null;
        HWPartition[] partitions = diskStore.getPartitions();
        if (partitions.length > 0) {
            index = Integer.toString(partitions[0].getMajor());
        } else if (diskStore.getName().startsWith(PHYSICALDRIVE_PREFIX)) {
            index = diskStore.getName().substring(PHYSICALDRIVE_PREFIX.length(), diskStore.getName().length());
        } else {
            LOG.warn("Couldn't match index for {}", (Object)diskStore.getName());
            return false;
        }
        WindowsDisks.populateReadWriteMaps(index);
        if (readMap.containsKey(index)) {
            diskStore.setReads(MapUtil.getOrDefault(readMap, index, 0L));
            diskStore.setReadBytes(MapUtil.getOrDefault(readByteMap, index, 0L));
            diskStore.setWrites(MapUtil.getOrDefault(writeMap, index, 0L));
            diskStore.setWriteBytes(MapUtil.getOrDefault(writeByteMap, index, 0L));
            diskStore.setCurrentQueueLength(MapUtil.getOrDefault(queueLengthMap, index, 0L));
            diskStore.setTimeStamp(MapUtil.getOrDefault(timeStampMap, index, 0L));
            diskStore.setTransferTime(diskStore.getTimeStamp() - MapUtil.getOrDefault(xferTimeMap, index, 0L));
            return true;
        }
        return false;
    }

    @Override
    public HWDiskStore[] getDisks() {
        ArrayList<HWDiskStore> result = new ArrayList<HWDiskStore>();
        WindowsDisks.populateReadWriteMaps(null);
        this.populatePartitionMaps();
        WbemcliUtil.WmiResult<DiskDriveProperty> vals = WmiUtil.queryWMI(DISK_DRIVE_QUERY);
        for (int i = 0; i < vals.getResultCount(); ++i) {
            HWDiskStore ds = new HWDiskStore();
            ds.setName(WmiUtil.getString(vals, DiskDriveProperty.NAME, i));
            ds.setModel(String.format("%s %s", WmiUtil.getString(vals, DiskDriveProperty.MODEL, i), WmiUtil.getString(vals, DiskDriveProperty.MANUFACTURER, i)).trim());
            ds.setSerial(ParseUtil.hexStringToString(WmiUtil.getString(vals, DiskDriveProperty.SERIALNUMBER, i)));
            String index = Integer.toString(WmiUtil.getUint32(vals, DiskDriveProperty.INDEX, i));
            ds.setReads(MapUtil.getOrDefault(readMap, index, 0L));
            ds.setReadBytes(MapUtil.getOrDefault(readByteMap, index, 0L));
            ds.setWrites(MapUtil.getOrDefault(writeMap, index, 0L));
            ds.setWriteBytes(MapUtil.getOrDefault(writeByteMap, index, 0L));
            ds.setCurrentQueueLength(MapUtil.getOrDefault(queueLengthMap, index, 0L));
            ds.setTimeStamp(MapUtil.getOrDefault(timeStampMap, index, 0L));
            ds.setTransferTime(ds.getTimeStamp() - MapUtil.getOrDefault(xferTimeMap, index, 0L));
            ds.setSize(WmiUtil.getUint64(vals, DiskDriveProperty.SIZE, i));
            ArrayList<HWPartition> partitions = new ArrayList<HWPartition>();
            List<String> partList = driveToPartitionMap.get(ds.getName());
            if (partList != null && !partList.isEmpty()) {
                for (String part : partList) {
                    if (!partitionMap.containsKey(part)) continue;
                    partitions.add(partitionMap.get(part));
                }
            }
            ds.setPartitions(partitions.toArray(new HWPartition[partitions.size()]));
            result.add(ds);
        }
        return result.toArray(new HWDiskStore[result.size()]);
    }

    private static void populateReadWriteMaps(String index) {
        PdhUtil.PdhEnumObjectItems objectItems;
        if (index == null) {
            readMap.clear();
            readByteMap.clear();
            writeMap.clear();
            writeByteMap.clear();
            queueLengthMap.clear();
            xferTimeMap.clear();
            timeStampMap.clear();
        }
        if (physicalDiskQuery != null) {
            WbemcliUtil.WmiResult<PhysicalDiskProperty> result = WmiUtil.queryWMI(physicalDiskQuery);
            for (int i = 0; i < result.getResultCount(); ++i) {
                String name = WindowsDisks.getIndexFromName(WmiUtil.getString(result, PhysicalDiskProperty.NAME, i));
                if (index != null && !index.equals(name) || TOTAL_INSTANCE.equals(name)) continue;
                readMap.put(name, WmiUtil.getUint32asLong(result, PhysicalDiskProperty.DISKREADSPERSEC, i));
                readByteMap.put(name, WmiUtil.getUint64(result, PhysicalDiskProperty.DISKREADBYTESPERSEC, i));
                writeMap.put(name, WmiUtil.getUint32asLong(result, PhysicalDiskProperty.DISKWRITESPERSEC, i));
                writeByteMap.put(name, WmiUtil.getUint64(result, PhysicalDiskProperty.DISKWRITEBYTESPERSEC, i));
                queueLengthMap.put(name, WmiUtil.getUint64(result, PhysicalDiskProperty.CURRENTDISKQUEUELENGTH, i));
                xferTimeMap.put(name, WmiUtil.getUint64(result, PhysicalDiskProperty.PERCENTIDLETIME, i) / 10000L);
                long timestamp = WmiUtil.getUint64(result, PhysicalDiskProperty.TIMESTAMP_SYS100NS, i);
                timeStampMap.put(name, timestamp > 0L ? PerfDataUtil.filetimeToUtcMs(timestamp, false) : System.currentTimeMillis());
            }
            return;
        }
        try {
            objectItems = PdhUtil.PdhEnumObjectItems(null, null, (String)PHYSICAL_DISK_LOCALIZED, (int)100);
        }
        catch (PdhUtil.PdhException e) {
            LOG.error("Unable to enumerate instances for {}.", (Object)PHYSICAL_DISK_LOCALIZED);
            return;
        }
        List instances = objectItems.getInstances();
        instances.remove(TOTAL_INSTANCE);
        HashSet<String> unseenInstances = new HashSet<String>(diskReadsCounterMap.keySet());
        for (String instance : instances) {
            PerfDataUtil.PerfCounter counter;
            unseenInstances.remove(instance);
            if (!diskReadsCounterMap.containsKey(instance)) {
                counter = PerfDataUtil.createCounter(PHYSICAL_DISK, instance, "Disk Reads/sec");
                diskReadsCounterMap.put(instance, counter);
                if (!PerfDataUtil.addCounterToQuery(counter)) {
                    diskReadsCounterMap.remove(instance);
                }
            }
            if (!diskReadBytesCounterMap.containsKey(instance)) {
                counter = PerfDataUtil.createCounter(PHYSICAL_DISK, instance, "Disk Read Bytes/sec");
                diskReadBytesCounterMap.put(instance, counter);
                if (!PerfDataUtil.addCounterToQuery(counter)) {
                    diskReadBytesCounterMap.remove(instance);
                }
            }
            if (!diskWritesCounterMap.containsKey(instance)) {
                counter = PerfDataUtil.createCounter(PHYSICAL_DISK, instance, "Disk Writes/sec");
                diskWritesCounterMap.put(instance, counter);
                if (!PerfDataUtil.addCounterToQuery(counter)) {
                    diskWritesCounterMap.remove(instance);
                }
            }
            if (!diskWriteBytesCounterMap.containsKey(instance)) {
                counter = PerfDataUtil.createCounter(PHYSICAL_DISK, instance, "Disk Write Bytes/sec");
                diskWriteBytesCounterMap.put(instance, counter);
                if (!PerfDataUtil.addCounterToQuery(counter)) {
                    diskWriteBytesCounterMap.remove(instance);
                }
            }
            if (!diskQueueLengthCounterMap.containsKey(instance)) {
                counter = PerfDataUtil.createCounter(PHYSICAL_DISK, instance, "Current Disk Queue Length");
                diskQueueLengthCounterMap.put(instance, counter);
                if (!PerfDataUtil.addCounterToQuery(counter)) {
                    diskQueueLengthCounterMap.remove(instance);
                }
            }
            if (diskXferTimeCounterMap.containsKey(instance)) continue;
            counter = PerfDataUtil.createCounter(PHYSICAL_DISK, instance, "% Idle Time");
            diskXferTimeCounterMap.put(instance, counter);
            if (PerfDataUtil.addCounterToQuery(counter)) continue;
            diskXferTimeCounterMap.remove(instance);
        }
        long timestamp = PerfDataUtil.updateQuery(PHYSICAL_DISK);
        for (String instance : instances) {
            String name = WindowsDisks.getIndexFromName(instance);
            if (index != null && !index.equals(name)) continue;
            readMap.put(name, PerfDataUtil.queryCounter(diskReadsCounterMap.get(instance)));
            readByteMap.put(name, PerfDataUtil.queryCounter(diskReadBytesCounterMap.get(instance)));
            writeMap.put(name, PerfDataUtil.queryCounter(diskWritesCounterMap.get(instance)));
            writeByteMap.put(name, PerfDataUtil.queryCounter(diskWriteBytesCounterMap.get(instance)));
            queueLengthMap.put(name, PerfDataUtil.queryCounter(diskQueueLengthCounterMap.get(instance)));
            xferTimeMap.put(name, PerfDataUtil.queryCounter(diskXferTimeCounterMap.get(instance)) / 10000L);
            timeStampMap.put(name, timestamp);
        }
        for (String instance : unseenInstances) {
            PerfDataUtil.PerfCounter counter = diskReadsCounterMap.get(instance);
            PerfDataUtil.removeCounterFromQuery(counter);
            counter = diskReadBytesCounterMap.get(instance);
            PerfDataUtil.removeCounterFromQuery(counter);
            counter = diskWritesCounterMap.get(instance);
            PerfDataUtil.removeCounterFromQuery(counter);
            counter = diskWriteBytesCounterMap.get(instance);
            PerfDataUtil.removeCounterFromQuery(counter);
            counter = diskQueueLengthCounterMap.get(instance);
            PerfDataUtil.removeCounterFromQuery(counter);
            counter = diskXferTimeCounterMap.get(instance);
            PerfDataUtil.removeCounterFromQuery(counter);
        }
    }

    private void populatePartitionMaps() {
        Matcher mDep;
        Matcher mAnt;
        driveToPartitionMap.clear();
        partitionToLogicalDriveMap.clear();
        partitionMap.clear();
        WbemcliUtil.WmiResult<DriveToPartitionProperty> drivePartitionMap = WmiUtil.queryWMI(DRIVE_TO_PARTITION_QUERY);
        for (int i = 0; i < drivePartitionMap.getResultCount(); ++i) {
            mAnt = DEVICE_ID.matcher(WmiUtil.getRefString(drivePartitionMap, DriveToPartitionProperty.ANTECEDENT, i));
            mDep = DEVICE_ID.matcher(WmiUtil.getRefString(drivePartitionMap, DriveToPartitionProperty.DEPENDENT, i));
            if (!mAnt.matches() || !mDep.matches()) continue;
            MapUtil.createNewListIfAbsent(driveToPartitionMap, mAnt.group(1).replaceAll("\\\\\\\\", "\\\\")).add(mDep.group(1));
        }
        WbemcliUtil.WmiResult<DriveToPartitionProperty> diskPartitionMap = WmiUtil.queryWMI(DISK_TO_PARTITION_QUERY);
        for (int i = 0; i < diskPartitionMap.getResultCount(); ++i) {
            mAnt = DEVICE_ID.matcher(WmiUtil.getRefString(diskPartitionMap, DriveToPartitionProperty.ANTECEDENT, i));
            mDep = DEVICE_ID.matcher(WmiUtil.getRefString(diskPartitionMap, DriveToPartitionProperty.DEPENDENT, i));
            if (!mAnt.matches() || !mDep.matches()) continue;
            partitionToLogicalDriveMap.put(mAnt.group(1), mDep.group(1) + "\\");
        }
        WbemcliUtil.WmiResult<DiskPartitionProperty> hwPartitionQueryMap = WmiUtil.queryWMI(PARTITION_QUERY);
        for (int i = 0; i < hwPartitionQueryMap.getResultCount(); ++i) {
            String deviceID = WmiUtil.getString(hwPartitionQueryMap, DiskPartitionProperty.DEVICEID, i);
            String logicalDrive = MapUtil.getOrDefault(partitionToLogicalDriveMap, deviceID, "");
            String uuid = "";
            if (!logicalDrive.isEmpty()) {
                char[] volumeChr = new char[255];
                Kernel32.INSTANCE.GetVolumeNameForVolumeMountPoint(logicalDrive, volumeChr, 255);
                uuid = ParseUtil.parseUuidOrDefault(new String(volumeChr).trim(), "");
            }
            partitionMap.put(deviceID, new HWPartition(WmiUtil.getString(hwPartitionQueryMap, DiskPartitionProperty.NAME, i), WmiUtil.getString(hwPartitionQueryMap, DiskPartitionProperty.TYPE, i), WmiUtil.getString(hwPartitionQueryMap, DiskPartitionProperty.DESCRIPTION, i), uuid, WmiUtil.getUint64(hwPartitionQueryMap, DiskPartitionProperty.SIZE, i), WmiUtil.getUint32(hwPartitionQueryMap, DiskPartitionProperty.DISKINDEX, i), WmiUtil.getUint32(hwPartitionQueryMap, DiskPartitionProperty.INDEX, i), logicalDrive));
        }
    }

    private static String getIndexFromName(String s) {
        if (s.isEmpty()) {
            return s;
        }
        return s.split("\\s")[0];
    }

    static {
        String physicalDisk = PdhUtil.PdhLookupPerfNameByIndex(null, (int)PdhUtil.PdhLookupPerfIndexByEnglishName((String)PHYSICAL_DISK));
        boolean enumeration = true;
        try {
            PdhUtil.PdhEnumObjectItems objectItems = PdhUtil.PdhEnumObjectItems(null, null, (String)physicalDisk, (int)100);
            if (!objectItems.getInstances().isEmpty()) {
                List instances = objectItems.getInstances();
                for (int i = 0; i < instances.size(); ++i) {
                    String instance = (String)instances.get(i);
                    PerfDataUtil.PerfCounter counter = PerfDataUtil.createCounter(PHYSICAL_DISK, instance, "Disk Reads/sec");
                    diskReadsCounterMap.put(instance, counter);
                    if (!PerfDataUtil.addCounterToQuery(counter)) {
                        throw new PdhUtil.PdhException(0);
                    }
                    counter = PerfDataUtil.createCounter(PHYSICAL_DISK, instance, "Disk Read Bytes/sec");
                    diskReadBytesCounterMap.put(instance, counter);
                    if (!PerfDataUtil.addCounterToQuery(counter)) {
                        throw new PdhUtil.PdhException(0);
                    }
                    counter = PerfDataUtil.createCounter(PHYSICAL_DISK, instance, "Disk Writes/sec");
                    diskWritesCounterMap.put(instance, counter);
                    if (!PerfDataUtil.addCounterToQuery(counter)) {
                        throw new PdhUtil.PdhException(0);
                    }
                    counter = PerfDataUtil.createCounter(PHYSICAL_DISK, instance, "Disk Write Bytes/sec");
                    diskWriteBytesCounterMap.put(instance, counter);
                    if (!PerfDataUtil.addCounterToQuery(counter)) {
                        throw new PdhUtil.PdhException(0);
                    }
                    counter = PerfDataUtil.createCounter(PHYSICAL_DISK, instance, "Current Disk Queue Length");
                    diskQueueLengthCounterMap.put(instance, counter);
                    if (!PerfDataUtil.addCounterToQuery(counter)) {
                        throw new PdhUtil.PdhException(0);
                    }
                    counter = PerfDataUtil.createCounter(PHYSICAL_DISK, instance, "% Idle Time");
                    diskXferTimeCounterMap.put(instance, counter);
                    if (PerfDataUtil.addCounterToQuery(counter)) continue;
                    throw new PdhUtil.PdhException(0);
                }
            }
        }
        catch (PdhUtil.PdhException e) {
            LOG.warn("Unable to enumerate performance counter instances for {}.", (Object)physicalDisk);
            enumeration = false;
        }
        if (!enumeration) {
            PerfDataUtil.removeAllCounters(PHYSICAL_DISK);
            diskReadsCounterMap = null;
            diskReadBytesCounterMap = null;
            diskWritesCounterMap = null;
            diskWriteBytesCounterMap = null;
            diskQueueLengthCounterMap = null;
            diskXferTimeCounterMap = null;
            physicalDiskQuery = new WbemcliUtil.WmiQuery("Win32_PerfRawData_PerfDisk_PhysicalDisk", PhysicalDiskProperty.class);
        }
    }

    static enum PhysicalDiskProperty {
        NAME,
        DISKREADSPERSEC,
        DISKREADBYTESPERSEC,
        DISKWRITESPERSEC,
        DISKWRITEBYTESPERSEC,
        CURRENTDISKQUEUELENGTH,
        PERCENTIDLETIME,
        TIMESTAMP_SYS100NS;

    }

    static enum DiskPartitionProperty {
        DESCRIPTION,
        DEVICEID,
        DISKINDEX,
        INDEX,
        NAME,
        SIZE,
        TYPE;

    }

    static enum DriveToPartitionProperty {
        ANTECEDENT,
        DEPENDENT;

    }

    static enum DiskDriveProperty {
        INDEX,
        MANUFACTURER,
        MODEL,
        NAME,
        SERIALNUMBER,
        SIZE;

    }
}

