/*
 * Decompiled with CFR 0.152.
 */
package oshi.demo;

import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import oshi.SystemInfo;
import oshi.hardware.HardwareAbstractionLayer;
import oshi.hardware.NetworkIF;
import oshi.util.FileUtil;

public class DetectVM {
    private static final String OSHI_VM_MAC_ADDR_PROPERTIES = "oshi.vmmacaddr.properties";
    private static final Properties vmMacAddressProps = FileUtil.readPropertiesFromFilename("oshi.vmmacaddr.properties");
    private static final Map<String, String> vmVendor = new HashMap<String, String>();
    private static final String[] vmModelArray;

    public static void main(String[] args) {
        String vmString = DetectVM.identifyVM();
        if (vmString.isEmpty()) {
            System.out.println("You do not appear to be on a Virtual Machine.");
        } else {
            System.out.println("You appear to be on a VM: " + vmString);
        }
    }

    public static String identifyVM() {
        NetworkIF[] nifs;
        SystemInfo si = new SystemInfo();
        HardwareAbstractionLayer hw = si.getHardware();
        String vendor = hw.getProcessor().getProcessorIdentifier().getVendor().trim();
        if (vmVendor.containsKey(vendor)) {
            return vmVendor.get(vendor);
        }
        for (NetworkIF nif : nifs = hw.getNetworkIFs()) {
            String oui;
            String mac = nif.getMacaddr().toUpperCase();
            String string = oui = mac.length() > 7 ? mac.substring(0, 8) : mac;
            if (!vmMacAddressProps.containsKey(oui)) continue;
            return vmMacAddressProps.getProperty(oui);
        }
        String model = hw.getComputerSystem().getModel();
        for (String vm : vmModelArray) {
            if (!model.contains(vm)) continue;
            return vm;
        }
        String manufacturer = hw.getComputerSystem().getManufacturer();
        if ("Microsoft Corporation".equals(manufacturer) && "Virtual Machine".equals(model)) {
            return "Microsoft Hyper-V";
        }
        return "";
    }

    static {
        vmVendor.put("bhyve bhyve", "bhyve");
        vmVendor.put("KVMKVMKVM", "KVM");
        vmVendor.put("TCGTCGTCGTCG", "QEMU");
        vmVendor.put("Microsoft Hv", "Microsoft Hyper-V or Windows Virtual PC");
        vmVendor.put("lrpepyh vr", "Parallels");
        vmVendor.put("VMwareVMware", "VMware");
        vmVendor.put("XenVMMXenVMM", "Xen HVM");
        vmVendor.put("ACRNACRNACRN", "Project ACRN");
        vmVendor.put("QNXQVMBSQG", "QNX Hypervisor");
        vmModelArray = new String[]{"Linux KVM", "Linux lguest", "OpenVZ", "Qemu", "Microsoft Virtual PC", "VMWare", "linux-vserver", "Xen", "FreeBSD Jail", "VirtualBox", "Parallels", "Linux Containers", "LXC"};
    }
}

