/*
 * Decompiled with CFR 0.152.
 */
package oshi.demo.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Paint;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import javax.swing.JPanel;
import javax.swing.Timer;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.labels.PieSectionLabelGenerator;
import org.jfree.chart.labels.StandardPieSectionLabelGenerator;
import org.jfree.chart.plot.PiePlot;
import org.jfree.chart.title.TextTitle;
import org.jfree.data.general.DefaultPieDataset;
import org.jfree.data.general.PieDataset;
import oshi.PlatformEnum;
import oshi.SystemInfo;
import oshi.demo.gui.OshiJPanel;
import oshi.software.os.FileSystem;
import oshi.software.os.OSFileStore;
import oshi.util.FormatUtil;

public class FileStorePanel
extends OshiJPanel {
    private static final long serialVersionUID = 1L;
    private static final String USED = "Used";
    private static final String AVAILABLE = "Available";

    public FileStorePanel(FileSystem fileSystem) {
        this.init(fileSystem);
    }

    private void init(FileSystem fs) {
        OSFileStore[] fileStores = fs.getFileStores();
        DefaultPieDataset[] fsData = new DefaultPieDataset[fileStores.length];
        JFreeChart[] fsCharts = new JFreeChart[fsData.length];
        JPanel fsPanel = new JPanel();
        fsPanel.setLayout(new GridBagLayout());
        GridBagConstraints fsConstraints = new GridBagConstraints();
        fsConstraints.weightx = 1.0;
        fsConstraints.weighty = 1.0;
        fsConstraints.fill = 1;
        int modBase = (int)((double)(fileStores.length * 1300) / (800.0 * Math.sqrt(fileStores.length)));
        for (int i = 0; i < fileStores.length; ++i) {
            fsData[i] = new DefaultPieDataset();
            fsCharts[i] = ChartFactory.createPieChart(null, (PieDataset)fsData[i], (boolean)true, (boolean)true, (boolean)false);
            FileStorePanel.configurePlot(fsCharts[i]);
            fsConstraints.gridx = i % modBase;
            fsConstraints.gridy = i / modBase;
            fsPanel.add((Component)new ChartPanel(fsCharts[i]), fsConstraints);
        }
        FileStorePanel.updateDatasets(fs, fsData, fsCharts);
        this.add((Component)fsPanel, "Center");
        Timer timer = new Timer(15000, e -> {
            if (!FileStorePanel.updateDatasets(fs, fsData, fsCharts)) {
                ((Timer)e.getSource()).stop();
                fsPanel.removeAll();
                this.init(fs);
                fsPanel.revalidate();
                fsPanel.repaint();
            }
        });
        timer.start();
    }

    private static boolean updateDatasets(FileSystem fs, DefaultPieDataset[] fsData, JFreeChart[] fsCharts) {
        OSFileStore[] fileStores = fs.getFileStores();
        if (fileStores.length != fsData.length) {
            return false;
        }
        for (int i = 0; i < fsData.length; ++i) {
            fsCharts[i].setTitle(fileStores[i].getName());
            ArrayList<TextTitle> subtitles = new ArrayList<TextTitle>();
            if (SystemInfo.getCurrentPlatformEnum().equals((Object)PlatformEnum.WINDOWS)) {
                subtitles.add(new TextTitle(fileStores[i].getLabel()));
            }
            long usable = fileStores[i].getUsableSpace();
            long total = fileStores[i].getTotalSpace();
            subtitles.add(new TextTitle("Available: " + FormatUtil.formatBytes(usable) + "/" + FormatUtil.formatBytes(total)));
            fsCharts[i].setSubtitles(subtitles);
            fsData[i].setValue((Comparable)((Object)USED), (double)total - (double)usable);
            fsData[i].setValue((Comparable)((Object)AVAILABLE), (double)usable);
        }
        return true;
    }

    private static void configurePlot(JFreeChart chart) {
        PiePlot plot = (PiePlot)chart.getPlot();
        plot.setSectionPaint((Comparable)((Object)USED), (Paint)Color.red);
        plot.setSectionPaint((Comparable)((Object)AVAILABLE), (Paint)Color.green);
        plot.setExplodePercent((Comparable)((Object)USED), 0.1);
        plot.setSimpleLabels(true);
        StandardPieSectionLabelGenerator labelGenerator = new StandardPieSectionLabelGenerator("{0}: {1} ({2})", (NumberFormat)new DecimalFormat("0"), (NumberFormat)new DecimalFormat("0%"));
        plot.setLabelGenerator((PieSectionLabelGenerator)labelGenerator);
    }
}

