/*
 * Decompiled with CFR 0.152.
 */
package oshi.hardware.platform.windows;

import com.sun.jna.platform.win32.COM.WbemcliUtil;
import java.util.function.Supplier;
import oshi.hardware.Baseboard;
import oshi.hardware.Firmware;
import oshi.hardware.common.AbstractComputerSystem;
import oshi.hardware.platform.windows.WindowsBaseboard;
import oshi.hardware.platform.windows.WindowsFirmware;
import oshi.util.Memoizer;
import oshi.util.Util;
import oshi.util.platform.windows.WmiQueryHandler;
import oshi.util.platform.windows.WmiUtil;

final class WindowsComputerSystem
extends AbstractComputerSystem {
    private final Supplier<ManufacturerModel> manufacturerModel = Memoizer.memoize(this::queryManufacturerModel);
    private final Supplier<String> serialNumber = Memoizer.memoize(this::querySystemSerialNumber);
    private final WmiQueryHandler wmiQueryHandler = WmiQueryHandler.createInstance();

    WindowsComputerSystem() {
    }

    @Override
    public String getManufacturer() {
        return this.manufacturerModel.get().manufacturer;
    }

    @Override
    public String getModel() {
        return this.manufacturerModel.get().model;
    }

    @Override
    public String getSerialNumber() {
        return this.serialNumber.get();
    }

    @Override
    public Firmware createFirmware() {
        return new WindowsFirmware();
    }

    @Override
    public Baseboard createBaseboard() {
        return new WindowsBaseboard();
    }

    private ManufacturerModel queryManufacturerModel() {
        String manufacturer = null;
        String model = null;
        WbemcliUtil.WmiQuery computerSystemQuery = new WbemcliUtil.WmiQuery("Win32_ComputerSystem", ComputerSystemProperty.class);
        WbemcliUtil.WmiResult win32ComputerSystem = this.wmiQueryHandler.queryWMI(computerSystemQuery);
        if (win32ComputerSystem.getResultCount() > 0) {
            manufacturer = WmiUtil.getString(win32ComputerSystem, ComputerSystemProperty.MANUFACTURER, 0);
            model = WmiUtil.getString(win32ComputerSystem, ComputerSystemProperty.MODEL, 0);
        }
        return new ManufacturerModel(manufacturer, model);
    }

    private String querySystemSerialNumber() {
        String result = this.querySerialFromBios();
        if (result == null && (result = this.querySerialFromCsProduct()) == null) {
            return "unknown";
        }
        return Util.isBlank(result) ? "unknown" : result;
    }

    private String querySerialFromBios() {
        String result = null;
        WbemcliUtil.WmiQuery serialNumQuery = new WbemcliUtil.WmiQuery("Win32_BIOS where PrimaryBIOS=true", BiosProperty.class);
        WbemcliUtil.WmiResult serialNum = this.wmiQueryHandler.queryWMI(serialNumQuery);
        if (serialNum.getResultCount() > 0) {
            result = WmiUtil.getString(serialNum, BiosProperty.SERIALNUMBER, 0);
        }
        return result;
    }

    private String querySerialFromCsProduct() {
        String result = null;
        WbemcliUtil.WmiQuery identifyingNumberQuery = new WbemcliUtil.WmiQuery("Win32_ComputerSystemProduct", ComputerSystemProductProperty.class);
        WbemcliUtil.WmiResult identifyingNumber = this.wmiQueryHandler.queryWMI(identifyingNumberQuery);
        if (identifyingNumber.getResultCount() > 0) {
            result = WmiUtil.getString(identifyingNumber, ComputerSystemProductProperty.IDENTIFYINGNUMBER, 0);
        }
        return result;
    }

    private static final class ManufacturerModel {
        private final String manufacturer;
        private final String model;

        private ManufacturerModel(String manufacturer, String model) {
            this.manufacturer = Util.isBlank(manufacturer) ? "unknown" : manufacturer;
            this.model = Util.isBlank(model) ? "unknown" : model;
        }
    }

    static enum ComputerSystemProductProperty {
        IDENTIFYINGNUMBER;

    }

    static enum BiosProperty {
        SERIALNUMBER;

    }

    static enum ComputerSystemProperty {
        MANUFACTURER,
        MODEL;

    }
}

