/*
 * Decompiled with CFR 0.152.
 */
package org.openehr.utils.message;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.Optional;
import java.util.ResourceBundle;

public class I18n {
    private static final LoadingCache<Locale, Optional<ResourceBundle>> resourceCache = CacheBuilder.newBuilder().build((CacheLoader)new CacheLoader<Locale, Optional<ResourceBundle>>(){

        public Optional<ResourceBundle> load(Locale locale) throws Exception {
            try {
                return Optional.of(ResourceBundle.getBundle("openehrArchie", locale));
            }
            catch (MissingResourceException e) {
                return Optional.empty();
            }
        }
    });
    private static ThreadLocal<Locale> currentLocale = new ThreadLocal();

    public static String t(String input, Object ... args) {
        return I18n.t(input, I18n.getCurrentLocale(), args);
    }

    public static String t(String input, Locale locale, Object ... args) {
        ResourceBundle bundle;
        Optional optionalBundle = (Optional)resourceCache.getUnchecked((Object)locale);
        if (optionalBundle.isPresent() && (bundle = (ResourceBundle)optionalBundle.get()).containsKey(input)) {
            return MessageFormat.format(((ResourceBundle)optionalBundle.get()).getString(input), args);
        }
        return MessageFormat.format(input, args);
    }

    public static String register(String template) {
        return template;
    }

    public static void setCurrentLocale(Locale locale) {
        currentLocale.set(locale);
    }

    public static Locale getCurrentLocale() {
        Locale result = currentLocale.get();
        if (currentLocale.get() == null) {
            result = Locale.getDefault();
        }
        return result;
    }
}

