/*
 * Decompiled with CFR 0.152.
 */
package com.nedap.archie.paths;

import com.google.common.base.Joiner;
import java.util.regex.Pattern;

public class PathSegment {
    private static final Joiner expressionJoiner = Joiner.on((String)",").skipNulls();
    private static final Pattern archetypeRefPattern = Pattern.compile("(.*::)?.*-.*-.*\\..*\\.v.*");
    private static final Pattern nodeIdPattern = Pattern.compile("id(\\.?\\d)+|at(\\.?\\d)+");
    private String nodeName;
    private String nodeId;
    private String archetypeRef = null;
    private Integer index;

    public PathSegment(String nodeName, Integer index) {
        this(nodeName, null, index);
    }

    public PathSegment(String nodeName, String nodeId) {
        this(nodeName, nodeId, null);
    }

    public PathSegment(String nodeName) {
        this(nodeName, null, null);
    }

    public PathSegment(String nodeName, String nodeId, Integer index) {
        this.nodeName = nodeName;
        this.nodeId = nodeId;
        this.index = index;
    }

    public String getNodeName() {
        return this.nodeName;
    }

    public void setNodeName(String nodeName) {
        this.nodeName = nodeName;
    }

    public String getNodeId() {
        return this.nodeId;
    }

    public void setNodeId(String nodeId) {
        this.nodeId = nodeId;
    }

    public Integer getIndex() {
        return this.index;
    }

    public void setIndex(Integer index) {
        this.index = index;
    }

    public String getArchetypeRef() {
        return this.archetypeRef;
    }

    public void setArchetypeRef(String archetypeRef) {
        this.archetypeRef = archetypeRef;
    }

    public boolean hasIdCode() {
        return this.nodeId != null && nodeIdPattern.matcher(this.nodeId).matches();
    }

    public boolean hasNumberIndex() {
        return this.index != null;
    }

    public boolean hasArchetypeRef() {
        return this.nodeId != null && archetypeRefPattern.matcher(this.nodeId).matches();
    }

    public String toString() {
        if (this.hasExpressions()) {
            return "/" + this.nodeName + "[" + expressionJoiner.join((Object)this.nodeId, (Object)this.index, new Object[0]) + "]";
        }
        return "/" + this.nodeName;
    }

    public boolean hasExpressions() {
        return this.nodeId != null || this.index != null;
    }
}

