/*
 * Decompiled with CFR 0.152.
 */
package org.openehr.utils.message;

import org.openehr.utils.message.MessageCode;
import org.openehr.utils.message.MessageSeverity;

public class MessageDescriptor {
    private MessageCode code;
    private MessageSeverity severity;
    private String message;
    private String location;

    public MessageCode getCode() {
        return this.code;
    }

    public void setCode(MessageCode code) {
        this.code = code;
    }

    public MessageSeverity getSeverity() {
        return this.severity;
    }

    public void setSeverity(MessageSeverity severity) {
        this.severity = severity;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public String getLocation() {
        return this.location;
    }

    public void setLocation(String location) {
        this.location = location;
    }

    public MessageDescriptor() {
    }

    public MessageDescriptor(MessageCode aCode, MessageSeverity aSeverity, String aMessage, String aLoc) {
        this.code = aCode;
        this.severity = aSeverity;
        this.message = aMessage;
        this.location = aLoc;
    }

    public static MessageDescriptor createError(MessageCode aCode, String aMessage, String aLoc) {
        return MessageDescriptor.create(aCode, MessageSeverity.ERROR, aMessage, aLoc);
    }

    public static MessageDescriptor createWarning(MessageCode aCode, String aMessage, String aLoc) {
        return MessageDescriptor.create(aCode, MessageSeverity.WARNING, aMessage, aLoc);
    }

    public static MessageDescriptor createInfo(MessageCode aCode, String aMessage, String aLoc) {
        return MessageDescriptor.create(aCode, MessageSeverity.INFO, aMessage, aLoc);
    }

    public static MessageDescriptor createDebug(MessageCode aCode, String aMessage, String aLoc) {
        return MessageDescriptor.create(aCode, MessageSeverity.DEBUG, aMessage, aLoc);
    }

    public static MessageDescriptor create(MessageCode aCode, MessageSeverity aSeverity, String aMessage, String aLoc) {
        return new MessageDescriptor(aCode, aSeverity, aMessage, aLoc);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.severity.name()).append(" ");
        if (this.location != null && this.location.trim().length() > 0) {
            builder.append(this.location).append(": ");
        }
        builder.append("(").append(this.code).append(") ").append(this.message);
        return builder.toString();
    }
}

