/*
 * Decompiled with CFR 0.152.
 */
package com.nedap.archie.rules.evaluation.evaluators.functions;

import com.nedap.archie.rules.PrimitiveType;
import com.nedap.archie.rules.evaluation.FunctionCallException;
import com.nedap.archie.rules.evaluation.FunctionImplementation;
import com.nedap.archie.rules.evaluation.Value;
import com.nedap.archie.rules.evaluation.ValueList;
import com.nedap.archie.rules.evaluation.evaluators.FunctionUtil;
import java.util.ArrayList;
import java.util.List;

public class Max
implements FunctionImplementation {
    @Override
    public String getName() {
        return "max";
    }

    @Override
    public ValueList evaluate(List<ValueList> arguments) throws FunctionCallException {
        ValueList possiblyNullResult = FunctionUtil.checkAndHandleNull(arguments);
        if (possiblyNullResult != null) {
            possiblyNullResult.setType(PrimitiveType.Real);
            return possiblyNullResult;
        }
        int length = FunctionUtil.checkEqualLengthOrOne(arguments);
        if (length == -1) {
            throw new FunctionCallException("value lists of max operator not the same length");
        }
        ValueList result = new ValueList();
        result.setType(PrimitiveType.Real);
        for (int i = 0; i < length; ++i) {
            Double max = null;
            ArrayList<String> paths = new ArrayList<String>();
            for (ValueList list : arguments) {
                Value value = list.get(i);
                if (!value.isNull() && (max == null || FunctionUtil.castToDouble(value) > max)) {
                    max = FunctionUtil.castToDouble(value);
                }
                paths.addAll(value.getPaths());
            }
            result.addValue(max, paths);
        }
        return result;
    }
}

